import matplotlib.pyplot as plt
import numpy as np
import math

#computes the length in the x and y direction based on the coefficients
def compute_unit_length(x_coeff,y_coeff):
    # TODO: fill in this function with your implementation
    new_x_coeff = x_coeff
    new_y_coeff = y_coeff
    return (new_x_coeff, new_y_coeff)

def plot_graph():
    # TODO: fill in the following function with the values for the problem
    # We recommend googling the matplotlib functions to learn more about particular parameters

    #create a figure that is 6in x 6in
    plt.figure(figsize=(6,6))

    #create a range of your x axis values
    x_vals = np.arange(-3,11,0.1)

    #create the ranges of y values for each line
    y_line1 = 1 - 1 * x_vals # line 1 y values
    y_line2 = -1 - 1 * x_vals # line 2 y values
    y_line3 = 1 + 1 * x_vals # line 3 y values

    #the axis limits and grid lines
    plt.xlim(6,10)
    plt.ylim(6,8)
    plt.hlines(0,-3,10,color='k')
    plt.vlines(0,-5,8,color='k')
    plt.grid(True)

    #label your graph, axes, and ticks on each axis
    plt.xlabel('$x$', fontsize=22)
    plt.ylabel('$y$', fontsize=22)
    plt.xticks(np.arange(-2, 11))
    plt.yticks(np.arange(-4, 9))
    plt.tick_params(labelsize=16)
    plt.title ('My First Graph', fontsize=18)

    #plot the lines in different colors, create a legend
    plt.plot(x_vals,y_line1,color='r',linewidth=3)
    plt.plot(x_vals,y_line2,color='g',linewidth=3)
    plt.plot(x_vals,y_line3,color='b',linewidth=3)
    plt.legend([r'$-x + y = 1$',
                r'$x + y = -1$',
                r'$x + y = 1$'])

    #create unit length arrows in the correct directions
    plt.quiver(1, -2, compute_unit_length(1,1)[0], compute_unit_length(1,1)[1], color=['black'])
    plt.quiver(1, 0, compute_unit_length(1,1)[0], compute_unit_length(1,1)[1], color=['black'])
    plt.quiver(1, 2, compute_unit_length(1,-1)[0], compute_unit_length(1,-1)[1], color=['black'])

    #complete the layout, save figure, and show the figure for you to see
    plt.tight_layout()
    plt.savefig('my_graph.png')
    plt.show()

if __name__ == '__main__':
    plot_graph()
