import unittest
from gradescope_utils.autograder_utils.decorators import tags, weight
from hw import file_to_subsearch

class TestFileToSubsearch(unittest.TestCase):
    def setUp(self):
        pass

    def runitems(self,test,answer,file):
        self.assertTrue(len(test) == len(answer),msg="testing lengths of lists the same for "+file)
        for item in answer:
            self.assertTrue(item in test,msg="testing if all items in "+str(answer)+" are in "+str(test))

    @weight(10)
    @tags("q5")
    def test_filetosubsearch(self):
        lst = file_to_subsearch("files/wordlist1.txt","dog")
        self.runitems(lst,[],"dog in wordlist1.txt")
        lst = file_to_subsearch("files/wordlist3.txt","dog")
        self.runitems(lst,["dog","dogs"],"dog in wordlist3.txt")
        lst = file_to_subsearch("files/allwords.txt","dog")
        self.runitems(lst,["dog","dogs"],"dog in allwords.txt")
        lst = file_to_subsearch("files/wordlist1.txt","mouse")
        self.runitems(lst,[],"mouse in wordlist1.txt")
        lst = file_to_subsearch("files/wordlist6.txt","mouse")
        self.runitems(lst,["mouse"],"mouse in wordlist6.txt")
        lst = file_to_subsearch("files/allwords.txt","mouse")
        self.runitems(lst,["mouse"],"mouse in allwords.txt")
        lst = file_to_subsearch("files/wordlist1.txt","sna")
        self.runitems(lst,[],"sna in wordlist1.txt")
        lst = file_to_subsearch("files/wordlist9.txt","sna")
        self.runitems(lst,["snake","snap","snapshot"],"sna in wordlist9.txt")
        lst = file_to_subsearch("files/allwords.txt","sna")
        self.runitems(lst,["snake","snap","snapshot"],"sna in allwords.txt")