from mapreduce import *
from hw5_checkin import *

def test_file_to_count(filename):
    return [('count',file_to_count(filename))]

def test_combine_counts(item):
    return combine_counts(item[1])

def test_testfiletocount():
    print("testing file_to_count...",end="")
    assert(test_file_to_count("wordlist1.txt") == [('count',1000)])
    assert(test_file_to_count("wordlist2.txt") == [('count',1000)])
    assert(test_file_to_count("wordlist3.txt") == [('count',1000)])
    assert(test_file_to_count("wordlist4.txt") == [('count',1000)])
    assert(test_file_to_count("allwords.txt") == [('count',10000)])
    print("done!")

def test_testcombinecount():
    print("testing combine_count...",end="")
    assert(test_combine_counts(('count',[1000,1000])) == 2000)
    assert(test_combine_counts(('count',[1000,1000,1000])) == 3000)
    assert(test_combine_counts(('count',[1000,1000,1000,1000])) == 4000)
    print("done!")

def test_wordcounter():
    print("testing word count...",end="")
    import glob

    input_files = glob.glob('wordlist*.txt')

    mapper = SimpleMapReduce(test_file_to_count, test_combine_counts)
    word_count = mapper(input_files)
    assert(word_count[0] == 10000)
    print("done!")

########################################################

def test_file_to_search(input):
    filename,word = input
    return [(word,(filename,file_to_search(filename,word)))]

def test_combine_search(input):
    word, search_results = input
    filenames = []
    boolresults = []
    for s in search_results:
        filenames.append(s[0])
        boolresults.append(s[1])
    idx = combine_search(boolresults)
    if idx >-1:
        return (word,filenames[idx])
    return (word,None)

def test_testfiletosearch():
    print("testing file_to_search...",end="")
    assert(test_file_to_search(("wordlist1.txt","dog")) == [('dog',("wordlist1.txt",False))])
    assert(test_file_to_search(("wordlist2.txt","dog")) == [('dog',("wordlist2.txt",False))])
    assert(test_file_to_search(("wordlist3.txt","dog")) == [('dog',("wordlist3.txt",True))])
    assert(test_file_to_search(("wordlist4.txt","dog")) == [('dog',("wordlist4.txt",False))])
    assert(test_file_to_search(("allwords.txt","dog")) == [('dog',("allwords.txt",True))])
    print("done!")

def test_testcombinesearch():
    print("testing combine_search...",end="")
    assert(test_combine_search(('dog', [('wordlist10.txt', False), ('wordlist8.txt', False), ('wordlist9.txt', False), ('wordlist4.txt', False), ('wordlist5.txt', False), ('wordlist7.txt', False), ('wordlist6.txt', False), ('wordlist2.txt', False), ('wordlist3.txt', True), ('wordlist1.txt', False)]))==('dog','wordlist3.txt'))
    assert(test_combine_search(('cat', [('wordlist10.txt', False), ('wordlist8.txt', False), ('wordlist9.txt', False), ('wordlist4.txt', False), ('wordlist5.txt', False), ('wordlist7.txt', False), ('wordlist6.txt', False), ('wordlist2.txt', True), ('wordlist3.txt', False), ('wordlist1.txt', False)]))==('cat',"wordlist2.txt"))
    assert(test_combine_search(('mouse', [('wordlist10.txt', False), ('wordlist8.txt', False), ('wordlist9.txt', False), ('wordlist4.txt', False), ('wordlist5.txt', False), ('wordlist7.txt', False), ('wordlist6.txt', True), ('wordlist2.txt', False), ('wordlist3.txt', False), ('wordlist1.txt', False)]))==('mouse','wordlist6.txt'))
    print("done!")

def test_wordsearcher():
    print("testing word searcher...")
    import glob

    inputs = []
    input_files = glob.glob('wordlist*.txt')
    for i in input_files:
        inputs.append((i,"dog"))
    for i in input_files:
        inputs.append((i,"cat"))
    for i in input_files:
        inputs.append((i,"mouse"))
    mapper = SimpleMapReduce(test_file_to_search, test_combine_search)
    word_search = mapper(inputs)
    print("check the words:")
    for search in word_search:
        print(search[0]+" found in "+str(search[1]))
    print("done!")

##########################################################################

def test_file_to_subsearch(input):
    return [(input[1],file_to_subsearch(input[0],input[1]))]

def test_combine_lists(input):
    substring,lists = input
    l = combine_lists(lists)
    return (substring,l)

def test_substsearcher():
    print("testing substring search...")
    import glob

    inputs = []
    input_files = glob.glob('wordlist*.txt')
    for i in input_files:
        inputs.append((i,"dog"))
    for i in input_files:
        inputs.append((i,"cat"))
    for i in input_files:
        inputs.append((i,"qu"))
    mapper = SimpleMapReduce(test_file_to_subsearch, test_combine_lists)
    word_search = mapper(inputs)
    print("check the substrings:")
    for search in word_search:
        print(search[0]+" found in "+str(search[1]))
    print("done!")

def testAll():
    test_testfiletocount()
    test_testcombinecount()
    test_wordcounter()
    
    test_testfiletosearch()
    test_testcombinesearch()
    test_wordsearcher()
    
    test_substsearcher()

if __name__ == '__main__':
    testAll()
