from cmu_graphics import *
from PIL import Image, ImageDraw
import random

# For more on ImageDraw, see:
# https://pillow.readthedocs.io/en/stable/reference/ImageDraw.html

def onAppStart(app):
    # make some pilImages:
    imageSize = (300, 200)
    pilImage1 = makePilImageWithRandomShapes(imageSize, ovals=True)
    pilImage2 = makePilImageWithRandomShapes(imageSize, ovals=False)
    # convert to CMUImage for drawing:
    app.image1 = CMUImage(pilImage1)
    app.image2 = CMUImage(pilImage2)

def makePilImageWithRandomShapes(imageSize, ovals=True):
    pilImage = Image.new('RGB', imageSize)
    # Create the ImageDraw object
    draw = ImageDraw.Draw(pilImage)
    # Draw random ovals with random radii in random colors
    for _ in range(100):
        cx = random.randrange(pilImage.width)
        cy = random.randrange(pilImage.height)
        xr = random.randrange(5, 30)
        yr = random.randrange(5, 30)
        rgb = (random.randrange(256), random.randrange(256), random.randrange(256))
        if ovals:
            draw.ellipse((cx-xr, cy-yr, cx+xr, cy+yr), fill=rgb)
        else:
            draw.rectangle((cx-xr, cy-yr, cx+xr, cy+yr), fill=rgb)
    return pilImage

def redrawAll(app):
    drawLabel('Image1', 200, 125, align='center', size=24)
    drawImage(app.image1, 200, 250, align='center')
    drawLabel('Image2', 550, 125, align='center', size=24)
    drawImage(app.image2, 550, 250, align='center')
    drawLabel('Press s to save as pdf', app.width//2, 40, size=24)

def onKeyPress(app, key):
    if key == 's': saveImagesAsPdf(app)

def saveImagesAsPdf(app):
    cmuImages = [app.image1, app.image2]
    pilImages = [cmuImage.image for cmuImage in cmuImages]
    pilImages[0].save('savedImages.pdf', save_all=True, append_images=pilImages[1:])

def main():
    runApp(750, 400)

if __name__ == '__main__':
    main()