from cmu_graphics import *
from PIL import Image
import os, pathlib

def openImage(fileName):
        return Image.open(os.path.join(pathlib.Path(__file__).parent,fileName))

def onAppStart(app):
    #Sprite Strip: 'http://www.cs.cmu.edu/~112/notes/sample-spritestrip.png'
    
    spritestrip = Image.open('images/spritestrip.png')
    
    # Alternatively, if this throw an error, comment out the above line and
    # use the following:
    # spritestrip = openImage('images/spritestrip.png')
    
    app.sprites = [ ]
    for i in range(6):
        # Split up the spritestrip into its separate sprites
        # then save them in a list
        frame = spritestrip.crop((30+260*i, 30, 230+260*i, 250))
        # Make sure you do this in onAppStart! Converting to a CMUImage every
        # time redrawAll is called is slow
        sprite = CMUImage(frame)
        app.sprites.append(sprite)
        
    # app.spriteIndex indicates which sprite in the list we should display
    app.spriteIndex = 0
    app.stepsPerSecond = 8

def onStep(app):
    app.spriteIndex += 1
    app.spriteIndex %= len(app.sprites)

def redrawAll(app):
    sprite = app.sprites[app.spriteIndex]
    drawImage(sprite,200, 200, align = 'center')

def main():
    runApp(width=400, height=400)

if __name__ == '__main__':
    main()