from cmu_graphics import *
from PIL import Image
import os, pathlib

#See: https://pillow.readthedocs.io/en/stable/reference/Image.html 

def openImage(fileName):
        return Image.open(os.path.join(pathlib.Path(__file__).parent,fileName))

def onAppStart(app):
    app.margin = 5

    # Open image from local directory
    app.image = Image.open('images/cat.jpg')
    
    # If the above line displays the error
    # FileNotFoundError: [Errno 2] No such file or directory: 'images/cat.jpg',
    # it's because PIL is looking for the file in the directory Python is 
    # installed in. Instead, either use absolute file path, or comment out the
    # line above and use the line below.
    # app.image = openImage('images/cat.jpg')
    
    # Access attributes like width and height
    app.imageWidth, app.imageHeight = app.image.width, app.image.height

    # Use 'transpose' to flip images
    app.imageFlipped = app.image.transpose(Image.FLIP_LEFT_RIGHT)

    # Cast image type to CMUImage to allow for faster drawing
    # Make sure you do this in onAppStart! Converting to a CMUImage every
    # time redrawAll is called is slow
    app.image = CMUImage(app.image)
    app.imageFlipped = CMUImage(app.imageFlipped)

def redrawAll(app):
    # drawImage takes a CMUImage object and the left-top coordinates
    drawImage(app.image, 100, 100)

    # Scale image by defining new dimensions 
    newWidth, newHeight = (app.imageWidth//2, app.imageHeight//2)
    drawImage(app.image, 500, 100, width=newWidth, height=newHeight)

    # Draw the flipped image
    drawImage(app.imageFlipped,100,500)

    # Rotate image by a given angle (in degrees)
    drawImage(app.image, 500, 500, rotateAngle=-60)

    drawCaptions(app)

def drawCaptions(app):
    drawLabel('Original',100,100 - app.margin,align='left-bottom',size=24)
    drawLabel('Scaled',500,100 - app.margin,align='left-bottom',size=24)
    drawLabel('Flipped',100,450 - app.margin,align='left-bottom',size=24)
    drawLabel('Rotated',500,450 - app.margin,align='left-bottom',size=24)

def main():
    runApp(width=800,height=800)

if __name__ == '__main__':
    main()