/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Random;

public class Tetris
extends JComponentWithEvents {
    private Color[][] board;
    private int rows;
    private int cols;
    private Color emptyColor = Color.white;
    private Color backgroundColor = Color.lightGray;
    private Color gridColor = Color.darkGray;
    private Color scoreColor = Color.black;
    private int boardMargin = 25;
    private int cellMargin = 2;
    private int cellSize = 20;
    private static final int DEFAULT_ROWS = 15;
    private static final int DEFAULT_COLS = 10;
    private boolean[][] fallingPiece;
    private Color fallingPieceColor;
    private int fallingPieceRow;
    private int fallingPieceCol;
    private int fallingPieceRows;
    private int fallingPieceCols;
    private Random random = new Random();
    private int timerFiredCount = 0;
    private int timerFiredLimit = 3;
    private boolean isGameOver = false;
    private int score;
    private static final boolean[][] I_PIECE = new boolean[][]{{true, true, true, true}};
    private static final boolean[][] J_PIECE = new boolean[][]{{true, false, false}, {true, true, true}};
    private static final boolean[][] L_PIECE = new boolean[][]{{false, false, true}, {true, true, true}};
    private static final boolean[][] O_PIECE = new boolean[][]{{true, true}, {true, true}};
    private static final boolean[][] S_PIECE = new boolean[][]{{false, true, true}, {true, true, false}};
    private static final boolean[][] T_PIECE = new boolean[][]{{false, true, false}, {true, true, true}};
    private static final boolean[][] Z_PIECE = new boolean[][]{{true, true, false}, {false, true, true}};
    private static boolean[][][] TETRIS_PIECES = new boolean[][][]{I_PIECE, J_PIECE, L_PIECE, O_PIECE, S_PIECE, T_PIECE, Z_PIECE};
    private static Color[] TETRIS_PIECE_COLORS = new Color[]{Color.red, Color.yellow, Color.magenta, Color.blue, Color.cyan, Color.green, Color.orange};

    public static void main(String[] args) {
        Tetris.launch(250, 350);
    }

    public Tetris() {
        this(15, 10);
    }

    public Tetris(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.board = new Color[rows][cols];
        int boardWidth = 2 * this.boardMargin + cols * this.cellSize;
        int boardHeight = 2 * this.boardMargin + rows * this.cellSize;
        this.setPreferredSize(new Dimension(boardWidth, boardHeight));
        this.resetGame();
    }

    public void resetGame() {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                this.board[row][col] = this.emptyColor;
            }
        }
        this.isGameOver = false;
        this.score = 0;
        this.newFallingPiece();
        this.loop("tetris.mid");
    }

    public void keyPressed(char key) {
        if (key == 'r') {
            this.resetGame();
            return;
        }
        if (this.isGameOver) {
            return;
        }
        switch (key) {
            case '%': {
                this.moveFallingPiece(0, -1);
                break;
            }
            case '\'': {
                this.moveFallingPiece(0, 1);
                break;
            }
            case '(': {
                this.moveFallingPiece(1, 0);
                break;
            }
            case '&': {
                this.rotateFallingPiece();
            }
        }
    }

    public void timerFired() {
        if (this.isGameOver) {
            return;
        }
        ++this.timerFiredCount;
        if (this.timerFiredCount == this.timerFiredLimit) {
            this.timerFiredCount = 0;
            if (!this.moveFallingPiece(1, 0)) {
                this.placeFallingPiece();
                this.newFallingPiece();
                if (!this.fallingPieceIsLegal()) {
                    this.isGameOver = true;
                    this.stopSounds();
                }
            }
        }
    }

    public void placeFallingPiece() {
        for (int row = 0; row < this.fallingPieceRows; ++row) {
            for (int col = 0; col < this.fallingPieceCols; ++col) {
                if (!this.fallingPiece[row][col]) continue;
                this.board[row + this.fallingPieceRow][col + this.fallingPieceCol] = this.fallingPieceColor;
            }
        }
        this.removeFullRows();
    }

    public void removeFullRows() {
        int col;
        int newRow = this.rows - 1;
        int fullRows = 0;
        for (int oldRow = this.rows - 1; oldRow >= 0; --oldRow) {
            if (this.isRowFull(oldRow)) {
                ++fullRows;
                continue;
            }
            if (oldRow != newRow) {
                for (col = 0; col < this.cols; ++col) {
                    this.board[newRow][col] = this.board[oldRow][col];
                }
            }
            --newRow;
        }
        for (int row = 0; row < fullRows; ++row) {
            for (col = 0; col < this.cols; ++col) {
                this.board[row][col] = this.emptyColor;
            }
        }
        this.score += fullRows * fullRows;
    }

    public boolean isRowFull(int row) {
        for (int col = 0; col < this.cols; ++col) {
            if (this.board[row][col] != this.emptyColor) continue;
            return false;
        }
        return true;
    }

    public void rotateFallingPiece() {
        int oldCols;
        boolean[][] oldPiece = this.fallingPiece;
        int oldFallingPieceRow = this.fallingPieceRow;
        int oldFallingPieceCol = this.fallingPieceCol;
        int oldRows = this.fallingPieceRows;
        this.fallingPieceRows = oldCols = this.fallingPieceCols;
        this.fallingPieceCols = oldRows;
        this.fallingPieceRow -= (oldCols - oldRows) / 2;
        this.fallingPieceCol -= (oldRows - oldCols) / 2;
        this.fallingPiece = new boolean[oldCols][oldRows];
        for (int oldRow = 0; oldRow < oldRows; ++oldRow) {
            for (int oldCol = 0; oldCol < oldCols; ++oldCol) {
                int newRow = oldCols - 1 - oldCol;
                int newCol = oldRow;
                this.fallingPiece[newRow][newCol] = oldPiece[oldRow][oldCol];
            }
        }
        if (!this.fallingPieceIsLegal()) {
            this.fallingPieceRow = oldFallingPieceRow;
            this.fallingPieceCol = oldFallingPieceCol;
            this.fallingPieceRows = oldRows;
            this.fallingPieceCols = oldCols;
            this.fallingPiece = oldPiece;
        }
    }

    public boolean moveFallingPiece(int drow, int dcol) {
        this.fallingPieceRow += drow;
        this.fallingPieceCol += dcol;
        boolean legalMove = this.fallingPieceIsLegal();
        if (!legalMove) {
            this.fallingPieceRow -= drow;
            this.fallingPieceCol -= dcol;
        }
        return legalMove;
    }

    public boolean fallingPieceIsLegal() {
        for (int row = 0; row < this.fallingPieceRows; ++row) {
            for (int col = 0; col < this.fallingPieceCols; ++col) {
                if (row + this.fallingPieceRow >= 0 && row + this.fallingPieceRow < this.rows && col + this.fallingPieceCol >= 0 && col + this.fallingPieceCol < this.cols && (!this.fallingPiece[row][col] || this.board[row + this.fallingPieceRow][col + this.fallingPieceCol] == this.emptyColor)) continue;
                return false;
            }
        }
        return true;
    }

    public void newFallingPiece() {
        int index = this.random.nextInt(TETRIS_PIECES.length);
        this.fallingPiece = TETRIS_PIECES[index];
        this.fallingPieceColor = TETRIS_PIECE_COLORS[index];
        this.fallingPieceRows = this.fallingPiece.length;
        this.fallingPieceCols = this.fallingPiece[0].length;
        this.fallingPieceRow = 0;
        this.fallingPieceCol = this.cols / 2 - this.fallingPieceCols / 2;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintBoard(graphics);
        this.paintFallingPiece(graphics);
        this.paintScore(graphics);
        if (this.isGameOver) {
            this.paintGameOver(graphics);
        }
    }

    public void paintScore(Graphics2D graphics) {
        graphics.setColor(this.scoreColor);
        graphics.setFont(new Font("Arial", 1, 16));
        Tetris.drawCenteredString(graphics, "Score: " + this.score, 0, 0, this.getWidth(), 20);
    }

    public void paintGameOver(Graphics2D graphics) {
        graphics.setColor(new Color(0, 0, 0, 160));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.yellow);
        graphics.setFont(new Font("Arial", 1, 36));
        graphics.drawString("Game Over!", 25, 150);
        graphics.setFont(new Font("Arial", 1, 16));
        graphics.drawString("Press 'r' to reset", 70, 200);
    }

    public void paintFallingPiece(Graphics2D graphics) {
        for (int row = 0; row < this.fallingPieceRows; ++row) {
            for (int col = 0; col < this.fallingPieceCols; ++col) {
                if (!this.fallingPiece[row][col]) continue;
                this.paintCell(graphics, row + this.fallingPieceRow, col + this.fallingPieceCol, this.fallingPieceColor);
            }
        }
    }

    public void paintBoard(Graphics2D graphics) {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                this.paintCell(graphics, row, col, this.board[row][col]);
            }
        }
    }

    public void paintCell(Graphics2D graphics, int row, int col, Color cellColor) {
        int cellLeft = this.boardMargin + col * this.cellSize;
        int cellTop = this.boardMargin + row * this.cellSize;
        graphics.setColor(this.gridColor);
        graphics.fillRect(cellLeft, cellTop, this.cellSize, this.cellSize);
        int innerSize = this.cellSize - 2 * this.cellMargin;
        graphics.setColor(cellColor);
        graphics.fillRect(cellLeft + this.cellMargin, cellTop + this.cellMargin, innerSize, innerSize);
    }
}

