/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JComponentWithEvents
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
ComponentListener,
ActionListener,
Runnable {
    public static final char UP = '&';
    public static final char DOWN = '(';
    public static final char LEFT = '%';
    public static final char RIGHT = '\'';
    public static final char DELETE = '\u007f';
    public static final char HOME = '$';
    public static final char PAGE_UP = '!';
    public static final char PAGE_DOWN = '\"';
    public static final char END = '#';
    public static final char SPACE = ' ';
    public static final char BACK_SPACE = '\b';
    public static final char ENTER = '\n';
    public static final char ESCAPE = '\u001b';
    public static final char SHIFT = '\u0010';
    public static final char CAPS_LOCK = '\u0014';
    public static final char CONTROL = '\u0011';
    public static final char ALT = '\u0012';
    public static final char F1 = 'p';
    public static final char F2 = 'q';
    public static final char F3 = 'r';
    public static final char F4 = 's';
    public static final char F5 = 't';
    public static final char F6 = 'u';
    public static final char F7 = 'v';
    public static final char F8 = 'w';
    public static final char F9 = 'x';
    public static final char F10 = 'y';
    public static final char F11 = 'z';
    public static final char F12 = '{';
    public static final int version = 3;
    private static boolean checkedVersion = false;
    private static HashMap<String, Image> fileToImageMap = new HashMap();
    private int _defaultWidth;
    private int _defaultHeight;
    private boolean _paused = false;
    private boolean _exited = false;
    private char _pauseKey = '\u0000';
    private char _unpauseKey = (char)112;
    private static int width0 = -1;
    private static int height0 = -1;
    private boolean started = false;
    private boolean isApplet = true;
    private JApplet applet = null;
    private boolean timerStopped = false;
    private String[] warningMessage = null;
    private Timer timer;
    private int _timerDelay = 250;
    private MouseEvent currentMouseEvent = null;
    private KeyEvent currentKeyEvent = null;
    private boolean ignoreModifierKeys = true;
    private HashMap<String, byte[]> fileCache = new HashMap();
    private HashSet<String> badAppletLocations = new HashSet();
    private Sequencer sequencer = null;
    private ArrayList<Clip> wavClips = new ArrayList();

    public void start() {
    }

    public void timerFired() {
    }

    public void paint(Graphics2D page) {
    }

    public void mousePressed(int x, int y) {
    }

    public void mouseDragged(int x, int y) {
    }

    public void mouseReleased(int x, int y) {
    }

    public void mouseClicked(int x, int y, int clickCount) {
    }

    public void mouseMoved(int x, int y) {
    }

    public void mouseEntered(int x, int y) {
    }

    public void mouseExited(int x, int y) {
    }

    public void keyPressed(char key) {
    }

    public void keyReleased(char key) {
    }

    public void keyTyped(char key) {
    }

    public void componentResized() {
    }

    public final void beep() {
        this.doBeep();
    }

    public final void exit() {
        this.doExit();
    }

    public final int getTimerDelay() {
        return this._timerDelay;
    }

    public final void setTimerDelay(int delay) {
        this.doSetTimerDelay(delay);
    }

    public final void stopTimer() {
        this.doStopTimer();
    }

    public final boolean isPaused() {
        return this._paused;
    }

    public final void setPaused(boolean paused) {
        this._paused = paused;
    }

    public final char getPauseKey() {
        return this._pauseKey;
    }

    public final void setPauseKey(char c) {
        this._pauseKey = c;
    }

    public final char getUnpauseKey() {
        return this._unpauseKey;
    }

    public final void setUnpauseKey(char c) {
        this._unpauseKey = c;
    }

    public final void setIgnoreModifierKeys(boolean b) {
        this.ignoreModifierKeys = b;
    }

    public final void play(String location) {
        this.doPlay(location, false);
    }

    public final void loop(String location) {
        this.doPlay(location, true);
    }

    public final void stopSounds() {
        this.doStopSounds();
    }

    public MouseEvent getMouseEvent() {
        return this.currentMouseEvent;
    }

    public KeyEvent getKeyEvent() {
        return this.currentKeyEvent;
    }

    public static final int getVersion() {
        return 3;
    }

    private final void checkVersion() {
        if (checkedVersion) {
            return;
        }
        checkedVersion = true;
        try {
            Scanner scanner;
            block7: {
                String url = "http://kosbie.net/cmu/fall-08/15-100/handouts/events/";
                scanner = null;
                try {
                    scanner = new Scanner(new URL(url).openStream());
                }
                catch (Exception e) {
                    if (!this.isApplet) break block7;
                    return;
                }
            }
            int version = -1;
            while (scanner.hasNext()) {
                String s = scanner.next();
                if (!s.startsWith("version=")) continue;
                s = s.substring("version=".length());
                int currentVersion = 0;
                for (int i = 0; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
                    currentVersion = 10 * currentVersion + s.charAt(i) - 48;
                }
                this.checkVersion(currentVersion);
                return;
            }
            throw new RuntimeException("Cannot find version number in JComponentWithEventsVersion.html");
        }
        catch (Exception e) {
            String msg = "Error in JComponentWithEvent.checkVersion: \n  " + e;
            this.showMessageDialog(msg);
            System.err.println(msg);
            return;
        }
    }

    private void checkVersion(int currentVersion) {
        if (3 == currentVersion) {
            return;
        }
        String infoUrl = "http://kosbie.net/cmu/fall-08/15-100/handouts/events/";
        String msg = "A different version of JComponentWithEvents is available.\nYou are using version 3.\nThe current version is version " + currentVersion + ".\n" + "Please see the following web page to download the current version:\n" + "   " + infoUrl;
        System.err.println(msg);
        this.showUrlInBrowser(infoUrl);
        String prompt = msg + "\n\nProceed with installed version anyway?";
        if (!this.showYesNoDialog(prompt)) {
            this.exit();
        }
    }

    private void showUrlInBrowser(String url) {
        if (this.applet != null) {
            try {
                this.applet.getAppletContext().showDocument(new URL(url), "_blank");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Object p = null;
            if (JComponentWithEvents.exec("iexplore.exe", url) != null) {
                return;
            }
            if (JComponentWithEvents.exec("\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"", url) != null) {
                return;
            }
            if (JComponentWithEvents.exec("open", "-a", "Firefox.app", url) != null) {
                return;
            }
        }
    }

    private static Process exec(String ... cmdArray) {
        try {
            return Runtime.getRuntime().exec(cmdArray);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public final int showOptionDialog(String prompt, String ... options) {
        int result = -1;
        while (result < 0) {
            result = JOptionPane.showOptionDialog(this, prompt, "Please choose...", -1, 3, null, options, options[0]);
            if (result >= 0) continue;
            this.beep();
        }
        return result;
    }

    public final boolean showYesNoDialog(String prompt) {
        int result = -1;
        while (result < 0) {
            result = this.showOptionDialog(prompt, "Yes", "No");
            if (result >= 0) continue;
            this.beep();
        }
        return result == 0;
    }

    public final String showInputDialog(String prompt) {
        String result = null;
        while (result == null) {
            result = JOptionPane.showInputDialog(this, (Object)prompt);
            if (result != null) continue;
            this.beep();
        }
        return result;
    }

    public static final void setLineThickness(Graphics page, int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        ((Graphics2D)page).setStroke(new BasicStroke(thickness));
    }

    public static final int getStringWidth(Graphics page, Font f, String s) {
        FontMetrics fm = page.getFontMetrics(f);
        Rectangle2D rect = fm.getStringBounds(s, page);
        return (int)Math.round(rect.getWidth());
    }

    public static final int getStringHeight(Graphics page, Font f, String s) {
        FontMetrics fm = page.getFontMetrics(f);
        Rectangle2D rect = fm.getStringBounds(s, page);
        return (int)Math.round(rect.getHeight());
    }

    public static final int getStringAscent(Graphics page, Font f, String s) {
        FontMetrics fm = page.getFontMetrics(f);
        return fm.getAscent();
    }

    public static final void drawCenteredString(Graphics page, String s, int left, int top, int width, int height) {
        Font font = page.getFont();
        int textWidth = JComponentWithEvents.getStringWidth(page, font, s);
        int textHeight = JComponentWithEvents.getStringHeight(page, font, s);
        int textAscent = JComponentWithEvents.getStringAscent(page, font, s);
        int textX = left + (width - textWidth) / 2;
        int textY = top + (height - textHeight) / 2 + textAscent;
        page.drawString(s, textX, textY);
    }

    public final void drawImage(Graphics page, String filename, int left, int top, double scale, double radians) {
        Image image = this.getImageFromFile(filename);
        this.drawImage(page, image, left, top, scale, radians);
    }

    public final void drawCenteredImage(Graphics page, String filename, int cx, int cy, double scale, double radians) {
        Image image = this.getImageFromFile(filename);
        this.drawCenteredImage(page, image, cx, cy, scale, radians);
    }

    public final void drawImage(Graphics page, Image image, int x, int y, double scale, double radians) {
        double imageWidth = image.getWidth(null);
        double imageHeight = image.getHeight(null);
        Dimension newSize = this.getImageSize(image, scale, radians);
        AffineTransform transform = new AffineTransform();
        transform.translate((double)x + newSize.getWidth() / 2.0, (double)y + newSize.getHeight() / 2.0);
        transform.rotate(radians);
        transform.scale(scale, scale);
        transform.translate(-imageWidth / 2.0, -imageHeight / 2.0);
        ((Graphics2D)page).drawImage(image, transform, null);
    }

    public final void drawCenteredImage(Graphics page, Image image, int cx, int cy, double scale, double radians) {
        Dimension newSize = this.getImageSize(image, scale, radians);
        this.drawImage(page, image, cx - (int)(newSize.getWidth() / 2.0), cy - (int)(newSize.getHeight() / 2.0), scale, radians);
    }

    public final Dimension getImageSize(String filename, double scale, double radians) {
        Image image = this.getImageFromFile(filename);
        return this.getImageSize(image, scale, radians);
    }

    public final Dimension getImageSize(Image image, double scale, double radians) {
        double imageWidth = image.getWidth(null);
        double imageHeight = image.getHeight(null);
        AffineTransform transform = new AffineTransform();
        transform.rotate(radians);
        transform.scale(scale, scale);
        transform.translate(-imageWidth / 2.0, -imageHeight / 2.0);
        double[] x = new double[]{0.0, imageWidth, imageWidth, 0.0};
        double[] y = new double[]{0.0, 0.0, imageHeight, imageHeight};
        double minx = 0.0;
        double maxx = 0.0;
        double miny = 0.0;
        double maxy = 0.0;
        Point2D.Double src = new Point2D.Double();
        Point2D.Double dst = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            src.setLocation(x[i], y[i]);
            transform.transform(src, dst);
            if (i == 0) {
                minx = maxx = dst.getX();
                miny = maxy = dst.getY();
                continue;
            }
            minx = Math.min(dst.getX(), minx);
            miny = Math.min(dst.getY(), miny);
            maxx = Math.max(dst.getX(), maxx);
            maxy = Math.max(dst.getY(), maxy);
        }
        return new Dimension((int)(maxx - minx), (int)(maxy - miny));
    }

    public final Image getImageFromFile(String filename) {
        URL url = null;
        if (this.applet != null) {
            try {
                url = new URL(this.applet.getCodeBase(), filename);
            }
            catch (Exception e) {
                throw new RuntimeException("" + e);
            }
        } else if (!new File(filename).exists()) {
            throw new RuntimeException("File does not exist: " + filename);
        }
        Image image = fileToImageMap.get(filename);
        if (image == null) {
            image = this.applet != null ? this.applet.getImage(url) : new ImageIcon(filename).getImage();
            fileToImageMap.put(filename, image);
        }
        return image;
    }

    public static final boolean shapesIntersect(Shape s1, Shape s2) {
        Area area = new Area(s1);
        area.intersect(new Area(s2));
        return !area.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized JComponentWithEvents newInstance(Class c, int w, int h) {
        JComponentWithEvents result = null;
        if (width0 != -1) {
            throw new RuntimeException("width0 is not -1");
        }
        try {
            width0 = w;
            height0 = h;
            result = (JComponentWithEvents)c.newInstance();
        }
        catch (Exception e) {
            System.out.println("Err!");
            e.printStackTrace();
        }
        finally {
            width0 = -1;
            height0 = -1;
        }
        return result;
    }

    public JComponentWithEvents() {
        if (width0 == -1) {
            return;
        }
        this._defaultWidth = width0;
        this._defaultHeight = height0;
        this.setPreferredSize(new Dimension(this._defaultWidth, this._defaultHeight));
    }

    private void deferredDoStart() {
        if (!this.started) {
            this.start();
            this.repaint();
            this.started = true;
        }
    }

    @Override
    public final void run() {
        this.deferredDoStart();
    }

    private void doStart() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public final int getWidth() {
        int w = super.getWidth();
        return w > 0 ? w : this._defaultWidth;
    }

    @Override
    public final int getHeight() {
        int h = super.getHeight();
        return h > 0 ? h : this._defaultHeight;
    }

    @Override
    public final void paint(Graphics page) {
        super.paint(page);
    }

    @Override
    public final void paintComponent(Graphics page) {
        if (this.timer == null) {
            this.timer = new Timer(this._timerDelay, this);
            if (!this.timerStopped) {
                this.timer.start();
            }
        }
        if (!this.started) {
            return;
        }
        page.setColor(Color.white);
        page.fillRect(0, 0, this.getWidth(), this.getHeight());
        page.setColor(Color.black);
        if (this.warningMessage != null) {
            page.setColor(Color.red);
            page.setFont(new Font("SansSerif", 1, 20));
            for (int i = 0; i < this.warningMessage.length; ++i) {
                page.drawString(this.warningMessage[i], 20, 30 + 30 * i);
            }
        } else if (this._paused || this._exited) {
            page.setFont(new Font("SansSerif", 1, 32));
            JComponentWithEvents.drawCenteredString(page, this._exited ? "Exited!" : "Paused!", 0, 0, this.getWidth(), this.getHeight());
        } else {
            HashMap<Field, Object> oldValuesMap = this.getNonLocalVariableValues();
            this.paint((Graphics2D)page);
            this.checkNonLocalVariableValues(oldValuesMap);
        }
    }

    private void setWarningMessage(String ... msg) {
        this.warningMessage = msg;
        this.beep();
        this.repaint();
    }

    private HashMap<Field, Object> getNonLocalVariableValues() {
        try {
            HashMap<Field, Object> valuesMap = new HashMap<Field, Object>();
            for (Field field : this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                valuesMap.put(field, this.get(this, field));
            }
            return valuesMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void checkNonLocalVariableValues(HashMap<Field, Object> oldValuesMap) {
        if (oldValuesMap == null) {
            return;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object oldValue = oldValuesMap.get(field);
            Object newValue = this.get(this, field);
            if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) continue;
            this.setWarningMessage("Warning:  Field changed in paint method!", "Field: " + field.getName(), "   Changed from: " + oldValue, "   Changed to: " + newValue, "Fields should only be changed in event handlers", "and never in paint methods!");
        }
    }

    private Object get(Object object, Field field) {
        field.setAccessible(true);
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    private void doExit() {
        if (this.applet == null) {
            System.exit(0);
        } else {
            this._paused = true;
            this._exited = true;
            this.doStopSounds();
        }
    }

    private void doBeep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private void doSetTimerDelay(int millis) {
        this.timerStopped = false;
        this._timerDelay = Math.max(1, millis);
        if (this.timer != null) {
            this.timer.setDelay(this._timerDelay);
            this.timer.setInitialDelay(this._timerDelay);
            this.timer.restart();
        }
    }

    private void doStopTimer() {
        this.timerStopped = true;
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.componentResized();
        this.repaint();
    }

    @Override
    public final void actionPerformed(ActionEvent evt) {
        if (!this.started || this._paused) {
            return;
        }
        this.timerFired();
        this.repaint();
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mousePressed(e.getX(), e.getY());
        this.currentMouseEvent = null;
        this.repaint();
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseReleased(e.getX(), e.getY());
        this.currentMouseEvent = null;
        this.repaint();
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseDragged(e.getX(), e.getY());
        this.currentMouseEvent = null;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseEntered(e.getX(), e.getY());
        this.currentMouseEvent = null;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseExited(e.getX(), e.getY());
        this.currentMouseEvent = e;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseClicked(e.getX(), e.getY(), e.getClickCount());
        this.currentMouseEvent = e;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        this.currentMouseEvent = e;
        this.mouseMoved(e.getX(), e.getY());
        this.currentMouseEvent = e;
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        char key = this.getKeyEventChar(e);
        if (key == '\u0000') {
            return;
        }
        this.currentKeyEvent = e;
        this.keyReleased(key);
        this.currentKeyEvent = null;
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!this.started || this._paused) {
            return;
        }
        char key = this.getKeyEventChar(e);
        if (key == '\u0000') {
            return;
        }
        this.currentKeyEvent = e;
        this.keyTyped(key);
        this.currentKeyEvent = null;
        this.repaint();
    }

    @Override
    public final void keyPressed(KeyEvent e) {
        if (!this.started || this._exited) {
            return;
        }
        char key = this.getKeyEventChar(e);
        if (key == '\u0000') {
            return;
        }
        this.currentKeyEvent = e;
        if (!this._paused && key == this._pauseKey) {
            this._paused = true;
            this.doPauseSounds();
        } else if (this._paused && !this._exited && key == this._unpauseKey) {
            this._paused = false;
            this.doUnpauseSounds();
        } else {
            this.keyPressed(key);
        }
        this.currentKeyEvent = null;
        this.repaint();
    }

    private char getKeyEventChar(KeyEvent e) {
        char key;
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        char c = key = keyChar < '\uffff' ? keyChar : (char)keyCode;
        if (this.ignoreModifierKeys && (key == '\u0010' || key == '\u0014' || key == '\u0011' || key == '\u0012')) {
            key = '\u0000';
        }
        return key;
    }

    private void addEventListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
    }

    public static final void launch() {
        JComponentWithEvents.launch(500, 400);
    }

    public static final synchronized void launch(int width, int height) {
        try {
            StackTraceElement ste;
            Class<?> nextC;
            StackTraceElement[] em;
            Class<?> c = null;
            StackTraceElement[] arr$ = em = new Exception().getStackTrace();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && JComponentWithEvents.class.isAssignableFrom(nextC = Class.forName((ste = arr$[i$]).getClassName())); ++i$) {
                c = nextC;
            }
            if (c == null) {
                throw new RuntimeException("No main class");
            }
            JComponentWithEvents comp = JComponentWithEvents.newInstance(c, width, height);
            comp.isApplet = false;
            JFrame frame = new JFrame(comp.getClass().getName());
            frame.setDefaultCloseOperation(3);
            JPanel cp = new JPanel();
            cp.setLayout(new BorderLayout());
            cp.add(comp);
            frame.setContentPane(cp);
            frame.pack();
            frame.setVisible(true);
            comp.launchApplet(null);
        }
        catch (Exception e) {
            System.out.println("Err!");
            e.printStackTrace();
        }
    }

    public final void launchApplet(JApplet applet) {
        try {
            this.checkVersion();
            this.applet = applet;
            this.addEventListeners();
            this.setFocusable(true);
            this.requestFocusInWindow();
            this.doStart();
        }
        catch (Exception e) {
            System.out.println("Err!");
            e.printStackTrace();
        }
    }

    private URL toUrl(String location) throws Exception {
        if (location == null) {
            return null;
        }
        if (location.startsWith("http")) {
            return new URL(location);
        }
        return new File(location).toURI().toURL();
    }

    private InputStream toInputStream(String location) throws Exception {
        byte[] data = this.fileCache.get(location);
        if (data == null) {
            int len;
            InputStream is = location.startsWith("http") ? new URL(location).openStream() : (this.applet != null ? new URL(this.applet.getCodeBase(), location).openStream() : new FileInputStream(new File(location)));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            data = bos.toByteArray();
            this.fileCache.put(location, data);
        }
        return new ByteArrayInputStream(data);
    }

    private boolean inSandbox() {
        SecurityManager mgr = System.getSecurityManager();
        if (mgr == null) {
            return false;
        }
        try {
            mgr.checkExit(-1);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public final boolean isApplet() {
        return this.inSandbox();
    }

    private void doPlay(String location, boolean loop) {
        if (location == null) {
            return;
        }
        String err = null;
        if (!(location.endsWith("wav") || location.endsWith("mid") || location.endsWith("midi"))) {
            err = "Unknown file type: " + location;
        } else {
            try {
                InputStream is = this.toInputStream(location);
                if (location.endsWith("wav")) {
                    this.doPlayWav(is, loop);
                } else if (location.endsWith("midi") || location.endsWith("mid")) {
                    this.doPlayMidi(is, loop);
                }
            }
            catch (Exception e) {
                err = e.getMessage();
                if (this.isApplet) {
                    if (!this.badAppletLocations.contains(location)) {
                        System.err.println("Applet cannot access: " + location);
                    }
                    this.badAppletLocations.add(location);
                }
                e.printStackTrace();
                throw new RuntimeException(err);
            }
        }
    }

    private void doStopSounds() {
        this.doStopWavSounds();
        this.doStopMidiSounds();
    }

    private void doPauseSounds() {
        this.doPauseWavSounds();
        this.doPauseMidiSounds();
    }

    private void doUnpauseSounds() {
        this.doUnpauseWavSounds();
        this.doUnpauseMidiSounds();
    }

    private void doPlayMidi(InputStream is, boolean loop) {
        try {
            this.doStopMidiSounds();
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.setSequence(MidiSystem.getSequence(is));
            if (loop) {
                this.sequencer.setLoopCount(-1);
            }
            this.sequencer.open();
            this.sequencer.start();
        }
        catch (Exception e) {
            this.midiError("" + e);
        }
    }

    private void midiError(String msg) {
        System.err.println("Midi error: " + msg);
        this.sequencer = null;
    }

    private void doStopMidiSounds() {
        try {
            if (this.sequencer == null || !this.sequencer.isRunning()) {
                return;
            }
            this.sequencer.stop();
            this.sequencer.close();
        }
        catch (Exception e) {
            this.midiError("" + e);
        }
        this.sequencer = null;
    }

    private void doPauseMidiSounds() {
        try {
            if (this.sequencer == null || !this.sequencer.isRunning()) {
                return;
            }
            this.sequencer.stop();
        }
        catch (Exception e) {
            this.midiError("" + e);
        }
    }

    private void doUnpauseMidiSounds() {
        try {
            if (this.sequencer == null) {
                return;
            }
            this.sequencer.start();
        }
        catch (Exception e) {
            this.midiError("" + e);
        }
    }

    private void doPlayWav(InputStream is, boolean loop) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(is);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
        }
        catch (Exception e) {
            throw new RuntimeException("" + e);
        }
    }

    private void doPauseWavSounds() {
        for (Clip clip : this.wavClips) {
            clip.stop();
        }
    }

    private void doUnpauseWavSounds() {
        for (Clip clip : this.wavClips) {
            clip.start();
        }
    }

    private void doStopWavSounds() {
        for (Clip clip : this.wavClips) {
            clip.stop();
        }
        this.wavClips.clear();
    }

    public static void main(String[] args) {
        JComponentWithEvents.launch(500, 300);
    }
}

