/*
 * Copyright (c) 2008, 2009, 2010, 2011, 2012, 2013 Kernel Drivers, LLC.
 * Copyright (c) 2009, 2010, 2011, 2012, 2013 Your File System, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 * - Neither the names of Kernel Drivers, LLC and Your File System, Inc.
 *   nor the names of their contributors may be used to endorse or promote
 *   products derived from this software without specific prior written
 *   permission from Kernel Drivers, LLC and Your File System, Inc.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _AFS_USER_IOCTL_H
#define _AFS_USER_IOCTL_H
                    
//
// IOCtl definitions
//

#define IOCTL_AFS_INITIALIZE_CONTROL_DEVICE     CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1001, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_INITIALIZE_REDIRECTOR_DEVICE  CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1002, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_PROCESS_IRP_REQUEST           CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1003, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_PROCESS_IRP_RESULT            CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1004, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SET_FILE_EXTENTS              CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1005, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_RELEASE_FILE_EXTENTS          CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1006, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_INVALIDATE_CACHE              CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1007, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SET_FILE_EXTENT_FAILURE       CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1008, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_NETWORK_STATUS                CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1009, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_VOLUME_STATUS                 CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100A, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SHUTDOWN                      CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100B, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SYSNAME_NOTIFICATION          CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100C, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_STATUS_REQUEST                CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100D, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SET_BYTE_RANGE_LOCKS          CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100E, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_CONFIGURE_DEBUG_TRACE         CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x100F, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_GET_TRACE_BUFFER              CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1010, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_FORCE_CRASH                   CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1011, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_INITIALIZE_LIBRARY_DEVICE     CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1012, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_GET_OBJECT_INFORMATION        CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1013, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_CREATE_AND_SET      CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1014, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_QUERY               CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1015, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_SET                 CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1016, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_RESET               CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1017, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_SID_CREATE          CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1018, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_SID_QUERY           CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x1019, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_AUTHGROUP_LOGON_CREATE        CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x101A, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_CONFIG_LIBRARY_TRACE          CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x101B, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_SET_REPARSE_POLICY            CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x101C, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_GET_REPARSE_POLICY            CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x101D, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_AFS_GET_DEBUG_TRACE               CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x101E, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif /* _AFS_USER_IOCTL_H */
