/*
 * Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 * 
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 */

#ifndef TRANSARC_LOGEVENT_H
#define TRANSARC_LOGEVENT_H

#define AFSEVT_MAXARGS  16   /* max number of text insertion strings */

extern int
ReportErrorEventAlt(unsigned int eventId, int status, char *str, ...);

extern int
ReportWarningEventAlt(unsigned int eventId, int status, char *str, ...);

extern int
ReportInformationEventAlt(unsigned int eventId, char *str, ...);

#endif /* TRANSARC_LOGEVENT_H */
/* Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 *
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 * event.mc --(mc)--> event.[h|rc] --(logevent.h + event.h)--> afsevent.h
 */

#ifndef TRANSARC_AFSEVENT_H
#define TRANSARC_AFSEVENT_H


/* AFS event.mc format.
 *
 * AFS event messages are grouped by category.  The MessageId of the
 * first message in a given category specifies the starting identifier
 * range for that category; the second and later messages in a category
 * do NOT specify a MessageId value and thus receive the value of the
 * previous message plus one.
 *
 * To add a new message to an existing category, append it to the end of
 * that category.  To create a new category, provide an appropriate
 * comment line and specify a non-conflicting MessageId for the first
 * message in the new category.
 */


/* Test message text */

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//


//
// MessageId: AFSEVT_SVR_TEST_MSG_NOARGS
//
// MessageText:
//
//  AFS ¼־Ϣ
//
#define AFSEVT_SVR_TEST_MSG_NOARGS       ((unsigned)0x60000001L)

//
// MessageId: AFSEVT_SVR_TEST_MSG_TWOARGS
//
// MessageText:
//
//  AFS ¼־Ϣ(str1: %1 str2: %2)
//
#define AFSEVT_SVR_TEST_MSG_TWOARGS      ((unsigned)0xA0000002L)


/* General messages for all AFS server processes */

//
// MessageId: AFSEVT_SVR_FAILED_ASSERT
//
// MessageText:
//
//  AFS ʧܣļ %2  %1
//
#define AFSEVT_SVR_FAILED_ASSERT         ((unsigned)0xE0000101L)

//
// MessageId: AFSEVT_SVR_NO_INSTALL_DIR
//
// MessageText:
//
//  %1 λ AFS װĿ¼ʧܡ
//
#define AFSEVT_SVR_NO_INSTALL_DIR        ((unsigned)0xE0000102L)

//
// MessageId: AFSEVT_SVR_WINSOCK_INIT_FAILED
//
// MessageText:
//
//  %1 ʼ Windows ׽ֿʧܡ
//
#define AFSEVT_SVR_WINSOCK_INIT_FAILED   ((unsigned)0xE0000103L)


/* AFS BOS control (startup/shutdown) service messages */

//
// MessageId: AFSEVT_SVR_BCS_STARTED
//
// MessageText:
//
//  AFS BOS Ʒ
//
#define AFSEVT_SVR_BCS_STARTED           ((unsigned)0x60000201L)

//
// MessageId: AFSEVT_SVR_BCS_STOPPED
//
// MessageText:
//
//  AFS BOS Ʒֹͣ
//
#define AFSEVT_SVR_BCS_STOPPED           ((unsigned)0x60000202L)

//
// MessageId: AFSEVT_SVR_BCS_SCM_COMM_FAILED
//
// MessageText:
//
//  AFS BOS Ʒ޷ϵͳ SCM ͨš
//
#define AFSEVT_SVR_BCS_SCM_COMM_FAILED   ((unsigned)0xE0000203L)

//
// MessageId: AFSEVT_SVR_BCS_HANDLER_REG_FAILED
//
// MessageText:
//
//  AFS BOS Ʒ޷ע¼
//  AFS δȷá
//
#define AFSEVT_SVR_BCS_HANDLER_REG_FAILED ((unsigned)0xE0000204L)

//
// MessageId: AFSEVT_SVR_BCS_INSUFFICIENT_RESOURCES
//
// MessageText:
//
//  AFS BOS Ʒ޷ñϵͳԴ
//
#define AFSEVT_SVR_BCS_INSUFFICIENT_RESOURCES ((unsigned)0xE0000205L)

//
// MessageId: AFSEVT_SVR_BCS_INTERNAL_ERROR
//
// MessageText:
//
//  AFS BOS Ʒһڲ
//
#define AFSEVT_SVR_BCS_INTERNAL_ERROR    ((unsigned)0xE0000206L)

//
// MessageId: AFSEVT_SVR_BCS_NO_INSTALL_DIR
//
// MessageText:
//
//  AFS BOS Ʒλ AFS װĿ¼ʧܡAFS δȷá
//
#define AFSEVT_SVR_BCS_NO_INSTALL_DIR    ((unsigned)0xE0000207L)

//
// MessageId: AFSEVT_SVR_BCS_BOSSERVER_START_FAILED
//
// MessageText:
//
//  AFS BOS Ʒ AFS bosserver ʧܡ
//
#define AFSEVT_SVR_BCS_BOSSERVER_START_FAILED ((unsigned)0xE0000208L)

//
// MessageId: AFSEVT_SVR_BCS_BOSSERVER_STOP_FAILED
//
// MessageText:
//
//  AFS BOS Ʒֹͣ AFS bosserver ʧܡ AFS ̱
//  ֹֹͣ(ͨ afskill  AFS bosserver  SIGQUIT ź)
//
#define AFSEVT_SVR_BCS_BOSSERVER_STOP_FAILED ((unsigned)0xE0000209L)

//
// MessageId: AFSEVT_SVR_BCS_BOSSERVER_STOP_TIMEOUT
//
// MessageText:
//
//  AFS BOS Ʒȴ AFS bosserver ֹͣǰ AFS Ƿֹͣ
//
#define AFSEVT_SVR_BCS_BOSSERVER_STOP_TIMEOUT ((unsigned)0xA000020AL)

//
// MessageId: AFSEVT_SVR_BCS_BOSSERVER_RESTART
//
// MessageText:
//
//  AFS BOS Ʒ AFS bosserver
//
#define AFSEVT_SVR_BCS_BOSSERVER_RESTART ((unsigned)0x6000020BL)

//
// MessageId: AFSEVT_SVR_BCS_BOSSERVER_EXIT
//
// MessageText:
//
//  AFS BOS Ʒ⵽ AFS bosserver û˳
//
#define AFSEVT_SVR_BCS_BOSSERVER_EXIT    ((unsigned)0x6000020CL)


#endif /* TRANSARC_AFSEVENT_H */
