/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;

public class Registry {
    protected DataHashtable nameToObjectHashtable = new DataHashtable();
    protected DataHashtable objectToNameHashtable = new DataHashtable();
    protected boolean allowNamesToMapToMultipleObjects;

    public Registry(boolean bl) {
        this.allowNamesToMapToMultipleObjects = bl;
    }

    protected DataHashtable getNameToObjectHashtable() {
        return this.nameToObjectHashtable;
    }

    protected DataHashtable getObjectToNameHashtable() {
        return this.objectToNameHashtable;
    }

    protected boolean getAllowNamesToMapToMultipleObjects() {
        return this.allowNamesToMapToMultipleObjects;
    }

    public boolean register(String string, Object object) {
        if (object instanceof DataVector) {
            System.err.println("[Registry:register]  Error:  Object may not be an instance of the DataVector class.");
            return false;
        }
        if (this.hasNameObjectPair(string, object)) {
            System.err.println("[Registry:register]  Warning:  Object/Name already registered together.  (\"" + string + "\")");
            return true;
        }
        if (!this.getAllowNamesToMapToMultipleObjects() && this.getIsNameRegistered(string)) {
            System.err.println("[Registry:register]  Warning:  Name already registered.  (\"" + string + "\")");
            return false;
        }
        if (this.getIsObjectRegistered(object)) {
            System.err.println("[Registry:register]  Warning:  Object already registered under name \"" + this.getNameForObject(object) + "\".");
            return false;
        }
        if (!this.getIsNameRegistered(string)) {
            this.getNameToObjectHashtable().put(string, object);
        } else {
            DataVector dataVector = this.getObjectsForName(string);
            dataVector.addElement(object);
            this.getNameToObjectHashtable().put(string, dataVector);
        }
        this.getObjectToNameHashtable().put(object, string);
        return true;
    }

    public boolean unregister(Object object) {
        if (!this.getIsObjectRegistered(object)) {
            System.err.println("[Registry:unregister]  Warning:  Object is not registered.");
            return false;
        }
        String string = this.getNameForObject(object);
        if (string == null) {
            System.err.println("[Registry:unregister]  Warning:  Object's name is not registered.");
        } else {
            switch (this.getNumberOfObjectsForName(string)) {
                case 0: {
                    System.err.println("[Registry:unregister]  Warning:  No Object's registered under Object's Name.");
                    break;
                }
                case 1: {
                    if (this.getFirstObjectForName(string) != object) {
                        System.err.println("[Registry:unregister]  Warning:  Object's Name's Object is not Object.");
                        break;
                    }
                    this.getNameToObjectHashtable().remove(string);
                    break;
                }
                default: {
                    if (this.getObjectsForName(string).removeElement(object)) break;
                    System.err.println("[Registry:unregister]  Warning:  Object not found under Object's Name.");
                }
            }
        }
        this.getObjectToNameHashtable().remove(object);
        return true;
    }

    public DataVector getObjectsForName(String string) {
        Object v = this.getNameToObjectHashtable().get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof DataVector) {
            if (((DataVector)v).count() <= 0) {
                return null;
            }
            return (DataVector)v;
        }
        DataVector dataVector = new DataVector(1);
        dataVector.addElement(v);
        return dataVector;
    }

    public Object getFirstObjectForName(String string) {
        Object v = this.getNameToObjectHashtable().get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof DataVector) {
            if (((DataVector)v).count() <= 0) {
                return null;
            }
            return ((DataVector)v).elementAt(0);
        }
        return v;
    }

    public int getNumberOfObjectsForName(String string) {
        Object v = this.getNameToObjectHashtable().get(string);
        if (v == null) {
            return 0;
        }
        if (v instanceof DataVector) {
            return ((DataVector)v).count();
        }
        return 1;
    }

    public String getNameForObject(Object object) {
        return (String)this.getObjectToNameHashtable().get(object);
    }

    public boolean hasNameObjectPair(String string, Object object) {
        switch (this.getNumberOfObjectsForName(string)) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.getFirstObjectForName(string) == object) break;
                return false;
            }
            default: {
                if (this.getObjectsForName(string).contains(object)) break;
                return false;
            }
        }
        return this.getNameForObject(object) == string;
    }

    public boolean getIsNameRegistered(String string) {
        return this.getFirstObjectForName(string) != null;
    }

    public boolean getIsObjectRegistered(Object object) {
        return this.getNameForObject(object) != null;
    }

    public Enumeration getObjects() {
        return this.getObjectToNameHashtable().keys();
    }

    public Enumeration getNames() {
        return this.getNameToObjectHashtable().keys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getNames();
        stringBuffer.append("Registry ");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append(":\n");
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("     \"");
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append("\"\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

