/*
 * Decompiled with CFR 0.152.
 */
public class DataForStatement
extends DataIterationStatement {
    public static final String FOR = "for";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String INITIAL_EXPRESSION_INDEX = "InitialExprIndex";
    public static final String TEST_EXPRESSION_INDEX = "TestExprIndex";
    public static final String ITERATION_EXPRESSION_INDEX = "IterExprIndex";
    public static final String STATEMENT_INDEX = "StatementIndex";
    public static final String SEMICOLON = ";";
    public static final int FOR_INIT_ONLY = 8;
    public static final int FOR_TEST_ONLY = 9;
    public static final int FOR_ITERATION_ONLY = 10;
    protected DataStatement initialExpressionOrDeclarationStatement = null;
    protected DataExpression testExpression = null;
    protected DataExpression iterationExpression = null;

    public DataStatement getInitialExpressionOrDeclarationStatement() {
        return this.initialExpressionOrDeclarationStatement;
    }

    public void setInitialExpressionOrDeclarationStatement(DataStatement dataStatement) {
        if (dataStatement instanceof DataExpressionStatement || dataStatement instanceof DataDeclarationStatement) {
            if (this.initialExpressionOrDeclarationStatement != null) {
                this.initialExpressionOrDeclarationStatement.setParent(null);
            }
            this.initialExpressionOrDeclarationStatement = dataStatement;
            if (this.initialExpressionOrDeclarationStatement != null) {
                this.initialExpressionOrDeclarationStatement.setParent(this);
            }
        } else {
            this.initialExpressionOrDeclarationStatement = null;
            System.err.println("[DataForStatement:setInitialExpressionOrDeclarationStatement]  Error:  Initial \"statement\" must be a DataExpressionStatement or a DataDeclarationStatement, not a \"" + dataStatement.getClass().getName() + "\".   initialExpressionOrDeclarationStatement SET TO NULL INSTEAD!");
        }
    }

    public DataExpression getTestExpression() {
        return this.testExpression;
    }

    public void setTestExpression(DataExpression dataExpression) {
        if (this.testExpression != null) {
            this.testExpression.setParent(null);
        }
        this.testExpression = dataExpression;
        if (this.testExpression != null) {
            this.testExpression.setParent(this);
        }
    }

    public DataExpression getIterationExpression() {
        return this.iterationExpression;
    }

    public void setIterationExpression(DataExpression dataExpression) {
        if (this.iterationExpression != null) {
            this.iterationExpression.setParent(null);
        }
        this.iterationExpression = dataExpression;
        if (this.iterationExpression != null) {
            this.iterationExpression.setParent(this);
        }
    }

    public boolean hasSubcomponentFraction(String string) {
        return super.hasSubcomponentFraction(string) || this.getInitialExpressionOrDeclarationStatement() != null && this.getInitialExpressionOrDeclarationStatement().hasSubcomponentFraction(string) || this.getTestExpression() != null && this.getTestExpression().hasSubcomponentFraction(string) || this.getIterationExpression() != null && this.getIterationExpression().hasSubcomponentFraction(string);
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        if (this.getInitialExpressionOrDeclarationStatement() != null) {
            this.getInitialExpressionOrDeclarationStatement().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getTestExpression() != null) {
            this.getTestExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getIterationExpression() != null) {
            this.getIterationExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataForStatement.FOR_INIT_ONLY (" + 8 + ") or DataForStatement.FOR_TEST_ONLY (" + 9 + ") or DataForStatement.FOR_ITERATION_ONLY (" + 10 + CLOSE_PAREN;
    }

    public boolean isValidObjectSubset(int n) {
        if (n == 8 || n == 9 || n == 10) {
            return true;
        }
        return super.isValidObjectSubset(n);
    }

    public boolean isValid(int n) {
        if (n == 8 || n == 9 || n == 10) {
            return true;
        }
        if (this.getStatement() == null) {
            return false;
        }
        return super.isValid(n);
    }

    public void generateInit(DataDestination dataDestination, int n, boolean bl) {
        boolean bl2 = bl;
        if (this.getInitialExpressionOrDeclarationStatement() != null && this.getInitialExpressionOrDeclarationStatement().hasLeadingWhitespaceSubcomponent()) {
            bl2 = false;
        }
        this.initializeGenerateSubcomponentIndex(OPEN_PAREN);
        this.generateSubcomponents(INITIAL_EXPRESSION_INDEX, dataDestination, n, bl2);
        if (this.getInitialExpressionOrDeclarationStatement() != null) {
            boolean bl3 = dataDestination.getEnableLineMacros();
            dataDestination.setEnableLineMacros(false);
            this.getInitialExpressionOrDeclarationStatement().generate(dataDestination, n);
            dataDestination.setEnableLineMacros(bl3);
        } else {
            dataDestination.write(SEMICOLON);
        }
    }

    public void generateTest(DataDestination dataDestination, int n, boolean bl) {
        boolean bl2 = bl;
        if (this.getTestExpression() != null && this.getTestExpression().hasLeadingWhitespaceSubcomponent()) {
            bl2 = false;
        }
        if (this.hasIndex(INITIAL_EXPRESSION_INDEX)) {
            this.initializeGenerateSubcomponentIndex(INITIAL_EXPRESSION_INDEX);
        } else {
            this.initializeGenerateSubcomponentIndex(OPEN_PAREN);
        }
        this.generateSubcomponents(TEST_EXPRESSION_INDEX, dataDestination, n, bl2);
        if (this.getTestExpression() != null) {
            this.getTestExpression().generate(dataDestination, n);
        }
        this.generateSubcomponents(SEMICOLON, dataDestination, n, false);
    }

    public void generateIteration(DataDestination dataDestination, int n, boolean bl) {
        boolean bl2 = bl;
        boolean bl3 = bl;
        if (this.getIterationExpression() != null) {
            if (this.getIterationExpression().hasLeadingWhitespaceSubcomponent()) {
                bl2 = false;
            }
            if (this.getIterationExpression().hasTrailingWhitespaceSubcomponent()) {
                bl3 = false;
            }
        }
        this.initializeGenerateSubcomponentIndex(SEMICOLON);
        this.generateSubcomponents(ITERATION_EXPRESSION_INDEX, dataDestination, n, bl2);
        if (this.getIterationExpression() != null) {
            this.getIterationExpression().generate(dataDestination, n);
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n, bl3);
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 8) {
            this.generateInit(dataDestination, 0, false);
            return;
        }
        if (n == 9) {
            this.generateTest(dataDestination, 0, false);
            return;
        }
        if (n == 10) {
            this.generateIteration(dataDestination, 0, false);
            return;
        }
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, FOR, this.getLabel() == null);
        this.generateSubcomponents(FOR, dataDestination, n, false);
        this.generatePreIterationCode(dataDestination, n);
        this.generateRelevantLineNumberMacros(dataDestination, this.getLineNumber(), 0);
        dataDestination.write(FOR);
        this.generateSubcomponents(OPEN_PAREN, dataDestination, n, false);
        dataDestination.write(OPEN_PAREN);
        this.generateInit(dataDestination, n, true);
        this.generateTest(dataDestination, n, true);
        dataDestination.write(SEMICOLON);
        this.generateIteration(dataDestination, n, true);
        dataDestination.write(CLOSE_PAREN);
        this.generateSubcomponents(STATEMENT_INDEX, dataDestination, n, false);
        if (this.getStatement() != null) {
            this.addInsideIterationCode(n, this.getStatement());
            this.getStatement().generate(dataDestination, n);
            this.removeInsideIterationCode(n, this.getStatement());
        } else {
            this.generateEmptyIterationBodyStatement(dataDestination, n);
        }
        this.generatePostIterationCode(dataDestination, n);
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }
}

