/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TDLC {
    public static final String MAJOR_VERSION_NUMBER = "1";
    public static final String MINOR_VERSION_NUMBER = "3";
    public static final String MICRO_VERSION_NUMBER = "6A";
    public static final String VERSION_NUMBER = "1.3.6A";
    public static final boolean DEBUG_ENABLED = false;
    public static final char UNSET_VALUE = ' ';
    public static final int NO_SUBSET = 0;
    public static final int GENERATE_HEADER_ONLY = -1;
    public static final char ARG_HELP = 'h';
    public static final char ARG_VERSION = 'V';
    public static final char ARG_DEBUG = 'n';
    public static final char ARG_VERBOSE = 'v';
    public static final char ARG_YES = 'y';
    public static final char ARG_DISABLE_LINE_MACROS = 'L';
    public static final char ARG_USE_LINE_NOT_FILENAME = 'l';
    public static final char ARG_ENABLE_VALIDATION = 'W';
    public static final char ARG_DISABLE_VALIDATION = 'Q';
    public static final char ARG_STANDARD_USING = 'u';
    public static final char ARG_NO_USING = 'N';
    public static final char ARG_TRANLATE_USING = 't';
    public static final char ARG_DELETE_EXTERN_TASKS = 'd';
    public static final char ARG_ENABLE_EXTERN_TASKS = 'e';
    public static final char ARG_DELETE_NON_TASK_CODE = 'D';
    public static final char ARG_ENABLE_NON_TASK_CODE = 'E';
    public static final char ARG_FULL_INLINE_TYPE = '1';
    public static final char ARG_FULL_EXTERN_TYPE = '2';
    public static final char ARG_HIDE_EXTERN_TYPE = '3';
    public static final char ARG_COMBINED_EXTERN_TYPE = '4';
    public static final char ARG_DISTRIBUTED_ONLY_INLINE = '5';
    public static final char ARG_DISTRIBUTED_ONLY_EXTERN = '6';
    public static final char ARG_HTML = 'm';
    public static final char ARG_SMART_ANALYZER = 'a';
    public static final char ARG_INLINED_CXX = 'i';
    public static final char ARG_HEADER_CXX = 'H';
    public static final char ARG_CODE_CXX = 'C';
    public static final char ARG_STANDARD_CXX = 'S';
    public static final char ARG_LOAD_USING = 's';
    public static final char ARG_INCLUDE_DIR = 'I';
    public static final char ARG_USING_DIR = 'U';
    public static final char ARG_USE_OLD_ROOT_NODE_VALUE = 'r';
    public static final char ARG_ADD_TEXT = 'A';
    public static final char ARG_OUT_FILE = 'o';
    public static final String USAGE_STRING = "Usage:  java TDLC [-hVnvyLlWQuNtedED123456maiHCSsr] [-{IU} <dir>] [-A <text>] [-o <file>] [<file>]\n  -h         -- Just show this usage list.\n  -V         -- Just show the current version. [1.3.6A]\n  -n         -- Show what would happen without actually doing it.\n  -v         -- Be verbose about what stage we are in.\n  -y         -- Auto-answer \"Yes\" when questioned about overwriting files.\n\n  -L         -- Disable #line macros.\n  -l         -- Use \"Line:\" instead of \"<filename>:\" to start with\n                when printing TDLC-generated error/warning messages.\n\n  -W         -- Issue warnings/errors about questionable code. (Default)\n  -Q         -- Be quite.  Do NOT check for questionable code.\n\n  -u         -- Normal.  #using statements are printed as they appear.\n  -N         -- Strip out all #using statements.\n                  (Default for Code files.)\n  -t         -- Translate #using statements to #include statements.\n                  (Default for Header files.)\n                  Note: The #using<> filenames are translated to their\n                        (assumed) C++ counterpart names.  (Ie: A \".H\" is\n                        appended, after first removing any trailing \".tdl\".)\n\n          Extern-Tasks merely generate their function-interface.\n  -e         -- Enable extern-tasks in   the output.  (Default)\n  -d         -- Delete extern-tasks from the output.\n\n  -E         -- Enable non-task code in   the output. (Default for code.)\n  -D         -- Delete non-task code from the output. (Default for headers.)\n\n          These next options refine what the -H, -C, and -S flags produce.\n          (They also change the defaults for the #using flags -[uNt].)\n  -1         -- Class declaration in header,  inline functions.\n                  (Header: Translate #using [t],  Code: Strip #using. [N])\n  -2         -- Class declaration in header,  extern functions.\n                  (Header: Translate #using [t],  Code: Strip #using. [N])\n  -3         -- Class declaration in code,    extern functions.\n                  (Header: Strip #using [N],  Code: Translate #using. [N])\n  -4         -- Class declaration in code,    extern functions.\n                  (Header: Strip #using [N],  Code: Translate #using. [N])\n                  (Header: Equivalent to -3H; Code: Equivalent to -2H, -2C.)\n  -5         -- Distributed-Only Invocation generation, inline functions.\n                  (Meaningful only with -5H.  -5C produces an empty file.)\n  -6         -- Distributed-Only Invocation generation, EXTERN functions.\n                  (Usable with -6H, -6C, -6S.)\n\n  -m         -- Generate HTML Documentation.\n  -a         -- Generate SMv AnalyzeR for Tca (SMART) translation.\n  -i         -- Generate Inlined C++ Header code.\n  -H         -- Generate C++ Header code.\n  -C         -- Generate C++ code.\n  -S         -- Generate both (Standard) C++ .C and .H files.\n                 Stores output in sourceFile.C and sourceFile.H.\n                 If \"-o\" is also used, the \"-o file\" replaces sourceFile.\n                 (If sourceFile matches *.tdl, the \".tdl\" is removed.)\n                 And \"#include <sourceFile.H>\" is added to the code file.\n\n  -s         -- Load any #using files.\n  -I <file>  -- Specify search directory for #using<> and #using\"\".\n  -U <file>  -- Specify search directory for #using<> only.\n\n  -r         -- Use \"::_TDL_ENCLOSING_TASK\" for the default root-node in\n                functions.  (E.g.: Revert to prior behavior, before being\n                replaced by \"" + DataComponent.CXX_TCM_ROOT_NODE + "\".)\n" + "\n" + "  -A <text>  -- Add text to beginning of the outputfile.  Useful for \n" + "                inserting #includes at the beginning of the code file.\n" + "                Note: Text must be a single string.\n" + "                      You may need \"\"'s to shell-escape it.\n" + "                Note: For \"-S\", text is only inserted in the header file." + "\n" + "\n" + "  -o <file>  -- Specify destination file.\n" + "\n" + "  <file>     -- Specify source file.  Specify no files for stdin.\n";
    protected String[] args;

    public static void main(String[] stringArray) {
        new TDLC(stringArray).run();
    }

    public static String limitNumberOfLines(String string, int n) {
        if (string == null) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && n3 < string.length()) {
            if ((n3 = string.indexOf(10, n3)) == -1) {
                return string;
            }
            ++n3;
            ++n2;
        }
        if (n3 >= string.length()) {
            return string;
        }
        return string.substring(0, n3);
    }

    public TDLC(String[] stringArray) {
        this.args = stringArray;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String checkThatFilenameEndsWith(String string, String string2) {
        if (string.endsWith(string2)) {
            return string;
        }
        return string + string2;
    }

    public File checkValidFileToWrite(String string, boolean bl) {
        int n = -1;
        File file = new File(string);
        if (file.exists()) {
            System.err.print("TDLC Warning:  Overwriting Output file \"" + string + "\".  Continue (y/n)?   ");
            if (bl) {
                System.err.println("YES [-y]");
            } else {
                System.err.println("");
                do {
                    try {
                        n = System.in.read();
                    }
                    catch (IOException iOException) {
                        System.err.println("TDLC Error:  Unable to read \"(y/n)?\" from stdin.\nAborting...\nJava.io.IOException = " + iOException);
                        System.exit(-2);
                    }
                    if (n == -1) {
                        System.err.println("TDLC Error:  Unable to read \"(y/n)?\" from stdin.\nAborting...\nNo java.io.IOException, but End-Of-File reached.");
                        System.exit(-2);
                    }
                    if (n != 110 && n != 78) continue;
                    System.exit(-1);
                } while (n != 121 && n != 89);
            }
        }
        return file;
    }

    public void run() {
        DataVector dataVector = new DataVector();
        DataVector dataVector2 = new DataVector();
        String string = null;
        String string2 = "";
        String string3 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        char c = ' ';
        char c2 = ' ';
        char c3 = ' ';
        char c4 = 'i';
        char c5 = '1';
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int n = 0;
        while (n < this.getArgs().length) {
            File file4;
            if (this.getArgs()[n].charAt(0) != '-') {
                file4 = new File(this.getArgs()[n]);
                if (!file4.exists()) {
                    System.err.println("TDLC Error:  Input file \"" + this.getArgs()[n] + "\" does not exist.\nUse -h for HELP.");
                    System.exit(-2);
                }
                file = file4;
                this.runForFile(file, file2, file3, string3, string2, c, c2, c3, c4, c5, bl7, dataVector, dataVector2, bl, bl6, bl2, bl4, bl3);
                bl5 = false;
                bl7 = false;
                file = null;
                file2 = null;
                file3 = null;
                string3 = null;
            } else {
                bl5 = true;
                int n2 = 1;
                while (n2 < this.getArgs()[n].length()) {
                    bl8 = false;
                    switch (this.getArgs()[n].charAt(n2)) {
                        case 'h': {
                            System.out.println(USAGE_STRING);
                            System.exit(0);
                            break;
                        }
                        case 'V': {
                            System.out.println("TDLC Version:  1.3.6A");
                            System.exit(0);
                            break;
                        }
                        case 'n': {
                            bl = true;
                            break;
                        }
                        case 'v': {
                            bl2 = true;
                            break;
                        }
                        case 'y': {
                            bl6 = true;
                            break;
                        }
                        case 'L': {
                            bl3 = false;
                            break;
                        }
                        case 'l': {
                            DataFile.setOverrideInMessagesFilenamesWithLine(true);
                            break;
                        }
                        case 'W': {
                            bl4 = true;
                            break;
                        }
                        case 'Q': {
                            bl4 = false;
                            break;
                        }
                        case 'u': {
                            c = 'u';
                            break;
                        }
                        case 'N': {
                            c = 'N';
                            break;
                        }
                        case 't': {
                            c = 't';
                            break;
                        }
                        case 'd': {
                            c2 = 'd';
                            break;
                        }
                        case 'e': {
                            c2 = 'e';
                            break;
                        }
                        case 'D': {
                            c3 = 'D';
                            break;
                        }
                        case 'E': {
                            c3 = 'E';
                            break;
                        }
                        case '1': {
                            c5 = '1';
                            break;
                        }
                        case '2': {
                            c5 = '2';
                            break;
                        }
                        case '3': {
                            c5 = '3';
                            break;
                        }
                        case '4': {
                            c5 = '4';
                            break;
                        }
                        case '5': {
                            c5 = '5';
                            break;
                        }
                        case '6': {
                            c5 = '6';
                            break;
                        }
                        case 'm': {
                            if (c4 == 'S' && file2 != null) {
                                System.err.println("TDLC Error:  Encountered \"-m\" after both \"-S\" and \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'm';
                            break;
                        }
                        case 'a': {
                            if (c4 == 'S' && file2 != null) {
                                System.err.println("TDLC Error:  Encountered \"-a\" after both \"-S\" and \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'a';
                            bl7 = true;
                            break;
                        }
                        case 'i': {
                            if (c4 == 'S' && file2 != null) {
                                System.err.println("TDLC Error:  Encountered \"-i\" after both \"-S\" and \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'i';
                            break;
                        }
                        case 'H': {
                            if (c4 == 'S' && file2 != null) {
                                System.err.println("TDLC Error:  Encountered \"-H\" after both \"-S\" and \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'H';
                            break;
                        }
                        case 'C': {
                            if (c4 == 'S' && file2 != null) {
                                System.err.println("TDLC Error:  Encountered \"-C\" after both \"-S\" and \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'C';
                            break;
                        }
                        case 'S': {
                            if (file2 != null) {
                                System.err.println("TDLC Error:  \"-S\" MUST proceed \"-o\".  Aborting Compilation.  Use \"-h\" for help.");
                                System.exit(-1);
                            }
                            c4 = 'S';
                            break;
                        }
                        case 's': {
                            bl7 = true;
                            break;
                        }
                        case 'I': {
                            bl8 = true;
                            break;
                        }
                        case 'U': {
                            bl8 = true;
                            break;
                        }
                        case 'r': {
                            DataComponent.restorePreviousRootNodeValueForBackwardCompatibility();
                            break;
                        }
                        case 'A': {
                            bl8 = true;
                            break;
                        }
                        case 'o': {
                            bl8 = true;
                            break;
                        }
                        default: {
                            System.err.println("TDLC Error:  Illegal command '-" + this.getArgs()[n].charAt(n2) + "'.\nUse -h for HELP.");
                            System.exit(-1);
                        }
                    }
                    if (bl8) {
                        if (n2 + 1 < this.getArgs()[n].length()) {
                            string = this.getArgs()[n].substring(n2 + 1);
                        } else {
                            if (this.getArgs().length <= n) {
                                System.err.println("TDLC Error:  Illegal command '-o'.\nUse -h for HELP.");
                                System.exit(-1);
                            }
                            string = this.getArgs()[n + 1];
                        }
                    }
                    if (this.getArgs()[n].charAt(n2) == 'I') {
                        file4 = new File(string);
                        if (file4.isDirectory()) {
                            dataVector.addElement(file4);
                            dataVector2.addElement(file4);
                        } else {
                            System.err.println("TDLC Warning:  Unable to search directory \"" + string + "\".   Directory is not accessible.");
                        }
                    }
                    if (this.getArgs()[n].charAt(n2) == 'U') {
                        file4 = new File(string);
                        if (file4.isDirectory()) {
                            dataVector2.addElement(file4);
                        } else {
                            System.err.println("TDLC Warning:  Unable to search directory \"" + string + "\".   Directory is not accessible.");
                        }
                    }
                    if (this.getArgs()[n].charAt(n2) == 'A') {
                        string2 = string;
                    }
                    if (this.getArgs()[n].charAt(n2) == 'o') {
                        if (c4 != 'S') {
                            file2 = this.checkValidFileToWrite(string, bl6);
                        } else {
                            string3 = this.checkThatFilenameEndsWith(DataFile.translateTDLFilenameToCxx(string, ".H"), ".H");
                            file2 = this.checkValidFileToWrite(string3, bl6);
                            file3 = this.checkValidFileToWrite(this.checkThatFilenameEndsWith(DataFile.translateTDLFilenameToCxx(string, ".C"), ".C"), bl6);
                        }
                    }
                    if (bl8) {
                        if (n2 + 1 < this.getArgs()[n].length()) break;
                        ++n;
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (bl5) {
            this.runForFile(null, file2, file3, string3, string2, c, c2, c3, c4, c5, bl7, dataVector, dataVector2, bl, bl6, bl2, bl4, bl3);
        }
    }

    public void runForFile(File file, File file2, File file3, String string, String string2, char c, char c2, char c3, char c4, char c5, boolean bl, DataVector dataVector, DataVector dataVector2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        DataFile dataFile = null;
        int n2 = 0;
        boolean bl7 = true;
        boolean bl8 = false;
        boolean bl9 = true;
        char c6 = 'N';
        char c7 = 'N';
        if (c4 == 'C' || c4 == 'i') {
            bl8 = true;
        }
        block4 : switch (c5) {
            case '2': {
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1001;
                        c6 = 't';
                        break block4;
                    }
                    case 'C': {
                        n = 1002;
                        break block4;
                    }
                    case 'S': {
                        n = 1001;
                        c6 = 't';
                        n2 = 1002;
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-1]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1003;
                c6 = 't';
                break;
            }
            case '3': {
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1006;
                        break block4;
                    }
                    case 'C': {
                        n = 1007;
                        c6 = 't';
                        break block4;
                    }
                    case 'S': {
                        n = 1006;
                        n2 = 1007;
                        c7 = 't';
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-2]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1003;
                c6 = 't';
                break;
            }
            case '4': {
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1006;
                        break block4;
                    }
                    case 'C': {
                        n = 1008;
                        c6 = 't';
                        break block4;
                    }
                    case 'S': {
                        n = 1006;
                        n2 = 1008;
                        c7 = 't';
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-2]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1003;
                c6 = 't';
                break;
            }
            case '5': {
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1009;
                        c6 = 't';
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                    case 'C': {
                        n = -1;
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                    case 'S': {
                        n = 1009;
                        c6 = 't';
                        n2 = -1;
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-2]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1009;
                c6 = 't';
                bl8 = false;
                bl9 = false;
                break;
            }
            case '6': {
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1010;
                        c6 = 't';
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                    case 'C': {
                        n = 1011;
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                    case 'S': {
                        n = 1010;
                        c6 = 't';
                        n2 = 1011;
                        bl8 = false;
                        bl9 = false;
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-1]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1009;
                c6 = 't';
                bl8 = false;
                bl9 = false;
                break;
            }
            default: {
                if (c5 != '1') {
                    System.err.println("[TDLC:runForFile-3]  Warning:  theProduceType is unknown. (\"-" + c5 + "\")  Assuming \"-" + '1' + "\".");
                }
                switch (c4) {
                    case 'm': {
                        n = 2000;
                        break block4;
                    }
                    case 'a': {
                        n = 0;
                        break block4;
                    }
                    case 'H': {
                        n = 1004;
                        c6 = 't';
                        break block4;
                    }
                    case 'C': {
                        n = 1005;
                        break block4;
                    }
                    case 'S': {
                        n = 1004;
                        c6 = 't';
                        n2 = 1005;
                        break block4;
                    }
                }
                if (c4 != 'i') {
                    System.err.println("[TDLC:runForFile-0]  Warning:  theProduceFile is unknown. (\"-" + c4 + "\")  Assuming \"-" + 'i' + "\".");
                }
                n = 1003;
                c6 = 't';
            }
        }
        if (c2 == 'd') {
            bl7 = false;
        }
        if (c2 == 'e') {
            bl7 = true;
        }
        if (c3 == 'D') {
            bl8 = false;
            bl9 = false;
        }
        if (c3 == 'E') {
            bl8 = true;
            bl9 = true;
        }
        if (c != ' ') {
            c6 = c;
            c7 = c;
        }
        if (bl2 || bl4) {
            System.err.print("Running with " + DataComponent.getCxxSubsetName(n) + "( " + (bl7 ? "_HAS_ " : "NO ") + "Extern Tasks, " + (bl8 ? "_HAS_ " : "NO ") + "Non-Task Code. ) ");
            if (n2 != 0) {
                System.err.print("\n         and " + DataComponent.getCxxSubsetName(n2) + "( " + (bl7 ? "_HAS_ " : "NO ") + "Extern Tasks, " + (bl9 ? "_HAS_ " : "NO ") + "Non-Task Code. ) ");
            }
            System.err.println(",\n inputFile  = \"" + (file == null ? "*STDIN*" : file.getAbsolutePath()) + "\",\n outputFile = \"" + (file2 == null ? "*STDOUT*" : file2.getAbsolutePath()) + "\",\n textToAdd  = \"" + string2 + "\",\n");
            int n3 = 0;
            while (n3 < dataVector.count()) {
                System.err.println("  #using \"\" Search Directory [ " + n3 + " ] = \"" + ((File)dataVector.elementAt(n3)).getAbsolutePath() + "\"");
                ++n3;
            }
            int n4 = 0;
            while (n4 < dataVector2.count()) {
                System.err.println("  #using <> Search Directory [ " + n4 + " ] = \"" + ((File)dataVector2.elementAt(n4)).getAbsolutePath() + "\"");
                ++n4;
            }
        }
        if (bl2) {
            return;
        }
        if (bl4) {
            System.err.println("Starting...");
        }
        if (file == null) {
            try {
                int n5;
                while ((n5 = System.in.read()) != -1) {
                    stringBuffer.append((char)(n5 & 0xFF));
                }
            }
            catch (IOException iOException) {
                System.err.println("FAILURE:  Error Reading from stdin.  (" + iOException.toString() + ")");
                System.exit(-2);
            }
        }
        if (bl4) {
            System.err.println("Parsing...");
        }
        try {
            dataFile = file == null ? DataFile.loadDataFile(stringBuffer.toString()) : DataFile.loadDataFile(file);
        }
        catch (DetailedParseException detailedParseException) {
            System.err.println("PARSE FAILURE:\n\n" + TDLC.limitNumberOfLines(detailedParseException.toString(), 15));
            System.exit(-3);
        }
        if (bl4) {
            System.err.println("Primary Parse Ended.");
        }
        if (bl5) {
            DataDestinationPrintStream dataDestinationPrintStream = new DataDestinationPrintStream(System.err);
            DataValidateCodeReturnValue dataValidateCodeReturnValue = new DataValidateCodeReturnValue(dataDestinationPrintStream);
            try {
                dataFile.validateExternalCode(0, dataValidateCodeReturnValue);
            }
            catch (CompilationException compilationException) {
                System.err.println("\n\nTDL Semantic Violation Detected::\n\n" + compilationException.getMessage());
                System.exit(-3);
            }
            if (dataValidateCodeReturnValue.hasWarningsOrErrors()) {
                System.out.println("\n" + dataValidateCodeReturnValue.toString() + " found.");
            }
            if (dataValidateCodeReturnValue.hasErrors()) {
                System.exit(-3);
            }
        }
        if (bl) {
            try {
                dataFile.loadAttachedFiles(dataVector, dataVector2, bl4);
            }
            catch (CompilationException compilationException) {
                System.err.print(compilationException.getMessage());
                System.exit(-3);
            }
        }
        if (bl4) {
            System.err.println("All Parsing Ended.");
        }
        if (n2 != 0 && file2 == null) {
            if (file3 != null) {
                System.err.println("[TDLC:runForFile]  Warning:  Output file is null.  Secondary Output file ignored. (reset).  Possible programmer error.");
            }
            if (file == null) {
                file3 = null;
            } else {
                file2 = this.checkValidFileToWrite(DataFile.translateTDLFilenameToCxx(file.getAbsolutePath(), ".H"), bl3);
                file3 = this.checkValidFileToWrite(DataFile.translateTDLFilenameToCxx(file.getAbsolutePath(), ".C"), bl3);
            }
        }
        if (c4 == 'a') {
            TDLtoSMART.printSMARTFile(file, file2, dataFile, bl4, string2, this);
            return;
        }
        this.printForFile(file, file2, n, dataFile, c6, bl7, bl8, bl4, bl6, string2);
        if (n2 != 0) {
            this.printForFile(file, file3, n2, dataFile, c7, bl7, bl9, bl4, bl6, file2 == null ? "" : "#include <" + (string != null ? string : file2.getName()) + ">");
        }
    }

    public void printForFile(File file, File file2, int n, DataFile dataFile, char c, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        int n2;
        DataDestinationFile dataDestinationFile = new DataDestinationFile();
        DataDestinationAbstractBaseClass dataDestinationAbstractBaseClass = null;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 1);
        dateFormat.setTimeZone(TimeZone.getDefault());
        switch (c) {
            case 'u': {
                n2 = 1100;
                break;
            }
            case 'N': {
                n2 = 1101;
                break;
            }
            case 't': {
                n2 = 1102;
                break;
            }
            default: {
                System.err.println("[TDLC:printForFile]  Warning:  Unknown translate-using-statements directive (\"-" + c + "\").");
                n2 = 1100;
            }
        }
        try {
            if (file2 == null) {
                if (bl3) {
                    System.out.println("\nResults:");
                }
                dataDestinationAbstractBaseClass = new DataDestinationStringBuffer();
            } else if (!dataDestinationFile.setFile(file2.getAbsolutePath())) {
                System.err.println("TDLC Error:  Failed to open output file  \"" + file2.getAbsolutePath() + "\".");
                System.exit(-2);
            } else {
                dataDestinationAbstractBaseClass = dataDestinationFile;
            }
            dataDestinationAbstractBaseClass.setEnableLineMacros(bl4);
            if (file == null) {
                dataDestinationAbstractBaseClass.setTdlFileName("*STDIN*");
            } else {
                dataDestinationAbstractBaseClass.setTdlFileName(file.getName());
            }
            if (file2 == null) {
                dataDestinationAbstractBaseClass.setCxxFileName("*STDOUT*");
            } else {
                dataDestinationAbstractBaseClass.setCxxFileName(file2.getName());
            }
            if (n == 2000) {
                dataDestinationAbstractBaseClass.write("<!--\n");
            }
            dataDestinationAbstractBaseClass.write("/* File generated by TDLC version ");
            dataDestinationAbstractBaseClass.write(VERSION_NUMBER);
            dataDestinationAbstractBaseClass.write("\n * On.................: ");
            dataDestinationAbstractBaseClass.write(dateFormat.format(new Date()));
            dataDestinationAbstractBaseClass.write("\n * Source      File...: ");
            if (file == null) {
                dataDestinationAbstractBaseClass.write("*STDIN*");
            } else {
                dataDestinationAbstractBaseClass.write(file.getAbsolutePath());
            }
            dataDestinationAbstractBaseClass.write("\n * Destination File...: ");
            if (file2 == null) {
                dataDestinationAbstractBaseClass.write("*STDOUT*");
            } else {
                dataDestinationAbstractBaseClass.write(file2.getAbsolutePath());
            }
            dataDestinationAbstractBaseClass.write("\n * Command Line.......: java TDLC");
            int n3 = 0;
            while (n3 < this.getArgs().length) {
                dataDestinationAbstractBaseClass.write(" ");
                dataDestinationAbstractBaseClass.write(this.getArgs()[n3]);
                ++n3;
            }
            dataDestinationAbstractBaseClass.write("\n */\n");
            if (n == 2000) {
                dataDestinationAbstractBaseClass.write("-->\n");
            }
            dataDestinationAbstractBaseClass.write(string);
            dataDestinationAbstractBaseClass.write("\n");
            if (n != 1008) {
                if (n != -1) {
                    dataFile.generate(dataDestinationAbstractBaseClass, n, n2, bl, bl2);
                }
            } else {
                dataFile.generate(dataDestinationAbstractBaseClass, 1001, n2, bl, false);
                dataFile.generate(dataDestinationAbstractBaseClass, 1002, 1101, false, bl2);
            }
            if (file2 == null) {
                System.out.print(((DataDestinationStringBuffer)dataDestinationAbstractBaseClass).getString());
            } else {
                dataDestinationFile.close();
            }
        }
        catch (CompilationException compilationException) {
            System.err.println("");
            System.err.println(compilationException.getMessage());
            System.err.println("");
            System.exit(-3);
        }
    }
}

