/*
 * Decompiled with CFR 0.152.
 */
public class DataWithDoStatement
extends DataStatementWithSubstatements
implements DataConstrainedObject {
    public static final String WITH = "WITH";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String COMMA = ",";
    public static final String STATEMENT_INDEX = "StatementIndex";
    public static final String SEMICOLON = ";";
    public static final int CONSTRAINTS_ONLY = 2;
    protected DataVector constraints = new DataVector();

    public DataVector getConstraints() {
        return this.constraints;
    }

    public int getConstraintCount() {
        return this.getConstraints().count();
    }

    public void addConstraint(DataConstraint dataConstraint) {
        this.getConstraints().addElement(dataConstraint);
        dataConstraint.setParent(this);
    }

    public DataConstraint getConstraint(int n) {
        if (n >= 0 && n < this.getConstraints().count()) {
            return (DataConstraint)this.getConstraints().elementAt(n);
        }
        return null;
    }

    public boolean hasSubcomponentFraction(String string) {
        if (super.hasSubcomponentFraction(string)) {
            return true;
        }
        int n = 0;
        while (n < this.getConstraintCount()) {
            if (this.getConstraint(n).hasSubcomponentFraction(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        int n = 0;
        while (n < this.getConstraintCount()) {
            this.getConstraint(n).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
            ++n;
        }
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            this.getConstraint(n2).validateInternalCode(n, dataValidateCodeReturnValue);
            switch (this.getConstraint(n2).getConstraintType()) {
                case 22: {
                    dataValidateCodeReturnValue.addError(this.getConstraint(n2)).write("Exception Handlers ").write("are not permitted in WITH statements.\n");
                    break;
                }
                case 23: {
                    dataValidateCodeReturnValue.addError(this.getConstraint(n2)).write("On-Terminate constraints ").write("are not permitted in WITH statements.\n");
                    break;
                }
            }
            ++n2;
        }
        DataStatement.validateInternalConstrainedObject(n, dataValidateCodeReturnValue, this);
        DataStatement.validateAnyOverridenConstraints(this, dataValidateCodeReturnValue);
        super.validateInternalCode(n, dataValidateCodeReturnValue);
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataWithDoStatement.CONSTRAINTS_ONLY (" + 2 + CLOSE_PAREN;
    }

    public boolean isValidObjectSubset(int n) {
        if (n == 2) {
            return true;
        }
        return super.isValidObjectSubset(n);
    }

    public boolean isValid(int n) {
        if (this.getConstraints().count() <= 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            if (!this.getConstraint(n2).isValid()) {
                return false;
            }
            ++n2;
        }
        if (n == 2) {
            return true;
        }
        if (this.getStatement() == null) {
            return false;
        }
        return super.isValid(n);
    }

    public void generateConstraints(DataDestination dataDestination, int n) {
        boolean bl = true;
        this.initializeGenerateSubcomponentIndex(OPEN_PAREN);
        int n2 = 0;
        while (n2 < this.getConstraints().count()) {
            this.getConstraint(n2).generate(dataDestination, n);
            if (n2 + 1 < this.getConstraints().count()) {
                dataDestination.write(COMMA);
            } else {
                bl = !this.getConstraint(n2).hasTrailingWhitespaceSubcomponent();
            }
            ++n2;
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n, bl);
    }

    public void generate(DataDestination dataDestination, int n) {
        boolean bl = false;
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 2) {
            this.generateConstraints(dataDestination, 0);
            return;
        }
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, 100, WITH);
        this.generateSubcomponents(WITH, dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.setNewlineText("// ");
            dataDestination.write("// ");
        }
        dataDestination.write(WITH);
        this.generateSubcomponents(OPEN_PAREN, dataDestination, n, false);
        dataDestination.write(OPEN_PAREN);
        this.generateConstraints(dataDestination, 0);
        dataDestination.write(CLOSE_PAREN);
        this.generateSubcomponents(STATEMENT_INDEX, dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.clearNewlineText();
            dataDestination.write("\n");
            dataDestination.setStripLeadingWhitespace();
        }
        if (this.getStatement() != null) {
            DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
            if (this.isCxxSubset(n) && dataTaskDefinition != null) {
                DataDestinationStringBuffer dataDestinationStringBuffer = new DataDestinationStringBuffer();
                dataDestinationStringBuffer.addIndent(dataDestination.getSecondaryIndent());
                if (this.getConstraints().count() > 0) {
                    dataDestinationStringBuffer.write("\nif ( ");
                }
                dataDestinationStringBuffer.write("_TDL_SpawnedTasks");
                dataDestinationStringBuffer.write(" . ");
                dataDestinationStringBuffer.write("pushWithStatement");
                dataDestinationStringBuffer.write(" ( \"");
                dataDestinationStringBuffer.write(dataTaskDefinition.getIdentifierForBranch(this));
                dataDestinationStringBuffer.write("\" )");
                if (this.getConstraints().count() <= 0) {
                    dataDestinationStringBuffer.write(";\n");
                } else {
                    dataDestinationStringBuffer.write(" == ");
                    dataDestinationStringBuffer.write("SUCCESS");
                    dataDestinationStringBuffer.write(" )\n");
                    dataDestinationStringBuffer.addIndent(DataComponent.getIndent());
                    dataDestinationStringBuffer.write("_TDL_SpawnedTasks");
                    dataDestinationStringBuffer.addIndent(DataComponent.getIndent());
                    int n2 = 0;
                    while (n2 < this.getConstraints().count()) {
                        if (!DataConstraint.getIsConstraintOverriden(this.getConstraint(n2), this.getConstraints())) {
                            dataDestinationStringBuffer.write("\n. ");
                            dataDestinationStringBuffer.write("doAddWithStatementConstraint");
                            dataDestinationStringBuffer.write(" ( new ");
                            this.getConstraint(n2).generateCxxTaskInternal(dataDestinationStringBuffer);
                            dataDestinationStringBuffer.write(" )");
                        }
                        ++n2;
                    }
                    dataDestinationStringBuffer.removeIndent(DataComponent.getIndent());
                    dataDestinationStringBuffer.removeIndent(DataComponent.getIndent());
                    dataDestinationStringBuffer.write(";\n");
                }
                this.getStatement().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder(dataDestinationStringBuffer.getString()));
                this.getStatement().addSubcomponentBeforeCloseBrace(new DataComponentPlaceholder("\n_TDL_SpawnedTasks . popWithStatement ( \"" + dataTaskDefinition.getIdentifierForBranch(this) + "\" );\n"));
            }
            this.getStatement().generate(dataDestination, n);
            if (this.isCxxSubset(n) && dataTaskDefinition != null) {
                this.getStatement().removeSubcomponentBeforeCloseBrace();
                this.getStatement().removeSubcomponentAfterOpenBrace();
            }
        } else {
            dataDestination.write(SEMICOLON);
        }
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }

    public boolean isSpawnRelatedStatement() {
        return true;
    }

    public int getChildStatementCount() {
        return super.getChildStatementCount() + this.getConstraintChildStatementCount();
    }

    public DataStatement getChildStatement(int n) {
        if (n < this.getConstraintChildStatementCount()) {
            return this.getConstraintChildStatement(n);
        }
        return super.getChildStatement(n - this.getConstraintChildStatementCount());
    }
}

