/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public abstract class DataSource
implements CharStream {
    public static final int START_POSITION = 0;
    public static final int UNKNOWN_POSITION = -1;
    String filenameWithoutPathPlusColonDefault;
    int totalReadSoFar;
    int column;
    int row;
    int totalReadSoFarAtMark;
    int columnAtMark;
    int rowAtMark;

    public DataSource() {
        this.setFilenameWithoutPathDefault("stdin");
        this.reset();
    }

    public DataSource(String string) {
        if (DataComponent.isEmptyString(string)) {
            this.setFilenameWithoutPathDefault("stdin");
        } else {
            this.setFilenameWithoutPathDefault(string);
        }
        this.reset();
    }

    public void reset() {
        this.totalReadSoFar = 0;
        this.column = 0;
        this.row = 0;
        this.totalReadSoFarAtMark = 0;
        this.columnAtMark = 0;
        this.rowAtMark = 0;
    }

    public abstract char read(int var1) throws IOException;

    public abstract String readSubString(int var1, int var2);

    public char[] readCharArray(int n, int n2) {
        return this.readSubString(n, n2).toCharArray();
    }

    public void Done() {
    }

    public void setFilenameWithoutPathDefault(String string) {
        this.filenameWithoutPathPlusColonDefault = string + ":";
    }

    public String getFilenameWithoutPathPlusColonDefault() {
        return this.filenameWithoutPathPlusColonDefault;
    }

    public String getFilenameWithoutPathPlusColon() {
        if (DataFile.getOverrideInMessagesFilenamesWithLine()) {
            return "Line:";
        }
        return this.getFilenameWithoutPathPlusColonDefault();
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getLine() {
        return this.row;
    }

    public int getEndColumn() {
        return this.getColumn();
    }

    public int getEndRow() {
        return this.getRow();
    }

    public int getEndLine() {
        return this.getRow();
    }

    public int getBeginColumn() {
        return this.columnAtMark;
    }

    public int getBeginRow() {
        return this.rowAtMark;
    }

    public int getBeginLine() {
        return this.rowAtMark;
    }

    private void setColumn(int n) {
        this.column = n;
    }

    private void setRow(int n) {
        this.row = n;
    }

    private void incrementColumn() {
        ++this.column;
    }

    private void decrementColumn() {
        --this.column;
    }

    private void incrementRow() {
        ++this.row;
    }

    private void decrementRow() {
        --this.row;
    }

    public int getTotalReadSoFar() {
        return this.totalReadSoFar;
    }

    private void setTotalReadSoFar(int n) {
        this.totalReadSoFar = n;
    }

    private void incrementTotalReadSoFar() {
        ++this.totalReadSoFar;
    }

    private void decrementTotalReadSoFar() {
        --this.totalReadSoFar;
    }

    public int getTotalReadSoFarAtMark() {
        return this.totalReadSoFarAtMark;
    }

    public int getColumnAtMark() {
        return this.columnAtMark;
    }

    public int getRowAtMark() {
        return this.rowAtMark;
    }

    private void setMark() {
        this.totalReadSoFarAtMark = this.totalReadSoFar;
        this.columnAtMark = this.getColumn();
        this.rowAtMark = this.getRow();
    }

    private void restoreToMark() {
        this.setTotalReadSoFar(this.getTotalReadSoFarAtMark());
        this.setColumn(this.getColumnAtMark());
        this.setRow(this.getRowAtMark());
    }

    public int getTotalReadFromMark() {
        return this.getTotalReadSoFar() - this.getTotalReadSoFarAtMark();
    }

    public char readChar() throws IOException {
        char c = this.read(this.getTotalReadSoFar());
        if (c == '\n') {
            this.incrementRow();
            this.setColumn(0);
        } else {
            this.incrementColumn();
        }
        this.incrementTotalReadSoFar();
        return c;
    }

    public void backup(int n) {
        if (n <= 0) {
            System.err.println("[DataSource:backup]  Warning:  theAmount(" + n + ") <= 0");
            return;
        }
        if (n <= this.getTotalReadFromMark()) {
            int n2 = this.getTotalReadFromMark() - n;
            this.restoreToMark();
            while (n2 > 0) {
                try {
                    this.readChar();
                }
                catch (IOException iOException) {
                    System.err.println("[DataSource:backup]  Warning:  move-forward readChar() failed. ");
                }
                --n2;
            }
            return;
        }
        System.err.println("[DataSource:backup]  Warning:  Non-trivial backup case invoked.  (Should this be happening?)");
        int n3 = this.getTotalReadSoFar() - 1;
        while (n3 >= this.getTotalReadSoFar() - n && n3 >= 0) {
            try {
                if (this.read(n3) == '\n') {
                    this.decrementRow();
                }
            }
            catch (IOException iOException) {
                System.err.println("[DataSource:backup]  Warning:  look-backward [row] read() failed. ");
            }
            --n3;
        }
        this.setColumn(0);
        this.setTotalReadSoFar(this.getTotalReadSoFar() - n);
        if (this.getTotalReadSoFar() < 0) {
            this.setTotalReadSoFar(0);
            if (this.getRow() != 0) {
                System.err.println("[DataSource:backup]  Warning:  Internal consistency failure.  Row(" + this.getRow() + ") != 0");
                this.setRow(0);
            }
        } else {
            n3 = this.getTotalReadSoFar() - 1;
            while (n3 >= 0) {
                try {
                    if (this.read(n3) == '\n') break;
                    this.incrementColumn();
                }
                catch (IOException iOException) {
                    System.err.println("[DataSource:backup]  Warning:  look-backward [col] read() failed. ");
                }
                --n3;
            }
        }
    }

    public char BeginToken() throws IOException {
        this.setMark();
        return this.readChar();
    }

    public String getImage() {
        return this.GetImage();
    }

    public String GetImage() {
        return this.readSubString(this.getTotalReadSoFarAtMark(), this.getTotalReadSoFar());
    }

    public char[] GetSuffix(int n) {
        if (n <= 0) {
            return new char[0];
        }
        if (n > this.getTotalReadSoFar()) {
            System.err.println("[DataSource:GetSuffix]  Warning:  theLength(" + n + ")  >  totalReadSoFar(" + this.getTotalReadSoFar() + ").  Truncating...");
            n = this.getTotalReadSoFar();
        }
        if (n > this.getTotalReadFromMark()) {
            System.err.println("[DataSource:GetSuffix]  Warning:  theLength(" + n + ")  >  tokenLength(" + this.getTotalReadFromMark() + ").");
        }
        return this.readCharArray(this.getTotalReadSoFar() - n, this.getTotalReadSoFar());
    }

    public int getPositionFromLineAndColumn(int n, int n2) {
        int n3 = 0;
        try {
            while (n > 0 || n2 > 0) {
                if (this.read(n3++) == '\n' && n > 0) {
                    --n;
                    continue;
                }
                if (n > 0) continue;
                --n2;
            }
            return n3;
        }
        catch (IOException iOException) {
            System.err.println("[DataSource:getPositionFromLineAndColumn]  Warning:  read(" + n3 + ") Failed.  " + "Exception: " + iOException);
            return -1;
        }
    }
}

