/*
 * Decompiled with CFR 0.152.
 */
public class DataConstraintStatement
extends DataStatement
implements DataConstrainedObject,
DataConstraintTagTaskIndexes {
    public static final String BEGIN_TAG_TASK_INDEX = "[";
    public static final String DEFAULT_TAG_TASK_INDEX = ".";
    public static final String END_TAG_TASK_INDEX = "]";
    public static final String TAG_TASK = "TagTask";
    public static final String THIS = "THIS";
    public static final String SEMICOLON = ";";
    protected String taskTag = null;
    protected Object[] taskTagIndexes = null;
    protected DataConstraint constraint = new DataConstraint();

    public DataConstraintStatement() {
        this.constraint.setParent(this);
    }

    public boolean getHasTaskTag() {
        return !DataComponent.isEmptyString(this.getTaskTag());
    }

    public String getTaskTag() {
        return this.taskTag == null ? "" : this.taskTag;
    }

    public void setTaskTag(String string) {
        this.taskTag = string;
    }

    public boolean getHasTaskTagOfThis() {
        return this.getHasTaskTag() && this.getTaskTag().equals(THIS);
    }

    public boolean getHasTaskIndexes() {
        return this.getTaskIndexes() != null && this.getTaskIndexes().length > 0;
    }

    public Object[] getTaskIndexes() {
        return this.taskTagIndexes;
    }

    public void setTaskIndexesWithoutParsing(Object[] objectArray) {
        this.taskTagIndexes = objectArray;
    }

    public boolean getHasTagTask() {
        return this.getHasTaskTag();
    }

    public String getTagTask() {
        return this.getTaskTag();
    }

    public void setTagTask(String string) {
        this.setTaskTag(string);
    }

    public boolean getHasTagTaskIndexes() {
        return this.getHasTaskIndexes();
    }

    public Object[] getTagTaskIndexes() {
        return this.getTaskIndexes();
    }

    public void setTagTaskIndexesWithoutParsing(Object[] objectArray) {
        this.setTaskIndexesWithoutParsing(objectArray);
    }

    public DataConstraint getConstraint() {
        return this.constraint;
    }

    public int getConstraintType() {
        return this.getConstraint().getConstraintType();
    }

    public int getConstraintCount() {
        return 1;
    }

    public DataConstraint getConstraint(int n) {
        if (n == 0) {
            return this.getConstraint();
        }
        System.err.println("[DataConstraintStatement:getConstraint]  Error:  Invalid Index (" + n + ")");
        return null;
    }

    public void addConstraint(DataConstraint dataConstraint) {
        if (dataConstraint != null) {
            this.constraint = dataConstraint;
            dataConstraint.setParent(this);
        } else {
            System.err.println("[DataConstraintStatement:addConstraint]  Error:  NULL Constraint.");
        }
    }

    public boolean getConstrainsSpawnOrWithStatement(DataStatement dataStatement) {
        if (dataStatement instanceof DataSpawnTask && this.getTaskTag().equals(((DataSpawnTask)dataStatement).getTaskName())) {
            return true;
        }
        DataLabelStatement dataLabelStatement = dataStatement.getLabel();
        while (dataLabelStatement != null) {
            if (dataLabelStatement.hasId() && this.getTaskTag().equals(dataLabelStatement.getId())) {
                return true;
            }
            dataLabelStatement = dataLabelStatement.getLabel();
        }
        return false;
    }

    public boolean hasSubcomponentFraction(String string) {
        if (this.getHasTaskIndexes()) {
            int n = 0;
            while (n < this.getTaskIndexes().length) {
                if (this.getTaskIndexes()[n] instanceof DataComponent && ((DataComponent)this.getTaskIndexes()[n]).hasSubcomponentFraction(string) || !(this.getTaskIndexes()[n] instanceof DataComponent) && this.getTaskIndexes()[n].toString().indexOf(string) != -1) {
                    return true;
                }
                ++n;
            }
        }
        return super.hasSubcomponentFraction(string) || this.getConstraint(0).hasSubcomponentFraction(string);
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        if (this.getHasTaskIndexes()) {
            int n = 0;
            while (n < this.getTaskIndexes().length) {
                if (this.getTaskIndexes()[n] instanceof DataComponent) {
                    ((DataComponent)this.getTaskIndexes()[n]).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
                } else {
                    DataComponent.staticRunOnStringFraction(this.getTaskIndexes()[n].toString(), string, runOnSubcomponentInterface, object);
                }
                ++n;
            }
        }
        this.getConstraint(0).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        if (this.getHasTaskTag()) {
            DataComponent dataComponent = this;
            while (dataComponent != null) {
                if (dataComponent instanceof DataTaskDefinition) break;
                dataComponent = dataComponent.getParent();
            }
            if (dataComponent == null) {
                throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ": Programmer Error:  Unable to find DataTaskDefinition ancestor.");
            }
            DataTaskDefinition dataTaskDefinition = (DataTaskDefinition)dataComponent;
            DataComponent dataComponent2 = dataTaskDefinition.getDataComponentWithName(this.getTaskTag());
            if (dataComponent2 != null) {
                int n2 = dataTaskDefinition.getIterationParentCount(dataComponent2);
                if (dataComponent2 instanceof DataBindTaskStatement) {
                    if (this.getHasTaskIndexes()) {
                        dataValidateCodeReturnValue.addError(this).write("Too many Iteration-Indexes for TDL_BIND ").write("Constraint Statement Reference.  (There is (are) ").write("" + this.getTaskIndexes().length).write(" array index(es) specified.  ").write("There should be zero.)\n");
                    }
                } else {
                    if (this.getHasTaskIndexes() && this.getTaskIndexes().length > n2) {
                        dataValidateCodeReturnValue.addError(this).write("Too many Iteration-Indexes for Constraint ").write(" Statement Reference.  (Reference is enclosed in ").write("" + n2).write(" iteration loop(s) and there is (are) ").write("" + this.getTaskIndexes().length).write(" array index(es) specified.)\n");
                    }
                    if (n2 > 0 && (this.getTaskIndexes() == null || this.getTaskIndexes().length < n2)) {
                        dataValidateCodeReturnValue.addWarning(this).write("Using an Iteration-Set of References for Constraint").write(" Statement Reference.  (Reference is enclosed in ").write("" + n2).write(" iteration loop(s) and there is (are) ").write(this.getTaskIndexes() == null ? "0" : "" + this.getTaskIndexes().length).write(" array index(es) specified.)\n");
                    }
                }
            }
        }
        int n3 = 0;
        while (this.getHasTaskIndexes() && n3 < this.getTaskIndexes().length) {
            if (this.getTaskIndexes()[n3].toString().trim().charAt(0) == '0' && this.getTaskIndexes()[n3].toString().trim().length() > 1) {
                dataValidateCodeReturnValue.addWarning(this).write("Task Index is specified in octal.\n");
                break;
            }
            ++n3;
        }
        super.validateInternalCode(n, dataValidateCodeReturnValue);
        if (this.getConstraint().getConstraintType() == 6) {
            dataValidateCodeReturnValue.addWarning(this.getConstraint()).write("PARALLEL constraint in a CONSTRAINT STATEMENT is meaningless.\n");
        }
        this.getConstraint().validateInternalCode(n, dataValidateCodeReturnValue);
    }

    protected void generateTaskTag(DataDestination dataDestination, int n) throws CompilationException {
        Object[] objectArray = this.getTaskIndexes();
        if (!this.getHasTaskTag()) {
            throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ":  [DataConstraintStatement:generateEventTagTask]  " + "Error:  No Task-Tag available to generate...");
        }
        dataDestination.write(this.getTaskTag());
        if (this.getHasTaskIndexes()) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.generateSubcomponents(BEGIN_TAG_TASK_INDEX + n2, dataDestination, n, false);
                dataDestination.write(BEGIN_TAG_TASK_INDEX);
                this.generateSubcomponents("" + n2, dataDestination, n, false);
                if (objectArray[n2] != null) {
                    if (objectArray[n2] instanceof DataComponent) {
                        ((DataComponent)objectArray[n2]).generate(dataDestination, 0);
                    } else {
                        dataDestination.write(objectArray[n2].toString());
                    }
                }
                this.generateSubcomponents(END_TAG_TASK_INDEX + n2, dataDestination, n, false);
                dataDestination.write(END_TAG_TASK_INDEX);
                ++n2;
            }
        }
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        this.initializeGenerateSubcomponentIndex();
        this.generateLabels(dataDestination, n, TAG_TASK);
        this.generateSubcomponents(TAG_TASK, dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.setNewlineText("    // ");
            dataDestination.write("    // ");
        }
        this.generateTaskTag(dataDestination, 0);
        this.getConstraint().generate(dataDestination, 0);
        this.generateSubcomponents(SEMICOLON, dataDestination, n, false);
        dataDestination.write(SEMICOLON);
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
        if (this.isCxxSubset(n)) {
            dataDestination.clearNewlineText();
            dataDestination.write("\n");
            this.generateCxx(dataDestination, n);
            return;
        }
    }

    public void generateCxx(DataDestination dataDestination, int n) throws CompilationException {
        if (!this.getHasTaskTag()) {
            throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ":  Error:  Missing Task-Tag.");
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write("\n");
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" . ");
        dataDestination.write("applyConstraintTo");
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        if (this.getHasTaskTagOfThis()) {
            dataDestination.write("_TDL_SpawnedTasks . getEnclosingTaskTreeNode()");
        } else {
            DataStatement.generateTagTaskCxxReference(dataDestination, this.getTaskTag(), this.getTaskIndexes(), this);
        }
        dataDestination.write(",\n");
        this.getConstraint().generateCxxTaskInternal(dataDestination);
        dataDestination.removeIndent(n2);
        dataDestination.write(" );\n");
    }

    public boolean isSpawnRelatedStatement() {
        return true;
    }

    public int getChildStatementCount() {
        return super.getChildStatementCount() + this.getConstraintChildStatementCount();
    }

    public DataStatement getChildStatement(int n) {
        if (n < this.getConstraintChildStatementCount()) {
            return this.getConstraintChildStatement(n);
        }
        return super.getChildStatement(n - this.getConstraintChildStatementCount());
    }
}

