signature UNPARSE =
sig

  (**** A fixity unparser. ****)

  datatype Associativity = LeftAssoc | RightAssoc | NonAssoc

  (* A 'a Seq is a sequence of 'a with nested sequences in parentheses *)
  datatype 'a Item =
      Unit of 'a
    | Paren of 'a Seq
  withtype 'a Seq = 'a Item list

  (* an expression which is being unparsed *)
  type 'a Part

  (* constructors for unparsing expressions *)
  val atom      : 'a -> 'a Part
  val prefix    : int * 'a                 -> 'a Part -> 'a Part
  val infixx    : Associativity * int * 'a -> 'a Part * 'a Part -> 'a Part
  val postfix   : int * 'a                 -> 'a Part -> 'a Part
  (* implicit application between adjacent expressions *)
  val adj       : 'a Part * 'a Part -> 'a Part

  (* return the unparsed parenthesized sequence *)
  val done      : 'a Part -> 'a Seq

  (* given sequencing and parenthesizing functions, apply them to a Seq *)
  val compose   : ('a list -> 'b) -> ('b -> 'a) -> 'a Seq -> 'b
  (* parens and spaces applied to a string Seq *)
  val parens    : string Seq -> string

end