signature TOKENS =
sig

  datatype token =
      Word of string
    | Number of int

  (* parse a char stream into tokens separated by whitespace or comments *)
  val token      : (token * Pos.T, char) Parsing.T

  (* a parser that recognizes a specific word *)
  val litWord    : string -> (string, token) Parsing.T
  (* ... a specific number *)
  val litNumber  : int -> (int, token) Parsing.T

  (* ... any word *)
  val anyWord    : (string, token) Parsing.T
  (* ... any number *)
  val anyNumber  : (int, token) Parsing.T

  (* given a parser p, parses p's separated by semicolons, reporting
     syntax errors *)
  val recover    : ('a, token) Parsing.T -> ('a, token) Parsing.T

end
