structure Stream :> STREAM =
    struct

	datatype lazy 'a T = Nil | Cons of 'a * 'a T

	exception Empty

	val empty = Nil
	val cons = Cons

	fun lazy delay t = t()
	fun lcons (x, f) = Cons (x, delay f)

	fun is_empty Nil = true
	  | is_empty _ = false

	fun uncons Nil = raise Empty
	  | uncons (Cons p) = p

	fun hd s = #1 (uncons s)
	fun tl s = #2 (uncons s)
	fun lazy ltl Nil = raise Empty
	       | ltl (Cons (_, t)) = t

        fun lazy
            map f Nil = Nil
          | map f (Cons (h, t)) = Cons (f h, map f t)

        fun app f Nil = ()
          | app f (Cons (h, t)) = (f h; app f t)

        fun foldr s b Nil = b
          | foldr s b (Cons (h, t)) = s (h, foldr s b t)

        fun foldl s b Nil = b
          | foldl s b (Cons (h, t)) = foldl s (s (h, b)) t

        fun lazy
            fromList nil = Nil
          | fromList (h::t) = Cons(h, fromList t)

        fun toList s = foldr op:: [] s

    end
