(* Chris Okasaki / Robert Harper
   School of Computer Science
   Carnegie Mellon University
   Pittsburgh, PA 15213
   cokasaki@cs.cmu.edu *)

structure Input :> INPUT =
struct

  open TextIO

  fun getchars file close =
        let fun get () =
	          if endOfStream file then
		      (close (); Stream.empty)
		  else
		      doline (explode (inputLine file))

            and doline cs = foldr Stream.cons (Stream.delay get) cs

        in Stream.delay get end

  fun readfile filename =
        let val file = openIn filename
        in
	    getchars file (fn () => closeIn file)
        end

  fun readkeybd () = getchars stdIn (fn () => ())

  fun promptkeybd prompt =
        let fun get () =
	      (output (stdOut,prompt);
	       flushOut stdOut;
	       if endOfStream stdIn 
		 then Stream.empty
	         else doline (explode (inputLine stdIn)))
            and doline cs = foldr Stream.cons (Stream.delay get) cs
        in Stream.delay get end

end
