structure Loop :> LOOP =
struct

  type action = ((string -> MinML.typ) * (MinML.exp)) -> unit

  val empty = (fn _ => raise Typing.TypeError)

  fun typing (e, l) =
          (case Typing.typeOpt (e, l)
             of SOME t => " : " ^ Print.typToString t
              | NONE => " has no type.")


  (* A few actions *)

  fun show (l, e) =
      List.app print [Print.expToString e, "\n"]

  fun showType (l, e) =
      List.app print [Print.expToString e, typing (e, l), "\n"]

  fun eval action (l, e) = 
    let 
      val (m, e) = (CMachine.eval e)
    in
      action (m, e)
    end

  fun wait action e =
      (action e;
       print "Press return:";
       TextIO.inputLine TextIO.stdIn;
       ())

  fun step action (l, e) = Stream.app (action o (fn ((_, m), _, _, e) =>
						 (m, e))) 
    (CMachine.CstepStream e)


  (* Running the actions on an interactive loop or a file *)

  fun loop action =
         (Stream.app (action o (fn x => (empty, x))) o
          Parsing.transform (Tokens.recover Parse.exp) o
          Parsing.transform Tokens.token o
          Pos.markstream)
         (Input.promptkeybd "MinML> ")

  fun loopFile name action =
         (Stream.app (action o (fn x => (empty, x))) o
          Parsing.transform (Tokens.recover Parse.exp) o
          Parsing.transform Tokens.token o
          Pos.markstream)
         (Input.readfile name)

end
