signature EMINML =
sig

  datatype typ =
      INT
    | BOOL
    | ARROW of typ * typ
    | TIMES of typ * typ
    | UNIT
    | PLUS of typ * typ
    | REF of typ
    | EXN
    | RAISE

  datatype pat =
      WildPat
    | VarPat of string * typ
    | PairPat of pat * pat
    | UnitPat

  datatype primop = Equal | Plus | Minus | Times | Negate

  datatype exp =
      Int of int

    | Bool of bool
    | If of exp * exp * exp

    | Primop of primop * exp list

    | Fun of string * string * typ * typ * exp
    | Apply of exp * exp

    | Var of string

    | Pair of exp * exp
    | Bind of pat * exp * exp
    | UnitE 

    | Inleft of typ * typ * exp
    | Inright of typ * typ * exp
    | Case of exp * string * typ * exp * string * typ * exp

    | Loc of string
    | Ref of exp
    | Deref of exp
    | Assign of exp * exp

    | LetExn of string * exp
    | Try of exp * exp
    | Raise of exp
    | ExnEq of exp * exp
    | Exn of string

  (* given a primop, get its argument and result types *)
  val typeOfPrimop : primop -> typ list * typ
  (* given a primop and some arguments, try to apply it *)
  val evalPrimop : primop * exp list -> exp option

  type subst = string -> exp
  val id : subst
  val ++ : subst * (string * exp) -> subst
  (* closed substitution *)
  val csubst : subst * exp -> exp

end
