structure ELoop :> ELOOP =
struct

  type action = ((string -> EMinML.typ) * (EMinML.exp)) -> unit

  val empty = (fn _ => raise ETyping.TypeError)

  fun typing (e, l) =
          (case ETyping.typeOpt (e, l)
             of SOME t => " : " ^ EPrint.typToString t
              | NONE => " has no type.")


  (* A few actions *)

  fun show (l, e) =
      List.app print [EPrint.expToString e, "\n"]

  fun showType (l, e) =
      List.app print [EPrint.expToString e, typing (e, l), "\n"]

  fun eval action (l, e) = 
    let 
      val (m, e) = (ECMachine.eval e)
    in
      action (m, e)
    end

  fun wait action e =
      (action e;
       print "Press return:";
       TextIO.inputLine TextIO.stdIn;
       ())

  fun step action (l, e) = Stream.app (action o (fn ((_, m), _, _, e) =>
						 (m, e))) 
    (ECMachine.CstepStream e)


  (* Running the actions on an interactive loop or a file *)

  fun loop action =
         (Stream.app (action o (fn x => (empty, x))) o
          Parsing.transform (Tokens.recover EParse.exp) o
          Parsing.transform Tokens.token o
          Pos.markstream)
         (Input.promptkeybd "MinML> ")

  fun loopFile name action =
         (Stream.app (action o (fn x => (empty, x))) o
          Parsing.transform (Tokens.recover EParse.exp) o
          Parsing.transform Tokens.token o
          Pos.markstream)
         (Input.readfile name)

end
