signature ECMACHINE =
sig

  val Debug : bool ref

  exception Stuck

  type frame
  type 'a stack
  type memory = EMinML.subst * (string -> EMinML.typ)
  type handlers
  type state = memory * handlers * (frame stack) * EMinML.exp

  val Cstep : state -> state

  val CstepOpt : state -> state option
  val CmultiStep : state -> state
  val CstepStream : EMinML.exp -> state Stream.T
  val eval : EMinML.exp -> ((string -> EMinML.typ) * EMinML.exp)

end
  