/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiningPhilosophers
extends JApplet
implements ActionListener,
ChangeListener {
    private JButton stopStartButton = new JButton("start");
    int grabDelay = 500;
    private JSlider grabDelaySlider = new JSlider(0, 0, 100, 5);
    private JLabel label = new JLabel("  500 milliseconds");
    private JPanel philosopherArea;
    public ImageIcon[] imgs = new ImageIcon[3];
    Chopstick[] chopsticks = new Chopstick[5];
    String[] names = new String[]{"Arisduktle", "Dukrates", "Pythagoduke", "Duko", "Dukimedes"};
    static final int NUMPHILS = 5;
    static final int HUNGRYDUKE = 0;
    static final int RIGHTSPOONDUKE = 1;
    static final int BOTHSPOONSDUKE = 2;
    private int width;
    private int height;
    private double spacing;
    private static final double MARGIN = 10.0;
    private Philosopher[] philosophers = new Philosopher[5];

    public void init() {
        this.imgs[0] = new ImageIcon(this.getURL("images/hungryduke.gif"));
        this.imgs[1] = new ImageIcon(this.getURL("images/rightspoonduke.gif"));
        this.imgs[2] = new ImageIcon(this.getURL("images/bothspoonsduke.gif"));
        this.width = this.imgs[0].getIconWidth() + 20;
        this.height = this.imgs[0].getIconHeight() + 20;
        this.spacing = (double)this.width + 10.0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.philosopherArea = new JPanel(null);
        this.philosopherArea.setBackground(Color.white);
        Dimension dimension = this.createPhilosophersAndChopsticks();
        this.philosopherArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.philosopherArea.setPreferredSize(dimension);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.philosopherArea, gridBagConstraints);
        jPanel.add(this.philosopherArea);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.stopStartButton, gridBagConstraints);
        jPanel.add(this.stopStartButton);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.grabDelaySlider, gridBagConstraints);
        jPanel.add(this.grabDelaySlider);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        jPanel.add(this.label);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(jPanel);
        this.stopStartButton.addActionListener(this);
        this.grabDelaySlider.addChangeListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.stopStartButton.getText().equals("stop/reset")) {
            this.stopPhilosophers();
            this.stopStartButton.setText("start");
            return;
        }
        if (this.stopStartButton.getText().equals("start")) {
            this.startPhilosophers();
            this.stopStartButton.setText("stop/reset");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        this.grabDelay = jSlider.getValue() * 100;
        this.label.setText(String.valueOf(String.valueOf(this.grabDelay) + " milliseconds"));
    }

    public void startPhilosophers() {
        int n = 0;
        while (n < 5) {
            this.philosophers[n].philThread.start();
            ++n;
        }
    }

    public void stopPhilosophers() {
        int n = 0;
        while (n < 5) {
            this.philosophers[n].philThread.interrupt();
            ++n;
        }
    }

    public Dimension createPhilosophersAndChopsticks() {
        double d = 80.0;
        double d2 = 85.0;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < 5) {
            this.chopsticks[n] = new Chopstick();
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            double d3 = (double)n2 * 1.2566370614359172;
            double d4 = Math.sin(d3) * d + d2;
            double d5 = Math.cos(d3) * d + d2;
            this.philosophers[n2] = new Philosopher(this, n2, this.imgs[0]);
            this.philosophers[n2].setBounds((int)d4, (int)d5, this.width, this.height);
            this.philosopherArea.add(this.philosophers[n2]);
            if ((int)d4 > dimension.width) {
                dimension.width = (int)d4;
            }
            if ((int)d5 > dimension.height) {
                dimension.height = (int)d5;
            }
            ++n2;
        }
        dimension.width += this.width;
        dimension.height += this.height;
        return dimension;
    }

    protected URL getURL(String string) {
        URL uRL = this.getCodeBase();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return uRL2;
    }
}

