/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextEventDemo
extends JApplet
implements ActionListener {
    JTextField textField;
    JTextArea textArea;
    JTextArea displayArea;

    public void init() {
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        this.textField = new JTextField(20);
        this.textField.addActionListener(new MyTextActionListener());
        this.textField.getDocument().addDocumentListener(new MyDocumentListener("Text Field"));
        this.textArea = new JTextArea();
        this.textArea.getDocument().addDocumentListener(new MyDocumentListener("Text Area"));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(200, 75));
        this.displayArea = new JTextArea();
        this.displayArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.displayArea);
        jScrollPane2.setPreferredSize(new Dimension(200, 75));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.textField, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel.add(jScrollPane2);
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        this.textField.requestFocus();
        this.setContentPane(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.displayArea.setText("");
        this.textField.requestFocus();
    }

    class MyDocumentListener
    implements DocumentListener {
        String preface;
        String newline = System.getProperty("line.separator");

        public MyDocumentListener(String string) {
            TextEventDemo.this = TextEventDemo.this;
            this.preface = String.valueOf(string) + " text value changed." + this.newline + "   First 10 characters: \"";
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void update(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = document.getLength();
            String string = null;
            try {
                string = document.getText(0, n > 10 ? 10 : n);
            }
            catch (BadLocationException badLocationException) {}
            TextEventDemo.this.displayArea.append(String.valueOf(this.preface) + string + "\"" + this.newline);
        }
    }

    class MyTextActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TextEventDemo.this.textArea.getSelectionStart();
            int n2 = TextEventDemo.this.textArea.getSelectionEnd();
            TextEventDemo.this.textArea.replaceRange(TextEventDemo.this.textField.getText(), n, n2);
            TextEventDemo.this.textField.selectAll();
        }

        MyTextActionListener() {
            TextEventDemo.this = TextEventDemo.this;
        }
    }
}

