/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class CubicPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    BufferedImage bi;
    Graphics2D big;
    int x;
    int y;
    Rectangle area;
    Rectangle startpt;
    Rectangle endpt;
    Rectangle ctrl1;
    Rectangle ctrl2;
    Rectangle rect;
    CubicCurve2D.Double cubic = new CubicCurve2D.Double();
    Point2D.Double start;
    Point2D.Double end;
    Point2D.Double one;
    Point2D.Double two;
    Point2D.Double point;
    boolean firstTime = true;
    boolean pressOut = false;

    public CubicPanel() {
        this.setBackground(Color.white);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.start = new Point2D.Double();
        this.one = new Point2D.Double();
        this.two = new Point2D.Double();
        this.end = new Point2D.Double();
        this.cubic.setCurve(this.start, this.one, this.two, this.end);
        this.startpt = new Rectangle(0, 0, 8, 8);
        this.endpt = new Rectangle(0, 0, 8, 8);
        this.ctrl1 = new Rectangle(0, 0, 8, 8);
        this.ctrl2 = new Rectangle(0, 0, 8, 8);
    }

    void checkPoint() {
        if (this.area == null) {
            return;
        }
        if (this.area.contains(this.rect) && this.area.contains(this.point)) {
            return;
        }
        int n = this.rect.x;
        int n2 = this.rect.y;
        double d = this.point.x;
        double d2 = this.point.y;
        if ((double)(this.rect.x + this.rect.width) > this.area.getWidth()) {
            n = (int)this.area.getWidth() - (this.rect.width - 1);
        }
        if (this.point.x > this.area.getWidth()) {
            d = (int)this.area.getWidth() - 1;
        }
        if (this.rect.x < 0) {
            n = -1;
        }
        if (this.point.x < 0.0) {
            d = -1.0;
        }
        if ((double)(this.rect.y + this.rect.width) > this.area.getHeight()) {
            n2 = (int)this.area.getHeight() - (this.rect.height - 1);
        }
        if (this.point.y > this.area.getHeight()) {
            d2 = (int)this.area.getHeight() - 1;
        }
        if (this.rect.y < 0) {
            n2 = -1;
        }
        if (this.point.y < 0.0) {
            d2 = -1.0;
        }
        this.rect.setLocation(n, n2);
        this.point.setLocation(d, d2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.pressOut) {
            this.updateLocation(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (this.startpt.contains(this.x, this.y)) {
            this.rect = this.startpt;
            this.point = this.start;
            this.x = this.startpt.x - mouseEvent.getX();
            this.y = this.startpt.y - mouseEvent.getY();
            this.updateLocation(mouseEvent);
        } else if (this.endpt.contains(this.x, this.y)) {
            this.rect = this.endpt;
            this.point = this.end;
            this.x = this.endpt.x - mouseEvent.getX();
            this.y = this.endpt.y - mouseEvent.getY();
            this.updateLocation(mouseEvent);
        } else if (this.ctrl1.contains(this.x, this.y)) {
            this.rect = this.ctrl1;
            this.point = this.one;
            this.x = this.ctrl1.x - mouseEvent.getX();
            this.y = this.ctrl1.y - mouseEvent.getY();
            this.updateLocation(mouseEvent);
        } else if (this.ctrl2.contains(this.x, this.y)) {
            this.rect = this.ctrl2;
            this.point = this.two;
            this.x = this.ctrl2.x - mouseEvent.getX();
            this.y = this.ctrl2.y - mouseEvent.getY();
            this.updateLocation(mouseEvent);
        } else {
            this.pressOut = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.startpt.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.rect = this.startpt;
            this.point = this.start;
            this.updateLocation(mouseEvent);
        } else if (this.endpt.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.rect = this.endpt;
            this.point = this.end;
            this.updateLocation(mouseEvent);
        } else if (this.ctrl1.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.rect = this.ctrl1;
            this.point = this.one;
            this.updateLocation(mouseEvent);
        } else if (this.ctrl2.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.rect = this.ctrl2;
            this.point = this.two;
            this.updateLocation(mouseEvent);
        } else {
            this.pressOut = false;
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.firstTime) {
            this.bi = (BufferedImage)this.createImage(n, n2);
            this.big = this.bi.createGraphics();
            this.start.setLocation(n / 2 - 50, n2 / 2);
            this.end.setLocation(n / 2 + 50, n2 / 2);
            this.one.setLocation((int)this.start.x + 25, (int)this.start.y - 25);
            this.two.setLocation((int)this.end.x - 25, (int)this.end.y + 25);
            this.startpt.setLocation((int)(this.start.x - 4.0), (int)(this.start.y - 4.0));
            this.endpt.setLocation((int)(this.end.x - 4.0), (int)(this.end.y - 4.0));
            this.ctrl1.setLocation((int)(this.one.x - 4.0), (int)(this.one.y - 4.0));
            this.ctrl2.setLocation((int)(this.two.x - 4.0), (int)(this.two.y - 4.0));
            this.cubic.setCurve(this.start, this.one, this.two, this.end);
            this.big.setColor(Color.black);
            this.big.setStroke(new BasicStroke(5.0f));
            this.big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.area = new Rectangle(dimension);
            this.firstTime = false;
        }
        this.big.setColor(Color.white);
        this.big.clearRect(0, 0, this.area.width, this.area.height);
        this.big.setPaint(Color.black);
        this.big.draw(this.cubic);
        this.big.setPaint(Color.red);
        this.big.fill(this.startpt);
        this.big.setPaint(Color.magenta);
        this.big.fill(this.endpt);
        this.big.setPaint(Color.blue);
        this.big.fill(this.ctrl1);
        this.big.setPaint(new Color(0, 200, 0));
        this.big.fill(this.ctrl2);
        graphics2D.drawImage((Image)this.bi, 0, 0, this);
    }

    public void updateLocation(MouseEvent mouseEvent) {
        this.rect.setLocation(this.x + mouseEvent.getX() - 4, this.y + mouseEvent.getY() - 4);
        this.point.setLocation(this.x + mouseEvent.getX(), this.y + mouseEvent.getY());
        this.checkPoint();
        this.cubic.setCurve(this.start, this.one, this.two, this.end);
        this.repaint();
    }
}

