\newcommand{\whr}{\stackrel{\mbox{\tiny  $whr^k$}}{\longrightarrow}}
\newcommand{\lsb}{ \mbox{[}}
\newcommand{\byind}{\begin{proof} By induction on the structure of 
the given derivation(s).\end{proof}}
\newcommand{\den}[1]{\lsemantics#1\rsemantics}   
\newcommand{\lsemantics}{\mathopen{\lbrack\mkern-3mu\lbrack}}
\newcommand{\rsemantics}{\mathclose{\rbrack\mkern-3mu\rbrack}}

\section{The Canonical Form Theorem}
\label{sec:canonthm}


In this section we establish the existence of canonical forms for $\lc$, 
\ie $\beta$-normal $\eta$-long  forms, which is crucial for our
intended application. We prove this by Tait's method of \emph{logical
relations}; we follow the account in \cite{Pfenning94un}, with the obvious 
generalisation from simple to strict types.

We start by presenting the inductive definition of \emph{canonical}
forms in $\lc$.  It is realized by the two mutually recursive
judgements depicted in Figure~\ref{fig:canon}:
\ben 
\item$\GG;\Omega;\Delta\prv M \da A$\qquad $M$ is atomic of type $A$.
\item$\GG;\Omega;\Delta\prv M \bua A$\qquad $M$ is canonical of type $A$.
\enen

\begin{figure}
\[
\begin{array}{c}
\ianc{c\oftp A\in\Sigma}{\GG; \Omega;\cdot  \prv  c\da A}{cIdc}\vsk
\ianc{}{(\GG,x\oftp A);\Omega; \cdot  \prv  x\da A}{cId^{u}}
\qquad \mbox{\textrm{no rule for }}cId^{0}
\qquad
\ianc{}{\GG;\Omega; x\oftp A \prv  x\da A} {cId^{1}}
\vsk
%\ianc{}{\GG;\Omega;\Delta\vd E\ \ol{x_{n}^{l}}\da P}{cPat}
%\qquad
\ianc{\GG;\Omega;\Delta \prv  M\da a}{\GG;\Omega;\Delta \prv  M\bua a} 
{cAt}\vsk
\ianc{(\GG,x\oftp A) ; \Omega;\Delta \prv M\bua B}{\GG;\Omega;\Delta\prv(\lamb{x^u}{A} M) \bua 
A\TImp B} {c\TImp I}
\vsk
\ianc{\GG ; \Omega; (\Delta,x\oftp A) \prv M\bua B}{\GG;\Delta\prv(\lamb{x^1}{A} M) \bua 
A\RImp B}{c\RImp I}
\vsk
\ianc{\GG ;(\Omega, x\oftp A) ;\Delta \prv M\bua B}{\GG;\Omega;\Delta\prv(\lamb{x^0}{A} M) \bua 
A\ZImp B}{c\ZImp I}
\vsk
 \ibnc{\Gamma; \Omega; \Delta \vd M \da A \TImp B}{(\Gamma, \Delta);
\O; \cdot \vd N \bua A}{\Gamma; \Omega; \Delta
\vd M\ N^u \da B}{c\GImp{u}E}
\vsk
\ianc{\GG;\Omega;\Delta\prv M \da A \ZImp B \quad (\GG,\Omega,\Delta);\cdot;\cdot \prv N \bua A
} {\GG;\Omega;\Delta \prv M \ N^0 \da B}{c\ZImp E}\vsk
\ibnc{(\Gamma, \Delta_N); \Omega; \Delta_M \vd M \da A \RImp 
B}{(\Gamma, \Delta_M); \Omega; \Delta_N \vd N \bua A}{\Gamma; \Omega;
(\Delta_M, \Delta_N) \vd M\ N^1 \da B}{c\RImp E}
\end{array}
\]
\caption{Canonical forms}
\label{fig:canon}
\end{figure}



\begin{figure}
\[
\begin{array}{c}
\ianc{c\oftp A\in\Sigma}{\GG; \Omega;\cdot  \prv  c\da c\hastype A}{tcIdc}\vsk
\ianc{}{(\GG,x\oftp A);\Omega; \cdot  \prv  x\da x\hastype A}{tcId^{u}}
\qquad \mbox{\textrm{no rule for }}tcId^{0}
\qquad
\ianc{}{\GG;\Omega; x\oftp A \prv  x\da x\hastype A} {tcId^{1}}
\vsk
\ibnc{M\whr M'}{\god\vd M'\bua M''\hastype a}{\god\vd M\bua M''\hastype a}{tc
\whr}
\vsk
\ianc{\GG;\Omega;\Delta \prv  M\da M\hastype a}{\GG;\Omega;\Delta \prv  M\bua M\hastype a} 
{tcAt}\vsk
\ianc{(\GG,x\oftp A) ; \Omega;\Delta \prv M\ x^u\bua N\hastype B}
{\GG;\Omega;\Delta\prv M\bua (\lamb{x^u}{A} N) \hastype A\TImp B}
{tc\TImp I}
\vsk
\ianc{\GG ;(\Omega, x\oftp A) ;\Delta \prv M\ x^0\bua N\hastype B}
{\GG;\Omega;\Delta\prv M\bua (\lamb{x^0}{A} N) \hastype A\ZImp B}{tc\ZImp I}
\vsk
\ianc{\GG ; \Omega; (\Delta,x\oftp A) \prv M\ x^1\bua N\hastype B}
{\GG;\Delta\prv M\bua(\lamb{x^1}{A} N) \hastype A\RImp B}{tc\RImp I}
\vsk
 \ibnc{\Gamma; \Omega; \Delta \vd M \da P\hastype A \TImp B}{(\Gamma, \Delta);
\O; \cdot \vd N \bua Q \hastype A}{\Gamma; \Omega; \Delta
\vd M\ N^u \da P\ Q^u\hastype B}{tc\GImp{u}E}
\vsk
\ibnc{\GG;\Omega;\Delta\prv M \da P\hastype A \ZImp B}{ (\GG,\Omega,\Delta);
\cdot;\cdot \prv N \bua Q\hastype A}
{\GG;\Omega;\Delta \prv M \ N^0 \da P\ Q^0\hastype B}{tc\ZImp E}\vsk
\ibnc{(\Gamma, \Delta_N); \Omega; \Delta_M \vd M \da P\hastype A \RImp 
B}{(\Gamma, \Delta_M); \Omega; \Delta_N \vd N \bua Q\hastype
A}{\Gamma; \Omega; (\Delta_M, \Delta_N) \vd M\ N^1 \da P\ Q^1\hastype
B}{tc\RImp E}
\end{array}
\]
\caption{Conversion to canonical form}
\label{fig:tocanon}
\end{figure}


We then introduce conversion to canonical form in
Figure~\ref{fig:tocanon};
\ben 
\item $\GG;\Omega;\Delta\prv M \da N\hastype A\qquad M$ converts to 
 atomic form $N$ at  type $A$.
\item$\GG;\Omega;\Delta\prv M \bua N\hastype A\qquad M$ converts to
 canonical form $N$ at type $A$.
\enen

 This utilizes weak head reduction, which
includes local reduction ($\beta$) and partial congruence ($\nu$):
\beq
\ianc{}{(\lamb{x^k}{A}M)N^k\whr[N/x]M}{\beta}\qquad
\ianc{M\whr Q}{(M\ N)^k\whr (Q\ N)^k}{\nu}
\eneq


\begin{Theorem}[Conversion Yields Canonical Terms]\mbox{}
\ben
\item If $\god\vd M\buda A$, then $\god\vd M\hastype A$.
\item If $\god\vd M\buda N\hastype A$, then $\god\vd N\buda A$.
\enen
\end{Theorem}
\byind

Since we have to talk about open terms, we will need a notion of
context extension:
\beq
\ianc{}{\GG\geq\GG}{}\qquad
\ianc{\GG'\geq\GG}{\GG',\xoa\geq\GG}{}
\eneq

\begin{Lemma}[Weakening for Conversion to Canonical and Atomic Form]
\label{le:tcweak}\mbox{}
\ben
\item If $\god\vd M\buda N\hastype A$ and $\GG'\geq\GG$, then $\GG';\O;\D\vd
M\buda N\hastype A$.
\item If $\god\vd M\buda N\hastype A$ and $\O'\geq\O$, then $\GG;\O';\D\vd
M\buda N\hastype A$.
\enen
\end{Lemma}
\byind

We can now introduce \emph{logical relations}:


\begin{Definition}[Logical Relations]
\mbox{}
\begin{itemize}
\item[$1.$]
$\god\vd M\in\den{a}$ iff $\god\vd M\bua N\hastype A$, for some $N$.
\item[$2^u.$]
$\god\vd M\in\den{A\TImp B}$ iff for every $\GG'\geq \GG$ and every
$N$, if $ (\GG',\D);\O;\cdot\vd N\in\den{A}$, then $\GG';\O;\D\vd M\
N^u\in\den{B}$.
\item[$2^0.$]
$\god\vd M\in\den{A\ZImp B}$ iff for every $\O'\geq \O$ and every $N$, if
$(\GG,\O',\D);\cdot;\cdot\vd N\in\den{A}$, then $\GG;\O';\D\vd M\
N^0\in\den{B}$.
\item[$2^1.$] %% corrected by fp
$\GG;\O;\D_M\vd M\in\den{A\RImp B}$ iff for every $N$ and $\D_N$ such
that $(\GG,\D_N)\geq\GG$, if $(\GG,\D_M);\O;\D_N\vd N\in\den{A}$, then
$\GG;\O;\dmn\vd M\ N^1\in\den{B}$.
%\item[$2^1.$]
%$(\GG,\D_N);\O;\D_M\vd M\in\den{A\RImp B}$ iff for every $N$, if
%$(\GG,\D_M);\O;\D_N\vd N\in\den{A}$, then $\GG;\O;\dmn\vd M\
%N^1\in\den{B}$.
\end{itemize}
\end{Definition}

%% not needed anymore?
%\begin{Lemma}[Weakening for Logical Relations]
%\label{le:lrweak}
% If $\god\vd M\in\den{A}$ and $\GG'\geq\GG$, then $\GG';\O;\D\vd
%M\in\den{A}$.
%\end{Lemma}
%\begin{proof}
%By induction on $A$.
%\end{proof}

\begin{Lemma}\mbox{}
\label{le:lr2canon}
\ben
\item If $\god\vd M\in\den{A}$, then $\god\vd M\bua N\hastype A$.
\item If  $\god\vd M\da N\hastype A$, then $\god\vd M\in\den{A}$.
\enen
\end{Lemma}
\begin{proof}
By induction on $A$.
\bit
\itc $A=a$. Immediate from definition.
\itc $A=A\TImp B$.
\ben
\item %1
\btab
$\god\vd M\in\den{A\TImp B}$\bh
$\GG,\xoa\geq \GG$\br\\
$(\GG,\xoa,\D);\O;\cdot\vd x\da x\hastype A$\br\\
$(\GG,\xoa,\D);\O;\cdot\vd x\in\den{A}$\bi $2$\\
$(\GG,\xoa);\O;\D\vd M\ x^u\in\den{ B}$\bd of $\den{\cdot}$\\
$(\GG,\xoa);\O;\D\vd M\ x^u\bua N\hastype B$\bi $1$\\
$\GG;\O;\D\vd M\bua\lamb{x^u}{A}N\hastype A\TImp B$\br
\etab
\item %2
\btab
$\god\vd M\da M_+\hastype A\TImp B$\bh
$\GG'\geq\GG$ and $(\GG',\D);\O;\cdot\vd N\in\den{A}$\ba
$(\GG',\D);\O;\cdot\vd N\bua N_+ \hastype {A}$\bi $1$\\
$\GG';\O;\D\vd\vd M\da M_+\hastype A\TImp B$\bl{le:tcweak}
$\GG';\O;\D\vd M\ N^u\da M_+ N_+^u\hastype B$\br\\
$\GG';\O;\D\vd M\ N^u\in\den{ B}$\bi $2$\\
$\god\vd M\in\den{A\TImp B}$\bd  of $ \den{\cdot}$ 
\etab
\enen
\itc $A=A\ZImp B$.
\ben
\item %1
\btab
$\god\vd M\in\den{A\ZImp B}$\bh
$\O,\xoa\geq \O$\br\\
$(\GG,\O,\xoa,\D);\cdot;\cdot\vd x\da x\hastype A$\br\\
$(\GG,\O,\xoa,\D);\cdot;\cdot\vd x\in\den{A}$\bi $2$\\
$\GG;(\O,\xoa);\D\vd M\ x^0\in\den{ B}$\bd  of $ \den{\cdot}$ \\
$\GG;(\O,\xoa);\D\vd M\ x^0\bua N\hastype B$\bi $1$\\
$\GG;\O;\D\vd M\bua\lamb{x^0}{A}N\hastype A\ZImp B$\br
\etab
\item %2
\btab
$\god\vd M\da M_+\hastype A\ZImp B$\bh
$\O'\geq\O$ and $(\GG,\O',\D);\cdot;\cdot\vd N\in\den{A}$\ba
$(\GG,\O',\D);\cdot;\cdot\vd N\bua N_+ \hastype A$\bi $1$\\
$\GG;\O';\D\vd\vd M\da M_+\hastype A\ZImp B$\bl{le:tcweak}
$\GG;\O';\D\vd M\ N^0\da M_+ N_+^0\hastype B$\br\\
$\GG;\O';\D\vd M\ N^0\in\den{ B}$\bi $2$\\
$\god\vd  M\in\den{A\ZImp B}$\bd  of $ \den{\cdot}$ 
\etab
\enen
\itc $A=A\RImp B$.
\ben
\item %1
\btab
$\god\vd M\in\den{A\RImp B}$\bh
$\GG,\xoa\geq\GG$\br\\
%%$(\GG,\xoa);\O;\D\vd M\in\den{A\RImp B}$\bl{le:lrweak}
$(\GG,\D);\O;\xoa\vd x\da x\hastype A$\br\\
$(\GG,\D);\O;\xoa\vd x\in\den{A}$\bi $2$\\
$\GG;\O;(\D,\xoa)\vd M\ x^1\in\den{ B}$\bd  of $ \den{\cdot}$ \\
$\GG;\O;(\D,\xoa)\vd M\ x^1\bua N\hastype B$\bi $1$\\
$\GG;\O;\D\vd M\bua\lamb{x^1}{A}N\hastype A\RImp B$\br
\etab
\item %2
\btab
$\god\vd M\da M_+\hastype A\RImp B$\ba
$\GG,\D_N\geq\GG$ and
%%$(\GG,\D_N);\O;\D\vd\vd M\da M_+\hastype A\RImp B$\bh
$(\GG,\D);\O;\D_N\vd N\in\den{A}$\ba
$(\GG,\D);\O;\D_N\vd N\bua N_+ \hastype {A}$\bi $1$\\
$(\GG,\D_N);\O;\D\vd\vd M\da M_+\hastype A\RImp B$\bl{le:tcweak}
$\GG;\O;(\D,\D_N)\vd M\ N^1\da M_+ N_+^1\hastype B$\br\\
$\GG;\O;(\D,\D_N)\vd M\ N^1\in\den{ B}$\bi $2$\\
$\GG;\O;\D\vd M\in\den{A\RImp B}$\bd  of $ \den{\cdot}$ 
\etab
%\item %1
%\btab
%$\god\vd M\in\den{A\RImp B}$\bh
%$(\GG,\xoa);\O;\D\vd M\in\den{A\RImp B}$\bl{le:lrweak}
%$(\GG,\D);\O;\xoa\vd x\da x\hastype A$\br\\
%$(\GG,\D);\O;\xoa\vd x\in\den{A}$\bi $2$\\
%$\GG;\O;(\D,\xoa)\vd M\ x^1\in\den{ B}$\bd  of $ \den{\cdot}$ \\
%$\GG;\O;(\D,\xoa)\vd M\ x^1\bua N\hastype B$\bi $1$\\
%$\GG;\O;\D\vd M\bua\lamb{x^1}{A}N\hastype A\RImp B$\br
%\etab
%\item %2
%\btab
%%%$\god\vd M\da M_+\hastype A\RImp B$\ba
%%%$\GG'\geq\GG$\ba
%$(\GG,\D_N);\O;\D\vd\vd M\da M_+\hastype A\RImp B$\bh
%$(\GG,\D);\O;\D_N\vd N\in\den{A}$\ba
%$(\GG,\D);\O;\D_N\vd N\bua N_+ \hastype {A}$\bi $1$\\
%$\GG;\O;(\D,\D_N)\vd M\ N^1\da M_+ N_+^1\hastype B$\br\\
%$\GG;\O;(\D,\D_N)\vd M\ N^1\in\den{ B}$\bi $2$\\
%$(\GG,\D_N);\O;\D\vd M\in\den{A\RImp B}$\bd  of $ \den{\cdot}$ 
%\etab
\enen
\enit
\end{proof}

\begin{Lemma}[Closure under Head Expansion]
\label{le:clohead}
\mbox{}\\
If $\god\vd M'\in\den{A}$ and $M\whr M'$, then $\god\vd M'\in\den{A}$.
\end{Lemma}
\begin{proof} By induction on $A$:
\bit
\itc   $A=a$; immediate by definition and rule $tc\whr$.
\itc  $A=A\RImp B$:
\btab
$(\GG,\D_N);\O;\D_M\vd M'\in\den{A\RImp B}$\bh
$(\GG,\D_M);\O;\D_N\vd N\in\den{A}$\ba
$\GG;\O;(\D_M,\D_N)\vd M'\ N^1\in\den{A}$\bd\\
$(M\ N)^1\whr (M'\ N)^1$\br $\nu$\\
$\GG;\O;(\D_M,\D_N)\vd M\ N^1\in\den{A}$\bi\\
$(\GG,\D_N);\O;\D_M\vd M\in\den{A\RImp B}$\bd
\etab
\itc  $A=A\TImp B,A\ZImp B$: similarly.
\enit
\end{proof}


%%%\subsection{Substitutions}
\newcommand{\tri}{\gamma;\omega;\delta}
\newcommand{\trip}{\gamma';\omega';\delta'}
\newcommand{\tripp}{\gamma'';\omega'';\delta''}
\newcommand{\eps}{\epsilon}

Due to the need to $\beta$-reduce during conversion to canonical form,
we need to introduce the theory of well-typed substitutions in the
strict $\l$-calculus.

\[ \begin{array}{rrcl}
\mbox{\textit{Substitutions}}& \theta & \bnfas \epsilon\bnfalt \theta,M/x
\end{array}
\]
For $\theta=\theta',M/x$, we say that $x$ is \emph{defined} in $\s$.
We require all variables defined in a substitution to be distinct: we
use dom($\s$) for the set of variables defined in $\s$ and cod($\s$)
for the variables occurring in the substituting terms. We assume them
to be disjoint.  We use  triples of substitutions $\tri$,
one for each context.   Well-typed
substitutions are defined as follows:
\[
\begin{array}{c}
\ianc{}{\GG';\O';\cdot
\vd(\epsilon;\epsilon;\epsilon)\hastype(\cdot;\cdot;\cdot)}
{\epsilon\cdot}\vsk
%\ianc{}{\godp\vd\epsilon}{\epsilon}\qquad
\ibnc{(\GG';\D');\O';\cdot\vd M\hastype A}{\godp\vd\tri\hastype\god}
{\godp\vd(\gamma,M/x);\omega;\delta\hastype(\GG,x\oftp A);\O;\D} {\tri^u}\vsk
\ibnc{(\GG';\O';\D');\cdot;\cdot\vd M\hastype A}{\godp\vd\tri\hastype\god}
{\godp\vd\gamma;(\omega,M/x);\delta\hastype\GG;(\O,\xoa);\D} {\tri^0}\vsk
\ibnc{(\GG,\D_2);\O;\D_1\vd M\hastype A}{(\GG,\D_1);\O;\D_2\vd\tri\hastype\god}
{\GG;\O;(\D_1,\D_2)\vd\gamma;\omega;(\delta,M/x)\hastype\GG;\O;(\D,\xoa)} {\tri^1}
\end{array}
\]
We limit application of substitution to objects whose free variables
are in the domain of $\tri$. Assume $\god\vd M\hastype A$ and
$\godp\vd\tri\hastype\god$; we write $x^u$ to say that $x$ is
specifically declared in $\GG$; similarly for the other labels. Define
the application of $\tri$ to $M$, $[\tri]M$, as:
\beq
[\tri] c & = & c \\ 
\lsb\tri]  \mbox{$x^u$} & = & \gamma(x)\\
\lsb\tri] x^0 & = & \omega(x)\\
\lsb\tri] x^1 & = & \delta(x)\\
%\lsb\tri](M\ N^k) & = & ([\tri]M) \ ([\tri] N)^k\\ %%% from Iliano
\lsb\tri](M\ N^u) & = & ([\tri]M) \ ([(\gamma,\delta);\omega;\epsilon] N)^u\\
\lsb\tri](M\ N^0) & = & ([\tri]M) \ 
([(\gamma,\omega,\delta);\epsilon;\epsilon] N)^0\\
\lsb\gamma;\omega;(\delta_M,\delta_N)](M\ N^1) & = &
([(\gamma,\delta_N);\omega;\delta_M]M) \ ([(\gamma,\delta_M);\omega;\delta_N] N)^1\\
\lsb\tri](\lamb{x^u}{A}M) & = & \lamb{x^u}{A}((\gamma,x/x);\omega;\delta)M\\
\lsb\tri](\lamb{x^0}{A}M) & = & \lamb{x^0}{A}(\gamma;(\omega,x/x);\delta)M\\
\lsb\tri](\lamb{x^1}{A}M) & = &
\lamb{x^1}{A}(\gamma;\omega;(\delta,x/x))M \eneq

\begin{Lemma}[``Inversion'' for Well-typed Substitutions]
\label{le:invertsubst}\mbox{}
\ben
\item If $\godp\vd\tri\hastype{\GG,\O;(\D_1,\D_2)}$, then there are
  $\D_1',\D_2'=\D'$, $\delta_1,\delta_2=\delta$ such that
  $(\GG',\D_2');\O';\D_1'\vd
  (\gamma,\delta_2);\omega;\delta_1\hastype{(\GG,\D_2);\O;\D_1}$ and
  $(\GG',\D_1');\O';\D_2'\vd
  (\gamma,\delta_1);\omega;\delta_2\hastype{(\GG,\D_1);\O;\D_2}$.
\item If $\godp\vd\tri\hastype{\GG,\O;\D}$, then
  \bit
\item 
  $(\GG',\D');\O';\cdot\vd
  (\gamma,\delta);\omega;\epsilon\hastype{(\GG,\D);\O;\cdot}$.
\item 
  $(\GG',\O',\D');\cdot;\cdot\vd
  (\gamma,\omega;\delta);\epsilon;\epsilon\hastype{(\GG,\O\D);\cdot;\cdot}$.
  \enit
\enen
\end{Lemma}
\byind

\begin{Lemma}
If $\god\vd M\hastype A$ and $\godp\vd\tri\hastype\god$, then
$\godp\vd[\tri]M\hastype A$.
\end{Lemma}
\begin{proof} 
By induction on the structure of the derivation of $\god\vd M\hastype
A$, using Lemma~\ref{le:invertsubst} in the elimination cases.
\end{proof}

We will also need the notion of \emph{composition} of substitution: if
$\god\vd\tri\hastype\godp$ and $\godp\vd\trip\hastype \GG'';\O'';\D''$, define
the composition $[\tri]\trip$ as the pairwise composition
$[\gamma](\gamma'); [\omega](\omega');[\delta](\delta')$, where:
\beq %%%% change  into []
[\theta]\epsilon & = & \epsilon\\
\lsb\theta](\theta',M/x) & = & [\theta]\theta, ([\theta]M)/x
\eneq

\begin{Lemma}
\mbox{}
\ben
\item  If
$\god\vd\tri\hastype\godp$ and $\godp\vd\trip\hastype \GG'';\O'';\D''$, then
$\GG;\O;\D\vd[\tri])\trip\hastype \GG'';\O'';\D''$.
\item
If $\godp\vd M\hastype A$ and $\godp\vd\tripp\hastype \GG_2;\O_2;\D_2$, then 
\beq %%%% ( into [
[[\tri]\trip]M & = & [\tri]([\trip]M)\\
\mbox{$[$} [\tri]\trip]\tripp & = & [\tri]([\trip]\tripp)
\eneq
\enen
\end{Lemma}
\begin{proof}
\mbox{}
\ben
\item By induction on the structure of $\trip$.
\item By induction on the structure of $M$ and $\tripp$.
\enen
\end{proof}

For a context $\GG=x_1\oftp A_1,\mdots x_n\oftp A_n$, we introduce the
\emph{identity} substitution on $\GG$ as $id_{\GG}=x_1/x_1\mdots x_n/x_n$.
Define $id_{\god}$ as $id_{\GG};id_{\O};id_{\D}$.% We assume without
%explicit statement and proof the obvious properties of the identity
%substitution, namely that it is a left-unit for the typing judgements,
%as well as for substitution application and composition.

\begin{Lemma}[Identity Substituion]\mbox{}
\ben
\item If $\god\vd M\hastype A$, then $[id_{\god}] M= M$.
\item If $\god\vd [\gamma';\omega';\delta']\hastype \godp$, then 
$[id_{\god}]\gamma';\omega';\delta' = \gamma';\omega';\delta'$.
\enen
\end{Lemma}
\begin{proof}
\mbox{}
\ben
\item By induction on $M$.
\item By induction on $ \gamma';\omega';\delta'$.
\enen
\end{proof}
\begin{Corollary}\mbox{}
\ben
\item If $\god\vd M\hastype A$, then $\god\vd [id_{\god}] M\hastype A$.
\item If $\god\vd [\gamma';\omega';\delta']\hastype \godp$, then 
$\god\vd [id_{\god}]\gamma';\omega';\delta'\hastype\godp$.
\enen
\end{Corollary}
\smallskip

%\bit
%\item[1.] $\Phi\vd\(\epsilon;\eps;\eps)\in\den{\cdot;\cdot;\cdot}$
%\item[2^u.] $\ibnc{\Phi\vd M\in\den{ A}}{\Phi\vd\tri\in\den{\god}}
%{\GG\vd(\gamma,M/x);\omega;\delta\in\den{(\GG,x\oftp A);\O;\D}}{}$
%\item[2^0.] $\ibnc{\Phi\vd M\in\den{ A}}{\Phi\vd\tri\in\den{\god}}
%{\GG\vd\gamma;(\omega,M/x);\delta\in\den{\GG;(\O,\xoa);\D}}{}$
%\item[2^1.] $\ibnc{\Phi\vd M\in\den{ A}}{\Phi\vd\tri\in\den{\god}}
%{\GG\vd\gamma;\omega;(\delta,M/x)\in\den{\GG;\O;(\D,\xoa)}}{}$
%\enit
We extend the notion of logical relations to contexts:
\begin{Definition}\mbox{}
\bit
\item[$1$.] $\GG';\O';\cdot\vd (\epsilon;\epsilon;\epsilon)\in
\den{\cdot;\cdot;\cdot}$.
\item[$2^u$.] ${\godp\vd(\gamma,M/x);\omega;\delta\in\den{(\GG,x\oftp A);\O;\D}
}$ iff ${(\GG',\D');\O';\cdot\vd M\in\den{ A}}$ and
${\godp\vd\tri\in\den{\god}}$.
\item[$2^0$.] ${\godp\vd\gamma;(\omega,M/x);\delta\in\den{\GG;(\O,\xoa);\D}}$ 
iff ${(\GG',\O',\D');\cdot;\cdot\vd M\in\den{ A}}$ and\\
${\godp\vd\tri\in\den{\god}}$.
\item[$2^1$.] ${\GG';\O';(\D_1,\D_2)\vd\gamma;\omega;(\delta,M/x)\in
\den{\GG;\O;(\D,\xoa)}}$ iff ${(\GG',\D_1);\O';\D_2\vd M\in\den{ A}}$ 
and\\
 ${(\GG',\D_2);\O';\D_1\vd\tri\in\den{\god}}$.

\enit
\end{Definition}

\begin{Remark}
\label{re:emptyd}
If $\godp\vd\tau\in\den{\GG;\O;\cdot}$, then
$\tau\equiv\gamma;\omega;\epsilon$ and $\Delta'\equiv\cdot$.
\end{Remark}
%To prove the main Lemma~\ref{le:lrmain}, we need to establish a series
%of loosening lemmata for logical relations, which are analogous to the
%one established for typability. For the sake of brevity we state them directly 
%in the format of Corollary~\ref{thm:0loose} and \ref{thm:1loose}.

%\begin{Lemma}[Loosening for Conversion to Canonical Form]
%\label{le:loosetocanon}\mbox{}
%\ben
%\item
%If $\GG;(\O,\Phi);\D\vd M\buda N\hastype A$, then $(\GG,\Phi);\O;\D\vd
%M\buda N\hastype A$.
%\item
%If $\GG;\O;(\D,\Phi)\vd M\buda N\hastype A$, then $(\GG,\Phi);\O;\D\vd
%M\buda N\hastype A$.
%\enen
%\end{Lemma}
%\byind

%\begin{Lemma}[Loosening for Logical Relations]
%\label{le:looselr}
%\mbox{}
%\ben
%\item
%If $\GG;(\O,\Phi);\D\vd M\in\den{ A}$, then $(\GG,\Phi);\O;\D\vd
%M\in\den{ A}$.
%\item
%If $\GG;\O;(\D,\Phi)\vd M\in\den{ A}$, then $(\GG,\Phi);\O;\D\vd
%M\in\den{ A}$.
%\enen
%\end{Lemma}
%\begin{proof}
%By induction on $A$, using Lemma~\ref{le:loosetocanon}.
%\end{proof}

%\begin{Lemma}[Loosening for Logical Relations on Contexts]
%\label{le:loosectx}
%\mbox{}
%\ben
%\item
%If $\GG;(\O,\Phi);\D\vd \tri\in\den{ \godp}$, then $(\GG,\Phi);\O;\D\vd
%\tri\in\den{ \godp}$.
%\item
%If $\GG;\O;(\D,\Phi)\vd \tri\in\den{ \godp}$, then $(\GG,\Phi);\O;\D\vd
%\tri\in\den{ \godp}$.
%\enen
%\end{Lemma}
%\begin{proof}
%By induction on the structure of the given derivations, 
%using Lemma~\ref{le:looselr}.
%\end{proof}
\begin{Lemma}[``Inversion'' for Logically Related Substitutions]
\label{le:invertlr}\mbox{}
\ben
\item If $\godp\vd\tri\in\den{\GG,\O;(\D_1,\D_2)}$, then there are
  $\D_1',\D_2'=\D'$, $\delta_1,\delta_2=\delta$ such that
  $(\GG',\D_2');\O';\D_1'\vd
  (\gamma,\delta_2);\omega;\delta_1\in\den{(\GG,\D_2);\O;\D_1}$ and
  $(\GG',\D_1');\O';\D_2'\vd
  (\gamma,\delta_1);\omega;\delta_2\in\den{(\GG,\D_1);\O;\D_2}$.
\item If $\godp\vd\tri\in\den{\GG,\O;\D}$, then
  \bit
\item 
  $(\GG',\D');\O';\cdot\vd
  (\gamma,\delta);\omega;\epsilon\in\den{(\GG,\D);\O;\cdot}$.
\item 
  $(\GG',\O',\D');\cdot;\cdot\vd
  (\gamma,\omega;\delta);\epsilon;\epsilon\in\den{(\GG,\O\D);\cdot;\cdot}$.
  \enit
\enen
\end{Lemma}
\byind

\begin{Lemma}[Well-typed Terms are in the Logical Relation]
\label{le:lrmain}
If $\god\vd M\hastype A$, then for every $\godp$ such that
$\godp\vd\tri\in\den{\god}$, $\godp\vd [\tri]M\in\den{A}$.
\end{Lemma} 
\begin{proof}
By induction on the typing derivation:
\bit
%\itc $$\cD= \ianc{c\oftp A \in \Sigma}{\Gamma; \Omega; \cdot \vd c \hastype
% A}{Con}$$
%\btab
%$\Gamma; \Omega; \cdot \vd c\da c \hastype A$\br\\
%$[\tri]c=c\in\den{A}$\bl{le:lr2canon}
%\etab
\itc $$\cD= \ianc{}{(\Gamma, x\oftp A); \Omega; \cdot \vd x \hastype A}{Id^u}$$
\btab
$\godp\vd\tri\in\den{(\GG,\xoa);\O;\cdot}$\ba
$\tri\equiv\gamma',\gamma(x)/x;\omega;\epsilon$ and $\Delta'\equiv\cdot$\`
By inversion and Remark~\ref{re:emptyd}\\
$\GG';\O';\cdot\vd\gamma(x)\in\den{A}$\bd of $\den{\cdot}$\\
$\GG';\O';\cdot\vd[\tri]x\in\den{A}$\bd of substitution
\etab
\itc $$\cD= \ianc{}{\Gamma; \Omega; \xoa \vd x \hastype A}{Id^1}$$
\btab
$\godp\vd\tri\in\den{\GG;\O;\xoa}$\ba
$\tri\equiv \gamma;\omega;\delta(x)/x$ and 
$\D'\equiv\cdot$\` By inversion and Remark~\ref{re:emptyd}\\
$\GG';\O;\cdot\vd\delta(x)\in\den{A}$\bd of $\den{\cdot}$\\
$\GG';\O;\cdot\vd [\tri]x\in\den{A}$\bd of substitution.
\etab
\itc $$\cD= \ianc{c\oftp A \in \Sigma}{\Gamma; \Omega; \cdot \vd c \hastype
 A}{Con}$$
Immediate by Lemma~\ref{le:lr2canon} and definition of substitution.
\itc % TImp
$$\cD=\ianc{(\Gamma, x\oftp A); \Omega; \Delta \vd M \hastype B}{\Gamma;
\Omega; \Delta \vd \lam x^u \oftp A\ldot M \hastype A \GImp{u}
B}{\GImp{u}I}$$
\btab
$(\Gamma, x\oftp A); \Omega; \Delta \vd M \hastype B$\bs
$\GG'\geq\GG'$\br\\
$\godp\vd\tri\in\den{\god}$\bh 
%% $(\GG',\D');\O';\cdot\vd \tri\in\den{\god}$\bl{le:loosectx}
$(\GG',\D');\O';\cdot\vd N\in\den{A}$\ba
$\GG';\O';\D'\vd(\gamma,N/x);\omega;\delta\in\den{(\GG,\xoa);\O;\D}$\bd of $\den{ \cdot  }$\\
$\godp\vd [( \gamma,N/x);\omega;\delta]M\in\den{B}$\bi \\
$\godp\vd [(id_{\GG'},N/x);id_{\O'};id_{\D'}]((\gamma,x/x);\omega;\delta)
M\in\den{B}$\`By composition of substitutions\\ 
$\godp\vd(\lamb{x^u}{A}[(\gamma,x/x);\omega;\delta]M)) N^u\in\den{
B}$\bl{le:clohead}
$\godp\vd ([\tri](\lamb{x^u}{A}M)) N^u\in\den{B}$\bd of substitution \\
$\godp\vd [\tri](\lamb{x^u}{A}M)\in\den{A\TImp B}$\bd of $\den{A\TImp B}$
\etab

\itc % ZImp
$$\cD=\ianc{\Gamma; (\Omega,\xoa); \Delta \vd M \hastype B}{\Gamma;
\Omega; \Delta \vd \lam x^0 \oftp A\ldot M \hastype A \GImp{0}
B}{\GImp{0}I}$$
\btab
$\Gamma; (\Omega,\xoa); \Delta \vd M \hastype B$\bs
$\godp\vd\tri\in\den{\god}$\bh 
$\O'\geq\O'$\br\\
%%$(\GG',\O',\D');\cdot;\cdot\vd \tri\in\den{\god}$\bl{le:loosectx}
$(\GG',\O',\D');\cdot;\cdot\vd N\in\den{A}$\ba
$\godp\vd
\gamma;(\omega,N/x);\delta\in\den{(\GG,\xoa);\O;\D}$\bd of $\den{\cdot }$\\
$\godp\vd [\gamma;(\omega,N/x);\delta]M\in\den{B}$\bi\\
$\godp\vd
[id_{\GG'};(id_{\O'},N/x);id_{\D'}](\gamma;(\omega,x/x);\delta)
M\in\den{B}$\`By composition of substitutions\\ 
$\godp\vd(\lamb{x^0}{A}[\gamma;(\omega,x/x);\delta]M)) N^0\in\den{
B}$\bl{le:clohead}
$\godp\vd ([\tri](\lamb{x^0}{A}M)) N^0\in\den{B}$\bd of substitution \\
$\godp\vd [\tri](\lamb{x^0}{A}M)\in\den{A\ZImp B}$\bd of $\den{A\ZImp B}$
\etab

\itc %% RIMP
$$\cD=\ianc{\Gamma; \Omega; (\Delta,\xoa) \vd M \hastype B}{\Gamma;
\Omega; \Delta \vd \lam x^1 \oftp A\ldot M \hastype A \GImp{1}
B}{\GImp{1}I}$$
\btab
$\Gamma; \Omega; (\Delta,\xoa) \vd M \hastype B$\bs
%% $\godp\vd\tri\in\den{\god}$\bh 
$(\GG',\D_N);\O';\D_M\vd \tri\in\den{\god}$\bh
$(\GG',\D_M);\O';\D_N\vd N\in\den{A}$\ba
$\GG';\O';\dmn\vd
\gamma;\omega;(\delta,N/x)\in\den{(\GG,\xoa);\O;\D}$\bd of $\den{\cdot }$\\
$\GG';\O';\dmn\vd [\gamma;\omega;(\delta,N/x)]M\in\den{B}$\bi\\
$\GG';\O';\dmn\vd
[id_{\GG'};id_{\O},(id_{(\D_N,\D_M)},N/x)](\gamma;\omega;(\delta,x/x))
M\in\den{B}$\`By composition of subst.\\
$\GG';\O';\dmn\vd(\lamb{x^1}{A}[\gamma;\omega;(\delta,x/x)]M)) N^1\in\den{
B}$\bl{le:clohead} 
$\GG';\O';\dmn\vd ([\tri](\lamb{x^1}{A}M))
N^1\in\den{B}$\bd of substitution \\ 
$(\GG'\D_N);\O';\D_M\vd [\tri](\lamb{x^1}{A}M)\in\den{A\RImp B}$\bd of $\den{A\RImp B}$
\etab
%%%% end intro rules
\itc
$$\cD= \ibnc{\Gamma; \Omega; \Delta \vd M \hastype A \UImp B}{(\Gamma,
\Delta); \Omega; \cdot \vd N \hastype A}{\Gamma; \Omega; \Delta \vd M\
N^u \hastype B}{\GImp{u}E}$$
\btab
$\godp\vd\tri\in\den{\god}$\bh
$\Gamma; \Omega; \Delta \vd M \hastype A \UImp B$\bs
$\godp\vd[\tri]M\in\den{A\TImp B}$\bi\\
$(\GG',\D');\O';\cdot\vd
  (\gamma,\delta);\omega;\epsilon\in\den{(\GG,\D);\O;\cdot}$\bl{le:invertlr}
$(\Gamma,\Delta); \Omega; \cdot \vd N \hastype A$\bs
$(\Gamma',\Delta'); \Omega'; \cdot \vd [(\gamma,\delta);\omega;\epsilon]N \in\den{ A}$\bi\\
$\GG'\geq\GG'$\br\\
$\godp\vd ([\tri]M)([(\gamma,\delta);\omega;\epsilon] N)^u\in\den{B}$\bd
of $\den{ \cdot  }$\\ 
$\godp\vd [\tri](M\ N)^u\in\den{B}$\bd of substitution
\etab
%%%% ZIMP
\itc
$$\cD= \ibnc{\Gamma; \Omega; \Delta \vd M \hastype A \ZImp B}{(\Gamma,
  \O,\Delta); \cdot; \cdot \vd N \hastype A}{\Gamma; \Omega; \Delta
  \vd M\ N^0 \hastype B}{\GImp{0}E}$$
\btab
$\godp\vd\tri\in\den{\god}$\bh
$\godp\vd\tri\in\den{\god}$\bh $\Gamma; \Omega; \Delta \vd M \hastype
A \ZImp B$\bs
$\godp\vd[\tri]M\in\den{A\ZImp B}$\bi\\
$(\GG',\D');\O';\cdot\vd
(\gamma,\omega,\delta);\epsilon;\epsilon\in\den{(\GG,\O,\D);\cdot;\cdot}$\bl{le:invertlr}
$(\Gamma,\Omega,\Delta); \cdot; \cdot \vd N \hastype A$\bs
$(\Gamma',\Omega',\Delta'); \cdot; \cdot \vd [(\gamma,\omega,\delta);\epsilon;\epsilon]N \in\den{ A}$\bi\\
$\O'\geq\O'$\br\\
$\godp\vd ([\tri]M)([(\gamma,\omega,\delta);\epsilon;\epsilon]
N)^u\in\den{B}$\bd
of $\den{ \cdot  }$\\
$\godp\vd [\tri](M\ N)^u\in\den{B}$\bd of substitution \etab
% \btab
% $\Gamma; \Omega; \Delta \vd M \hastype A \ZImp B$\bs
% $\god\vd[\tri]M\in\den{A\ZImp B}$\bi\\
% $(\Gamma,\O,\Delta); \cdot; \cdot \vd N \hastype A$\bs
% $(\Gamma,\O,\Delta); \cdot; \cdot \vd N \in\den{ A}$\bi\\
% $\O\geq\O$\br\\
% $\god\vd ([\tri]M)([\tri] N)^0\in\den{B}$\bd of $\den{ \cdot  }$\\
% $\god\vd [\tri](M\ N)^0\in\den{B}$\bd of substitution
% \etab
\itc
$$\cD=\ibnc{(\Gamma, \Delta_N); \Omega; \Delta_M \vd M \hastype A \RImp
B}{(\Gamma, \Delta_M); \Omega; \Delta_N \vd N \hastype A}{\Gamma;
\Omega; (\Delta_M, \Delta_N) \vd M\ N^1 \hastype B}{\GImp{1}E}$$
\btab
$\godp\vd\tri\in\den{\GG;\O;\dmn}$\bh
  $(\GG',\D_N');\O';\D_M'\vd
  (\gamma,\delta_N);\omega;\delta_M\in\den{(\GG,\D_N);\O;\D_M}$ and\\
  $(\GG',\D_M');\O';\D_N'\vd
  (\gamma,\delta_M);\omega;\delta_N\in\den{(\GG,\D_M);\O;\D_N}$
for  $\D_M',\D_N'=\D'$, $\delta_M,\delta_N=\delta$\bl{le:invertlr}
$(\Gamma,\D_N); \Omega; \Delta_M \vd M \hastype A \RImp B$\bs
$(\Gamma',\D_N'); \Omega'; \Delta_M'\vd[(\gamma,\delta_N);\omega;\delta_M]M\in\den{A\RImp B}$\bi\\
$(\Gamma',\Delta_M'); \O'; \D_N' \vd N \hastype A$\bs
$(\GG',\D_N')\geq (\GG',\D_N')$\br\\
$(\Gamma',\Delta_M'); \O'; \D_N' \vd [(\gamma,\delta_M);\omega;\delta_N]N \in\den{ A}$\bi\\
$\GG';\O';(\Delta_M',\Delta_N')\vd
([(\gamma,\delta_N);\omega;\delta_M]M)
([(\gamma,\delta_M);\omega;\delta_N] N)^1\in\den{B}$\bd of $\den{ \cdot  }$\\
$\GG';\O';\Delta'\vd [\tri](M\ N)^1\in\den{B}$\bd of substitution
%$(\Gamma,\D_N); \Omega; \Delta_M \vd M \hastype A \RImp B$\bs
%$(\Gamma,\D_N); \Omega; \Delta_M\vd[\tri]M\in\den{A\RImp B}$\bi\\
%$(\Gamma,\Delta_M); \O; \D_N \vd N \hastype A$\bs
%$(\Gamma,\Delta_M); \O; \D_N \vd N \in\den{ A}$\bi\\
%$\GG;\O;\dmn\vd ([\tri]M)([\tri] N)^1\in\den{B}$\bd of $\den{ \cdot  }$\\
%$\GG;\O;\dmn\vd [\tri](M\ N)^1\in\den{B}$\bd of substitution
\etab
\enit
\end{proof}

\begin{Lemma}
\label{le:lrid}
 $\god\vd id_{\god}\in\den{\god}$. 
\end{Lemma}
\begin{proof}
Immediate from the definition of $\den{\god}$ and Lemma~\ref{le:lr2canon}(2).
\end{proof}


\begin{Theorem}[Canonical Form Theorem]
\label{thm:canonical}
If $\god\vd M\hastype A$, then there is $N$ such that $\god\vd M\bua
N\hastype A$.
\end{Theorem}
\begin{proof}
Assume $\god\vd M\hastype A$: By Lemma \ref{le:lrid} $
\god\vd id_{\god}\in\den{\god}$, hence, by Lemma \ref{le:lrmain} $\god\vd
[id_{\god}]M\in\den{A}$ and thus  $\god\vd M\in\den{A}$; by Lemma
\ref{le:lr2canon}(1), $\god\vd M\bua N\hastype A$ for some $N$.
\end{proof}

We shall abbreviate the statement of the canonical form Theorem as
$\GG;\Omega;\Delta\prv M \buda A$.

