(* Chris Okasaki
   School of Computer Science
   Carnegie Mellon University
   Pittsburgh, PA 15213
   cokasaki@cs.cmu.edu *)

signature ERROR =
  (* error/warning messages suitable for a compiler *)
sig

  exception TooManyErrors
  exception FatalError

(***** REPORT AN ERROR/WARNING *****)

  val warning    : int -> string -> string -> Pos.T -> unit
        (* display a message and continue *)
  val error      :        string -> string -> Pos.T -> unit
        (* display a message and continue unless there are too many errors *)
  val fatalerror :        string -> string -> Pos.T -> 'a
        (* display a message and abort *)

  val okay : string -> string -> unit
       (* check if there have been any errors *)
       (* if so, display a message and abort  *)
       (* if not, do nothing                  *)

  (* the first string is the component which detected the error   *)
  (*   (e.g. "Lexer")                                             *)
  (* the second string is an informative error message            *)
  (*   (e.g. "Unexpected Character")                              *)
  (* the position is the approximate position in the text file    *)
  (*   which caused the error                                     *)
  (* the integer is the warning severity level                    *)
  (*   (warnings below a certain threshold are suppressed)        *)

(***** STATE *****)

  val numErrors   : unit -> int
  val numWarnings : unit -> int * int
        (* numWarnings () = (x,y) where x = # of reported warnings    *) 
        (*                              y = # of suppressed warnings  *)

  val reset : unit -> unit
        (* reset error/warning counters to 0 *)

(***** USER SETTINGS *****)

  val maxErrors : int ref
        (* the number of errors at which the system will give up *)
        (* and raise the TooManyErrors exception                 *)

  val warningThreshold : int ref
        (* the threshold for displaying warnings.  warnings with a *)
        (* severity level below the given threshold are suppressed *)

end
