signature LOOP =
sig

  type action = (string -> MinML.typ) * MinML.exp -> unit

  (* print the expression *)
  val show      : action
  (* ... with its type *)
  val showType  : action

  (* apply an action to a completely evaluated expression *)
  val eval      : action -> action

  (* apply an action to each step of the evaluation *)
  val step      : action -> action

  (* wait after executing an action *)
  val wait      : action -> action

  (* run an action on user input expressions *)
  val loop      : action -> unit
  (* ... on a file *)
  val loopFile  : string -> action -> unit

end
