signature CMACHINE =
sig

  val Debug : bool ref

  exception Stuck

  type frame
  type 'a stack
  type memory = MinML.subst * (string -> MinML.typ)
  type handlers
  type state = memory * handlers * (frame stack) * MinML.exp

  val Cstep : state -> state

  val CstepOpt : state -> state option
  val CmultiStep : state -> state
  val CstepStream : MinML.exp -> state Stream.T
  val eval : MinML.exp -> ((string -> MinML.typ) * MinML.exp)

end
  