package bingo.shared;

import java.net.*;
import java.io.*;

public class PlayerListenerThread extends ListenerThread {

    private PlayerListener notifyee;

    public PlayerListenerThread(PlayerListener notifyee) throws IOException {

	super(Constants.PlayerListeningGroup);
	this.notifyee = notifyee;
    }

    public synchronized void run() {
	DatagramPacket packet;

        while (stopListening == false) {
	    byte[] buf = new byte[256];
            packet = new DatagramPacket(buf, 256);
	    try {
                socket.receive(packet);
		byte[] rcvd = packet.getData();
		PlayerRecord p = new PlayerRecord(rcvd);
	        notifyee.updatePlayer(p);
	    } catch (IOException e) {
		    // PENDING: what goes in here?
	    }
        }
    }
}
