import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class ClickMeDrag extends Applet implements MouseListener, MouseMotionListener {
    private Spot spot = new Spot(RADIUS);
    private Spot previousSpot = new Spot(RADIUS);
    private static final int RADIUS = 7;
    private boolean clear = false;

    public void init() {
        addMouseListener(this);
        addMouseMotionListener(this);
    }

    public void update(Graphics g) {

        //clear drawing area
        if (clear) {
            //draw a black border and a white background
            g.setColor(Color.white);
            g.fillRect(0, 0, getSize().width - 1, getSize().height - 1);
            g.setColor(Color.black);
            g.drawRect(0, 0, getSize().width - 1, getSize().height - 1);
            clear = false;
        }

        //limit drawing to within the black outline of the applet
        Rectangle clipping = g.getClip().getBounds();
        clipping.x += 1;
        clipping.y += 1;
        clipping.width -= 2;
        clipping.height -= 2;
        g.setClip(clipping);

        //erase the old spot
        g.setColor(Color.white);
        if (previousSpot.x != -1 && previousSpot.y != -1) {
            g.fillOval(previousSpot.x - RADIUS, previousSpot.y - RADIUS,
                       RADIUS * 2, RADIUS * 2);
        }
        //draw the spot
        g.setColor(Color.red);
        if (spot.x != -1 && spot.y != -1) {
            g.fillOval(spot.x - RADIUS, spot.y - RADIUS, RADIUS * 2, RADIUS * 2);
        }
    }

    public void paint(Graphics g) {
        //draw a black border and a white background
        g.setColor(Color.white);
        g.fillRect(0, 0, getSize().width - 1, getSize().height - 1);
        g.setColor(Color.black);
        g.drawRect(0, 0, getSize().width - 1, getSize().height - 1);
        update(g);
    }

    //MouseListener methods
    public void mousePressed(MouseEvent event) {
        previousSpot.x = spot.x;
        previousSpot.y = spot.y;
        spot.x = event.getX();
        spot.y = event.getY();
        clear = true;
        repaint();
    }
    public void mouseClicked(MouseEvent event) {}
    public void mouseReleased(MouseEvent event) {}
    public void mouseEntered(MouseEvent event) {}
    public void mouseExited(MouseEvent event) {}

    //MouseMotionListener methods
    public void mouseMoved(MouseEvent event) {}
    public void mouseDragged(MouseEvent event) {
        previousSpot.x = spot.x;
        previousSpot.y = spot.y;
        spot.x = event.getX();
        spot.y = event.getY();
        repaint();
    }
}
