/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class ClipImage
extends JApplet
implements Runnable {
    private Image img;
    private final double[] OINC = new double[]{5.0, 3.0};
    private final double[] SINC = new double[]{5.0, 5.0};
    private double x;
    private double y;
    private double ix = this.OINC[0];
    private double iy = this.OINC[1];
    private double iw = this.SINC[0];
    private double ih = this.SINC[1];
    private double ew;
    private double eh;
    private GeneralPath p = new GeneralPath();
    private AffineTransform at = new AffineTransform();
    private BasicStroke bs = new BasicStroke(20.0f);
    private Arc2D arc = new Arc2D.Float();
    private Ellipse2D ellipse = new Ellipse2D.Float();
    private RoundRectangle2D roundRect = new RoundRectangle2D.Float();
    private Rectangle2D rect = new Rectangle2D.Float();
    private Color redBlend = new Color(255, 0, 0, 120);
    private Color greenBlend = new Color(0, 255, 0, 120);
    private Thread thread;
    private BufferedImage offImg;
    private int w;
    private int h;
    private boolean newBufferedImage;

    public Graphics2D createDemoGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = null;
        if (this.offImg == null || this.offImg.getWidth() != this.w || this.offImg.getHeight() != this.h) {
            this.offImg = (BufferedImage)this.createImage(this.w, this.h);
            this.newBufferedImage = true;
        }
        if (this.offImg != null) {
            graphics2D = this.offImg.createGraphics();
            graphics2D.setBackground(this.getBackground());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.clearRect(0, 0, this.w, this.h);
        return graphics2D;
    }

    public void drawDemo(Graphics2D graphics2D) {
        if (this.newBufferedImage) {
            this.x = Math.random() * (double)this.w;
            this.y = Math.random() * (double)this.h;
            this.ew = Math.random() * (double)this.w / 2.0;
            this.eh = Math.random() * (double)this.h / 2.0;
        }
        this.x += this.ix;
        this.y += this.iy;
        this.ew += this.iw;
        this.eh += this.ih;
        if (this.ew > (double)(this.w / 2)) {
            this.ew = this.w / 2;
            this.iw = Math.random() * (double)(-this.w) / 16.0 - 1.0;
        }
        if (this.ew < (double)(this.w / 8)) {
            this.ew = this.w / 8;
            this.iw = Math.random() * (double)this.w / 16.0 + 1.0;
        }
        if (this.eh > (double)(this.h / 2)) {
            this.eh = this.h / 2;
            this.ih = Math.random() * (double)(-this.h) / 16.0 - 1.0;
        }
        if (this.eh < (double)(this.h / 8)) {
            this.eh = this.h / 8;
            this.ih = Math.random() * (double)this.h / 16.0 + 1.0;
        }
        if (this.x + this.ew > (double)this.w) {
            this.x = (double)this.w - this.ew - 1.0;
            this.ix = Math.random() * (double)(-this.w) / 32.0 - 1.0;
        }
        if (this.x < 0.0) {
            this.x = 2.0;
            this.ix = Math.random() * (double)this.w / 32.0 + 1.0;
        }
        if (this.y + this.eh > (double)this.h) {
            this.y = (double)this.h - this.eh - 2.0;
            this.iy = Math.random() * (double)(-this.h) / 32.0 - 1.0;
        }
        if (this.y < 0.0) {
            this.y = 2.0;
            this.iy = Math.random() * (double)this.h / 32.0 + 1.0;
        }
        this.ellipse.setFrame(this.x, this.y, this.ew, this.eh);
        graphics2D.setClip(this.ellipse);
        this.rect.setRect(this.x + 5.0, this.y + 5.0, this.ew - 10.0, this.eh - 10.0);
        graphics2D.clip(this.rect);
        graphics2D.drawImage(this.img, 0, 0, this.w, this.h, this);
        this.p.reset();
        this.p.moveTo((float)(-this.w) / 2.0f, (float)(-this.h) / 8.0f);
        this.p.lineTo((float)this.w / 2.0f, (float)(-this.h) / 8.0f);
        this.p.lineTo((float)(-this.w) / 4.0f, (float)this.h / 2.0f);
        this.p.lineTo(0.0f, (float)(-this.h) / 2.0f);
        this.p.lineTo((float)this.w / 4.0f, (float)this.h / 2.0f);
        this.p.closePath();
        this.at.setToIdentity();
        this.at.translate((float)this.w * 0.5f, (float)this.h * 0.5f);
        graphics2D.transform(this.at);
        graphics2D.setStroke(this.bs);
        graphics2D.setPaint(this.redBlend);
        graphics2D.draw(this.p);
        this.at.setToIdentity();
        graphics2D.setTransform(this.at);
        graphics2D.setPaint(this.greenBlend);
        int n = 0;
        while (n < this.h) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.w) {
                switch (n3) {
                    case 0: {
                        this.arc.setArc(n2, n, 25.0, 25.0, 45.0, 270.0, 2);
                        graphics2D.fill(this.arc);
                        break;
                    }
                    case 1: {
                        this.ellipse.setFrame(n2, n, 25.0, 25.0);
                        graphics2D.fill(this.ellipse);
                        break;
                    }
                    case 2: {
                        this.roundRect.setRoundRect(n2, n, 25.0, 25.0, 4.0, 4.0);
                        graphics2D.fill(this.roundRect);
                        break;
                    }
                    case 3: {
                        this.rect.setRect(n2, n, 25.0, 25.0);
                        graphics2D.fill(this.rect);
                        n3 = -1;
                    }
                }
                ++n3;
                n2 += 50;
            }
            n += 50;
        }
    }

    protected URL getURL(String string) {
        URL uRL = this.getCodeBase();
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Couldn't create image: badly specified URL");
            return null;
        }
        return uRL2;
    }

    public void init() {
        this.setBackground(Color.white);
        this.img = this.getImage(this.getURL("images/clouds.jpg"));
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.img, 0);
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        ClipImage clipImage = new ClipImage();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                ClipImage.this.start();
            }

            public void windowIconified(WindowEvent windowEvent) {
                ClipImage.this.stop();
            }
        };
        JFrame jFrame = new JFrame("Java 2D Demo - ClipImage");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", clipImage);
        ((Component)jFrame).setSize(new Dimension(400, 300));
        jFrame.show();
        clipImage.start();
    }

    public void paint(Graphics graphics) {
        this.w = this.getWidth();
        this.h = this.getHeight();
        if (this.w <= 0 || this.h <= 0) {
            return;
        }
        Graphics2D graphics2D = this.createDemoGraphics2D(graphics);
        this.drawDemo(graphics2D);
        graphics2D.dispose();
        if (this.offImg != null && this.isShowing()) {
            graphics.drawImage(this.offImg, 0, 0, this);
        }
        this.newBufferedImage = false;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread && this.isShowing()) {
            Graphics graphics = ((Component)this).getGraphics();
            this.paint(graphics);
            graphics.dispose();
            Thread.yield();
        }
        this.thread = null;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stop() {
        this.thread = null;
    }
}

