/********************************************************************/
/*   SPAWNO v3.5   EMS/XMS/disk swapping replacement for spawn...() */
/*   (c) Copyright 1991-1993 Ralf Brown  All Rights Reserved	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include <alloc.h>
#include "_spawno.h"

int _Cdecl spawnvpe(int type,const char *prog_name,const char **args,
		    const char **env)
{
   if (type != P_WAIT)
      {
      errno = EINVAL ;
      return -1 ;
      }
   return spawnvpeo(__spawn_swapdir,prog_name,args,env) ;
}

int _Cdecl spawnlpe(int type,const char *prog_name, ...)
{
   int retval ;
   va_list env ;

   if (type != P_WAIT)
      {
      errno = EINVAL ;
      return -1 ;
      }
   va_start(env,prog_name) ;
   while (*((char **)env))  /* find NULL terminating list of program args */
      va_arg(env,char *) ;
   va_arg(env,const char **) ; /* point at pointer to list of env variables */
   retval = spawnvpeo(__spawn_swapdir,prog_name,(const char **)_va_ptr,
		      *((const char ***)env)) ;
   va_end(env) ;
   return retval ;
}
