/********************************************************************/
/*   SPAWNO v3.5   EMS/XMS/disk swapping replacement for spawn...() */
/*   (c) Copyright 1991, 1993 Ralf Brown  All Rights Reserved 	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include "_spawno.h"
#include <dos.h>
#include <io.h>

int _Cdecl systemo(const char *overlay_path, const char *command)
{
   char *comspec = getenv("COMSPEC") ;
   char c_switch[3] ;

   if (!comspec || *comspec == '\0')  /* if no COMSPEC environment variable, */
      comspec = "COMMAND" ;           /* use COMMAND as the default          */
   if (!command || *command == '\0')  /* if given a null command, system()   */
      { 			      /* returns whether or not the command  */
      if (!access(__spawn_search(comspec),0)) /* processor is accessible     */
	 return 1 ;
      else
	 {
	 errno = ENOENT ;
	 return 0 ;
	 }
      }
#ifdef __TURBOC__
   _AX = 0x3700 ;		    /* ask DOS for current switch character */
   geninterrupt(0x21) ;
   if (_AL)
      c_switch[0] = '/' ;
   else
      c_switch[0] = _DL ;
#else
   c_switch[0] = '/' ;		    /* assume DOS-default forward slash */
#endif
   c_switch[1] = 'c' ;
   c_switch[2] = '\0' ;
   return spawnlpeo(overlay_path,comspec,comspec,c_switch,command,
		    (char *)NULL,environ) ;
}

