	NAME	IOerror
	TITLE	Convert DOS error numbers to C library error numbers
	PAGE	60,132

;-----------------------------------------------------------
; (c) Copyright 1991 Ralf Brown	 All Rights Reserved
; This file may be redistributed as a part of the complete SPAWNO package,
; under its distribution conditions
;
;  SPAWNO v4.00
;	Overlaying spawnv()
;
;  File: SPAWNERR.ASM  Convert DOS error numbers to C library error numbers
;
;-----------------------------------------------------------

	INCLUDE RULES.ASI

	Header@

;-----------------------------------------------------------
; initialized data

DSeg@
ExtSym@ _doserrno,WORD,__CDECL__
ExtSym@ errno,WORD,__CDECL__

IFNDEF __TURBOC__
error_numbers label byte
	db	0
	db	1
	db	2	; ENOENT
	db	3
	db	24	; EMFILE
	db	13	; EACCESS
	db	6
	db	7
	db	12	; ENOMEM
num_errors equ $-error_numbers
ENDIF ;ndef __TURBOC__

DSegEnd@

CSeg@

;----------------------------------------------------------------
; entry: AX = error number
;	 DS = DGROUP
; exit:	 errno and _doserrno set
;----------------------------------------------------------------
public __SPAWN_ERRNO
__SPAWN_ERRNO proc near
	mov	DGROUP:_doserrno@,ax
IFNDEF __TURBOC__
	cmp	ax,num_errors
	jae	translated
	mov	bx,offset DGROUP:error_numbers
	xlat
translated:
ENDIF ;ndef __TURBOC__
	mov	DGROUP:errno@,ax
	mov	ax,-1
	ret
__SPAWN_ERRNO endp

CSegEnd@

	END
