/********************************************************************/
/*   SPAWNO v3.5      XMS/disk swapping replacement for spawn...()  */
/*   (c) Copyright 1990, 1993 Ralf Brown  All Rights Reserved 	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include <dos.h>
#include <string.h>
#include "_spawno.h"

static char *__spawn_env ;

unsigned int pascal __spawn_buildenv(char * const *env)
{
   int seg, i ;
   char far *mem ;
   unsigned int length = 1 ;		  /* take trailing NUL into account */
   char *e ;

   for (i = 0 ; env[i] && *env[i] ; i++)  /* add up the lengths of the variables */
      length += strlen(env[i]) + 1 ;
   __spawn_env = (char *)malloc(length+15) ; /* enough to ensure para alignment */
   mem = (char far *) __spawn_env ;
   seg = FP_SEG(mem) + ((FP_OFF(mem)+15)>>4) ; /* normalize into paragraph alignment */
   if (seg)				/* if malloc did not return NULL,... */
      {
      mem = MK_FP(seg,0) ; 		  /* create a normalized pointer */
      while (*env && **env)		  /* for each environment variable: */
	 {
	 e = *env++ ;			  /* copy the variable */
	 do {} while ((*mem++ = *e++) != 0) ; /* incl. the terminating NUL */
	 }
      *mem = '\0' ;                       /* append final terminating NUL */
      }
   return seg ;
}

void pascal __spawn_free_env(void)
{
    if (__spawn_env)
	free(__spawn_env) ;
}