/********************************************************************/
/*   SPAWNO v3.5   EMS/XMS/disk swapping replacement for spawn...() */
/*   (c) Copyright 1990, 1993 Ralf Brown  All Rights Reserved 	    */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#ifndef __SPAWNO_H
#define __SPAWNO_H

#include <stdarg.h>

#ifndef _Cdecl
#  ifdef M_I86		/* MSC 5.x */
#    define _Cdecl cdecl
#  endif /* M_I86 */
#endif /* _Cdecl */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
int _Cdecl spawnvo(const char *overlay_path, const char *name, va_list args) ;
int _Cdecl spawnvpo(const char *overlay_path, const char *name, va_list args) ;
int _Cdecl spawnveo(const char *overlay_path, const char *name, va_list args,const char **env) ;
int _Cdecl spawnvpeo(const char *overlay_path, const char *name, va_list args,const char **env) ;
int _Cdecl spawnlo(const char *overlay_path, const char *name, ...) ;
int _Cdecl spawnlpo(const char *overlay_path, const char *name, ...) ;
int _Cdecl spawnleo(const char *overlay_path, const char *name, ...) ;
int _Cdecl spawnlpeo(const char *overlay_path, const char *name, ...) ;
int _Cdecl systemo(const char *overlay_path, const char *command) ;

/* this function is normally called only by the spawn...o() functions */
int pascal __spawnv(const char *overlay_path,const char *name,va_list args,int env) ;

#ifdef __cplusplus
}
#endif /* __cplusplus */

  /* The following variable determines whether SPAWNO is allowed to use XMS */
  /* memory if available.  Set to 0 to disable XMS, 1 (default) to enable   */
extern char _Cdecl __spawn_xms ;

  /* The next variable determines whether SPAWNO is allowed to use EMS	    */
  /* memory if available and XMS is either unavailable or disabled.  Set to */
  /* 0 to disable EMS, 1 (default) to enable.				    */
extern char _Cdecl __spawn_ems ;

  /* Specify whether to swap the program's memory blocks in the upper       */
  /* memory area under MSDOS 5.0 (requires DOS=UMB in CONFIG.SYS)	    */
extern char _Cdecl __spawn_swap_UMA ;

  /* The third variable specifies the swap directory to be used by the	    */
  /* direct spawn..() replacement functions (the spawn..o() functions	    */
  /* will always use the explicitly provided directory for disk swapping    */
extern char * _Cdecl __spawn_swapdir ;

  /* The last variable specifies the number of paragraphs to keep resident  */
  /* while swapped out (default 0 means minimum possible)		    */
extern unsigned int _Cdecl __spawn_resident ;


#endif /* __SPAWNO_H */
