;;***********************************************************************
;;*									*
;;*	RBspeed.COM  Adjust processor speed on Intel Pentium 'Neptune'  *
;;*									*
;;*	by Ralf Brown, 7 Aug 1994					*
;;*	Donated to the Public Domain.  Enjoy!				*
;;*									*
;;*	Last Edit: 9 Aug 1994						*
;;*									*
;;***********************************************************************

	.486p

;;----------------------------------------------------------------------

speed_port	equ 0C050h
speed_bit	equ 04h
bios_speed_flag equ 10h

;;----------------------------------------------------------------------

BIOS_SEG SEGMENT AT 0040h USE16
	;; the AMI BIOS keeps a flag to indicate current processor speed
	 org 16h
bios_flags label byte
BIOS_SEG ENDS

;;----------------------------------------------------------------------
;; define macros
;;----------------------------------------------------------------------

set0CF8_bit7 macro
	mov	dx,0CF8h
	mov	al,80h
	out	dx,al
	endm

clr0CF8_bit7 macro
	mov	dx,0CF8h
	mov	al,00h
	out	dx,al
	endm

;;----------------------------------------------------------------------
;; the main program
;;----------------------------------------------------------------------

CSEG	segment public byte 'code' use16
	org	100h

setspeed proc near
	ASSUME	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
	mov	si,81h
	cld
skip_whitespace:
	lodsb
	cmp	al,' '
	je	skip_whitespace
	cmp	al,9
	je	skip_whitespace
	and	al,0DFh	;; uppercase it
	cmp	al,'F'
	je	short set_fast
	cmp	al,'S'
	je	short set_slow
	cmp	al,'V'
	je	short set_very_slow
	mov	dx,offset usage_msg
done:
	push	dx
	clr0CF8_bit7
	pop	dx
	push	cs
	pop	ds
	ASSUME	DS:CSEG
	mov	ah,9
	int	21h
	int	20h

set_fast:
	call	fast
	mov	dx,offset fast_msg
	jmp	short done

set_slow:
	call	slow
set_slow_done:
	mov	dx,offset slow_msg
	jmp	short done

set_very_slow:
	call	slow
	;; disable on-chip memory cache
	mov	eax,cr0
	or	eax,60000000h
	mov	cr0,eax
	wbinvd
	mov	dx,offset vslow_msg
	jmp	short done
setspeed endp

;;----------------------------------------------------------------------

prepare_chipset proc near
	set0CF8_bit7
	mov	dx,0C008h
	in	al,dx
	test	al,al
	je	short prepare_1
	mov	dx,0CFAh
	xor	al,al
	out	dx,al
prepare_1:
	ret
prepare_chipset endp

;;----------------------------------------------------------------------
;; switch the CPU to slow speed
;;----------------------------------------------------------------------

slow proc near
	mov	ax,BIOS_SEG
	mov	ds,ax
	ASSUME	DS:BIOS_SEG
	call	prepare_chipset
	mov	dx,speed_port
	in	al,dx
	and	al,not speed_bit	; set chipset to slow
	wbinvd
	out	dx,al
	mov	dx,0C052h
	in	al,dx
	and	al,0FEh
	out	dx,al
	wbinvd
	and	bios_flags,not bios_speed_flag
	ret
slow endp

;;----------------------------------------------------------------------
;; switch the CPU to fast speed and enable internal cache
;;----------------------------------------------------------------------

fast proc near
	mov	ax,BIOS_SEG
	mov	ds,ax
	ASSUME	DS:BIOS_SEG
	call	prepare_chipset
	mov	dx,0C052h
	in	al,dx
	test	al,0C0h
	je	short fast_1
	or	al,03h
	out	dx,al
fast_1:
	mov	dx,speed_port
	in	al,dx
	or	al,speed_bit		; set chipset to fast
	out	dx,al
	;; enable internal (on-chip) memory cache
	mov	eax,cr0
	and	eax,9FFFFFFFh
	mov	cr0,eax
	or	bios_flags,bios_speed_flag
	ret
fast endp

;;----------------------------------------------------------------------

usage_msg db	"RBspeed v1.00 -- set speed of Intel Pentium 'Neptune' chipset",13,10
	  db	"Usage:	  SPEED F	set fast CPU speed",13,10
	  db	"	  SPEED S	set slow CPU speed",13,10
	  db	"	  SPEED V	set very slow (cache disabled)",13,10
	  db	"$"
fast_msg  db	"CPU now fast",13,10,"$"
slow_msg  db	"CPU now slow",13,10,"$"
vslow_msg db	"CPU now very slow",13,10,"$"

;;----------------------------------------------------------------------

CSEG ends

	end setspeed
