/****************************** -*- C++ -*- *****************************/
/*									*/
/*  FramepaC  -- frame manipulation in C++				*/
/*  Version 1.98							*/
/*	by Ralf Brown <ralf@cs.cmu.edu>					*/
/*									*/
/*  File frtimer2.cpp	    high-resolution execution-time measurement	*/
/*  LastEdit: 04nov09							*/
/*									*/
/*  (c) Copyright 2000,2001,2006,2009 Ralf Brown			*/
/*	This program is free software; you can redistribute it and/or	*/
/*	modify it under the terms of the GNU General Public License as	*/
/*	published by the Free Software Foundation, version 3.		*/
/*									*/
/*	This program is distributed in the hope that it will be		*/
/*	useful, but WITHOUT ANY WARRANTY; without even the implied	*/
/*	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR		*/
/*	PURPOSE.  See the GNU General Public License for more details.	*/
/*									*/
/*	You should have received a copy of the GNU General Public	*/
/*	License (file COPYING) along with this program.  If not, see	*/
/*	http://www.gnu.org/licenses/					*/
/*									*/
/************************************************************************/

#include "frtimer.h"

/**********************************************************************/
/*      Timing routines                                               */
/**********************************************************************/

double FrTimer::readsec()
{
   clock_t ticks = read() ;
   return ticks / (double)FrTICKS_PER_SEC ;
}

//----------------------------------------------------------------------

double FrTimer::stopsec()
{
   clock_t ticks = stop() ;
   return ticks / (double)FrTICKS_PER_SEC ;
}

//----------------------------------------------------------------------

double FrTimer::pausesec()
{
   clock_t ticks = pause() ;
   return ticks / (double)FrTICKS_PER_SEC ;
}


// end of file frtimer2.cpp //
