/************************************************************************/
/*									*/
/*  FramepaC  -- frame manipulation in C++				*/
/*  Version 1.98							*/
/*	by Ralf Brown <ralf@cs.cmu.edu>					*/
/*									*/
/*  File frctype.cpp		character-manipulation functions	*/
/*  LastEdit: 04nov09							*/
/*									*/
/*  (c) Copyright 1994,1995,1996,1997,2001,2006,2007,2009 Ralf Brown	*/
/*	This program is free software; you can redistribute it and/or	*/
/*	modify it under the terms of the GNU General Public License as	*/
/*	published by the Free Software Foundation, version 3.		*/
/*									*/
/*	This program is distributed in the hope that it will be		*/
/*	useful, but WITHOUT ANY WARRANTY; without even the implied	*/
/*	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR		*/
/*	PURPOSE.  See the GNU General Public License for more details.	*/
/*									*/
/*	You should have received a copy of the GNU General Public	*/
/*	License (file COPYING) along with this program.  If not, see	*/
/*	http://www.gnu.org/licenses/					*/
/*									*/
/************************************************************************/

#include "frctype.h"

/************************************************************************/
/*    Global data for this module					*/
/************************************************************************/

// list the characters which we consider to be whitespace; NUL is not
// whitespace since it is the string terminator
// (Note: assumes that data files use ASCII or the ANSI/Latin-1 supersets
//  thereof!)
const unsigned char FramepaC_isspace_table[] =
   {
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // ^@ to ^O
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // ^P to ^_
      1, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  @ to O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  P to _
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  ` to o
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  p to DEL
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x80 to 0x8F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x90 to 0x9F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xA0 to 0xAF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xB0 to 0xBF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xC0 to 0xCF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xD0 to 0xDF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xE0 to 0xEF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be decimal digits
// (Note: assumes that data files use ASCII or the ANSI superset thereof!)
const unsigned char FramepaC_isdigit_table[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  @ to O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  P to _
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  ` to o
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  p to DEL
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x80 to 0x8F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x90 to 0x9F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xA0 to 0xAF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xB0 to 0xBF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xC0 to 0xCF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xD0 to 0xDF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xE0 to 0xEF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be alphabetic; includes the
// high-bit accented characters
// (Note: assumes that data files use ASCII or the ANSI superset thereof!)
const unsigned char FramepaC_isalpha_table[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  @ to O
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  P to _
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  ` to o
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  p to DEL
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x80 to 0x8F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x90 to 0x9F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xA0 to 0xAF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xB0 to 0xBF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xC0 to 0xCF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xD0 to 0xDF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xE0 to 0xEF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be alphabetic when processing
//   GB-2312/EUC-x/etc-encoded text as individual bytes
const unsigned char FramepaC_isalpha_table_EUC[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  @ to O
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  P to _
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  ` to o
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  p to DEL
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0x80 to 0x8F
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0x90 to 0x9F
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xA0 to 0xAF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xB0 to 0xBF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xC0 to 0xCF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xD0 to 0xDF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xE0 to 0xEF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be alphabetic when processing
//   RawOctet-encoded text as individual bytes
const unsigned char FramepaC_isalpha_table_raw[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  @ to O
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  P to _
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  ` to o
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  p to DEL
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0x80 to 0x8F
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0x90 to 0x9F
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xA0 to 0xAF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xB0 to 0xBF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xC0 to 0xCF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xD0 to 0xDF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xE0 to 0xEF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be punctuation
// (Note: assumes that data files use ASCII or the ANSI/Latin-1 superset
//  thereof!)
const unsigned char FramepaC_ispunct_table[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 1, 1, 1, 1, 1, 1,    //  0 to ?
      1, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  @ to O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 1, 1, 1, 1, 1,    //  P to _
      1, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  ` to o
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 1, 1, 1, 1, 0,    //  p to DEL
      0, 0, 1, 0, 1, 1, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x80 to 0x8F
      0, 1, 1, 1, 1, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x90 to 0x9F
      1, 1, 0, 0, 0, 0, 0, 0,   0, 0, 0, 1, 0, 0, 0, 0,    // 0xA0 to 0xAF
      1, 0, 0, 0, 0, 0, 0, 0,   1, 0, 0, 1, 0, 0, 0, 1,    // 0xB0 to 0xBF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xC0 to 0xCF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xD0 to 0xDF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xE0 to 0xEF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be lowercase
// (Note: assumes that data files use ASCII or the ANSI superset thereof!)
const unsigned char FramepaC_islower_table[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  @ to O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  P to _
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  ` to o
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  p to DEL
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0x80 to 0x8F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 1, 0, 1, 0, 0, 0,    // 0x90 to 0x9F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xA0 to 0xAF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 1, 0, 0, 0, 0, 1, 0,    // 0xB0 to 0xBF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xC0 to 0xCF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xD0 to 0xDF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xE0 to 0xEF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xF0 to 0xFF
   } ;

// list the characters which we consider to be uppercase
// (Note: assumes that data files use ASCII or the ANSI superset thereof!)
const unsigned char FramepaC_isupper_table[] =
   {
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^@ to ^O
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // ^P to ^_
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // SP to /
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  0 to ?
      0, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    //  @ to O
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 0, 0, 0, 0, 0,    //  P to _
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  ` to o
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    //  p to DEL
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 1, 0, 1, 0, 0, 0,    // 0x80 to 0x8F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 1,    // 0x90 to 0x9F
      0, 0, 0, 0, 0, 0, 0, 0,   0, 1, 0, 0, 0, 0, 1, 0,    // 0xA0 to 0xAF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xB0 to 0xBF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xC0 to 0xCF
      1, 1, 1, 1, 1, 1, 1, 1,   1, 1, 1, 1, 1, 1, 1, 1,    // 0xD0 to 0xDF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xE0 to 0xEF
      0, 0, 0, 0, 0, 0, 0, 0,   0, 0, 0, 0, 0, 0, 0, 0,    // 0xF0 to 0xFF
   } ;

// list the mapping from arbitrary characters to their uppercase equivalents
// this table must match the actual character codes used by the input
// data; currently using the ANSI character set
//
const unsigned char FramepaC_toupper_table[] =
   {
       0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, // ^@-^O
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, // ^P-^_
      32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, // SP- /
      48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, // 0 - ?
      64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, // @ - O
      80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, // P - _
      96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, // ` - o
      80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,123,124,125,126,127, // p -DEL
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,138,155,140,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     176,177,178,179,180,181,182,183,184,169,186,187,188,189,174,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207, // uc acc
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207, // lc acc
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,159,
   } ;

// list the mapping from arbitrary characters to their lowercase equivalents
// this table must match the actual character codes used by the input
// data; currently using the ANSI character set
//
const unsigned char FramepaC_tolower_table[] =
   {
       0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, // ^@-^O
      16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, // ^P-^_
      32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, // SP- /
      48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, // 0 - ?
      64, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111, // @ - O
     112,113,114,115,116,117,118,119,120,121,122, 91, 92, 93, 94, 95, // P - _
      64, 97, 98, 99,100,101,102,103,104,105,106,107,108,109,110,111, // ` - o
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127, // p -DEL
     128,129,130,131,132,133,134,135,136,137,154,139,156,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,255,
     160,161,162,163,164,165,166,167,168,185,170,171,172,173,190,175,
     176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239, // uc acc
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239, // lc acc
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
   } ;

//----------------------------------------------------------------------

int Fr_stricmp(const char *s1, const char *s2)
{
   int diff = 0 ;
   while ((diff = (Fr_toupper(*s1) - Fr_toupper(*s2))) == 0 && *s1 && *s2)
      {
      s1++ ;
      s2++ ;
      }
   return diff ;
}

//----------------------------------------------------------------------

int Fr_stricmp(const char *s1, const char *s2, const unsigned char *map)
{
   int diff = 0 ;
   while ((diff = map[(unsigned char)*s1] - map[(unsigned char)*s2]) == 0 &&
	  *s1)
      {
      s1++ ;
      s2++ ;
      }
   return diff ;
}


// end of file frctype.cpp //
