;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File TSKNEW.ASM		Start a new thread of execution		*
;*									*
;************************************************************************
;LastEdit: 1/13/93

	INCLUDE API.INC
	MIN_VERSION 2,00

	Header@

TITLE_SIZE equ 32			; longest title to be read from parent
MIN_STACK  equ 256

;========================================================================

DSeg@
task_busy db 0

DSegEnd@

;========================================================================

BSeg@
free_stack db	?
switchmenu dw	?
stack_size dw	?
user_stack dd	?
IF LPROG
start_addr dd	?
ELSE
start_addr dw	?
ENDIF
BSegEnd@

;========================================================================

CSeg@

ExtProc@ DVWIN_TOP,__PASCAL__
ExtProc@ DVWIN_TOPSYS,__PASCAL__
ExtProc@ DVWIN_MOVE,__PASCAL__
ExtProc@ DVWIN_REDRAW,__PASCAL__
ExtProc@ DVQRY_SIZE,__PASCAL__
ExtProc@ DVQRY_TITLE,__PASCAL__

extrn $DVG$STRLEN:near

;------------------------------------------------------------------------
; entry: AX=BX=SI=DI=BP=0000h
;	 DX:CX = parent handle
;	 ES:DI = our handle
;	 SS:SP = task's private stack
;	 DS -> task's private stack
task_start proc far
; local variables
@parent = word ptr [bp-2]
@freestack = byte ptr [bp-3]
; [bp-4] unused
@stackbot = word ptr [bp-6]
	ASSUME	DS:NOTHING,ES:NOTHING,SS:NOTHING
	MOV_AX_DGROUP
	mov	ds,ax			; restore DS to our data segment
	ASSUME	DS:DGROUP
	LSS_	sp,user_stack		; switch to user's stack
	DV_OSTACK			; initialize DESQview's knowledge of
	DV_USTACK			;   the user's stack
	mov	ax,sp			; store stack pointer for later use
	mov	bp,sp			; set up stack frame
	push	dx			; @parent <- DX
	sub	sp,6			; local variables
	sub	ax,word ptr stack_size	; calculate start of stack area
	mov	@stackbot,ax
	mov	al,free_stack
	mov	@freestack,al
	cmp	switchmenu,0
	jz	go_start_task
	pushm	es,di			; window handle for new task
	call	DVWIN_TOPSYS@
go_start_task:
IF LPROG
	mov	dx,word ptr start_addr+2
ENDIF
	mov	cx,word ptr start_addr
	mov	task_busy,0		; finally done with static variables
	push	@parent			; pass parent's handle to child task
	CALL_REG dx,cx			; invoke actual start of task
IF LDATA
	mov	dx,ss
ENDIF
	mov	cx,@stackbot
	cmp	@freestack,0
	jz	kill_task
	FREE_MEM dx,cx
kill_task:
	mov	ah,12h
	mov	bx,0201h		; kill calling task
	int	15h
	int	20h			; just in case....
task_start endp

;------------------------------------------------------------------------

PubProc@ DVTASK_NEW,__PASCAL__
@parent = dword ptr [bp+SendOverhead+16+cPtrSize+dPtrSize]
@title = DPTR_ [bp+SendOverhead+16+cPtrSize]
@row = word ptr [bp+SendOverhead+14+cPtrSize]
@col = word ptr [bp+SendOverhead+12+cPtrSize]
@rows = word ptr [bp+SendOverhead+10+cPtrSize]
@cols = word ptr [bp+SendOverhead+8+cPtrSize]
@stack = dword ptr [bp+SendOverhead+4+cPtrSize]
@stacksize = word ptr [bp+SendOverhead+2+cPtrSize]
@startaddr = CPTR_ [bp+SendOverhead+2]
@switchmenu = word ptr [bp+SendOverhead]
; local variables
@i = word ptr [bp-2]
@old_title = byte ptr [bp-2-TITLE_SIZE]
	@EnterSend 2+TITLE_SIZE
	SERIALIZE task_busy
	COPYCPTR start_addr,@startaddr,ax
	mov	ax,@switchmenu
	mov	switchmenu,ax
	xor	ax,ax
	mov	free_stack,al
	mov	stack_size,ax
	mov	ax,word ptr @stack
	mov	dx,word ptr @stack+2
	mov	bx,ax
	or	bx,dx
	jnz	have_stack
	inc	free_stack		; free_stack <- TRUE
	mov	ax,@stacksize
	cmp	ax,MIN_STACK
	jae	stacksize_ok
	mov	ax,MIN_STACK
stacksize_ok:
	mov	stack_size,ax
	ALLOC_MEM			; allocate AX bytes
IF LDATA eq 0
	mov	dx,ds
ENDIF
	DPTR_NULL dx,ax,bx
	jnz	allocated_stack
IF LDATA eq 0
	xor	dx,dx
ENDIF
	jmp	task_new_exit

allocated_stack:
	add	ax,stack_size		; point at end of allocated memory
have_stack:
	mov	word ptr user_stack,ax
	mov	word ptr user_stack+2,dx
	LOADDPTR dx,ax,@title
	DPTR_NULL dx,ax,bx
	jz	no_title
IF LDATA eq 0
	mov	dx,ds
ENDIF
	pushm	dx,ax			; parm #0 = title
	call	$DVG$STRLEN		; get length of title
	jmp short title_set
no_title:
	PUSHMEM32 @parent
	lea	ax,@old_title
	PUSHDPTR ss,ax
	mov	ax,TITLE_SIZE
	push	ax
	call	DVQRY_TITLE@
	lea	ax,@old_title
	pushm	ss,ax			; parm #0 = title
	mov	bx,ax
	add	bx,TITLE_SIZE-2		; (last char in buffer = 00h)
scan_title_loop:
	cmp	byte ptr SS_[bx],' '
	jne	found_title_end
	dec	bx
	cmp	bx,ax
	ja	scan_title_loop
found_title_end:
	inc	bx			; went one too far
	sub	bx,ax			; BX <- length
	mov	ax,bx			; need length in AX
title_set:
	xor	bx,bx
	pushm	bx,ax			; parm #1 = length of title
	cmp	@rows,0
	jae	rows_ok
	PUSHMEM32 @parent
	lea	ax,@rows
	PUSHDPTR ss,ax
	lea	ax,@i
	PUSHDPTR ss,ax
	call	DVQRY_SIZE@
rows_ok:
	cmp	@cols,0
	jae	cols_ok
	PUSHMEM32 @parent
	lea	ax,@i
	PUSHDPTR ss,ax
	lea	ax,@cols
	PUSHDPTR ss,ax
	call	DVQRY_SIZE@
cols_ok:
	xor	ax,ax
	pushm	ax,@rows		; parm #2
	pushm	ax,@cols		; parm #3
	pushm	ax,ax			; parm #4, no addt'l allocation
	dec	ax
	pushm	ax,ax			; parm #5 (-1), use def task stack size
	pushm	ax,ax			; parm #6 (-1), task window
	mov	ax,offset __TEXT:task_start
	pushm	cs,ax			; parm #7
	xor	di,di
	mov	es,di
	SEND_N	NEW_MSG,WINDOW_CLASS,WINDOW_CLASS
	jc	task_new_exit
	popm	di,es			; get task handle into ES:DI
	;
	; wait until child task is up and running
	;
switch_wait:
	cmp	task_busy,0
	jz	set_switch_menu
	mov	ax,1000h		; give up time slice
	int	15h
	jmp	switch_wait
set_switch_menu:
	cmp	@switchmenu,0
	jnz	task_new_done
	pushm	es,di
	call	DVWIN_TOP@
task_new_done:
	pushm	es,di			; window handle for new task
	push	@row
	push	@col
	call	DVWIN_MOVE@
	pushm	es,di
	call	DVWIN_REDRAW@
	mov	ax,di
	mov	dx,es
task_new_exit:
	@ExitSend 20+cPtrSize+dPtrSize
EndProc@ DVTASK_NEW,__PASCAL__

CSegEnd@

	END
