;************************************************************************
;*									*
;*	DV-GLUE		DESQview and DESQview/X Function Library	*
;*			(c) Copyright 1993 Ralf Brown			*
;*			All Rights Reserved.				*
;*									*
;*	File QEMMPORT.ASM	I/O port manipulation via QEMM API	*
;*									*
;************************************************************************
;LastEdit: 1/15/93

	INCLUDE	API.INC
	Header@

.386

;========================================================================

CSeg@

extrn $DVG$QEMMCALL:near

;------------------------------------------------------------------------

PubProc@ QEMMINPORTB,__PASCAL__
@port = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	ax,1A00h
	mov	dx,@port
	call	$DVG$QEMMCALL
	jc	inport_error
	mov	ah,0			; zero-extend to 16 bits
	pop	bp
	ret	2
EndProc@ QEMMINPORTB,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMINPORTW,__PASCAL__
@port = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	ax,1A01h
	mov	dx,@port
	call	$DVG$QEMMCALL
	jc	inport_error
inport_done:
	pop	bp
	ret	2

inport_error:
	mov	ax,-1
	jmp	inport_done
EndProc@ QEMMINPORTW,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMOUTPORTB,__PASCAL__
@port = word ptr [bp+4+cPtrSize]
@val = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	bl,byte ptr @val
	mov	al,2
	jmp short outport$
EndProc@ QEMMOUTPORTB,__PASCAL__

;------------------------------------------------------------------------

PubProc@ QEMMOUTPORTW,__PASCAL__
@port = word ptr [bp+4+cPtrSize]
@val = word ptr [bp+2+cPtrSize]
	push	bp
	mov	bp,sp
	mov	bx,@val
	xchg	bh,bl			; BH is output to lower-numbered port
	mov	al,3
outport$:
	mov	ah,1Ah
	mov	dx,@port
	call	$DVG$QEMMCALL
	mov	ax,0
	jc	outport_done
	inc	ax			; AX<-1, indicates success
outport_done:
	pop	bp
	ret	4
EndProc@ QEMMOUTPORTW,__PASCAL__

;------------------------------------------------------------------------

CSegEnd@

	END
