/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;

public class DataTaskDefinition
extends DataComponent
implements DataValidateCode,
RunOnSubcomponentInterface {
    public static final int TASK_WITHOUT_BODY = 1;
    public static final int TASK_AFTER_OPEN_PAREN = 2001;
    public static final int TASK_TASK = 0;
    public static final int GOAL_TASK = 1;
    public static final int COMMAND_TASK = 2;
    public static final int MONITOR_TASK = 3;
    public static final int EXCEPTION_TASK = 4;
    public static final int HANDLER_TASK = 5;
    public static final int RESUME_TASK = 6;
    public static final int DEFAULT_TASK = 0;
    public static final int INVALID_TASK = -1;
    public static final String EXTERN = "extern";
    public static final String PERSISTENT = "PERSISTENT";
    public static final String DISTRIBUTED = "DISTRIBUTED";
    public static final String THREADED = "THREADED";
    public static final String TASK_TYPE_INDEX = "TaskType";
    public static final String TASK_NAME_INDEX = "TaskName";
    public static final String OPEN_PAREN = "(";
    public static final String CLOSE_PAREN = ")";
    public static final String COMMA = ",";
    public static final String SEMICOLON = ";";
    public static final String WITH = "WITH";
    public static final String COLON = ":";
    public static final String HANDLES = "HANDLES";
    public static final String HANDLES_INDEX = "HandlesIndex";
    public static final String HANDLES_COMMA_INDEX = "HandlesCommaIndex";
    public static final String TASK_BODY_INDEX = "TaskBodyIndex";
    protected static final String[][] TASK_TYPES = new String[][]{{"Task"}, {"Goal"}, {"Command"}, {"Monitor"}, {"Exception"}, {"Exception", "Handler"}, {"Resume"}};
    protected static final int[][] VALID_CONSTRAINTS = new int[][]{new int[0], {0, 1, 22, 23, 24}, {0, 1, 22, 23, 24}, {0, 1, 3, 4, 5, 19, 20, 21, 22, 23, 24}, {24}, {19, 24}, new int[0]};
    protected static final boolean[] VALID_PERSISTENT_TASKS = new boolean[]{false, true, true, true, false, false, false};
    protected static final boolean[] VALID_DISTRIBUTED_TASKS = new boolean[]{false, true, true, true, false, false, false};
    protected static final boolean[] VALID_THREADED_TASKS = new boolean[]{false, true, true, true, false, false, false};
    protected static Registry taskRegistry = new Registry(true);
    protected DataVector taskLeads = new DataVector(3);
    protected int taskType;
    protected String taskName;
    protected DataVector taskArguments;
    protected DataVector persistentTaskDeclarations;
    protected DataVector constraints;
    protected boolean hasWithKeyword;
    protected DataCompoundStatement taskBody;
    protected DataSpawnTask exceptionBaseTask;
    protected String handlesException;
    protected DataVector resumeTasksVector;
    protected DataTaskDefinition resumeMasterTask;
    protected DataVector statementsVector;
    protected DataVector __nonUniqueNamesVector;
    protected DataHashtable __onAgentHashtable;
    protected DataVector __taskRefsInWiths;
    protected DataHashtable __labelHashtable;
    protected DataHashtable __spawnHashtable;
    protected DataHashtable __withsToComponents;
    protected String uniqueIdString;

    protected static Registry getTaskRegistry() {
        return taskRegistry;
    }

    public static boolean unregisterTask(DataTaskDefinition dataTaskDefinition) {
        String string = dataTaskDefinition.getTaskName();
        if (DataTaskDefinition.getTaskRegistry().getIsObjectRegistered(dataTaskDefinition) && !DataTaskDefinition.getTaskRegistry().unregister(dataTaskDefinition)) {
            System.err.println("[DataTaskDefinition:unregisterTask] Warning:  Task was unregistered...  (\"" + string + "\")");
            return false;
        }
        return true;
    }

    public static boolean registerTask(DataTaskDefinition dataTaskDefinition, boolean bl) throws DetailedParseException {
        String string = dataTaskDefinition.getTaskName();
        if (DataComponent.isEmptyString(string)) {
            return true;
        }
        if (DataTaskDefinition.getFirstTaskForName(string) != null && (DataTaskDefinition.getFirstTaskForName(string).getTaskType() == 4 || dataTaskDefinition.getTaskType() == 4)) {
            String string2 = dataTaskDefinition.getMessageFilenameLead() + dataTaskDefinition.getLineNumberString() + ":  [DataTaskDefinition:registerTask] Warning:  " + "Task Registration Failure:  " + "Task \"" + string + "\" is both overloaded and of type " + "\"Exception\".  Overloading is not permitted for " + "\"Exception\" tasks.  " + "Please choose another name for this task.";
            if (bl) {
                throw new DetailedParseException(string2);
            }
            System.err.println(string2);
            return false;
        }
        if (DataTaskDefinition.getFirstTaskForName(string) != null && DataTaskDefinition.getFirstTaskForName(string).getTaskType() != dataTaskDefinition.getTaskType()) {
            String string3 = dataTaskDefinition.getMessageFilenameLead() + dataTaskDefinition.getLineNumberString() + ":  [DataTaskDefinition:registerTask] Warning:  " + "Task Registration Failure:  " + "Task \"" + string + "\" is of type \"" + dataTaskDefinition.getTaskTypeString() + "\".  Task \"" + string + "\" is overloaded, and was previously declared (registered) under " + "type \"" + DataTaskDefinition.getFirstTaskForName(string).getTaskTypeString() + "\".  These Task-Types are supposed to be the same, as one of " + "these Tasks will wind up being allocated with the other's " + "Task-Type, creating issues with constraint satisfaction.  " + "Please choose another name for this task, " + "or make both of them the same Task-Type.";
            if (bl) {
                throw new DetailedParseException(string3);
            }
            System.err.println(string3);
            return false;
        }
        if (DataTaskDefinition.getFirstTaskForName(string) != null && DataTaskDefinition.getFirstTaskForName(string).getIsDistributed() != dataTaskDefinition.getIsDistributed()) {
            String string4 = dataTaskDefinition.getMessageFilenameLead() + dataTaskDefinition.getLineNumberString() + ":  [DataTaskDefinition:registerTask] Warning:  " + "Task Registration Failure:  " + "Task \"" + string + "\" is \"" + (dataTaskDefinition.getIsDistributed() ? "" : "NON-") + "DISTRIBUTED\".  Task \"" + string + "\" is overloaded, and was previously declared (registered) as \"" + (DataTaskDefinition.getFirstTaskForName(string).getIsDistributed() ? "" : "NON-") + "DISTRIBUTED\".  This DISTRIBUTED nature must be the " + "same between overloaded tasks, as one of these Tasks will wind " + "up being allocated with the other's DISTRIBUTED/NON-DISTRIBUTED " + "allocation function, with the associated problems.  " + "Please choose another name for this task, make both of them " + "\"DISTRIBUTED\", or make both of them \"NON-DISTRIBUTED\".";
            if (bl) {
                throw new DetailedParseException(string4);
            }
            System.err.println(string4);
            return false;
        }
        if (!DataTaskDefinition.getTaskRegistry().register(string, dataTaskDefinition)) {
            System.err.println("[DataTaskDefinition:registerTask] Warning:  Task registration failed..  (\"" + string + "\")");
            return false;
        }
        return true;
    }

    public static DataVector getTasksForName(String string) {
        return DataTaskDefinition.getTaskRegistry().getObjectsForName(string);
    }

    public static DataTaskDefinition getFirstTaskForName(String string) {
        return (DataTaskDefinition)DataTaskDefinition.getTaskRegistry().getFirstObjectForName(string);
    }

    public static int getNumberOfTasksForName(String string) {
        return DataTaskDefinition.getTaskRegistry().getNumberOfObjectsForName(string);
    }

    public static boolean getIsTaskRegistered(DataTaskDefinition dataTaskDefinition) {
        return DataTaskDefinition.getTaskRegistry().getIsObjectRegistered(dataTaskDefinition);
    }

    public static Enumeration getRegisteredTasks() {
        return DataTaskDefinition.getTaskRegistry().getObjects();
    }

    public static String getTaskTypeString(int n) {
        if (n < 0 || n > TASK_TYPES.length) {
            throw new CompilationException("[DataTaskDefiniton:getTaskTypeString]  Error:  Invalid Task-Type (" + n + CLOSE_PAREN);
        }
        String[] stringArray = TASK_TYPES[n];
        String string = stringArray[0];
        int n2 = 1;
        while (n2 < stringArray.length) {
            string = string + " " + stringArray[n2];
            ++n2;
        }
        return string;
    }

    public DataTaskDefinition() {
        this(false, 0, "");
    }

    public DataTaskDefinition(boolean bl, int n, String string) {
        this.setIsExtern(bl);
        this.setTaskType(n);
        this.taskName = "";
        try {
            this.setTaskName(string);
        }
        catch (DetailedParseException detailedParseException) {
            System.err.println("[DataTaskDefinition:DataTaskDefinition]  Warning:  theTaskName is not parseable.  \"" + string + "\"  --  " + detailedParseException.toString());
        }
        this.taskArguments = new DataVector();
        this.persistentTaskDeclarations = new DataVector();
        this.constraints = new DataVector();
        this.hasWithKeyword = false;
        this.taskBody = null;
        this.exceptionBaseTask = null;
        this.handlesException = null;
        this.resumeTasksVector = new DataVector();
        this.resumeMasterTask = null;
        this.statementsVector = new DataVector();
        this.__nonUniqueNamesVector = new DataVector();
        this.__onAgentHashtable = new DataHashtable();
        this.__taskRefsInWiths = new DataVector();
        this.__labelHashtable = new DataHashtable();
        this.__spawnHashtable = new DataHashtable();
        this.__withsToComponents = new DataHashtable();
        this.uniqueIdString = this.getUniqueIdentifierString("_");
    }

    public boolean registerTask(String string, boolean bl) throws DetailedParseException {
        if (!DataTaskDefinition.registerTask(this, bl)) {
            System.err.println("[DataTaskDefinition:registerTask] --  [\"" + string + "\"] --  " + "Error:  New Registration of task has failed. (\"" + this.getTaskName() + "\").");
            return false;
        }
        return true;
    }

    public boolean unregisterTask(String string) {
        if (!DataTaskDefinition.unregisterTask(this)) {
            System.err.println("[DataTaskDefinition:unregisterTask] --  [\"" + string + "\"] --  " + "Warning:  unregistration of task has failed.  (\"" + this.getTaskName() + "\").");
            return false;
        }
        return true;
    }

    public boolean getIsTaskRegistered() {
        return DataTaskDefinition.getIsTaskRegistered(this);
    }

    protected DataVector getTaskLeads() {
        return this.taskLeads;
    }

    public boolean getIsExtern() {
        return this.getTaskLeads().contains(EXTERN);
    }

    public boolean getIsPersistent() {
        return this.getTaskLeads().contains(PERSISTENT);
    }

    public boolean getIsDistributed() {
        return this.getTaskLeads().contains(DISTRIBUTED);
    }

    public boolean getIsThreaded() {
        return this.getTaskLeads().contains(THREADED);
    }

    public boolean isValidTaskLead(Object object) {
        return object instanceof String && (object.equals(EXTERN) || object.equals(PERSISTENT) || object.equals(DISTRIBUTED) || object.equals(THREADED));
    }

    public int getFirstValidTaskLeadIndex() {
        int n = 0;
        while (n < this.getTaskLeads().size()) {
            if (this.isValidTaskLead(this.getTaskLeads().elementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getNextValidTaskLeadIndex(int n) {
        int n2 = n + 1;
        while (n2 < this.getTaskLeads().size()) {
            if (this.isValidTaskLead(this.getTaskLeads().elementAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean hasTaskLeads() {
        return this.getFirstValidTaskLeadIndex() != -1;
    }

    public boolean addExternKeywordToTaskLeadsOrder() {
        if (this.getIsExtern()) {
            return false;
        }
        this.getTaskLeads().addElement(EXTERN);
        return true;
    }

    public boolean addPersistentKeywordToTaskLeadsOrder() {
        if (this.getIsPersistent()) {
            return false;
        }
        this.getTaskLeads().addElement(PERSISTENT);
        return true;
    }

    public boolean addDistributedKeywordToTaskLeadsOrder() {
        if (this.getIsDistributed()) {
            return false;
        }
        this.getTaskLeads().addElement(DISTRIBUTED);
        return true;
    }

    public boolean addThreadedKeywordToTaskLeadsOrder() {
        if (this.getIsThreaded()) {
            return false;
        }
        this.getTaskLeads().addElement(THREADED);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void setIsExtern(boolean var1_1) {
        block3: {
            if (!var1_1) ** GOTO lbl8
            if (this.getIsExtern()) break block3;
            this.addExternKeywordToTaskLeadsOrder();
            break block3;
lbl-1000:
            // 1 sources

            {
                this.getTaskLeads().removeElement("extern");
lbl8:
                // 2 sources

                ** while (this.getIsExtern())
            }
        }
    }

    public void writeDistributedMacroRequirements(DataDestination dataDestination) {
        DataTaskArgument.writeDistributedMacroRequirements(dataDestination, this.getTaskArguments(), true);
    }

    public String getDistributedTaskFormatString(int n) throws CompilationException {
        if (!this.getIsDistributed()) {
            System.err.println("[DataTaskDefinition:getDistributedTaskFormat()]  Internal Error:  Invoked on non-distributed Task.");
            return null;
        }
        DataConstraint dataConstraint = this.findConstraint(24);
        if (dataConstraint != null) {
            return dataConstraint.getDistributedFormatStringExpression().toString(n);
        }
        return DataTaskArgument.getDistributedFormatString(this.getTaskArguments(), this, "task \"" + this.getTaskName() + "\"", "\"{\"", "\"}\"");
    }

    public int getTaskType() {
        return this.taskType;
    }

    public void setTaskType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6) {
            System.err.println("[DataTaskDefinition:setTaskType]  Error:  Invalid Task Type (" + n + ").  Assuming default.");
            this.taskType = 0;
        } else {
            this.taskType = n;
        }
        this.validateAllConstraints(true, true);
    }

    public String[] getTaskTypeStrings() {
        return TASK_TYPES[this.getTaskType()];
    }

    public String getTaskTypeString() {
        return DataTaskDefinition.getTaskTypeString(this.getTaskType());
    }

    public String getTaskName() {
        return this.taskName;
    }

    protected void setTaskNameWithoutParsingOrRegistration(String string) {
        if (DataComponent.isEmptyString(string)) {
            string = "";
        }
        this.unregisterTask("setTaskNameWithoutParsingOrRegistration");
        this.taskName = string;
    }

    protected boolean setTaskNameWithoutParsing(String string) throws DetailedParseException {
        String string2 = this.getTaskName();
        if (DataComponent.isEmptyString(string)) {
            string = "";
        }
        this.setTaskNameWithoutParsingOrRegistration(string);
        if (!this.registerTask("setTaskNameWithoutParsing", false)) {
            System.err.println("[DataTaskDefinition:setTaskNameWithoutParsing]  Warning:  Trying to restore old task name. [\"" + string2 + "\"]  (And then failing...)");
            this.setTaskNameWithoutParsingOrRegistration(string2);
            if (!this.registerTask("setTaskNameWithoutParsing", false)) {
                System.err.println("[DataTaskDefinition:setTaskNameWithoutParsing]  Warning:  Attempt to re-register under restored task name (\"" + this.getTaskName() + "\") has failed...  Failure is complete...");
            }
            return false;
        }
        return true;
    }

    public boolean setTaskName(String string) throws DetailedParseException {
        if (this.getTaskName().equals(string)) {
            return true;
        }
        if (DataComponent.isEmptyString(string)) {
            return this.setTaskNameWithoutParsing("");
        }
        TDLParser.reinitParser(string);
        try {
            TDLParser.getParser();
            return this.setTaskNameWithoutParsing(TDLParser.parseTaskName(null).image);
        }
        catch (Throwable throwable) {
            DataComponent.didParseOfSubpartFail(throwable);
            return false;
        }
    }

    protected DataVector getConstraints() {
        return this.constraints;
    }

    protected int getConstraintsCount() {
        return this.getConstraints().count();
    }

    protected DataConstraint getConstraint(int n) {
        if (n < 0 || n >= this.getConstraintsCount()) {
            System.err.println("[DataTaskDefinition:getConstraint]  Warning:  Invalid index (" + n + ").  [" + this.getConstraints().count() + "]");
            return null;
        }
        return (DataConstraint)this.getConstraints().elementAt(n);
    }

    protected int findConstraintIndex(int n) {
        int n2 = this.getConstraintsCount() - 1;
        while (n2 >= 0) {
            if (this.getConstraint(n2).getConstraintType() == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    protected DataConstraint findConstraint(int n) {
        int n2 = this.findConstraintIndex(n);
        if (n2 != -1) {
            return this.getConstraint(n2);
        }
        return null;
    }

    protected boolean getHasConstraint(int n) {
        return this.findConstraintIndex(n) != -1;
    }

    public boolean isValidConstraintType(int n) {
        int[] nArray = VALID_CONSTRAINTS[this.getTaskType()];
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean validateAllConstraints(boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (this.getConstraints() == null) {
            return bl3;
        }
        int n = 0;
        while (n < this.getConstraintsCount()) {
            if (!this.isValidConstraintType(this.getConstraint(n).getConstraintType())) {
                bl3 = false;
                if (bl2) {
                    System.err.println("[DataTaskDefinition:validateAllConstraints]  Warning:  Invalid Constraint-Type ( " + this.getConstraint(n).getConstraintType() + " ).");
                }
                if (bl) {
                    this.removeConstraint(n);
                    --n;
                }
            }
            ++n;
        }
        return bl3;
    }

    public void addConstraint(DataConstraint dataConstraint) {
        if (this.isValidConstraintType(dataConstraint.getConstraintType())) {
            dataConstraint.setParent(this);
            this.getConstraints().addElement(dataConstraint);
        } else {
            System.err.println("[DataTaskDefinition:addConstraint]  Warning:  Invalid Constraint-Type ( " + dataConstraint.getConstraintType() + " ).");
        }
    }

    public DataConstraint removeConstraint(int n) {
        if (n >= 0 && n < this.getConstraintsCount()) {
            DataConstraint dataConstraint = (DataConstraint)this.getConstraints().removeElementAt(n);
            dataConstraint.setParent(null);
            return dataConstraint;
        }
        System.err.println("[DataTaskDefinition:removeConstraint]  Warning:  Invalid theIndex ( " + n + " ).");
        return null;
    }

    protected DataVector getTaskArguments() {
        return this.taskArguments;
    }

    public int getTaskArgumentCount() {
        return this.getTaskArguments().count();
    }

    public DataTaskArgument getTaskArgument(int n) {
        if (n >= 0 && n < this.getTaskArgumentCount()) {
            return (DataTaskArgument)this.getTaskArguments().elementAt(n);
        }
        System.err.println("[DataTaskDefinition:getTaskArgument]  Warning:  Invalid theIndex ( " + n + " ).");
        return null;
    }

    public void addTaskArgument(DataTaskArgument dataTaskArgument) {
        dataTaskArgument.setParent(this);
        this.getTaskArguments().addElement(dataTaskArgument);
    }

    public DataTaskArgument removeTaskArgument(int n) {
        if (n >= 0 && n < this.getTaskArgumentCount()) {
            DataTaskArgument dataTaskArgument = (DataTaskArgument)this.getTaskArguments().removeElementAt(n);
            dataTaskArgument.setParent(null);
            return dataTaskArgument;
        }
        System.err.println("[DataTaskDefinition:removeTaskArgument]  Warning:  Invalid theIndex ( " + n + " ).");
        return null;
    }

    protected DataVector getPersistentTaskDeclarations() {
        return this.persistentTaskDeclarations;
    }

    public int getPersistentTaskDeclarationCount() {
        return this.getPersistentTaskDeclarations().count();
    }

    public DataTaskArgument getPersistentTaskDeclaration(int n) {
        if (n >= 0 && n < this.getPersistentTaskDeclarationCount()) {
            return (DataTaskArgument)this.getPersistentTaskDeclarations().elementAt(n);
        }
        System.err.println("[DataTaskDefinition:getPersistentTaskDeclaration]  Warning:  Invalid theIndex ( " + n + " ).");
        return null;
    }

    public void addPersistentTaskDeclaration(DataTaskArgument dataTaskArgument) {
        dataTaskArgument.setParent(this);
        this.getPersistentTaskDeclarations().addElement(dataTaskArgument);
    }

    public DataTaskArgument removePersistentTaskDeclaration(int n) {
        if (n >= 0 && n < this.getPersistentTaskDeclarationCount()) {
            DataTaskArgument dataTaskArgument = (DataTaskArgument)this.getPersistentTaskDeclarations().removeElementAt(n);
            dataTaskArgument.setParent(null);
            return dataTaskArgument;
        }
        System.err.println("[DataTaskDefinition:removePersistentTaskDeclaration]  Warning:  Invalid theIndex ( " + n + " ).");
        return null;
    }

    public boolean getHasWithKeyword() {
        return this.hasWithKeyword;
    }

    public void setHasWithKeyword(boolean bl) {
        this.hasWithKeyword = bl;
    }

    public DataCompoundStatement getTaskBody() {
        return this.taskBody;
    }

    public void setTaskBody(DataCompoundStatement dataCompoundStatement) {
        if (this.taskBody != null) {
            this.taskBody.setParent(null);
        }
        this.taskBody = dataCompoundStatement;
        if (this.taskBody != null) {
            this.taskBody.setParent(this);
        }
    }

    public DataSpawnTask getExceptionBaseTask() {
        return this.exceptionBaseTask;
    }

    public boolean setExceptionBaseTask(DataSpawnTask dataSpawnTask) {
        if (dataSpawnTask != null && dataSpawnTask.getTaskName() != null && dataSpawnTask.getTaskName().length() > 0 && dataSpawnTask.getConstraintCount() == 0 || dataSpawnTask == null) {
            this.exceptionBaseTask = dataSpawnTask;
            return true;
        }
        System.err.println("[DataTaskDefinition:setExceptionBaseTask]  Error: Bad object for theExceptionBaseTask:  " + dataSpawnTask.toString());
        return false;
    }

    public String getHandlesException() {
        return this.handlesException;
    }

    public void setHandlesException(String string) {
        this.handlesException = string;
    }

    public DataVector getResumeTasksVector() {
        return this.resumeTasksVector;
    }

    public DataTaskDefinition getResumeTask(int n) {
        if (n >= 0 && n < this.getResumeTasksVector().count()) {
            return (DataTaskDefinition)this.getResumeTasksVector().elementAt(n);
        }
        System.err.println("[DataTaskDefinition:getResumeTask]  Error: Bad resume-task index value (" + n + CLOSE_PAREN);
        return null;
    }

    public void clearResumeTasksVector() {
        this.getResumeTasksVector().removeAllElements();
    }

    public void addResumeTask(DataTaskDefinition dataTaskDefinition) {
        this.getResumeTasksVector().addElement(dataTaskDefinition);
    }

    public DataTaskDefinition getResumeMasterTask() {
        return this.resumeMasterTask;
    }

    public void setResumeMasterTask(DataTaskDefinition dataTaskDefinition) {
        this.resumeMasterTask = dataTaskDefinition;
    }

    public String getUniqueIdString() {
        if (this.getTaskType() == 6) {
            if (this.getResumeMasterTask() != null) {
                return this.getResumeMasterTask().getUniqueIdString();
            }
            if (this.getIsExtern()) {
                return this.uniqueIdString;
            }
            throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ":  INTERNAL Error:  Resume task named \"" + this.getTaskName() + "\" has no corresponding registered counterpart.");
        }
        return this.uniqueIdString;
    }

    public void setUniqueIdString(String string) {
        this.uniqueIdString = string;
    }

    public boolean addPrimaryChild(DataComponent dataComponent, DataComponent dataComponent2) {
        if (this.getTaskBody() == null) {
            this.setTaskBody(new DataCompoundStatement(null));
        }
        return this.getTaskBody().addChild(dataComponent, dataComponent2);
    }

    public boolean removeChild(DataComponent dataComponent) {
        if (this.getTaskBody() == null) {
            System.err.println("[DataTaskDefinition:removeChild]  Warning:  No task body to remove child from...");
            return false;
        }
        return this.getTaskBody().removeChild(dataComponent);
    }

    public void validateExternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (this.getTaskType() == 5 && (this.getHandlesException() == null || this.getHandlesException().length() <= 0)) {
            dataValidateCodeReturnValue.addError(this).write("EXCEPTION HANDLER does not handle an exception.\n");
        }
        if (this.getIsPersistent() && !VALID_PERSISTENT_TASKS[this.getTaskType()]) {
            dataValidateCodeReturnValue.addError(this).write(this.getTaskTypeString()).write(" Tasks may NOT be PERSISTENT!\n");
        }
        if (this.getIsDistributed() && !VALID_DISTRIBUTED_TASKS[this.getTaskType()]) {
            dataValidateCodeReturnValue.addError(this).write(this.getTaskTypeString()).write(" Tasks may NOT be DISTRIBUTED!\n");
        }
        if (this.getIsThreaded() && !VALID_THREADED_TASKS[this.getTaskType()]) {
            dataValidateCodeReturnValue.addError(this).write(this.getTaskTypeString()).write(" Tasks may NOT be THREADED!\n");
        }
        this.validateTaskForCxxGeneration(n, dataValidateCodeReturnValue);
        DataStatement.validateAnyOverridenConstraints(this, dataValidateCodeReturnValue);
        if (this.getTaskBody() != null) {
            this.getTaskBody().validateInternalCode(n, dataValidateCodeReturnValue);
        }
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        throw new CompilationException("Internal Error:  DataTaskDefinition object may not exist inside a Task.");
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataTaskDefinition.TASK_WITHOUT_BODY (" + 1 + CLOSE_PAREN + " or DataComponent.HTML_DOCUMENTATION (" + 2000 + ") or DataTaskDefinition.TASK_AFTER_OPEN_PAREN (" + 2001 + CLOSE_PAREN;
    }

    public boolean isValidObjectSubset(int n) {
        return n == 1 || n == 2000 || n == 2001 || super.isValidObjectSubset(n);
    }

    public boolean isValid(int n) {
        if (DataComponent.isEmptyString(this.getTaskName())) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.getTaskArgumentCount()) {
            if (!this.getTaskArgument(n2).isValid()) {
                return false;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.getPersistentTaskDeclarationCount()) {
            if (!this.getPersistentTaskDeclaration(n2).isValid()) {
                return false;
            }
            ++n2;
        }
        if (n != 1 && this.getTaskBody() != null && !this.getTaskBody().isValid()) {
            return false;
        }
        if (this.getTaskType() == 5 && (this.getHandlesException() == null || this.getHandlesException().length() <= 0)) {
            return false;
        }
        return super.isValid(n);
    }

    public void generate(DataDestination dataDestination, int n) {
        int n2;
        int n3 = n;
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n == 2000) {
            this.generateHTML(dataDestination);
            return;
        }
        if (this.isCxxSubset(n)) {
            this.generateCxx(dataDestination, n);
            return;
        }
        if (n == 1 || n == 2001) {
            n3 = 0;
        }
        if (n == 2001) {
            this.initializeGenerateSubcomponentIndex(OPEN_PAREN);
        } else {
            this.initializeGenerateSubcomponentIndex();
            String string = dataDestination.getNewlineText();
            dataDestination.clearNewlineText();
            if (dataDestination.getEnableLineMacros()) {
                boolean bl = dataDestination.getIsStrippingLeadingWhitespace();
                dataDestination.setStripLeadingWhitespace(false);
                int n4 = this.countSubcomponentNewlines(TASK_NAME_INDEX, n, false);
                dataDestination.setUsingTdlFileName(true);
                dataDestination.makeNextLineNumber(this.getLineNumber() - n4);
                dataDestination.write("\n");
                dataDestination.setStripLeadingWhitespace(bl);
            }
            this.generateSubcomponents("DataComponentFirstTokenIndex", dataDestination, n3, false);
            n2 = this.getFirstValidTaskLeadIndex();
            if (n2 != -1) {
                this.generateSubcomponents((String)this.getTaskLeads().elementAt(n2), dataDestination, n3, false);
                if (!DataComponent.isEmptyString(string)) {
                    dataDestination.setNewlineText(string);
                    dataDestination.write(string);
                    string = null;
                }
                dataDestination.write((String)this.getTaskLeads().elementAt(n2));
                n2 = this.getNextValidTaskLeadIndex(n2);
                while (n2 != -1) {
                    this.generateSubcomponents((String)this.getTaskLeads().elementAt(n2), dataDestination, n3, false);
                    dataDestination.write((String)this.getTaskLeads().elementAt(n2));
                    n2 = this.getNextValidTaskLeadIndex(n2);
                }
            } else {
                this.generateSubcomponents(EXTERN, dataDestination, n3, false);
                this.generateSubcomponents(PERSISTENT, dataDestination, n3, false);
                this.generateSubcomponents(DISTRIBUTED, dataDestination, n3, false);
                this.generateSubcomponents(THREADED, dataDestination, n3, false);
            }
            String[] stringArray = this.getTaskTypeStrings();
            n2 = 0;
            while (n2 < stringArray.length) {
                this.generateSubcomponents(n2 + 1 < stringArray.length ? TASK_TYPE_INDEX + n2 : TASK_TYPE_INDEX, dataDestination, n3, false);
                if (!DataComponent.isEmptyString(string)) {
                    dataDestination.setNewlineText(string);
                    dataDestination.write(string);
                    string = null;
                }
                dataDestination.write(stringArray[n2]);
                ++n2;
            }
            this.generateSubcomponents(TASK_NAME_INDEX, dataDestination, n3, false);
            dataDestination.write(this.getTaskName());
            this.generateSubcomponents(OPEN_PAREN, dataDestination, n3, false);
            dataDestination.write(OPEN_PAREN);
        }
        n2 = 0;
        while (n2 < this.getTaskArgumentCount()) {
            this.getTaskArgument(n2).generate(dataDestination, n3);
            if (n2 + 1 < this.getTaskArgumentCount()) {
                dataDestination.write(COMMA);
            }
            ++n2;
        }
        this.generateSubcomponents(CLOSE_PAREN, dataDestination, n3, false);
        dataDestination.write(CLOSE_PAREN);
        if (this.getIsExtern()) {
            this.generateSubcomponents(SEMICOLON, dataDestination, n3, false);
            dataDestination.write(SEMICOLON);
        } else {
            if (this.getTaskType() == 4 && this.getExceptionBaseTask() != null) {
                this.generateSubcomponents(COLON, dataDestination, n3, false);
                dataDestination.write(COLON);
                this.getExceptionBaseTask().generate(dataDestination, 3);
            }
            if (this.getHasWithKeyword()) {
                this.generateSubcomponents(WITH, dataDestination, n3, false);
                dataDestination.write(WITH);
            }
            n2 = 0;
            while (n2 < this.getConstraintsCount()) {
                if (n2 > 0) {
                    dataDestination.write(COMMA);
                }
                this.getConstraint(n2).generate(dataDestination, n3);
                ++n2;
            }
            if (this.getTaskType() == 5) {
                if (this.getConstraintsCount() > 0) {
                    dataDestination.write(COMMA);
                }
                this.generateSubcomponents(HANDLES, dataDestination, n3, false);
                dataDestination.write(HANDLES);
                this.generateSubcomponents(HANDLES_INDEX, dataDestination, n3, false);
                dataDestination.write(this.getHandlesException());
            }
            n2 = 0;
            while (n2 < this.getPersistentTaskDeclarationCount()) {
                if (this.getConstraintsCount() > 0 || this.getTaskType() == 5 || n2 > 0) {
                    if (this.getTaskType() == 5 && n2 == 0) {
                        this.generateSubcomponents(HANDLES_COMMA_INDEX, dataDestination, n3, false);
                    }
                    dataDestination.write(COMMA);
                }
                this.getPersistentTaskDeclaration(n2).generate(dataDestination, n3);
                ++n2;
            }
            if (this.getTaskType() == 4) {
                this.generateSubcomponents(SEMICOLON, dataDestination, n3, false);
                dataDestination.write(SEMICOLON);
            } else if (n != 1 && n != 2001 && this.getTaskBody() != null) {
                this.generateSubcomponents(TASK_BODY_INDEX, dataDestination, n3, false);
                this.getTaskBody().generate(dataDestination, n);
            }
        }
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }

    public void generateHTML(DataDestination dataDestination) {
        int n = 0;
        DataComponent dataComponent = this.getParent();
        while (dataComponent != null && !(dataComponent instanceof DataFile)) {
            dataComponent = dataComponent.getParent();
        }
        dataDestination.write("\n<A NAME=\"");
        dataDestination.write(this.getTaskName());
        dataDestination.write("\">\n<PRE><H2><TT>");
        dataDestination.write(this.getTaskTypeString());
        dataDestination.write(" <A HREF=\"file:");
        if (dataComponent != null) {
            if (DataComponent.isEmptyString(((DataFile)dataComponent).getFilename())) {
                dataDestination.write("/**UNSPECIFIED**");
            } else {
                if (!((DataFile)dataComponent).getFilename().startsWith("/")) {
                    dataDestination.write("/");
                }
                dataDestination.write(((DataFile)dataComponent).getFilename());
            }
        } else {
            dataDestination.write("/**UNKNOWN**");
        }
        dataDestination.write("\">");
        dataDestination.write(this.getTaskName());
        dataDestination.write("</A> (");
        this.generate(dataDestination, 2001);
        dataDestination.write("</TT></H2></PRE></A>\n<DD><P>");
        n = this.hasTaskLeads() ? this.getIndex((String)this.getTaskLeads().elementAt(this.getFirstValidTaskLeadIndex())) : this.getIndex(TASK_TYPE_INDEX);
        --n;
        while (n >= 0) {
            if (this.isSubcomponentAString(n)) {
                String string = this.getStringSubcomponent(n);
                int n2 = string.length();
                int n3 = -1;
                while (n2 != -1 && n3 == -1) {
                    if ((n2 = string.lastIndexOf("/**", n2 - 1)) == -1) continue;
                    n3 = string.indexOf("*/", n2);
                }
                if (n2 != -1 && n3 != -1) {
                    if ((string = string.substring(n2 + 3, n3 + 1)).indexOf(9) != -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < string.length()) {
                            if (string.charAt(n5) == '\n') {
                                n4 = n5;
                            }
                            if (string.charAt(n5) != '\t') {
                                stringBuffer.append(string.charAt(n5));
                            } else {
                                int n6 = 0;
                                while (n6 < DataComponent.getTabSize() - (n5 - n4 - 1) % DataComponent.getTabSize()) {
                                    stringBuffer.append(' ');
                                    ++n6;
                                }
                                if (n6 > 0) {
                                    n4 -= n6 - 1;
                                }
                            }
                            ++n5;
                        }
                        string = stringBuffer.toString();
                    }
                    int n7 = string.indexOf("\n");
                    int n8 = string.indexOf("\n", n7 + 1);
                    if (n7 == -1 || n8 == -1) {
                        dataDestination.write(string.substring(0, string.length() - 1));
                        break;
                    }
                    int n9 = 1;
                    while (n9 + n7 <= n8 && n9 + n8 <= string.length() && (Character.isWhitespace(string.charAt(n9 + n7)) || string.charAt(n9 + n7) == '*') && string.regionMatches(false, n7, string, n8, n9)) {
                        ++n9;
                    }
                    if (--n9 <= 1) {
                        dataDestination.write(string.substring(0, string.length() - 1));
                        break;
                    }
                    n2 = 0;
                    while (n2 < string.length() - 1) {
                        n3 = string.indexOf("\n", n2);
                        if (n3 == -1) {
                            n3 = string.length() - 1;
                        }
                        dataDestination.write(string.substring(n2, n3));
                        dataDestination.write("\n");
                        n2 = n9 + n3 < string.length() && string.regionMatches(false, n7, string, n3, n9) ? n3 + n9 : n3 + 1;
                    }
                    break;
                }
            }
            --n;
        }
        dataDestination.write("</P></DD>\n<BR><BR>\n\n");
    }

    private boolean shouldDoCxxHeaderClassFor(int n) {
        return this.shouldDoCxxHeaderClassFor(n, false);
    }

    private boolean shouldDoCxxHeaderClassFor(int n, boolean bl) {
        return !this.getIsExtern() && (this.getTaskType() != 6 || bl) && (n == 1001 || n == 1003 || n == 1004 || this.getTaskType() != 4 && n == 1007 || this.getTaskType() == 4 && n == 1006);
    }

    private boolean shouldDoCxxCodeFor(int n) {
        return !this.getIsExtern() && (n == 1002 || n == 1005);
    }

    private boolean shouldDoDefaultArgumentsFor(int n) {
        return n == 1001 || n == 1006 || this.getIsExtern() || n == 1003 || n == 1004 || n == 1010 || n == 1009;
    }

    private boolean hasExecuteMethod() {
        return this.getTaskType() != 4;
    }

    private boolean needsUniqueIdString() {
        switch (this.getTaskType()) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return true;
            }
            case 6: {
                if (this.getResumeMasterTask() != null) {
                    return this.getResumeMasterTask().needsUniqueIdString();
                }
                if (this.getIsExtern()) {
                    return false;
                }
                throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ":  INTERNAL ERROR:  Resume task named \"" + this.getTaskName() + "\" has no corresponding registered counterpart.");
            }
        }
        return false;
    }

    private void writeUniqueIdStringIfNeeded(DataDestination dataDestination) {
        if (this.needsUniqueIdString()) {
            dataDestination.write(this.getUniqueIdString());
        }
    }

    private void writeOverloadingBackwardCompatibilityIfdefIfNeeded(DataDestination dataDestination, String string) {
        if (this.needsUniqueIdString()) {
            dataDestination.write("#ifndef ");
            dataDestination.write(string);
            dataDestination.write("\n#define ");
            dataDestination.write(string);
            dataDestination.write(" ");
            dataDestination.write(string);
            dataDestination.write(this.getUniqueIdString());
            dataDestination.write("\n#endif /*");
            dataDestination.write(string);
            dataDestination.write("*/\n");
        }
    }

    public void generateCxx(DataDestination dataDestination, int n) throws CompilationException {
        this.generateCxx(dataDestination, n, this.shouldDoCxxHeaderClassFor(n) || this.shouldDoCxxCodeFor(n) || this.isCxxDistributedOnlySubset(n) && this.getIsDistributed(), null);
    }

    protected void generateCxx(DataDestination dataDestination, int n, boolean bl, DataVector dataVector) throws CompilationException {
        int n2;
        String string = null;
        DataTaskDefinition dataTaskDefinition = this;
        if (this.getTaskType() == 6 && (dataTaskDefinition = this.getResumeMasterTask()) == null) {
            if (this.getIsExtern()) {
                this.generateCxxResumeFunction(dataDestination, n, "This_Is_Extern_So_This_String_Should_Never_Be_Used_And_If_You_See_It_You_Have_Found_A_Bug.");
                return;
            }
            throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ":  Internal Error:  Resume task named \"" + this.getTaskName() + "\" has no corresponding registered counterpart.");
        }
        switch (dataTaskDefinition.getTaskType()) {
            case 4: {
                string = "_TDL_Exception_";
                break;
            }
            case 5: {
                string = "_TDL_ExceptionHandler_";
                break;
            }
            default: {
                string = "_TDL_";
            }
        }
        if (n != 1002 && n != 1001 && n != 1003 && n != 1005 && n != 1004 && n != 1007 && n != 1006 && !this.isCxxDistributedOnlySubset(n)) {
            System.err.println("[DataTaskDefinition:generateCxx]  Warning:  Invalid theSubsetToProduce (" + n + ").");
            return;
        }
        dataDestination.write("\n");
        if (bl) {
            dataDestination.setNewlineText("  // ");
            this.generate(dataDestination, 1);
            dataDestination.clearNewlineText();
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write("\n");
        }
        if (this.isCxxDistributedOnlySubset(n)) {
            if (this.getIsDistributed()) {
                this.generateCxxAllocate(dataDestination, n);
                this.generateCxxCreateAction(dataDestination, n);
            }
            return;
        }
        if (dataVector == null && !this.getIsExtern()) {
            dataVector = this.validateTaskForCxxGeneration();
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("class ");
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write("  : public ");
            switch (this.getTaskType()) {
                case 4: {
                    if (this.getExceptionBaseTask() != null) {
                        dataDestination.write("_TDL_Exception_");
                        dataDestination.write(this.getExceptionBaseTask().getTaskName());
                        break;
                    }
                    dataDestination.write("_TDL_BaseException");
                    break;
                }
                case 5: {
                    dataDestination.write("_TDL_BaseHandler");
                    break;
                }
                default: {
                    dataDestination.write("_TDL_BaseAction");
                }
            }
            dataDestination.write("\n{\npublic:\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("static  STRING TCM_getStaticName() { return \"TDL-");
            dataDestination.write(this.getTaskTypeString());
            dataDestination.write("-");
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write("\"; }\nvirtual STRING TCM_getActionName() { return TCM_getStaticName(); }");
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n\n");
        }
        if (n != 1006) {
            this.generateCxxDistributedRegistryEntry(dataDestination, n, string, this.shouldDoCxxHeaderClassFor(n));
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("\n\npublic:");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            if (this.getTaskArgumentCount() > 0 || this.getPersistentTaskDeclarationCount() > 0) {
                dataDestination.setUsingTdlFileName(true);
            }
            n2 = 0;
            while (n2 < this.getTaskArgumentCount()) {
                dataDestination.makeNextLineNumber(this.getTaskArgument(n2).getLineNumber());
                dataDestination.write("\n");
                dataDestination.setStripLeadingWhitespace();
                this.getTaskArgument(n2).generate(dataDestination, 202);
                dataDestination.write(SEMICOLON);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.getPersistentTaskDeclarationCount()) {
                dataDestination.makeNextLineNumber(this.getPersistentTaskDeclaration(n2).getLineNumber());
                dataDestination.write("\n");
                dataDestination.setStripLeadingWhitespace();
                this.getPersistentTaskDeclaration(n2).generate(dataDestination, 202);
                dataDestination.write(SEMICOLON);
                ++n2;
            }
            if (this.getTaskArgumentCount() > 0 || this.getPersistentTaskDeclarationCount() > 0) {
                dataDestination.setUsingTdlFileName(false);
            }
            dataDestination.write("\n");
            dataDestination.write("\n");
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write(" ( ");
            int n3 = dataDestination.indentToCurrentColumn();
            if (this.getTaskArgumentCount() > 0) {
                dataDestination.setUsingTdlFileName(true);
            }
            n2 = 0;
            while (n2 < this.getTaskArgumentCount()) {
                dataDestination.makeNextLineNumber(this.getTaskArgument(n2).getLineNumber());
                if (n2 > 0) {
                    dataDestination.write(",\n");
                } else if (dataDestination.getEnableLineMacros()) {
                    dataDestination.write("\n");
                }
                dataDestination.setStripLeadingWhitespace();
                this.getTaskArgument(n2).generate(dataDestination, 201);
                ++n2;
            }
            if (this.getTaskArgumentCount() > 0) {
                dataDestination.setUsingTdlFileName(false);
            }
            if (this.getTaskType() == 5) {
                if (this.getTaskArgumentCount() > 0) {
                    dataDestination.write(",\n");
                }
                dataDestination.write("u_int4");
                dataDestination.write(" ");
                dataDestination.write("_TDL_MaximumActivates");
                dataDestination.write(" = ");
                dataDestination.write("_TDL_MAXIMUM_ACTIVATES");
            }
            dataDestination.write(" )");
            dataDestination.removeIndent(n3);
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            if (this.getTaskArgumentCount() > 0 || this.getPersistentTaskDeclarationCount() > 0 || this.getTaskType() == 4 && this.getExceptionBaseTask() != null || this.getTaskType() == 5) {
                dataDestination.write("\n: ");
                n3 = dataDestination.indentToCurrentColumn();
                boolean bl2 = false;
                if (this.getTaskType() == 4 && this.getExceptionBaseTask() != null) {
                    dataDestination.write("_TDL_Exception_");
                    dataDestination.setStripLeadingWhitespace();
                    this.getExceptionBaseTask().generateTask(dataDestination, 0, false, false, true, false, true);
                    bl2 = true;
                }
                if (this.getTaskType() == 5) {
                    if (bl2) {
                        dataDestination.write(",\n");
                    } else {
                        bl2 = true;
                    }
                    dataDestination.write("_TDL_BaseHandler");
                    dataDestination.write(" ( ");
                    dataDestination.write("_TDL_MaximumActivates");
                    dataDestination.write(" )");
                }
                n2 = 0;
                while (n2 < this.getTaskArgumentCount()) {
                    if (bl2) {
                        dataDestination.write(",\n");
                    } else {
                        bl2 = true;
                    }
                    dataDestination.write(this.getTaskArgument(n2).getArgumentName());
                    dataDestination.write(" ( ");
                    dataDestination.write(this.getTaskArgument(n2).getArgumentName());
                    dataDestination.write(" )");
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.getPersistentTaskDeclarationCount()) {
                    if (this.getPersistentTaskDeclaration(n2).hasEquals()) {
                        if (bl2) {
                            dataDestination.write(",\n");
                        } else {
                            bl2 = true;
                        }
                        dataDestination.write(this.getPersistentTaskDeclaration(n2).getArgumentName());
                        dataDestination.write(" ( ");
                        int n4 = dataDestination.indentToCurrentColumn();
                        if (dataDestination.getEnableLineMacros()) {
                            dataDestination.setUsingTdlFileName(true);
                            dataDestination.makeNextLineNumber(this.getPersistentTaskDeclaration(n2).getLineNumber() + this.getPersistentTaskDeclaration(n2).countSubcomponentNewlinesAfterEquals());
                            dataDestination.write("\n");
                        }
                        dataDestination.setStripLeadingWhitespace();
                        dataDestination.setPersistentlyStripLeadingSpaces(true);
                        this.getPersistentTaskDeclaration(n2).generate(dataDestination, 203);
                        dataDestination.setPersistentlyStripLeadingSpaces(false);
                        if (dataDestination.getEnableLineMacros()) {
                            dataDestination.setUsingTdlFileName(false);
                            dataDestination.removeIndent(1);
                            --n4;
                            dataDestination.write("\n");
                        } else {
                            dataDestination.write(" ");
                        }
                        dataDestination.write(CLOSE_PAREN);
                        dataDestination.removeIndent(n4);
                    }
                    ++n2;
                }
                dataDestination.removeIndent(n3);
            }
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n{}\n\n\n");
        }
        this.generateCxxExecuteOrResume(dataDestination, n, dataVector, string, false, dataTaskDefinition);
        if (this.shouldDoCxxHeaderClassFor(n)) {
            n2 = 0;
            while (n2 < this.getResumeTasksVector().count()) {
                this.getResumeTask(n2).generateCxxExecuteOrResume(dataDestination, n, this.getResumeTask(n2).validateTaskForCxxGeneration(), string, true, dataTaskDefinition);
                ++n2;
            }
        }
        if (this.shouldDoCxxHeaderClassFor(n) || this.shouldDoCxxCodeFor(n)) {
            if (this.getTaskType() == 4) {
                this.generateCxxStaticExceptionName(dataDestination, n);
                this.generateCxxExceptionName(dataDestination, n);
                this.generateCxxExceptionMatchesString(dataDestination, n);
            } else if (this.getTaskType() == 5) {
                this.generateCxxHandledExceptionName(dataDestination, n);
            }
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n}; /* ");
            dataDestination.write("class ");
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            dataDestination.write(" */\n\n");
            this.writeOverloadingBackwardCompatibilityIfdefIfNeeded(dataDestination, string + this.getTaskName());
            dataDestination.write("\n\n");
        }
        if (n == 1002 || n == 1001 || n == 1003 || n == 1004 || n == 1006 || this.getIsExtern()) {
            if (this.getTaskType() == 4) {
                this.generateCxxCreateException(dataDestination, n);
            } else if (this.getTaskType() == 5) {
                this.generateCxxCreateExceptionHandler(dataDestination, n);
            } else if (this.getTaskType() == 6) {
                this.generateCxxResumeFunction(dataDestination, n, string);
            } else {
                this.generateCxxAllocate(dataDestination, n);
                this.generateCxxCreateAction(dataDestination, n);
                this.generateCxxCreateDistributedAction(dataDestination, n);
                this.generateCxxSpawnAndWait(dataDestination, n);
                this.generateCxxFunctionalInvocation(dataDestination, n);
            }
        }
        if (n == 1007 && !this.getIsExtern()) {
            this.generateCxx(dataDestination, 1002, false, dataVector);
        }
    }

    protected void generateCxxDistributedRegistryEntry(DataDestination dataDestination, int n, String string, boolean bl) throws CompilationException {
        if (!this.getIsDistributed()) {
            return;
        }
        if (n == 1003) {
            System.err.println("[DataTaskDefinition:generateCxxDistributedRegistryEntry]  Error:  Inlined-C++ translation is *NOT* compatible with Distributed Tasks.");
            throw new CompilationException("[DataTaskDefinition:generateCxxDistributedRegistryEntry]  Error:  Inlined-C++ translation is *NOT* compatible with Distributed Tasks.");
        }
        if (bl) {
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        }
        if (bl) {
            dataDestination.write("static ");
        } else {
            dataDestination.write("\n\n/*static*/ ");
        }
        dataDestination.write("_TDL_DistributedRegistryEntry");
        dataDestination.write(" ");
        if (!bl) {
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write("::");
        }
        dataDestination.write("_TDL_thisDistributedRegistryEntry");
        if (bl) {
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write(" ;\n");
        } else {
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n( ");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\"");
            dataDestination.write(this.getTaskName());
            dataDestination.write("\",\n");
            dataDestination.write("\"");
            dataDestination.write(this.getUniqueIdString());
            dataDestination.write("\",\n");
            dataDestination.write("_TDL_Allocate_");
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write(",\n");
            dataDestination.write("_TDL_UnpackAndCreateDistributedRemoteAction_");
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write(",\n");
            this.writeDistributedMacroRequirements(dataDestination);
            dataDestination.setIsConcatenatingStrings(true);
            dataDestination.write(this.getDistributedTaskFormatString(n));
            dataDestination.setIsConcatenatingStrings(false);
            dataDestination.write("\n");
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write(");\n\n\n");
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        }
    }

    protected void generateCxxExecuteOrResume(DataDestination dataDestination, int n, DataVector dataVector, String string, boolean bl, DataTaskDefinition dataTaskDefinition) {
        if (!this.hasExecuteMethod()) {
            return;
        }
        if (this.shouldDoCxxHeaderClassFor(n, bl)) {
            if (this.getTaskType() != 6) {
                dataDestination.write("virtual ");
                dataDestination.write("void");
            } else {
                dataDestination.write("void");
            }
            dataDestination.write(" ");
        }
        if (this.shouldDoCxxCodeFor(n)) {
            if (this.getTaskType() != 6) {
                dataDestination.write("/*virtual*/ ");
                dataDestination.write("void");
            } else {
                dataDestination.write("void");
            }
            dataDestination.write("\n");
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write("::");
        }
        if (this.shouldDoCxxHeaderClassFor(n, bl) || this.shouldDoCxxCodeFor(n)) {
            if (this.getTaskType() != 6) {
                dataDestination.write("execute ( const TCM_Task_Tree_Ref & _TDL_ENCLOSING_TASK )");
            } else {
                dataDestination.write("resume");
                dataDestination.write(" ( ");
                int n2 = dataDestination.indentToCurrentColumn();
                if (this.getTaskArgumentCount() > 0) {
                    dataDestination.setUsingTdlFileName(true);
                }
                int n3 = 0;
                while (n3 < this.getTaskArgumentCount()) {
                    dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
                    if (n3 > 0) {
                        dataDestination.write(",\n");
                    } else if (dataDestination.getEnableLineMacros()) {
                        dataDestination.write("\n");
                    }
                    dataDestination.setStripLeadingWhitespace();
                    int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
                    this.getTaskArgument(n3).generate(dataDestination, n4);
                    ++n3;
                }
                if (this.getTaskArgumentCount() > 0) {
                    dataDestination.setUsingTdlFileName(false);
                }
                dataDestination.write(" )");
                dataDestination.removeIndent(n2);
            }
            if (n == 1002 || n == 1003 || n == 1005) {
                this.getTaskBody().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder(this, dataVector, this.getCachedStatementsVector(), this.getCachedOnAgentHashtable()));
                this.getTaskBody().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder(dataTaskDefinition, this.getTaskType() == 6));
                if (this.getTaskType() == 6) {
                    this.getTaskBody().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder("\nTCM_Task_Tree_Ref _TDL_ENCLOSING_TASK = _TDL_getTcmTaskTreeNode();\n_TDL_clearTcmTaskTreeNode();\nTCM_PushUserTaskForThisThreadForDurationOfObject\n  _TDL_PushOurTaskForThisThreadForTheDurationOfThisObject ( _TDL_ENCLOSING_TASK );\n"));
                }
                if (this.getTaskType() == 1 || this.getTaskType() == 2 || this.getTaskType() == 3) {
                    this.getTaskBody().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder("TDL::verifyNodeClassType ( _TDL_ENCLOSING_TASK, " + (this.getTaskType() == 1 ? "TCM_Goal" : (this.getTaskType() == 2 ? "TCM_Command" : "TCM_Monitor")) + ", \"" + this.getTaskTypeString() + " " + this.getTaskName() + "\" );\n"));
                }
                if (this.getTaskType() == 1 || this.getTaskType() == 2 || this.getTaskType() == 3) {
                    this.getTaskBody().addSubcomponentAfterOpenBrace(new DataComponentPlaceholder("TDL::verifyNodeAllocationFunction (\n       _TDL_ENCLOSING_TASK,\n       " + (!this.getIsDistributed() ? "_TDL_AllocationFunction::LOCAL_NONDISTRIBUTED_ONLY" : (this.isCxxDistributedOnlySubset(n) ? "_TDL_AllocationFunction::DISTRIBUTED_ONLY" : "_TDL_AllocationFunction::EITHER_LOCAL_OR_DISTRIBUTED")) + ",\n       \"" + this.getTaskTypeString() + " " + this.getTaskName() + "\" );"));
                }
                this.getTaskBody().addSubcomponentBeforeCloseBrace(new DataComponentPlaceholder("\n_TDL_DO_TCM_SUCCESS ( _TDL_ENCLOSING_TASK );\n"));
                this.getTaskBody().generate(dataDestination, n);
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n\n");
                this.getTaskBody().removeSubcomponentBeforeCloseBrace();
                if (this.getTaskType() == 1 || this.getTaskType() == 2 || this.getTaskType() == 3 || this.getTaskType() == 5) {
                    this.getTaskBody().removeSubcomponentAfterOpenBrace();
                }
                if (this.getTaskType() == 1 || this.getTaskType() == 2 || this.getTaskType() == 3) {
                    this.getTaskBody().removeSubcomponentAfterOpenBrace();
                }
                if (this.getTaskType() == 6) {
                    this.getTaskBody().removeSubcomponentAfterOpenBrace();
                }
                this.getTaskBody().removeSubcomponentAfterOpenBrace();
                this.getTaskBody().removeSubcomponentAfterOpenBrace();
            } else {
                dataDestination.write(" ;\n\n");
            }
        }
    }

    protected void generateCxxResumeFunction(DataDestination dataDestination, int n, String string) {
        if (this.getTaskType() != 6) {
            return;
        }
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("void");
        dataDestination.write("\n");
        dataDestination.write("TDL_RESUME_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write("const TCM_Task_Tree_Ref & _TDL_ENCLOSING_TASK");
        if (this.getTaskArgumentCount() > 0) {
            dataDestination.setUsingTdlFileName(true);
        }
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            dataDestination.write(",\n");
            dataDestination.setStripLeadingWhitespace();
            int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
            this.getTaskArgument(n3).generate(dataDestination, n4);
            ++n3;
        }
        if (this.getTaskArgumentCount() > 0) {
            dataDestination.setUsingTdlFileName(false);
        }
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
        } else {
            dataDestination.write("\n{");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n");
            dataDestination.write("_TDL_INTERNAL_RESUME");
            dataDestination.write(" ( ");
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.write(string);
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write(",\n");
            dataDestination.write("_TDL_ENCLOSING_TASK");
            dataDestination.write(" ) ( ");
            n2 += dataDestination.indentToCurrentColumn();
            n3 = 0;
            while (n3 < this.getTaskArgumentCount()) {
                if (n3 > 0) {
                    dataDestination.write(",\n");
                }
                dataDestination.write(this.getTaskArgument(n3).getArgumentName());
                ++n3;
            }
            dataDestination.removeIndent(n2);
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write(" );\n}\n\n");
        }
    }

    private void generateCxxAllocate_generateConstraintConditional(DataDestination dataDestination) {
        dataDestination.write("\n  // Either Remote-side Distributed Task  OR  ");
        dataDestination.write("Non-Distributed Task scenario.\n");
        dataDestination.write("if ( ");
        dataDestination.write("theAgentName");
        dataDestination.write(" == (");
        dataDestination.write("STRING");
        dataDestination.write(")NULL )\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
    }

    protected void generateCxxAllocate(DataDestination dataDestination, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getIsDistributed()) {
            if (this.isCxxDistributedOnlySubset(n)) {
                bl3 = true;
            } else {
                bl = true;
            }
        } else {
            bl2 = true;
        }
        if (n == 1001 || n == 1006 || n == 1010 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004 || n == 1009) {
            dataDestination.write("inline ");
        }
        dataDestination.write("TCM_Task_Tree_Ref");
        dataDestination.write("\n");
        dataDestination.write("_TDL_Allocate_");
        dataDestination.write(this.getTaskName());
        this.writeUniqueIdStringIfNeeded(dataDestination);
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write("STRING");
        dataDestination.write("  ");
        dataDestination.write("theName");
        if (bl) {
            dataDestination.write("      ");
        }
        if (!bl3) {
            if (!this.shouldDoDefaultArgumentsFor(n)) {
                dataDestination.write(" /*");
            }
            dataDestination.write(" = (");
            dataDestination.write("STRING");
            dataDestination.write(")NULL");
            if (!this.shouldDoDefaultArgumentsFor(n)) {
                dataDestination.write(" */");
            }
        }
        if (bl3 || bl) {
            dataDestination.write(",\n");
            dataDestination.write("STRING");
            dataDestination.write("  ");
            dataDestination.write("theAgentName");
            if (!bl3) {
                dataDestination.write(" ");
                if (!this.shouldDoDefaultArgumentsFor(n)) {
                    dataDestination.write(" /*");
                }
                dataDestination.write(" = (");
                dataDestination.write("STRING");
                dataDestination.write(")NULL");
                if (!this.shouldDoDefaultArgumentsFor(n)) {
                    dataDestination.write(" */");
                }
            }
            if (bl) {
                dataDestination.write(",\n");
                dataDestination.write("BOOLEAN");
                dataDestination.write(" ");
                dataDestination.write("theIsDistributedRemoteSide");
                if (!this.shouldDoDefaultArgumentsFor(n)) {
                    dataDestination.write(" /*");
                }
                dataDestination.write(" = FALSE");
                if (!this.shouldDoDefaultArgumentsFor(n)) {
                    dataDestination.write(" */");
                }
            }
        }
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || n == 1010 || this.getIsExtern()) {
            dataDestination.write(" ;\n");
        } else {
            dataDestination.write("\n{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            if (bl) {
                dataDestination.write("_TDL_MARKUSED");
                dataDestination.write(" ( ");
                dataDestination.write("theIsDistributedRemoteSide");
                dataDestination.write(" );\n\n");
            }
            dataDestination.write("TCM_Task_Tree_Ref");
            dataDestination.write("  ");
            dataDestination.write("allocatedNode");
            if (bl) {
                dataDestination.write(";\n\n");
                dataDestination.write("if ( ");
                dataDestination.write("theAgentName");
                dataDestination.write(" == (");
                dataDestination.write("STRING");
                dataDestination.write(")NULL )\n");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("allocatedNode");
                dataDestination.write(" = ");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            } else {
                dataDestination.write("\n  = ");
            }
            if (bl2 || bl) {
                switch (this.getTaskType()) {
                    case 1: {
                        dataDestination.write("TCM_AllocateGoalNode");
                        break;
                    }
                    case 2: {
                        dataDestination.write("TCM_AllocateCommandNode");
                        break;
                    }
                    case 3: {
                        dataDestination.write("TCM_AllocateCompleteMonitorNode");
                        break;
                    }
                    default: {
                        throw new CompilationException("Error:  No KNOWN TCM allocate function for Task type \"" + this.getTaskTypeString() + "\".");
                    }
                }
                dataDestination.write(" ( ");
                n2 = dataDestination.indentToCurrentColumn();
                dataDestination.write("\"");
                dataDestination.write(this.getTaskName());
                dataDestination.write("\",\n");
                dataDestination.write("( ( ");
                dataDestination.write("theName");
                dataDestination.write(" == (");
                dataDestination.write("STRING");
                dataDestination.write(")NULL )\n ? \"");
                dataDestination.write(this.getTaskName());
                dataDestination.write("\" : ");
                dataDestination.write("theName");
                dataDestination.write(" ) );\n");
                dataDestination.removeIndent(n2);
            }
            if (bl) {
                dataDestination.write("else\n");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("allocatedNode");
                dataDestination.write(" = ");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            }
            if (bl || bl3) {
                dataDestination.write("TCM_AllocateDistributedNode");
                dataDestination.write(" ( ");
                n2 = dataDestination.indentToCurrentColumn();
                dataDestination.write("");
                dataDestination.write("theAgentName");
                dataDestination.write(",\n");
                dataDestination.write("\"");
                dataDestination.write(this.getTaskName());
                dataDestination.write("\",\n");
                dataDestination.write("( ( ");
                dataDestination.write("theName");
                dataDestination.write(" == (");
                dataDestination.write("STRING");
                dataDestination.write(")NULL )\n ? \"");
                dataDestination.write(this.getTaskName());
                dataDestination.write("\" : ");
                dataDestination.write("theName");
                dataDestination.write(" ),\n");
                dataDestination.write("\"");
                dataDestination.write(this.getUniqueIdString());
                dataDestination.write("\" );\n");
                dataDestination.removeIndent(n2);
            }
            dataDestination.write("\n");
            dataDestination.write("_TDL_AllocationFunction::cacheAllocationFunctionType");
            dataDestination.write(" (\n       ");
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.write("allocatedNode");
            dataDestination.write(",\n");
            if (bl2) {
                dataDestination.write("_TDL_AllocationFunction::LOCAL_NONDISTRIBUTED_ONLY");
            } else if (bl) {
                dataDestination.write("_TDL_AllocationFunction::EITHER_LOCAL_OR_DISTRIBUTED");
            } else if (bl3) {
                dataDestination.write("_TDL_AllocationFunction::DISTRIBUTED_ONLY");
            } else {
                dataDestination.write("_TDL_AllocationFunction::UNKNOWN");
            }
            dataDestination.write(" );\n");
            dataDestination.removeIndent(n2);
            dataDestination.write("\nreturn ");
            dataDestination.write("allocatedNode");
            dataDestination.write(";\n");
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\n");
        }
        this.writeOverloadingBackwardCompatibilityIfdefIfNeeded(dataDestination, "_TDL_Allocate_" + this.getTaskName());
        dataDestination.write("\n\n");
    }

    protected void generateCxxCreateAction(DataDestination dataDestination, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "\"[_TDL_CreateAction_" + this.getTaskName() + ":'" + "createdActionOrVoid" + "']\"";
        if (this.getIsDistributed()) {
            if (this.isCxxDistributedOnlySubset(n)) {
                bl3 = true;
            } else {
                bl = true;
            }
        } else {
            bl2 = true;
        }
        if (n == 1001 || n == 1006 || n == 1010 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004 || n == 1009) {
            dataDestination.write("inline ");
        }
        dataDestination.write("_TDL_ActionOrVoid");
        dataDestination.write("\n");
        dataDestination.write("_TDL_CreateAction_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write("const TCM_Task_Tree_Ref &");
        dataDestination.write(" ");
        dataDestination.write("_TDL_ENCLOSING_TASK");
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            dataDestination.write(",\n");
            dataDestination.setStripLeadingWhitespace();
            int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
            this.getTaskArgument(n3).generate(dataDestination, n4);
            ++n3;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || n == 1010 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
            return;
        }
        dataDestination.write("\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        if (bl || bl2) {
            dataDestination.write("_TDL_TrivialHandleManager");
            dataDestination.write(" ");
            dataDestination.write("_TDL_SpawnedTasks");
            dataDestination.write(" ( ");
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.write("\"");
            dataDestination.write("_TDL_CreateAction_");
            dataDestination.write(this.getTaskName());
            dataDestination.write("\",\n");
            dataDestination.write("_TDL_ENCLOSING_TASK");
            dataDestination.removeIndent(n2);
            dataDestination.write(" );\n\n");
        } else {
            dataDestination.write("_TDL_MARKUSED");
            dataDestination.write(" ( ");
            dataDestination.write("_TDL_ENCLOSING_TASK");
            dataDestination.write(" );\n\n");
        }
        dataDestination.write("_TDL_ActionOrVoid");
        dataDestination.write("  ");
        dataDestination.write("createdActionOrVoid");
        dataDestination.write(";\n");
        if (bl) {
            dataDestination.write("if ( ");
            dataDestination.write("_TDL_DO_CHECK_IF_TASK_DISTRIBUTED");
            dataDestination.write(" ( ");
            dataDestination.write("_TDL_ENCLOSING_TASK");
            dataDestination.write(" ) == TRUE )\n{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        }
        if (bl || bl3) {
            if (this.getTaskArgumentCount() > 0) {
                this.generateCxxDistributedStruct(dataDestination);
                dataDestination.write("_TDL_distributedStructPointer");
                dataDestination.write(" = ");
                dataDestination.write("MALLOC");
                dataDestination.write(" ( ");
                dataDestination.write("_TDL_DISTRIBUTED_STRUCT");
                dataDestination.write(" );\n");
                n3 = 0;
                while (n3 < this.getTaskArgumentCount()) {
                    dataDestination.write("_TDL_distributedStructPointer");
                    dataDestination.write(" -> ");
                    dataDestination.setStripLeadingWhitespace();
                    dataDestination.write(this.getTaskArgument(n3).getArgumentName());
                    dataDestination.write(" = ");
                    dataDestination.setStripLeadingWhitespace();
                    dataDestination.write(this.getTaskArgument(n3).getArgumentName());
                    dataDestination.write(";\n");
                    ++n3;
                }
            }
            dataDestination.write("createdActionOrVoid");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n. ");
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("setVoidPointer");
            dataDestination.write(" ( ");
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.write("(void *) ");
            if (this.getTaskArgumentCount() > 0) {
                dataDestination.write("_TDL_distributedStructPointer");
            } else {
                dataDestination.write("NULL");
            }
            dataDestination.write(",\n\"");
            dataDestination.write(this.getUniqueIdString());
            dataDestination.write("\" );\n");
            dataDestination.removeIndent(n2);
        }
        if (bl) {
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\nelse\n{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        }
        if (bl || bl2) {
            dataDestination.write("createdActionOrVoid");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("\n. ");
            dataDestination.write("setActionPointer");
            dataDestination.write(" ( new ");
            dataDestination.write("_TDL_");
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write(" ( ");
            n2 = dataDestination.indentToCurrentColumn();
            n3 = 0;
            while (n3 < this.getTaskArgumentCount()) {
                if (n3 > 0) {
                    dataDestination.write(",\n");
                }
                dataDestination.setStripLeadingWhitespace();
                dataDestination.write(this.getTaskArgument(n3).getArgumentName());
                ++n3;
            }
            dataDestination.write(" ) );\n");
            dataDestination.removeIndent(n2);
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        }
        if (bl) {
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\n");
        }
        if ((bl || bl2) && (this.getTaskType() == 1 || this.getTaskType() == 2 || this.getTaskType() == 3)) {
            boolean bl4 = bl;
            boolean bl5 = false;
            boolean bl6 = false;
            n3 = -2;
            while (n3 < this.getConstraintsCount()) {
                if (n3 == -2 && this.getIsPersistent() || n3 == -1 && this.getIsThreaded() || n3 >= 0 && !DataConstraint.getIsConstraintOverriden(this.getConstraint(n3), this.getConstraints()) && this.getConstraint(n3).getConstraintType() != 24) {
                    if (!bl6) {
                        dataDestination.write("\n");
                        bl6 = true;
                    }
                    if (bl4) {
                        bl4 = false;
                        bl5 = true;
                        dataDestination.write("\n  // Either Remote-side Distributed Task  OR  ");
                        dataDestination.write("Non-Distributed Task scenario.\n");
                        dataDestination.write("if ( ");
                        dataDestination.write("_TDL_DO_CHECK_IF_TASK_DISTRIBUTED");
                        dataDestination.write(" ( ");
                        dataDestination.write("_TDL_ENCLOSING_TASK");
                        dataDestination.write(" ) == FALSE )\n{");
                        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                    }
                    switch (n3) {
                        case -2: {
                            dataDestination.write("\n       // Task is PERSISTENT.\n");
                            dataDestination.write("TDL::verifyConstraint");
                            dataDestination.write(" ( ");
                            n2 = dataDestination.indentToCurrentColumn();
                            dataDestination.write(string);
                            dataDestination.write(",\n\"");
                            dataDestination.write("TCM_SetPersistence");
                            dataDestination.write("\",\n");
                            dataDestination.write("TCM_SetPersistence");
                            dataDestination.write(" ( ");
                            dataDestination.write("_TDL_ENCLOSING_TASK");
                            dataDestination.write(", TRUE ) );\n");
                            dataDestination.removeIndent(n2);
                            break;
                        }
                        case -1: {
                            dataDestination.write("\n       // Task is THREADED.\n");
                            dataDestination.write("TDL::verifyConstraint");
                            dataDestination.write(" ( ");
                            n2 = dataDestination.indentToCurrentColumn();
                            dataDestination.write(string);
                            dataDestination.write(",\n\"");
                            dataDestination.write("TCM_SetIsThreadedTask");
                            dataDestination.write("\",\n");
                            dataDestination.write("TCM_SetIsThreadedTask");
                            dataDestination.write(" ( ");
                            dataDestination.write("_TDL_ENCLOSING_TASK");
                            dataDestination.write(", TRUE ) );\n");
                            dataDestination.removeIndent(n2);
                            break;
                        }
                        default: {
                            this.getConstraint(n3).generateCxxExternalSubtaskDeclarations(dataDestination, true);
                            this.getConstraint(n3).generateCxxTaskExternal(dataDestination, string, "_TDL_ENCLOSING_TASK", "", false, this.getTaskType() == 3);
                        }
                    }
                }
                ++n3;
            }
            if (bl5) {
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("}\n");
            }
        }
        dataDestination.write("\nreturn ");
        dataDestination.write("createdActionOrVoid");
        dataDestination.write(";\n");
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("}\n\n\n");
    }

    protected void generateCxxCreateDistributedAction(DataDestination dataDestination, int n) {
        if (!this.getIsDistributed()) {
            return;
        }
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("TCM_Action_Ref");
        dataDestination.write("\n");
        dataDestination.write("_TDL_UnpackAndCreateDistributedRemoteAction_");
        dataDestination.write(this.getTaskName());
        this.writeUniqueIdStringIfNeeded(dataDestination);
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        int n3 = 0;
        while (n3 < DataComponent.CXX_CREATE_DISTRIBUTED_REMOTE_ACTION_FUNCTION_ARGUMENTS.length) {
            if (n3 > 0) {
                dataDestination.write(",\n");
            }
            dataDestination.write(DataComponent.CXX_CREATE_DISTRIBUTED_REMOTE_ACTION_FUNCTION_ARGUMENTS[n3]);
            ++n3;
        }
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
            return;
        }
        dataDestination.write("\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        n3 = 0;
        while (n3 < DataComponent.CXX_CREATE_DISTRIBUTED_REMOTE_ACTION_FUNCTION_ARGUMENT_NAMES.length) {
            dataDestination.write("_TDL_MARKUSED");
            dataDestination.write(" ( ");
            dataDestination.write(DataComponent.CXX_CREATE_DISTRIBUTED_REMOTE_ACTION_FUNCTION_ARGUMENT_NAMES[n3]);
            dataDestination.write(" );\n");
            ++n3;
        }
        dataDestination.write("\n");
        if (this.getTaskArgumentCount() > 0) {
            this.generateCxxDistributedStruct(dataDestination);
            dataDestination.write("_TDL_distributedStructPointer");
            dataDestination.write(" = (");
            dataDestination.write("_TDL_DISTRIBUTED_STRUCT");
            dataDestination.write(" *) ");
            dataDestination.write("theVoidPointerArgumentToUnpack");
            dataDestination.write(";\n");
        }
        dataDestination.write("return ");
        dataDestination.write("_TDL_CreateAction_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write("_TDL_ENCLOSING_TASK");
        n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.write(",\n");
            dataDestination.write("_TDL_distributedStructPointer");
            dataDestination.write(" -> ");
            dataDestination.setStripLeadingWhitespace();
            dataDestination.write(this.getTaskArgument(n3).getArgumentName());
            ++n3;
        }
        dataDestination.write(" );\n");
        dataDestination.removeIndent(n2);
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("}\n\n\n");
    }

    protected void generateCxxDistributedStruct(DataDestination dataDestination) {
        if (this.getTaskArgumentCount() <= 0) {
            System.err.println("[DataTaskDefinition:generateCxxDistributedStruct]  Internal Warning:  No arguments present.  This method should have never been called.  ");
            return;
        }
        dataDestination.write("struct ");
        dataDestination.write("_TDL_DISTRIBUTED_STRUCT");
        dataDestination.write("\n{");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        int n = 0;
        while (n < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n).getLineNumber());
            if (n > 0) {
                dataDestination.write(";\n");
            } else {
                dataDestination.write("\n");
            }
            dataDestination.setStripLeadingWhitespace();
            this.getTaskArgument(n).generate(dataDestination, 204);
            ++n;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write(";\n} * ");
        dataDestination.write("_TDL_distributedStructPointer");
        dataDestination.write(";\n");
    }

    protected void generateCxxSpawnAndWait(DataDestination dataDestination, int n) {
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("TCM_Return_Type");
        dataDestination.write("\n");
        dataDestination.write("_TDL_SpawnAndWait_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write("const TCM_Task_Tree_Ref &");
        dataDestination.write(" ");
        dataDestination.write("theParentTaskTreeRef");
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            dataDestination.write(",\n");
            dataDestination.setStripLeadingWhitespace();
            int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
            this.getTaskArgument(n3).generate(dataDestination, n4);
            ++n3;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
        } else {
            dataDestination.write("\n{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            DataSpawnTask.generateCxxOutsideOfTask(dataDestination, n, this);
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\n\n");
        }
    }

    protected void generateCxxFunctionalInvocation(DataDestination dataDestination, int n) {
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("TCM_Return_Type");
        dataDestination.write("\n");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            if (n3 > 0) {
                dataDestination.write(",\n");
            } else if (dataDestination.getEnableLineMacros()) {
                dataDestination.write("\n");
            }
            dataDestination.setStripLeadingWhitespace();
            this.getTaskArgument(n3).generate(dataDestination, 201);
            ++n3;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
        } else {
            dataDestination.write("\n{\n");
            dataDestination.addIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("return ");
            dataDestination.write("_TDL_SpawnAndWait_");
            dataDestination.write(this.getTaskName());
            dataDestination.write(" ( ");
            n2 = dataDestination.indentToCurrentColumn();
            dataDestination.write(DataComponent.CXX_TCM_ROOT_NODE);
            n3 = 0;
            while (n3 < this.getTaskArgumentCount()) {
                dataDestination.write(", ");
                dataDestination.write(this.getTaskArgument(n3).getArgumentName());
                ++n3;
            }
            dataDestination.write(" );\n");
            dataDestination.removeIndent(n2);
            dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
            dataDestination.write("}\n\n");
        }
    }

    protected void generateCxxStaticExceptionName(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 4) {
            System.err.println("[DataTaskDefinition:generateCxxStaticExceptionName]  Warning:  Not an exception.  Aborting creating Exception-name method.");
            return;
        }
        if (n == 1005) {
            return;
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("static  ");
        } else {
            dataDestination.write("/*static*/ ");
        }
        dataDestination.write("STRING");
        if (this.shouldDoCxxCodeFor(n)) {
            dataDestination.write("\n");
            dataDestination.write("_TDL_Exception_");
            dataDestination.write(this.getTaskName());
            dataDestination.write("::");
        } else {
            dataDestination.write(" ");
        }
        dataDestination.write("getStaticExceptionName");
        dataDestination.write("()");
        switch (n) {
            case 1002: 
            case 1003: 
            case 1004: {
                dataDestination.write("\n{");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\nreturn \"");
                dataDestination.write(this.getTaskName());
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\";\n}\n\n");
                break;
            }
            default: {
                dataDestination.write(";\n");
            }
        }
    }

    protected void generateCxxExceptionName(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 4) {
            System.err.println("[DataTaskDefinition:generateCxxExceptionName]  Warning:  Not an exception.  Aborting creating Exception-name method.");
            return;
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("virtual ");
        } else {
            dataDestination.write("/*virtual*/ ");
        }
        dataDestination.write("STRING");
        if (this.shouldDoCxxCodeFor(n)) {
            dataDestination.write("\n");
            dataDestination.write("_TDL_Exception_");
            dataDestination.write(this.getTaskName());
            dataDestination.write("::");
        } else {
            dataDestination.write(" ");
        }
        dataDestination.write("getExceptionName() const");
        switch (n) {
            case 1002: 
            case 1003: 
            case 1005: {
                dataDestination.write("\n{");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\nreturn ");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("_TDL_Exception_");
                dataDestination.write(this.getTaskName());
                dataDestination.write("::");
                dataDestination.write("getStaticExceptionName");
                dataDestination.write("();\n}\n\n");
                break;
            }
            default: {
                dataDestination.write(";\n");
            }
        }
    }

    protected void generateCxxExceptionMatchesString(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 4) {
            System.err.println("[DataTaskDefinition:generateCxxExceptionMatchesStrng]  Warning:  Not an exception.  Aborting creating Exception-matches method.");
            return;
        }
        if (n == 1005) {
            return;
        }
        if (n == 1003 || n == 1004) {
            dataDestination.write("\n");
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("static  ");
        } else {
            dataDestination.write("/*static*/ ");
        }
        dataDestination.write("BOOLEAN");
        dataDestination.spaceToColumn(dataDestination.getColumn() - "BOOLEAN".length() + "STRING".length());
        if (this.shouldDoCxxCodeFor(n)) {
            dataDestination.write("\n");
            dataDestination.write("_TDL_Exception_");
            dataDestination.write(this.getTaskName());
            dataDestination.write("::");
        } else {
            dataDestination.write(" ");
        }
        dataDestination.write("exceptionMatches ( STRING theString )");
        switch (n) {
            case 1002: 
            case 1003: 
            case 1004: {
                dataDestination.write("\n{");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\nreturn ( ");
                dataDestination.write("StringEqual");
                dataDestination.write(" ( ");
                int n2 = dataDestination.indentToCurrentColumn();
                dataDestination.write("_TDL_Exception_");
                dataDestination.write(this.getTaskName());
                dataDestination.write("::");
                dataDestination.write("getStaticExceptionName");
                dataDestination.write("(),\n");
                dataDestination.write("theString");
                dataDestination.write(" ) == TRUE )");
                dataDestination.removeIndent(n2);
                dataDestination.write("\n    || ");
                if (this.getExceptionBaseTask() != null) {
                    dataDestination.write("_TDL_Exception_");
                    dataDestination.write(this.getExceptionBaseTask().getTaskName());
                } else {
                    dataDestination.write("_TDL_BaseException");
                }
                dataDestination.write("::");
                dataDestination.write("exceptionMatches");
                dataDestination.write(" ( ");
                dataDestination.write("theString");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write(" );\n}\n\n\n");
                break;
            }
            default: {
                dataDestination.write(";\n\n");
            }
        }
    }

    protected void generateCxxCreateException(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 4) {
            System.err.println("[DataTaskDefinition:generateCxxCreateException]  Warning:  Not an exception.  Aborting creating create-Exception function.");
            return;
        }
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("_TDL_BaseException *");
        dataDestination.write("\n");
        dataDestination.write("_TDL_CreateException_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            if (n3 > 0) {
                dataDestination.write(",\n");
            } else if (dataDestination.getEnableLineMacros()) {
                dataDestination.write("\n");
            }
            dataDestination.setStripLeadingWhitespace();
            int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
            this.getTaskArgument(n3).generate(dataDestination, n4);
            ++n3;
        }
        dataDestination.setUsingTdlFileName(false);
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
            return;
        }
        dataDestination.write("\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("return new ");
        dataDestination.write("_TDL_Exception_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        n2 = dataDestination.indentToCurrentColumn();
        n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            if (n3 > 0) {
                dataDestination.write(",\n");
            }
            dataDestination.setStripLeadingWhitespace();
            dataDestination.write(this.getTaskArgument(n3).getArgumentName());
            ++n3;
        }
        dataDestination.removeIndent(n2);
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write(" );\n}\n\n\n");
    }

    protected void generateCxxHandledExceptionName(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 5) {
            System.err.println("[DataTaskDefinition:generateCxxHandledExceptionName]  Warning:  Not an exception handler.  Aborting creating Exception-Handler-name method.");
            return;
        }
        if (this.getHandlesException() == null || this.getHandlesException().length() <= 0) {
            throw new CompilationException("Internal Error:  DataTaskDefinition object of type \"EXCEPTION HANDLER\" does not handle an exception.");
        }
        if (this.shouldDoCxxHeaderClassFor(n)) {
            dataDestination.write("virtual ");
        } else {
            dataDestination.write("/*virtual*/ ");
        }
        dataDestination.write("STRING");
        if (this.shouldDoCxxCodeFor(n)) {
            dataDestination.write("\n");
            dataDestination.write("_TDL_ExceptionHandler_");
            dataDestination.write(this.getTaskName());
            this.writeUniqueIdStringIfNeeded(dataDestination);
            dataDestination.write("::");
        } else {
            dataDestination.write(" ");
        }
        dataDestination.write("_TDL_getHandledExceptionName() const");
        switch (n) {
            case 1002: 
            case 1003: 
            case 1005: {
                dataDestination.write("\n{");
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\nreturn ");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("_TDL_Exception_");
                dataDestination.write(this.getHandlesException());
                dataDestination.write("::");
                dataDestination.write("getStaticExceptionName");
                dataDestination.write("();\n}\n\n");
                break;
            }
            default: {
                dataDestination.write(";\n");
            }
        }
    }

    protected void generateCxxCreateExceptionHandler(DataDestination dataDestination, int n) {
        if (this.getTaskType() != 5) {
            System.err.println("[DataTaskDefinition:generateCxxCreateExceptionHandler]  Warning:  Not an exception handler.  Aborting creating CreateExceptionHandler function.");
            return;
        }
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write("extern ");
        } else if (n == 1003 || n == 1004) {
            dataDestination.write("inline ");
        }
        dataDestination.write("_TDL_BaseHandler *");
        dataDestination.write("\n");
        dataDestination.write("_TDL_CreateExceptionHandler_");
        dataDestination.write(this.getTaskName());
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        int n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(this.getTaskArgument(n3).getLineNumber());
            if (n3 > 0) {
                dataDestination.write(",\n");
            } else if (dataDestination.getEnableLineMacros()) {
                dataDestination.write("\n");
            }
            dataDestination.setStripLeadingWhitespace();
            int n4 = this.shouldDoDefaultArgumentsFor(n) ? 201 : 204;
            this.getTaskArgument(n3).generate(dataDestination, n4);
            ++n3;
        }
        dataDestination.setUsingTdlFileName(false);
        if (this.getTaskArgumentCount() > 0) {
            dataDestination.write(",\n");
        }
        dataDestination.write("u_int4");
        dataDestination.write(" ");
        dataDestination.write("_TDL_MaximumActivates");
        if (!this.shouldDoDefaultArgumentsFor(n)) {
            dataDestination.write(" /*");
        }
        dataDestination.write(" = 0 ");
        if (!this.shouldDoDefaultArgumentsFor(n)) {
            dataDestination.write("*/");
        }
        dataDestination.write(CLOSE_PAREN);
        dataDestination.removeIndent(n2);
        if (n == 1001 || n == 1006 || this.getIsExtern()) {
            dataDestination.write(" ;\n\n");
            return;
        }
        dataDestination.write("\n{\n");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write("return new ");
        dataDestination.write("_TDL_ExceptionHandler_");
        dataDestination.write(this.getTaskName());
        this.writeUniqueIdStringIfNeeded(dataDestination);
        dataDestination.write(" ( ");
        n2 = dataDestination.indentToCurrentColumn();
        n3 = 0;
        while (n3 < this.getTaskArgumentCount()) {
            if (n3 > 0) {
                dataDestination.write(",\n");
            }
            dataDestination.setStripLeadingWhitespace();
            dataDestination.write(this.getTaskArgument(n3).getArgumentName());
            ++n3;
        }
        if (this.getTaskArgumentCount() > 0) {
            dataDestination.write(",\n");
        }
        dataDestination.write("  ( ");
        dataDestination.write("_TDL_MaximumActivates");
        dataDestination.write(" != 0 )\n?   ");
        dataDestination.write("_TDL_MaximumActivates");
        DataConstraint dataConstraint = this.findConstraint(19);
        if (dataConstraint != null && dataDestination.getEnableLineMacros()) {
            dataDestination.setUsingTdlFileName(true);
            dataDestination.makeNextLineNumber(dataConstraint.getNumericExpression().getLineNumber());
        }
        dataDestination.write("\n: ( ");
        if (dataConstraint != null) {
            n2 += dataDestination.indentToCurrentColumn();
            dataDestination.setStripLeadingWhitespace();
            dataDestination.setPersistentlyStripLeadingSpaces(true);
            dataConstraint.getNumericExpression().generate(dataDestination, 0);
            dataDestination.setPersistentlyStripLeadingSpaces(false);
            if (dataDestination.getEnableLineMacros()) {
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n");
            }
        } else {
            dataDestination.write("_TDL_MAXIMUM_ACTIVATES");
        }
        dataDestination.write(" )");
        dataDestination.removeIndent(n2);
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write(" );\n}\n\n\n");
    }

    public void generateArgumentsDeclarationCode(boolean bl, DataDestination dataDestination) {
        if (this.getTaskArgumentCount() > 0) {
            dataDestination.setUsingTdlFileName(true);
        }
        int n = 0;
        while (n < this.getTaskArgumentCount()) {
            dataDestination.makeNextLineNumber(this.getTaskArgument(n).getLineNumber());
            dataDestination.write("\n");
            dataDestination.setStripLeadingWhitespace();
            this.getTaskArgument(n).generate(dataDestination, 202);
            dataDestination.write(" = this -> ");
            dataDestination.write(this.getTaskArgument(n).getArgumentName());
            if (bl) {
                dataDestination.write(";   ");
                dataDestination.write("_TDL_MARKUSED");
                dataDestination.write(" ( ");
                dataDestination.write(this.getTaskArgument(n).getArgumentName());
                dataDestination.write(" )");
            }
            dataDestination.write(SEMICOLON);
            ++n;
        }
        if (this.getTaskArgumentCount() > 0 || this.getTaskType() == 5) {
            dataDestination.setUsingTdlFileName(false);
            dataDestination.write("\n");
        }
        if (this.getTaskType() == 5) {
            dataDestination.write("_TDL_Exception_");
            dataDestination.write(this.getHandlesException());
            dataDestination.write(" & ");
            dataDestination.write(this.getHandlesException());
            dataDestination.addIndent(2 * DataComponent.STANDARD_INDENT);
            dataDestination.write("\n= * ( (");
            dataDestination.write("_TDL_Exception_");
            dataDestination.write(this.getHandlesException());
            dataDestination.write(" *)\n      ");
            dataDestination.write("TCM_FailureDataRefCount ( _TDL_ENCLOSING_TASK )");
            dataDestination.write(" );\n");
            dataDestination.removeIndent(2 * DataComponent.STANDARD_INDENT);
            dataDestination.write("_TDL_MARKUSED");
            dataDestination.write(" ( ");
            dataDestination.write(this.getHandlesException());
            dataDestination.write(" );\n");
        }
    }

    public void generateHandleManagerDeclaration(DataDestination dataDestination, DataVector dataVector, DataVector dataVector2, DataHashtable dataHashtable) {
        if (dataVector == null) {
            System.err.println("[DataTaskDefinition:generateHandleManagerDeclaration] Error:  theNonUniqueNames is null.  Unable to generate HandleManager declaration.");
            return;
        }
        if (dataVector2 == null) {
            System.err.println("[DataTaskDefinition:generateHandleManagerDeclaration] Warning: theStatements is null.  Regenerating...");
            dataVector2 = this.generateStatementsVector();
        }
        if (dataHashtable == null) {
            System.err.println("[DataTaskDefinition:generateHandleManagerDeclaration] Error:  theOnAgentHashtable is null.  Unable to generate HandleManager declaration.");
            return;
        }
        int n = 0;
        while (n < dataVector2.count()) {
            if (((DataStatement)dataVector2.elementAt(n)).isSpawnRelatedStatement()) break;
            ++n;
        }
        if (n >= dataVector2.count()) {
            return;
        }
        dataDestination.write("\n");
        dataDestination.write("_TDL_HandleManager");
        dataDestination.write("   ");
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" ( \"");
        dataDestination.write(this.getTaskName());
        dataDestination.write("\", ");
        dataDestination.write("_TDL_ENCLOSING_TASK");
        dataDestination.write(" );\n");
        n = 0;
        while (n < dataVector2.count()) {
            if (dataVector2.elementAt(n) instanceof DataSpawnTask || dataVector2.elementAt(n) instanceof DataWithDoStatement) {
                int n2;
                DataStatement dataStatement = (DataStatement)dataVector2.elementAt(n);
                int n3 = 1;
                if (dataStatement instanceof DataSpawnTask && !dataVector.contains(((DataSpawnTask)dataStatement).getTaskName())) {
                    ++n3;
                }
                DataLabelStatement dataLabelStatement = dataStatement.getLabel();
                while (dataLabelStatement != null) {
                    if (!(!dataLabelStatement.hasId() || dataStatement instanceof DataSpawnTask && ((DataSpawnTask)dataStatement).getTaskName().equals(dataLabelStatement.getId()) || dataVector.contains(dataLabelStatement.getId()))) {
                        ++n3;
                    }
                    dataLabelStatement = dataLabelStatement.getLabel();
                }
                dataDestination.write("_TDL_SpawnedTasks");
                int n4 = dataDestination.indentToCurrentColumn();
                dataDestination.write(" .  ");
                if (dataStatement instanceof DataSpawnTask) {
                    DataSpawnTask dataSpawnTask = (DataSpawnTask)dataStatement;
                    if (dataHashtable.containsKey(dataSpawnTask.getTaskName())) {
                        if (DataStatement.hasNonconditionalConstraintOfType(dataSpawnTask, 25, dataVector2)) {
                            dataDestination.write("addSpawnStatement_Distributed");
                        } else {
                            dataDestination.write("addSpawnStatement_Either");
                        }
                    } else {
                        dataDestination.write("addSpawnStatement_Local");
                    }
                } else {
                    dataDestination.write("addWithStatement");
                }
                dataDestination.write(" ( ");
                if (dataStatement instanceof DataSpawnTask) {
                    dataDestination.write("_TDL_Allocate_");
                    dataDestination.write(((DataSpawnTask)dataStatement).getTaskName());
                    dataDestination.write(", ");
                }
                dataDestination.write("" + n3);
                dataDestination.write(" )");
                if (dataStatement instanceof DataSpawnTask && (n2 = DataConstraint.getLastIndexOfConstraintOfType(28, (DataSpawnTask)dataStatement)) >= 0) {
                    dataDestination.write("\n -> ");
                    dataDestination.write("setTcmTaskTreeNodeName");
                    dataDestination.write(" ( ");
                    dataDestination.setUsingTdlFileName(true);
                    dataDestination.makeNextLineNumber(((DataSpawnTask)dataStatement).getConstraint(n2).getTcmTaskTreeNameExpression());
                    if (dataDestination.getEnableLineMacros()) {
                        dataDestination.write("\n");
                    }
                    ((DataSpawnTask)dataStatement).getConstraint(n2).getTcmTaskTreeNameExpression().generate(dataDestination, 0);
                    dataDestination.setUsingTdlFileName(false);
                    dataDestination.write(" )");
                }
                dataDestination.write("\n -> ");
                dataDestination.write("addName");
                dataDestination.write(" ( \"");
                if (dataStatement instanceof DataSpawnTask) {
                    dataDestination.write(this.getIdentifierForSubtask((DataSpawnTask)dataStatement));
                } else {
                    dataDestination.write(this.getIdentifierForBranch((DataWithDoStatement)dataStatement));
                }
                dataDestination.write("\" )");
                if (dataStatement instanceof DataSpawnTask && !dataVector.contains(((DataSpawnTask)dataStatement).getTaskName())) {
                    dataDestination.write("\n -> ");
                    dataDestination.write("addName");
                    dataDestination.write(" ( \"");
                    dataDestination.write(((DataSpawnTask)dataStatement).getTaskName());
                    dataDestination.write("\" )");
                }
                dataLabelStatement = dataStatement.getLabel();
                while (dataLabelStatement != null) {
                    if (!(!dataLabelStatement.hasId() || dataStatement instanceof DataSpawnTask && ((DataSpawnTask)dataStatement).getTaskName().equals(dataLabelStatement.getId()) || dataVector.contains(dataLabelStatement.getId()))) {
                        dataDestination.write("\n -> ");
                        dataDestination.write("addName");
                        dataDestination.write(" ( \"");
                        dataDestination.write(dataLabelStatement.getId());
                        dataDestination.write("\" )");
                    }
                    dataLabelStatement = dataLabelStatement.getLabel();
                }
                DataComponent dataComponent = dataStatement.getParent();
                while (dataComponent != null) {
                    if (dataComponent instanceof DataWithDoStatement) {
                        dataDestination.write("\n -> ");
                        dataDestination.write("setDefaultWithParent");
                        dataDestination.write(" ( \"");
                        dataDestination.write(this.getIdentifierForBranch((DataWithDoStatement)dataComponent));
                        dataDestination.write("\" )");
                        break;
                    }
                    dataComponent = dataComponent.getParent();
                }
                dataDestination.removeIndent(n4);
                dataDestination.write(";\n\n\n");
            }
            ++n;
        }
    }

    public DataVector generateStatementsVector() {
        DataStatement.getChildrenInFlatVector(this.statementsVector, this.getTaskBody());
        return this.statementsVector;
    }

    public DataVector validateTaskForCxxGeneration() throws CompilationException {
        DataDestinationStringBuffer dataDestinationStringBuffer = new DataDestinationStringBuffer();
        DataValidateCodeReturnValue dataValidateCodeReturnValue = new DataValidateCodeReturnValue(dataDestinationStringBuffer);
        DataVector dataVector = this.validateTaskForCxxGeneration(0, dataValidateCodeReturnValue);
        if (dataValidateCodeReturnValue.hasErrors()) {
            throw new CompilationException(dataDestinationStringBuffer.getString() + "\n\n" + dataValidateCodeReturnValue.toString());
        }
        return dataVector;
    }

    public DataVector validateTaskForCxxGeneration(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        DataLabelStatement dataLabelStatement;
        String string;
        int n2;
        DataConstrainedObject dataConstrainedObject;
        DataStatement dataStatement;
        DataVector dataVector = this.__nonUniqueNamesVector;
        DataVector dataVector2 = this.__taskRefsInWiths;
        DataVector dataVector3 = new DataVector(1000);
        DataHashtable dataHashtable = this.__labelHashtable;
        DataHashtable dataHashtable2 = this.__spawnHashtable;
        DataHashtable dataHashtable3 = this.__withsToComponents;
        DataHashtable dataHashtable4 = new DataHashtable();
        DataHashtable dataHashtable5 = this.__onAgentHashtable;
        DataHashtable dataHashtable6 = new DataHashtable();
        DataHashtable dataHashtable7 = new DataHashtable();
        DataHashtable dataHashtable8 = new DataHashtable();
        String string2 = null;
        String string3 = null;
        dataVector.removeAllElements();
        dataVector2.removeAllElements();
        dataHashtable.clear();
        dataHashtable2.clear();
        dataHashtable3.clear();
        DataVector dataVector4 = this.generateStatementsVector();
        if (this.getTaskBody() == null) {
            return dataVector;
        }
        int n3 = 0;
        while (n3 < dataVector4.count()) {
            dataStatement = (DataStatement)dataVector4.elementAt(n3);
            if (dataStatement instanceof DataConstrainedObject) {
                dataConstrainedObject = (DataConstrainedObject)((Object)dataStatement);
                n2 = 0;
                while (n2 < dataConstrainedObject.getConstraintCount()) {
                    if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && !dataHashtable3.containsKey(string = dataConstrainedObject.getConstraint(n2).getEventTagTask())) {
                        dataHashtable3.put(string, dataConstrainedObject.getConstraint(n2));
                        dataVector2.addElement(string);
                    }
                    ++n2;
                }
            }
            if (dataStatement instanceof DataConstraintStatement && !dataHashtable3.containsKey(string = ((DataConstraintStatement)dataStatement).getTaskTag()) && !string.equals("THIS")) {
                dataHashtable3.put(string, dataStatement);
                dataVector2.addElement(string);
            }
            if (dataStatement instanceof DataBindTaskStatement) {
                dataHashtable4.put(((DataBindTaskStatement)dataStatement).getTaskNameToBind(), dataStatement);
            }
            if (dataStatement instanceof DataWithDoStatement) {
                dataLabelStatement = dataStatement.getLabel();
                while (dataLabelStatement != null) {
                    if (dataLabelStatement.hasId()) {
                        dataHashtable6.put(dataLabelStatement.getId(), dataStatement);
                    }
                    dataLabelStatement = dataLabelStatement.getLabel();
                }
            }
            if (dataStatement instanceof DataSpawnTask) {
                dataLabelStatement = dataStatement.getLabel();
                while (dataLabelStatement != null) {
                    if (dataLabelStatement.hasId()) {
                        dataHashtable7.put(dataLabelStatement.getId(), dataStatement);
                    }
                    dataLabelStatement = dataLabelStatement.getLabel();
                }
                dataHashtable7.put(((DataSpawnTask)dataStatement).getTaskName(), dataStatement);
            }
            ++n3;
        }
        dataHashtable8.clear();
        n3 = 0;
        while (n3 < dataVector4.count()) {
            block74: {
                dataStatement = (DataStatement)dataVector4.elementAt(n3);
                if (!(dataStatement instanceof DataConstrainedObject)) break block74;
                dataConstrainedObject = (DataConstrainedObject)((Object)dataStatement);
                n2 = 0;
                while (n2 < dataConstrainedObject.getConstraintCount()) {
                    block75: {
                        block76: {
                            block78: {
                                block77: {
                                    if (dataConstrainedObject.getConstraint(n2).getConstraintType() != 25) break block75;
                                    if (!(dataStatement instanceof DataConstraintStatement)) break block76;
                                    string = ((DataConstraintStatement)dataStatement).getTaskTag();
                                    if (!dataHashtable6.containsKey(string)) break block77;
                                    dataStatement = (DataStatement)dataHashtable6.get(string);
                                    break block78;
                                }
                                if (!dataHashtable7.containsKey(string)) break block75;
                                dataStatement = (DataStatement)dataHashtable7.get(string);
                            }
                            if (dataHashtable8.containsKey(dataStatement)) break block75;
                        }
                        if (dataStatement instanceof DataSpawnTask || dataStatement instanceof DataWithDoStatement) {
                            DataStatement.getChildrenInFlatVector(dataVector3, dataStatement);
                            int n4 = 0;
                            while (n4 < dataVector3.count()) {
                                dataStatement = (DataStatement)dataVector3.elementAt(n4);
                                if (dataStatement instanceof DataSpawnTask) {
                                    dataLabelStatement = dataStatement.getLabel();
                                    while (dataLabelStatement != null) {
                                        if (dataLabelStatement.hasId()) {
                                            dataHashtable5.put(dataLabelStatement.getId(), new Integer(n3));
                                        }
                                        dataLabelStatement = dataLabelStatement.getLabel();
                                    }
                                    dataHashtable5.put(((DataSpawnTask)dataStatement).getTaskName(), new Integer(n3));
                                }
                                ++n4;
                            }
                            break;
                        }
                        System.err.println("[DataTaskDefinition:validateTaskForCxxGeneration]  Warning:  Found DataConstrainedObject that is *NOT* a DataConstraintStatement, DataSpawnTask, or DataWithDoStatement:  " + dataStatement.toString());
                        break;
                    }
                    ++n2;
                }
            }
            if ((dataStatement = (DataStatement)dataVector4.elementAt(n3)) instanceof DataSpawnTask || dataStatement instanceof DataWithDoStatement) {
                dataHashtable8.put(dataStatement, dataStatement);
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < dataVector4.count()) {
            boolean bl;
            dataStatement = (DataStatement)dataVector4.elementAt(n3);
            DataSpawnTask dataSpawnTask = null;
            if (dataStatement instanceof DataSpawnTask) {
                dataSpawnTask = (DataSpawnTask)dataStatement;
                if (dataHashtable.containsKey(dataSpawnTask.getTaskName())) {
                    dataVector.addElement(dataSpawnTask.getTaskName());
                    if (dataHashtable3.containsKey(dataSpawnTask.getTaskName())) {
                        dataValidateCodeReturnValue.addError((DataComponent)dataHashtable3.get(dataSpawnTask.getTaskName())).write("Ambiguous reference for name \"").write(dataSpawnTask.getTaskName()).write("\". (Matches LABEL at line ").write(((DataStatement)dataHashtable.get(dataSpawnTask.getTaskName())).getLineNumberString()).write(" and SPAWN at line ").write(dataSpawnTask.getLineNumberString()).write(".)\n");
                    }
                }
                if (!dataHashtable2.containsKey(dataSpawnTask.getTaskName())) {
                    dataHashtable2.put(dataSpawnTask.getTaskName(), dataSpawnTask);
                } else {
                    dataVector.addElement(dataSpawnTask.getTaskName());
                    if (dataHashtable3.containsKey(dataSpawnTask.getTaskName())) {
                        dataValidateCodeReturnValue.addError((DataComponent)dataHashtable3.get(dataSpawnTask.getTaskName())).write("Ambiguous reference for name \"").write(dataSpawnTask.getTaskName()).write("\". (Matches SPAWN at line ").write(((DataStatement)dataHashtable2.get(dataSpawnTask.getTaskName())).getLineNumberString()).write(" and SPAWN at line ").write(dataSpawnTask.getLineNumberString()).write(".)\n");
                    }
                }
            }
            if (dataStatement instanceof DataBindTaskStatement) {
                DataBindTaskStatement dataBindTaskStatement = (DataBindTaskStatement)dataStatement;
                if (dataHashtable2.containsKey(dataBindTaskStatement.getTaskNameToBind())) {
                    dataValidateCodeReturnValue.addError(dataBindTaskStatement).write("Ambiguous reference for name \"").write(dataBindTaskStatement.getTaskNameToBind()).write("\".  (Matches SPAWN at line ").write(((DataStatement)dataHashtable2.get(dataBindTaskStatement.getTaskNameToBind())).getLineNumberString()).write(".)\n");
                } else if (dataHashtable.containsKey(dataBindTaskStatement.getTaskNameToBind())) {
                    if (!(dataHashtable.get(dataBindTaskStatement.getTaskNameToBind()) instanceof DataBindTaskStatement)) {
                        dataValidateCodeReturnValue.addError(dataBindTaskStatement).write("Ambiguous reference for name \"").write(dataBindTaskStatement.getTaskNameToBind()).write("\".  (Matches LABEL at line ").write(((DataStatement)dataHashtable.get(dataBindTaskStatement.getTaskNameToBind())).getLineNumberString()).write(".)\n");
                    }
                } else {
                    dataHashtable.put(dataBindTaskStatement.getTaskNameToBind(), dataStatement);
                }
            }
            dataLabelStatement = dataStatement.getLabel();
            while (dataLabelStatement != null) {
                if (dataLabelStatement.hasId()) {
                    if (dataHashtable2.containsKey(dataLabelStatement.getId()) && (dataSpawnTask == null || !dataSpawnTask.getTaskName().equals(dataLabelStatement.getId()) || dataVector.contains(dataLabelStatement.getId()))) {
                        dataVector.addElement(dataLabelStatement.getId());
                        if (dataHashtable3.containsKey(dataLabelStatement.getId())) {
                            dataValidateCodeReturnValue.addError((DataComponent)dataHashtable3.get(dataLabelStatement.getId())).write("Ambiguous reference for name \"").write(dataLabelStatement.getId()).write("\". (Matches SPAWN at line ").write(((DataSpawnTask)dataHashtable2.get(dataLabelStatement.getId())).getLineNumberString()).write(" and LABEL at line ").write(dataLabelStatement.getLineNumberString()).write(".)\n");
                        }
                    }
                    if (!dataHashtable.containsKey(dataLabelStatement.getId())) {
                        dataHashtable.put(dataLabelStatement.getId(), dataStatement);
                    } else {
                        dataVector.addElement(dataLabelStatement.getId());
                        if (dataHashtable3.containsKey(dataLabelStatement.getId())) {
                            dataValidateCodeReturnValue.addError((DataComponent)dataHashtable3.get(dataLabelStatement.getId())).write("Ambiguous reference for name \"").write(dataLabelStatement.getId()).write("\". (Matches LABEL at line ").write(((DataStatement)dataHashtable.get(dataLabelStatement.getId())).getLineNumberString()).write(" and LABEL at line ").write(dataLabelStatement.getLineNumberString()).write(".)\n");
                        } else {
                            dataValidateCodeReturnValue.addError(dataLabelStatement).write("LABEL \"").write(dataLabelStatement.getId()).write("\" duplicates LABEL at line ").write(((DataStatement)dataHashtable.get(dataLabelStatement.getId())).getLineNumberString()).write(".\n");
                        }
                    }
                    if (dataHashtable3.containsKey(dataLabelStatement.getId()) && !(dataStatement instanceof DataSpawnTask) && !(dataStatement instanceof DataWithDoStatement)) {
                        dataValidateCodeReturnValue.addError(dataLabelStatement).write("LABEL \"").write(dataLabelStatement.getId()).write("\" is used in constraint at line ").write(((DataComponent)dataHashtable3.get(dataLabelStatement.getId())).getLineNumberString()).write(", but does not refer to a SPAWN or WITH statement.\n");
                    }
                }
                dataLabelStatement = dataLabelStatement.getLabel();
            }
            if (dataStatement instanceof DataSpawnTask) {
                boolean bl2 = false;
                bl = false;
                DataComponent dataComponent = dataStatement;
                while (dataComponent != null) {
                    if (dataComponent instanceof DataConstrainedObject) {
                        dataConstrainedObject = (DataConstrainedObject)((Object)dataComponent);
                        n2 = 0;
                        while (n2 < dataConstrainedObject.getConstraintCount()) {
                            if (dataConstrainedObject.getConstraint(n2).getConstraintType() == 7) {
                                bl2 = true;
                                string2 = dataConstrainedObject.getConstraint(n2).getLineNumberString();
                            }
                            if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && !dataHashtable2.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && !dataHashtable.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask())) {
                                bl = true;
                                string3 = dataConstrainedObject.getConstraint(n2).getLineNumberString();
                            }
                            ++n2;
                        }
                    }
                    dataComponent = dataComponent.getParent();
                }
                if (bl2 && bl) {
                    dataValidateCodeReturnValue.addError(dataStatement).write("WAIT constraint (line ").write(string2).write(") conflicts with Future-Reference (line ").write(string3).write(").\n");
                }
            }
            if (dataStatement instanceof DataConstraintStatement) {
                DataConstraintStatement dataConstraintStatement = (DataConstraintStatement)dataStatement;
                bl = !dataHashtable2.containsKey(dataConstraintStatement.getTaskTag()) && !dataHashtable.containsKey(dataConstraintStatement.getTaskTag());
                switch (dataConstraintStatement.getConstraint().getConstraintType()) {
                    case 7: {
                        if (!bl) break;
                        dataValidateCodeReturnValue.addError(dataStatement).write("WAIT constraint applied against Future-Reference '").write(dataConstraintStatement.getTaskTag()).write("'.\n");
                        break;
                    }
                    case 6: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 9: 
                    case 10: {
                        if (bl) break;
                        dataValidateCodeReturnValue.addError(dataStatement).write("Constraint [").write(dataConstraintStatement.getConstraint().getConstraintName()).write("] applied against Task(s) ('").write(dataConstraintStatement.getTaskTag()).write("') that are already running.\n");
                        break;
                    }
                    case 22: 
                    case 23: {
                        if (bl) break;
                        dataValidateCodeReturnValue.addWarning(dataStatement).write("Constraint [").write(dataConstraintStatement.getConstraint().getConstraintName()).write("] applied against Task(s) ('").write(dataConstraintStatement.getTaskTag()).write("') that are already running.  ").write("(Results are unpredictable.)\n");
                        break;
                    }
                    case 25: {
                        if (dataHashtable4.containsKey(dataConstraintStatement.getTaskTag())) {
                            dataValidateCodeReturnValue.addError(dataStatement).write("Distributed '");
                            dataValidateCodeReturnValue.getDataDestination().setStripLeadingWhitespace();
                            dataConstraintStatement.getConstraint().generate(dataValidateCodeReturnValue.getDataDestination(), 0);
                            dataValidateCodeReturnValue.getDataDestination().write("' Constraint applied against ").write("TDL_BIND-accessed Task ('").write(dataConstraintStatement.getTaskTag()).write("').\n");
                            break;
                        }
                        if (bl) break;
                        dataValidateCodeReturnValue.addError(dataStatement).write("Distributed '");
                        dataValidateCodeReturnValue.getDataDestination().setStripLeadingWhitespace();
                        dataConstraintStatement.getConstraint().generate(dataValidateCodeReturnValue.getDataDestination(), 0);
                        dataValidateCodeReturnValue.getDataDestination().write("' Constraint applied against ").write("Task(s) ('").write(dataConstraintStatement.getTaskTag()).write("') that are already running.\n");
                        break;
                    }
                    default: {
                        if (bl) break;
                        dataValidateCodeReturnValue.addWarning(dataStatement).write("Constraint [").write(dataConstraintStatement.getConstraint().getConstraintName()).write("] applied against Task(s) ('").write(dataConstraintStatement.getTaskTag()).write("') that are already running.  (Uncertain if ").write("this is a problem or not.  Possible TDLC ").write(" internal error.)\n");
                    }
                }
            }
            if (dataStatement instanceof DataConstrainedObject) {
                dataConstrainedObject = (DataConstrainedObject)((Object)dataStatement);
                n2 = 0;
                while (n2 < dataConstrainedObject.getConstraintCount()) {
                    if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && dataHashtable7.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && (!dataHashtable2.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && !dataHashtable.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) || this.checkSharedIterationParentIndexProblem(dataStatement, dataConstrainedObject.getConstraint(n2), (DataComponent)dataHashtable7.get(dataConstrainedObject.getConstraint(n2).getEventTagTask()), dataValidateCodeReturnValue)) && this.getIterationParentCount((DataComponent)dataHashtable7.get(dataConstrainedObject.getConstraint(n2).getEventTagTask())) > 0 && (!dataConstrainedObject.getConstraint(n2).getHasEventTagTaskIndexes() || this.getIterationParentCount((DataComponent)dataHashtable7.get(dataConstrainedObject.getConstraint(n2).getEventTagTask())) > dataConstrainedObject.getConstraint(n2).getEventTagTaskIndexes().length)) {
                        dataValidateCodeReturnValue.addError(dataConstrainedObject.getConstraint(n2)).write("Constraint contains a Future-Reference on an ").write("Iteration-Set of Spawn Statements.  ").write("(This is currently unimplemented.)\n");
                    } else if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && dataHashtable6.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && (!dataHashtable2.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && !dataHashtable.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) || this.checkSharedIterationParentIndexProblem(dataStatement, dataConstrainedObject.getConstraint(n2), (DataComponent)dataHashtable6.get(dataConstrainedObject.getConstraint(n2).getEventTagTask()), dataValidateCodeReturnValue)) && this.getIterationParentCount((DataComponent)dataHashtable6.get(dataConstrainedObject.getConstraint(n2).getEventTagTask())) > 0 && (!dataConstrainedObject.getConstraint(n2).getHasEventTagTaskIndexes() || this.getIterationParentCount((DataComponent)dataHashtable6.get(dataConstrainedObject.getConstraint(n2).getEventTagTask())) > dataConstrainedObject.getConstraint(n2).getEventTagTaskIndexes().length)) {
                        dataValidateCodeReturnValue.addError(dataConstrainedObject.getConstraint(n2)).write("Constraint contains a Future-Reference on an ").write("Iteration-Set of With Statements.  ").write("(This is currently unimplemented.)\n");
                    } else if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && !dataHashtable2.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && !dataHashtable.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask()) && dataHashtable6.containsKey(dataConstrainedObject.getConstraint(n2).getEventTagTask())) {
                        dataValidateCodeReturnValue.addError(dataConstrainedObject.getConstraint(n2)).write("Constraint contains a Future-Reference on a WITH ").write("statement.  (This is currently unimplemented.)\n");
                    }
                    ++n2;
                }
            }
            if (dataStatement instanceof DataConstrainedObject) {
                dataConstrainedObject = (DataConstrainedObject)((Object)dataStatement);
                n2 = 0;
                while (n2 < dataConstrainedObject.getConstraintCount()) {
                    if (dataConstrainedObject.getConstraint(n2).getHasNonStandardEventTagTask() && dataHashtable5.containsKey(string = dataConstrainedObject.getConstraint(n2).getEventTagTask()) && (Integer)dataHashtable5.get(string) > n3) {
                        dataValidateCodeReturnValue.addError(dataConstrainedObject.getConstraint(n2)).write("Constraint contains a future reference ['").write(string).write("'] to a Distributed Task prior to that Task''s ").write("final ON-AGENT constraint [line ").write(((DataStatement)dataVector4.elementAt((Integer)dataHashtable5.get(string))).getLineNumberString()).write("].  Future references prior to ").write("the final ON-AGENT constraint are not currently ").write("supported.  Recommended workaround is to utilize ").write("an ON-AGENT Constraint-Statement for Task '").write(string).write("' prior to this statement.\n");
                    }
                    ++n2;
                }
            }
            if (n3 > 0) {
                dataStatement.runOnSubcomponentFraction("TDL_REF", this, new RunOnSubcomponent_TdlRefDistributedData(n3, dataVector4, dataHashtable5, dataValidateCodeReturnValue));
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < dataVector2.count()) {
            string = (String)dataVector2.elementAt(n2);
            if (!dataHashtable2.containsKey(string) && !dataHashtable.containsKey(string)) {
                dataValidateCodeReturnValue.addError((DataComponent)dataHashtable3.get(string)).write("Unknown reference for name '").write(string).write("'.\n");
            }
            ++n2;
        }
        return dataVector;
    }

    public void foundSubcomponentMatch(String string, String string2, int n, DataComponent dataComponent, int n2, Object object) {
        String string3;
        if (!string.equals("TDL_REF")) {
            System.err.println("[DataTaskDefinition:foundSubcomponentMatch]  Error:  Unexpected search string:  \"" + string + "\".");
            return;
        }
        int n3 = ((RunOnSubcomponent_TdlRefDistributedData)object).getStatementsIndex();
        DataVector dataVector = ((RunOnSubcomponent_TdlRefDistributedData)object).getStatements();
        DataHashtable dataHashtable = ((RunOnSubcomponent_TdlRefDistributedData)object).getOnAgentHashtable();
        DataValidateCodeReturnValue dataValidateCodeReturnValue = ((RunOnSubcomponent_TdlRefDistributedData)object).getReturnValue();
        string2 = string2.substring(n);
        if (dataComponent != null) {
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append(string2);
            ++n2;
            while (n2 < dataComponent.getSubcomponentsCount()) {
                stringBuffer.append(dataComponent.getSubcomponent(n2).toString());
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        TDLParser.reinitParser(string2);
        try {
            TDLParser.getParser();
            string3 = TDLParser.parseTdlRefTaskName();
        }
        catch (Throwable throwable) {
            System.err.println("[DataTaskDefinition:foundSubcomponentMatch]  Error:  Unexpected error encountered while trying to re-parse out TDL_REF Task-name:  " + throwable.toString());
            return;
        }
        if (!string3.equals("THIS") && dataHashtable.containsKey(string3) && (Integer)dataHashtable.get(string3) >= n3) {
            dataValidateCodeReturnValue.addError((DataStatement)dataVector.elementAt(n3)).write("TDL_REF(").write(string3).write(") contains a future reference [\"").write(string3).write("\"] to a Distributed Task prior to that Task''s ").write("final ON-AGENT constraint [line ").write(((DataStatement)dataVector.elementAt((Integer)dataHashtable.get(string3))).getLineNumberString()).write("].  Future references prior to ").write("the final ON-AGENT constraint are not currently ").write("supported.  Recommended workaround is to utilize ").write("an ON-AGENT Constraint-Statement for Task \"").write(string3).write("\" prior to this statement.\n");
        }
    }

    public DataVector getCachedStatementsVector() {
        return this.statementsVector;
    }

    public DataHashtable getCachedOnAgentHashtable() {
        return this.__onAgentHashtable;
    }

    public DataComponent getDataComponentWithName(String string) {
        if (this.__spawnHashtable.containsKey(string)) {
            return (DataComponent)this.__spawnHashtable.get(string);
        }
        if (this.__labelHashtable.containsKey(string)) {
            return (DataComponent)this.__labelHashtable.get(string);
        }
        return null;
    }

    public int getIterationParentCount(DataComponent dataComponent) throws CompilationException {
        int n = 0;
        DataComponent dataComponent2 = dataComponent;
        while (dataComponent2 != null) {
            if (dataComponent2 instanceof DataIterationStatement) {
                ++n;
            }
            if (dataComponent2 instanceof DataTaskDefinition) break;
            dataComponent2 = dataComponent2.getParent();
        }
        if (dataComponent2 == null) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  Programmer Error:  Unable to find tag-Task-DataComponent's " + "DataTaskDefinition ancestor.");
        }
        return n;
    }

    protected boolean checkSharedIterationParentIndexProblem(DataComponent dataComponent, DataConstraint dataConstraint, DataComponent dataComponent2, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        int n = 0;
        DataComponent dataComponent3 = dataComponent;
        while (dataComponent3 != null) {
            n = 0;
            if (dataComponent3 instanceof DataTaskDefinition) break;
            DataComponent dataComponent4 = dataComponent2;
            while (dataComponent4 != null) {
                if (dataComponent4 == dataComponent3) break;
                if (dataComponent4 instanceof DataIterationStatement) {
                    ++n;
                }
                if (dataComponent4 instanceof DataTaskDefinition) break;
                dataComponent4 = dataComponent4.getParent();
            }
            if (dataComponent4 == null) {
                throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  PROGRAMMER Error:  Unable to find tag-Task-DataComponent's " + "DataTaskDefinition ancestor.");
            }
            if (dataComponent4 == dataComponent3) break;
            dataComponent3 = dataComponent3.getParent();
        }
        if (dataComponent3 == null) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  PROGRAMMER ERROR:  Unable to find DataComponent's " + "DataTaskDefinition ancestor.");
        }
        if (dataComponent3 instanceof DataTaskDefinition) {
            return false;
        }
        return this.getIterationParentCount(dataComponent2) - n > (dataConstraint.getHasEventTagTaskIndexes() ? dataConstraint.getEventTagTaskIndexes().length : 0);
    }

    public String getIdentifierForSubtask(DataSpawnTask dataSpawnTask) {
        DataVector dataVector = this.getCachedStatementsVector();
        int n = 0;
        int n2 = 0;
        while (n2 < dataVector.count()) {
            if (dataVector.elementAt(n2) == dataSpawnTask) break;
            ++n2;
        }
        if (n2 >= dataVector.count()) {
            System.err.println("[DataTaskDefinition:getIdentifierForSubtask]  Error:  theDataSpawnTask (" + dataSpawnTask.getTaskName() + ") is not inside this Task.");
            return dataSpawnTask.getTaskName() + "_0x" + Integer.toHexString(dataSpawnTask.hashCode());
        }
        --n2;
        while (n2 >= 0) {
            if (dataVector.elementAt(n2) instanceof DataSpawnTask && ((DataSpawnTask)dataVector.elementAt(n2)).getTaskName().equals(dataSpawnTask.getTaskName())) {
                ++n;
            }
            --n2;
        }
        return dataSpawnTask.getTaskName() + "-" + n;
    }

    public String getIdentifierForBranch(DataWithDoStatement dataWithDoStatement) {
        DataVector dataVector = this.getCachedStatementsVector();
        int n = 0;
        int n2 = 0;
        while (n2 < dataVector.count()) {
            if (dataVector.elementAt(n2) == dataWithDoStatement) break;
            ++n2;
        }
        if (n2 >= dataVector.count()) {
            System.err.println("[DataTaskDefinition:getIdentifierForBranch]  Error:  theDataWithDoStatement is not inside this Task:" + dataWithDoStatement);
            return "WithDo-_0x" + Integer.toHexString(dataWithDoStatement.hashCode());
        }
        --n2;
        while (n2 >= 0) {
            if (dataVector.elementAt(n2) instanceof DataWithDoStatement) {
                ++n;
            }
            --n2;
        }
        return "WithDo-" + n;
    }

    public int getIdentifierForConstraint(DataConstraint dataConstraint) {
        return this.getIdentifierForConstraint(dataConstraint, false);
    }

    public int getIdentifierForConstraint(DataConstraint dataConstraint, boolean bl) {
        DataVector dataVector = this.getCachedStatementsVector();
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < dataVector.count()) {
            if (dataVector.elementAt(n3) instanceof DataConstrainedObject) {
                n2 += ((DataConstrainedObject)dataVector.elementAt(n3)).getConstraintCount();
                if (!bl2) {
                    int n4 = 0;
                    while (n4 < ((DataConstrainedObject)dataVector.elementAt(n3)).getConstraintCount()) {
                        if (((DataConstrainedObject)dataVector.elementAt(n3)).getConstraint(n4) == dataConstraint) {
                            bl2 = true;
                            break;
                        }
                        ++n;
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        if (!bl2) {
            return -1;
        }
        if (!bl) {
            return n;
        }
        return n2 - n;
    }
}

