/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class DataTaskArgument
extends DataComponent {
    public static final int IN_DIRECTION = 0;
    public static final int OUT_DIRECTION = 1;
    public static final int INOUT_DIRECTION = 2;
    public static final int NO_DIRECTION = 3;
    public static final int DEFAULT_DIRECTION = 3;
    public static final int INVALID_DIRECTION = -1;
    protected static final String[] ARGUMENT_TYPES = new String[]{"IN", "OUT", "INOUT", ""};
    public static final int INT1 = 0;
    public static final int INT2 = 1;
    public static final int INT4 = 2;
    public static final int INT8 = 3;
    public static final int U_INT1 = 4;
    public static final int U_INT2 = 5;
    public static final int U_INT4 = 6;
    public static final int U_INT8 = 7;
    public static final int FLOAT = 8;
    public static final int DOUBLE = 9;
    public static final int BOOLEAN = 10;
    public static final int STRING = 11;
    public static final int IDENTIFIER = 12;
    public static final int STRUCT = 13;
    public static final int ENUM = 14;
    public static final int DATA_DISTRIBUTED_STRUCT = 15;
    public static final int DATA_DISTRIBUTED_ENUM = 16;
    public static final int FIRST_TYPE = 0;
    public static final int LAST_TYPE = 16;
    public static final String[] DISTRIBUTED_TYPE_STRINGS = new String[]{"int1", "int2", "int4", "int8", "u_int1", "u_int2", "u_int4", "u_int8", "float", "double", "BOOLEAN", "STRING", "IDENTIFIER", "struct", "enum", "DataDistributedStruct", "DataDistributedEnum"};
    public static final String[] DISTRIBUTED_ARGUMENT_FORMAT_STRINGS = new String[]{"char", "short", "int", null, "uchar", "ushort", "uint", null, "float", "double", "Boolean", "string"};
    public static final String PERSISTENT = "PERSISTENT";
    public static final String ARGUMENT_DIRECTION_INDEX = "ArgDir";
    public static final String ARGUMENT_NAME_INDEX = "ArgName";
    public static final String ARGUMENT_EQUALS_INDEX = "ArgEquals";
    public static final String FORMAT = "FORMAT";
    public static final String FORMAT_EXPRESSION = "FormatExpression";
    public static final int TYPE_NAME_AND_EQUALS = 201;
    public static final int TYPE_AND_NAME = 202;
    public static final int AFTER_EQUALS = 203;
    public static final int TYPE_NAME_AND_COMMENTED_EQUALS = 204;
    public static final int TYPE_NAME_AND_COMMENTED_EQUALS_FORMAT = 205;
    private static DataVector macrosSoFarVector = new DataVector(100);
    private static DataVector taskArgumentsVector = new DataVector(100);
    protected boolean isPersistentDeclaration = false;
    protected int argumentDirection;
    protected String argumentName;
    protected DataExpression formatExpression;
    protected int distributedType;
    protected String distributedId;
    protected boolean distributedIsPointer;
    protected DataVector distributedArrayExpressionsVector;
    protected DataDistributedStruct dataDistributedStruct;
    protected DataDistributedEnum dataDistributedEnum;

    public static int getArgumentDirectionOfString(String string) {
        int n = 0;
        while (n < ARGUMENT_TYPES.length) {
            if (ARGUMENT_TYPES[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static synchronized void writeDistributedMacroRequirements(DataDestination dataDestination, DataVector dataVector, boolean bl) {
        if (bl) {
            macrosSoFarVector.removeAllElements();
        }
        if (dataVector != null) {
            int n = 0;
            while (n < dataVector.size()) {
                DataTaskArgument.writeDistributedMacroRequirements(dataDestination, (DataTaskArgument)dataVector.elementAt(n), macrosSoFarVector);
                ++n;
            }
        }
    }

    public static synchronized void writeDistributedMacroRequirements(DataDestination dataDestination, DataTaskArgument dataTaskArgument) {
        DataTaskArgument.writeDistributedMacroRequirements(dataDestination, dataTaskArgument, macrosSoFarVector);
    }

    public static synchronized void writeDistributedMacroRequirements(DataDestination dataDestination, DataTaskArgument dataTaskArgument, DataVector dataVector) {
        if (dataTaskArgument == null) {
            return;
        }
        if ((dataTaskArgument.getDistributedType() == 12 || dataTaskArgument.getDistributedType() == 13 || dataTaskArgument.getDistributedType() == 14) && dataTaskArgument.getDistributedId() != null) {
            DataTaskArgument.writeDistributedMacroRequirements(dataDestination, dataTaskArgument.getDistributedIdTranslatingScoping(), dataVector);
        } else if (dataTaskArgument.getDistributedType() == 15 && dataTaskArgument.getDataDistributedStruct() != null) {
            dataTaskArgument.getDataDistributedStruct().writeDistributedMacroRequirements(dataDestination, false);
        }
    }

    public static synchronized void writeDistributedMacroRequirements(DataDestination dataDestination, String string, DataVector dataVector) {
        if (dataVector != null) {
            if (dataVector.contains(string)) {
                return;
            }
            dataVector.addElement(string);
        }
        int n = dataDestination.getIndent();
        dataDestination.removeIndent(n);
        if (dataDestination.getColumn() != 0) {
            dataDestination.write("\n");
        }
        dataDestination.write("#ifndef ");
        dataDestination.write(string);
        dataDestination.write("_IPC_FORMAT");
        dataDestination.write("\n#error  \"Error:  ");
        dataDestination.write(string);
        dataDestination.write("_IPC_FORMAT");
        dataDestination.write(" is not #define'd!\"\n#endif /* ");
        dataDestination.write(string);
        dataDestination.write("_IPC_FORMAT");
        dataDestination.write(" */");
        dataDestination.addIndent(n);
        dataDestination.write("\n");
    }

    public static synchronized String getDistributedFormatString(DataTaskArgument dataTaskArgument, DataComponent dataComponent, String string) {
        taskArgumentsVector.removeAllElements();
        taskArgumentsVector.addElement(dataTaskArgument);
        return DataTaskArgument.getDistributedFormatString(taskArgumentsVector, dataComponent, string, null, null);
    }

    public static synchronized String getDistributedFormatString(DataVector dataVector, DataComponent dataComponent, String string, String string2, String string3) {
        boolean bl = false;
        if (dataVector.size() <= 0) {
            return "(STRING(NULL))";
        }
        int n = 0;
        while (n < dataVector.size()) {
            if (((DataTaskArgument)dataVector.elementAt(n)).getDistributedFormatRequiresDynamicString()) {
                bl = true;
                break;
            }
            ++n;
        }
        return DataTaskArgument.getDistributedFormatString(dataVector, dataComponent, string, string2, string3, bl);
    }

    public static String getDistributedFormat_DynamicStringBufferLead() {
        return "TDL_StringBuffer() << ";
    }

    public static synchronized String getDistributedFormatString(DataVector dataVector, DataComponent dataComponent, String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        if (bl) {
            stringBuffer.append(DataTaskArgument.getDistributedFormat_DynamicStringBufferLead());
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("\"");
        int n = 0;
        while (n < dataVector.size()) {
            String string4 = ((DataTaskArgument)dataVector.elementAt(n)).getDistributedFormatString();
            if (string4 == null) {
                throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  Error: Format constraint required.  Unable to automatically " + "create distributed IPC argument-format string for " + string + " element/argument \"" + ((DataTaskArgument)dataVector.elementAt(n)).toString(true).trim() + "\".");
            }
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string4);
            ++n;
        }
        stringBuffer.append("\"");
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public DataTaskArgument() {
        this.setArgumentDirection(3);
        this.setArgumentNameWithoutParsingChecks("");
        this.formatExpression = null;
        this.distributedType = -1;
        this.distributedId = null;
        this.distributedIsPointer = false;
        this.distributedArrayExpressionsVector = null;
        this.dataDistributedStruct = null;
        this.dataDistributedEnum = null;
    }

    public boolean getIsPersistentDeclaration() {
        return this.isPersistentDeclaration;
    }

    public void setIsPersistentDeclaration(boolean bl) {
        this.isPersistentDeclaration = bl;
    }

    public int getArgumentDirection() {
        return this.argumentDirection;
    }

    public void setArgumentDirection(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            System.err.println("[DataTaskArgument]  Error:  Invalid Argument Direction (" + n + ").  Assuming default.");
            this.argumentDirection = 3;
        } else {
            this.argumentDirection = n;
        }
    }

    public String getArgumentDirectionString() {
        return ARGUMENT_TYPES[this.getArgumentDirection()];
    }

    public void setArgumentDirectionString(String string) {
        int n = DataTaskArgument.getArgumentDirectionOfString(string);
        if (n == -1) {
            System.err.println("[DataTaskArgument:setArgumentDirectionString]  Warning:  Invalid direction (\"" + string + "\".  Using default direction instead.");
            n = 3;
        }
        this.setArgumentDirection(n);
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    protected void setArgumentNameWithoutParsingChecks(String string) {
        this.argumentName = string;
    }

    public void setArgumentName(String string) throws DetailedParseException {
        if (DataComponent.isEmptyString(string)) {
            this.setArgumentNameWithoutParsingChecks("");
            return;
        }
        TDLParser.reinitParser(string);
        try {
            TDLParser.getParser();
            this.setArgumentNameWithoutParsingChecks(TDLParser.parseArgumentName());
        }
        catch (Throwable throwable) {
            DataComponent.didParseOfSubpartFail(throwable);
        }
    }

    public boolean hasEquals() {
        return this.hasIndex(ARGUMENT_EQUALS_INDEX);
    }

    public int countSubcomponentNewlinesAfterEquals() {
        return this.countSubcomponentNewlines(this.getIndex(ARGUMENT_EQUALS_INDEX) + 1, this.getSubcomponentsCount(), 0, true);
    }

    DataExpression getFormatExpression() {
        return this.formatExpression;
    }

    void setFormatExpression(DataExpression dataExpression) {
        this.formatExpression = dataExpression;
    }

    public boolean getIsDistributed() {
        return this.getDistributedType() >= 0 && this.getDistributedType() <= 16;
    }

    public int getDistributedType() {
        return this.distributedType;
    }

    public void setDistributedType(int n) {
        this.distributedType = n;
    }

    public String getDistributedTypeString() {
        if (this.getDistributedType() >= 0 && this.getDistributedType() < DISTRIBUTED_TYPE_STRINGS.length) {
            return DISTRIBUTED_TYPE_STRINGS[this.getDistributedType()];
        }
        return "UNKNOWN_TYPE: " + this.getDistributedType();
    }

    public String getDistributedId() {
        return this.distributedId;
    }

    public void setDistributedId(String string) {
        this.distributedId = string;
    }

    public String getDistributedIdTranslatingScoping() {
        return this.getDistributedId().replace(':', '_');
    }

    public boolean getDistributedIsPointer() {
        return this.distributedIsPointer;
    }

    public void setDistributedPointer(boolean bl) {
        this.distributedIsPointer = bl;
    }

    public DataVector getDistributedArrayExpressionsVector() {
        return this.distributedArrayExpressionsVector;
    }

    public boolean getDistributedHasArrayExpressions() {
        return this.getDistributedArrayExpressionsVector() != null && this.getDistributedArrayExpressionsVector().size() > 0;
    }

    public void addDistributedArrayExpression(DataExpression dataExpression) {
        if (this.distributedArrayExpressionsVector == null) {
            this.distributedArrayExpressionsVector = new DataVector(10);
        }
        this.distributedArrayExpressionsVector.addElement(dataExpression);
    }

    public void setDistributedStructNotSubcomponent(DataDistributedStruct dataDistributedStruct) {
        if (this.dataDistributedStruct != null) {
            System.err.println("[DataTaskArgument:setDistributedStruct]  Warning:  Internal programmer error encountered:  Had previously set the dataDistributedStruct object.");
        }
        this.dataDistributedStruct = dataDistributedStruct;
    }

    public void setDistributedStruct(DataDistributedStruct dataDistributedStruct) {
        this.setDistributedStructNotSubcomponent(dataDistributedStruct);
        this.addSubcomponent(dataDistributedStruct);
    }

    public DataDistributedStruct getDataDistributedStruct() {
        return this.dataDistributedStruct;
    }

    public void setDistributedEnumNotSubcomponent(DataDistributedEnum dataDistributedEnum) {
        if (this.dataDistributedEnum != null) {
            System.err.println("[DataTaskArgument:setDistributedEnum]  Warning:  Internal programmer error encountered:  Had previously set the dataDistributedEnum object.");
        }
        this.dataDistributedEnum = dataDistributedEnum;
    }

    public void setDistributedEnum(DataDistributedEnum dataDistributedEnum) {
        this.setDistributedEnumNotSubcomponent(dataDistributedEnum);
        this.addSubcomponent(dataDistributedEnum);
    }

    public DataDistributedEnum getDataDistributedEnum() {
        return this.dataDistributedEnum;
    }

    public void writeDistributedMacroRequirements(DataDestination dataDestination) {
        DataTaskArgument.writeDistributedMacroRequirements(dataDestination, this, null);
    }

    public boolean getDistributedFormatRequiresDynamicString() {
        if (this.getFormatExpression() != null) {
            return true;
        }
        if (this.getDistributedHasArrayExpressions()) {
            return true;
        }
        if ((this.getDistributedType() == 12 || this.getDistributedType() == 13 || this.getDistributedType() == 14) && this.getDistributedId() != null) {
            return true;
        }
        return this.getDistributedType() == 15 && this.getDataDistributedStruct() != null && this.getDataDistributedStruct().getDistributedFormatRequiresDynamicString();
    }

    public String getDistributedFormatString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.getFormatExpression() != null) {
            return "\" << " + this.getFormatExpression().toString(true).trim() + " << \"";
        }
        if (!this.getIsDistributed()) {
            return null;
        }
        if (this.getDistributedType() == 3 || this.getDistributedType() == 7) {
            return null;
        }
        if (this.getDistributedType() < DISTRIBUTED_ARGUMENT_FORMAT_STRINGS.length) {
            stringBuffer.append(DISTRIBUTED_ARGUMENT_FORMAT_STRINGS[this.getDistributedType()]);
        } else if ((this.getDistributedType() == 12 || this.getDistributedType() == 13 || this.getDistributedType() == 14) && this.getDistributedId() != null) {
            stringBuffer.append("\" << (");
            stringBuffer.append(this.getDistributedIdTranslatingScoping());
            stringBuffer.append("_IPC_FORMAT");
            stringBuffer.append(") << \"");
        } else if (this.getDistributedType() == 15) {
            if (this.getDataDistributedStruct() != null) {
                stringBuffer.append(this.getDataDistributedStruct().getDistributedFormatString(false, false));
            } else {
                System.err.println("[DataTaskArgument:getDistributedFormatString]  Warning: Internal programmer error encountered:  No DataDistributedStruct object available.");
            }
        } else if (this.getDistributedType() == 16) {
            if (this.getDataDistributedEnum() != null) {
                stringBuffer.append(this.getDataDistributedEnum().getDistributedFormatString(false, false));
            } else {
                System.err.println("[DataTaskArgument:getDistributedFormatString]  Warning: Internal programmer error encountered:  No DataDistributedEnum object available.");
            }
        }
        if (stringBuffer.length() > 0) {
            if (this.getDistributedIsPointer()) {
                stringBuffer.insert(0, "*");
            }
            if (this.getDistributedHasArrayExpressions()) {
                stringBuffer.insert(0, "[");
                stringBuffer.append(":");
                int n = 0;
                while (n < this.getDistributedArrayExpressionsVector().size()) {
                    if (n > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("\" << ");
                    stringBuffer.append(this.getDistributedArrayExpressionsVector().elementAt(n));
                    stringBuffer.append(" << \"");
                    ++n;
                }
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String getWarnString(int n) {
        return super.getWarnString(n) + " or DataTaskArgument.TYPE_NAME_AND_EQUALS (" + 201 + ")" + " or DataTaskArgument.TYPE_AND_NAME (" + 202 + ")" + " or DataTaskArgument.AFTER_EQUALS (" + 203 + ")" + " or DataTaskArgument.TYPE_NAME_AND_COMMENTED_EQUALS (" + 204 + ")" + " or DataTaskArgument.TYPE_NAME_AND_COMMENTED_EQUALS_FORMAT (" + 205 + ")";
    }

    public boolean isValidObjectSubset(int n) {
        if (n == 201 || n == 202 || n == 203 || n == 204 || n == 205) {
            return true;
        }
        return super.isValidObjectSubset(n);
    }

    public boolean isValid(int n) {
        return !DataComponent.isEmptyString(this.getArgumentName());
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        if (n != 201 && n != 202 && n != 203 && n != 204 && n != 205) {
            this.initializeGenerateSubcomponentIndex();
            this.generateSubcomponents("DataComponentFirstTokenIndex", dataDestination, 0, false);
            if (this.getIsPersistentDeclaration()) {
                this.generateSubcomponents(PERSISTENT, dataDestination, 0, false);
                dataDestination.write(PERSISTENT);
            }
            if (this.getArgumentDirection() != 3) {
                this.generateSubcomponents(ARGUMENT_DIRECTION_INDEX, dataDestination, 0, false);
                dataDestination.write(this.getArgumentDirectionString());
            }
        } else {
            this.initializeGenerateSubcomponentIndex(ARGUMENT_DIRECTION_INDEX);
        }
        if (n != 203) {
            this.generateSubcomponents(ARGUMENT_NAME_INDEX, dataDestination, 0, false);
            dataDestination.write(this.getArgumentName());
        }
        switch (n) {
            case 201: {
                this.generateAllRemainingSubcomponents(dataDestination, 0, false);
                break;
            }
            case 202: {
                if (this.hasEquals()) {
                    this.generateSubcomponents(ARGUMENT_EQUALS_INDEX, dataDestination, 0, false);
                    break;
                }
                this.generateAllRemainingSubcomponents(dataDestination, 0, false);
                break;
            }
            case 203: {
                this.initializeGenerateSubcomponentIndex(this.getIndex(ARGUMENT_EQUALS_INDEX) + 1);
                this.generateAllRemainingSubcomponents(dataDestination, 0, false);
                break;
            }
            case 204: 
            case 205: {
                if (this.hasEquals()) {
                    this.generateSubcomponents(ARGUMENT_EQUALS_INDEX, dataDestination, 0, false);
                    dataDestination.write(" /* ");
                    dataDestination.setIsNestingComments(true);
                    if (this.hasIndex(FORMAT)) {
                        this.generateSubcomponents(FORMAT, dataDestination, 0, false);
                    } else {
                        this.generateAllRemainingSubcomponents(dataDestination, 0, false);
                    }
                    dataDestination.setIsNestingComments(false);
                    dataDestination.write(" */");
                }
                if (n == 204) {
                    this.generateAllRemainingSubcomponents(dataDestination, 0, false);
                    break;
                }
            }
            default: {
                if (this.getFormatExpression() != null) {
                    this.generateSubcomponents(FORMAT, dataDestination, 0, false);
                    if (n != 0) {
                        dataDestination.write(" /* ");
                        dataDestination.setIsNestingComments(true);
                    }
                    dataDestination.write(FORMAT);
                    this.generateSubcomponents(FORMAT_EXPRESSION, dataDestination, 0, false);
                    this.getFormatExpression().generate(dataDestination, 0);
                    if (n != 0) {
                        dataDestination.setIsNestingComments(false);
                        dataDestination.write(" */");
                    }
                }
                this.generateAllRemainingSubcomponents(dataDestination, 0, false);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException, DetailedParseException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        DataTaskArgument dataTaskArgument = null;
        while ((n = System.in.read()) != -1) {
            stringBuffer.append((char)(n & 0xFF));
        }
        System.out.println("Testing:                                 " + stringBuffer.toString() + "");
        TDLParser.getParser();
        TDLParser.reinitParser(stringBuffer.toString());
        try {
            TDLParser.getParser();
            dataTaskArgument = TDLParser.parseTaskArgument_AndTrailingEOF(null);
        }
        catch (Throwable throwable) {
            DataComponent.didParseOfSubpartFail(throwable);
        }
        System.out.println("DataComponent.ENTIRE_OBJECT:             " + dataTaskArgument.toString(0));
        System.out.println("DataComponent.CXX_HEADER:                " + dataTaskArgument.toString(1001));
        System.out.println("DataComponent.CXX_CODE:                  " + dataTaskArgument.toString(1002));
        System.out.println("TYPE_NAME_AND_EQUALS:                    " + dataTaskArgument.toString(201));
        System.out.println("TYPE_AND_NAME:                           " + dataTaskArgument.toString(202));
        System.out.println("AFTER_EQUALS:                            " + dataTaskArgument.toString(203));
        System.out.println("TYPE_NAME_AND_COMMENTED_EQUALS:          " + dataTaskArgument.toString(204));
        System.out.println("TYPE_NAME_AND_COMMENTED_EQUALS_FORMAT:   " + dataTaskArgument.toString(205));
    }
}

