/*
 * Decompiled with CFR 0.152.
 */
public abstract class DataStatement
extends DataComponent
implements DataValidateCode {
    public static int FOUND_NOTHING = 0;
    public static int FOUND_SPAWN_RELATED_STATEMENT = 1;
    public static int FOUND_END = 2;
    protected DataLabelStatement label = null;
    protected String postLabelString = null;

    public static boolean hasNonconditionalConstraintOfType(DataSpawnTask dataSpawnTask, int n, DataVector dataVector) {
        int n2 = 0;
        while (n2 < dataSpawnTask.getConstraintCount()) {
            if (dataSpawnTask.getConstraint(n2).getConstraintType() == n) {
                return true;
            }
            ++n2;
        }
        DataComponent dataComponent = dataSpawnTask.getParent();
        while (dataComponent != null) {
            if (dataComponent instanceof DataWithDoStatement) {
                DataWithDoStatement dataWithDoStatement = (DataWithDoStatement)dataComponent;
                n2 = 0;
                while (n2 < dataWithDoStatement.getConstraintCount()) {
                    if (dataWithDoStatement.getConstraint(n2).getConstraintType() == n) {
                        return true;
                    }
                    ++n2;
                }
            }
            dataComponent = dataComponent.getParent();
        }
        return false;
    }

    public static void validateAnyOverridenConstraints(DataComponent dataComponent, DataValidateCodeReturnValue dataValidateCodeReturnValue) {
    }

    public static void validateInternalConstrainedObject(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue, DataConstrainedObject dataConstrainedObject) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        DataConstraint dataConstraint = null;
        DataConstraint dataConstraint2 = null;
        int n2 = 0;
        while (n2 < dataConstrainedObject.getConstraintCount()) {
            if (dataConstrainedObject.getConstraint(n2).getHasEventTagTaskOfPrevious()) {
                switch (dataConstrainedObject.getConstraint(n2).getConstraintType()) {
                    case 5: {
                        bl2 = true;
                        dataConstraint = dataConstrainedObject.getConstraint(n2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        bl3 = true;
                        dataConstraint2 = dataConstrainedObject.getConstraint(n2);
                    }
                }
            }
            if (dataConstrainedObject.getConstraint(n2).getConstraintType() == 6) {
                bl = true;
            }
            ++n2;
        }
        if (bl && bl2) {
            dataValidateCodeReturnValue.addWarning(dataConstraint).write("SERIAL constraint overrides PARALLEL constraint.\n");
        }
        if (bl && bl3) {
            dataValidateCodeReturnValue.addWarning(dataConstraint2).write("SEQUENTIAL constraint overrides PARALLEL constraint.\n");
        }
    }

    public static void generateTagTaskCxxReference(DataDestination dataDestination, String string, Object[] objectArray, DataComponent dataComponent) throws CompilationException {
        if (dataComponent == null) {
            throw new CompilationException("Line:??: Programmer Error:  Missing DataComponent.");
        }
        if (DataComponent.isEmptyString(string)) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  Error:  Missing Task-Tag.");
        }
        DataTaskDefinition dataTaskDefinition = dataComponent.getParentTaskDefinition();
        if (dataTaskDefinition == null) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  " + "Programmer Error:  Unable to find DataTaskDefinition ancestor.");
        }
        DataComponent dataComponent2 = dataTaskDefinition.getDataComponentWithName(string);
        if (dataComponent2 == null) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  Programmer Error:  Unable to find tag-Task-DataComponent.");
        }
        int n = dataTaskDefinition.getIterationParentCount(dataComponent2);
        if (objectArray != null && objectArray.length > n) {
            throw new CompilationException(dataComponent.getMessageFilenameLead() + dataComponent.getLineNumberString() + ":  Error:  Too many iteration indexes for Task/With Reference." + "  (Task/With is enclosed in " + n + " iteration loop(s) and there is (are) " + objectArray.length + " array index(es) specified.)");
        }
        dataDestination.write("_TDL_SpawnedTasks");
        dataDestination.write(" [ \"");
        dataDestination.write(string);
        dataDestination.write("\" ]");
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        if (n <= 0) {
            dataDestination.write("\n. ");
            dataDestination.write("cacheDescendIntoNode");
            dataDestination.write(" ( ");
            dataDestination.write("_TDL_TreeNode::NO_ARRAY_INDEX");
            dataDestination.write(" )");
        } else if (objectArray == null || objectArray.length <= 0) {
            dataDestination.write("\n. ");
            dataDestination.write("getCachedTopmostTreeNodeBranch");
            dataDestination.write(" ()");
        } else {
            int n2 = 0;
            while (n2 < objectArray.length) {
                dataDestination.write("\n. ");
                if (n2 >= n - 1) {
                    dataDestination.write("cacheDescendIntoNode");
                } else {
                    dataDestination.write("cacheDescendIntoBranch");
                }
                dataDestination.write(" ( ");
                if (objectArray[n2] instanceof String && objectArray[n2].equals(".")) {
                    dataDestination.write("_TDL_SpawnedTasks");
                    dataDestination.write(" . ");
                    dataDestination.write("getCurrentIterationIndex");
                    dataDestination.write(" ( ");
                    dataDestination.write("" + n2);
                    dataDestination.write(" )");
                } else {
                    int n3 = dataDestination.indentToCurrentColumn();
                    if (objectArray[n2] instanceof DataComponent) {
                        if (dataDestination.getEnableLineMacros()) {
                            dataDestination.setUsingTdlFileName(true);
                            dataDestination.makeNextLineNumber(((DataComponent)objectArray[n2]).getLineNumber());
                            dataDestination.write("\n");
                        }
                        dataDestination.setStripLeadingWhitespace();
                        dataDestination.setPersistentlyStripLeadingSpaces(true);
                        ((DataComponent)objectArray[n2]).generate(dataDestination, 0);
                        dataDestination.setPersistentlyStripLeadingSpaces(false);
                        if (dataDestination.getEnableLineMacros()) {
                            dataDestination.setUsingTdlFileName(false);
                            dataDestination.write("\n");
                        }
                    } else {
                        dataDestination.write(objectArray[n2].toString());
                    }
                    dataDestination.removeIndent(n3);
                }
                dataDestination.write(" )");
                ++n2;
            }
            if (objectArray.length < n) {
                dataDestination.write("\n. ");
                dataDestination.write("getCachedTreeNodeNonConst");
                dataDestination.write(" ()");
            }
        }
        dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
    }

    public DataLabelStatement getLabel() {
        return this.label;
    }

    public void setLabel(DataLabelStatement dataLabelStatement) {
        if (this.label != null) {
            this.label.setParent(null);
        }
        this.label = dataLabelStatement;
        if (this.label != null) {
            this.label.setParent(this);
        }
    }

    public boolean hasCaseOrDefaultLabel() {
        DataLabelStatement dataLabelStatement = this.getLabel();
        while (dataLabelStatement != null) {
            if (!dataLabelStatement.hasId()) {
                return true;
            }
            dataLabelStatement = dataLabelStatement.getLabel();
        }
        return false;
    }

    public boolean hasName(String string) {
        DataLabelStatement dataLabelStatement = this.getLabel();
        while (dataLabelStatement != null) {
            if (dataLabelStatement.hasId() && dataLabelStatement.getId().equals(string)) {
                return true;
            }
            dataLabelStatement = dataLabelStatement.getLabel();
        }
        return false;
    }

    public String getPostLabelString() {
        return this.postLabelString;
    }

    public void setPostLabelString(String string) {
        this.postLabelString = string;
    }

    public void eraseAllPostLabelStrings() {
        this.setPostLabelString(null);
        int n = 0;
        while (n < this.getChildStatementCount()) {
            this.getChildStatement(n).eraseAllPostLabelStrings();
            ++n;
        }
    }

    public boolean isSubcomponentADataStatement(int n) {
        return this.isSubcomponentADataComponent(n) && this.getDataComponentSubcomponent(n) instanceof DataStatement;
    }

    public DataStatement getDataStatementSubcomponent(int n) {
        if (this.isSubcomponentADataStatement(n)) {
            return (DataStatement)this.getSubcomponent(n);
        }
        System.err.println("[DataStatement:getDataStatementSubcomponent]  Warning:  Subcomponent ( " + n + " ) is NOT a DataStatement!  It is a \"" + this.getSubcomponent(n).getClass().getName() + "\".");
        return null;
    }

    public void validateExternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        throw new CompilationException("Internal Error:  DataStatement object may not exist outside a Task.");
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        DataLabelStatement dataLabelStatement = this.getLabel();
        while (dataLabelStatement != null) {
            if (!dataLabelStatement.hasId()) {
                if (this.getParent() instanceof DataSwitchStatement || this.getParent() instanceof DataCompoundStatement && this.getParent().getParent() instanceof DataSwitchStatement) break;
                dataValidateCodeReturnValue.addError(dataLabelStatement).write("Case or Default label is not contained by an immediate switch statement.\n");
                break;
            }
            dataLabelStatement = dataLabelStatement.getLabel();
        }
        int n2 = 0;
        while (n2 < this.getChildStatementCount()) {
            this.getChildStatement(n2).validateInternalCode(n, dataValidateCodeReturnValue);
            ++n2;
        }
    }

    public void generateRelevantLineNumberMacros(DataDestination dataDestination, int n, int n2, String string) {
        this.generateRelevantLineNumberMacros(dataDestination, n2, this.countSubcomponentNewlines(string, n, false));
    }

    public void generateRelevantLineNumberMacros(DataDestination dataDestination, int n, int n2) {
        if (!dataDestination.getEnableLineMacros()) {
            return;
        }
        if (!DataComponent.isValidLineNumber(n)) {
            dataDestination.setUsingTdlFileName(false);
        } else {
            dataDestination.setUsingTdlFileName(true);
            if (n2 <= 0) {
                dataDestination.makeNextLineNumber(n - n2);
            } else {
                dataDestination.makeNextLineNumber(n - n2 + 1);
            }
        }
        if (n2 <= 0) {
            if (dataDestination.hasMakeNextLineNumber() && dataDestination.getAdjustedCurrentRow() == dataDestination.getMakeNextLineNumber()) {
                dataDestination.clearMakeNextLineNumber();
            } else {
                boolean bl = dataDestination.getIsStrippingLeadingWhitespace();
                dataDestination.setStripLeadingWhitespace(false);
                dataDestination.write("\n");
                dataDestination.setStripLeadingWhitespace(bl);
            }
        }
    }

    public void generateRelevantLineNumberMacros(DataDestination dataDestination, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (!dataDestination.getEnableLineMacros()) {
            return;
        }
        if (!bl) {
            if (dataDestination.getEnableLineMacros() && dataDestination.getUsingTdlFileName()) {
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n");
            }
            return;
        }
        int n5 = this.getLabel() != null && bl2 ? this.getLabel().getLineNumber() : this.getLineNumber();
        int n6 = dataDestination.getIsStrippingLeadingWhitespace() ? 0 : (this.getLabel() != null && bl2 ? this.countSubcomponentNewlines("DataComponentFirstTokenIndex", n, false) + this.getLabel().countSubcomponentNewlines("First", n2, false) : n4 + this.countSubcomponentNewlines(Math.max(this.getIndex("DataComponentFirstTokenIndex"), n3), n, false));
        this.generateRelevantLineNumberMacros(dataDestination, n5, n6);
    }

    public void generateLabels(DataDestination dataDestination, int n, String string) {
        this.generateLabels(dataDestination, n, n, this.getIndex(string), 0, true, false);
    }

    public void generateLabels(DataDestination dataDestination, int n, String string, boolean bl) {
        this.generateLabels(dataDestination, n, n, this.getIndex(string), 0, true, bl);
    }

    public void generateLabels(DataDestination dataDestination, int n, int n2, String string) {
        this.generateLabels(dataDestination, n, n2, this.getIndex(string), 0, true, false);
    }

    public void generateLabels(DataDestination dataDestination, int n, String string, DataComponent dataComponent, String string2) {
        this.generateLabels(dataDestination, n, n, this.getIndex(string), dataComponent != null ? dataComponent.countSubcomponentNewlines(string2, n, false) : 0, true, false);
    }

    public void generateLabels(DataDestination dataDestination, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (!bl2) {
            this.generateRelevantLineNumberMacros(dataDestination, n, n2, n3, n4, bl, true);
        }
        this.generateSubcomponents("DataComponentFirstTokenIndex", dataDestination, n, false);
        DataLabelStatement dataLabelStatement = this.getLabel();
        while (dataLabelStatement != null) {
            dataLabelStatement.generate(dataDestination, n2);
            dataLabelStatement = dataLabelStatement.getLabel();
        }
        if (!DataComponent.isEmptyString(this.getPostLabelString())) {
            dataDestination.setUsingTdlFileName(false);
            if (this.getPostLabelString().charAt(0) != '\n') {
                dataDestination.write("\n");
            }
            dataDestination.enableSecondaryIndent();
            dataDestination.write(this.getPostLabelString());
            dataDestination.disableSecondaryIndent();
            if (!bl2) {
                this.generateRelevantLineNumberMacros(dataDestination, n, n2, n3, n4, bl, false);
            }
        }
    }

    public String getSpawnDestroyClause(boolean bl) {
        return this.getSpawnDestroyClause(null, null, bl);
    }

    public String getSpawnDestroyClause(DataStatement dataStatement, DataStatement dataStatement2, boolean bl) {
        DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
        if (dataTaskDefinition == null) {
            System.err.println("[DataStatement:getSpawnDestroyClause]  Error:  Unable to find parent task.  Unable to compute spawn-destroy clause.");
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.getSpawnDestroyClause(dataStatement, dataStatement2, dataTaskDefinition, stringBuffer, false, bl);
        return stringBuffer.toString();
    }

    protected boolean getSpawnDestroyClause(DataStatement dataStatement, DataStatement dataStatement2, DataTaskDefinition dataTaskDefinition, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (dataStatement == null || dataStatement == this) {
            bl = true;
        }
        if (dataStatement2 != null && dataStatement2 == this) {
            return true;
        }
        if (bl && this instanceof DataSpawnTask) {
            stringBuffer.append("_TDL_SpawnedTasks");
            stringBuffer.append(" . ");
            if (bl2) {
                stringBuffer.append("destroyIfUnused");
            } else {
                stringBuffer.append("destroy");
            }
            stringBuffer.append(" ( \"");
            stringBuffer.append(dataTaskDefinition.getIdentifierForSubtask((DataSpawnTask)this));
            stringBuffer.append("\" );\n");
        }
        int n = 0;
        while (n < this.getChildStatementCount()) {
            if (this.getChildStatement(n).getSpawnDestroyClause(dataStatement, dataStatement2, dataTaskDefinition, stringBuffer, bl, bl2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isSpawnRelatedStatement() {
        return this.hasSubcomponentFraction("TDL_REF");
    }

    public boolean containsSpawnRelatedStatement() {
        return this.containsSpawnRelatedStatement(null, null, false);
    }

    public boolean containsSpawnRelatedStatement(DataStatement dataStatement, DataStatement dataStatement2) {
        return this.containsSpawnRelatedStatement(dataStatement, dataStatement2, false);
    }

    public boolean containsSpawnRelatedStatement(DataStatement dataStatement, DataStatement dataStatement2, boolean bl) {
        int n = this.privateContainsSpawnRelatedStatement(dataStatement, dataStatement2, false);
        return n == FOUND_SPAWN_RELATED_STATEMENT;
    }

    protected int privateContainsSpawnRelatedStatement(DataStatement dataStatement, DataStatement dataStatement2, boolean bl) {
        if (dataStatement == null || dataStatement == this) {
            bl = true;
        }
        if (dataStatement2 != null && dataStatement2 == this) {
            return FOUND_END;
        }
        if (bl && this.isSpawnRelatedStatement()) {
            return FOUND_SPAWN_RELATED_STATEMENT;
        }
        int n = 0;
        while (n < this.getChildStatementCount()) {
            int n2 = this.getChildStatement(n).privateContainsSpawnRelatedStatement(dataStatement, dataStatement2, bl);
            if (n2 == FOUND_END || n2 == FOUND_SPAWN_RELATED_STATEMENT) {
                return n2;
            }
            ++n;
        }
        return FOUND_NOTHING;
    }

    public int getChildStatementCount() {
        return 0;
    }

    public DataStatement getChildStatement(int n) {
        System.err.println("[DataComponent:getChild]  Warning:  theIndex [" + n + "]  is invalid.  Returning NULL!");
        return null;
    }

    public int getConstraintChildStatementCount() {
        DataConstrainedObject dataConstrainedObject = null;
        int n = 0;
        if (!(this instanceof DataConstrainedObject)) {
            return 0;
        }
        dataConstrainedObject = (DataConstrainedObject)((Object)this);
        int n2 = 0;
        while (n2 < dataConstrainedObject.getConstraintCount()) {
            if (dataConstrainedObject.getConstraint(n2).hasChildStatement()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public DataStatement getConstraintChildStatement(int n) {
        DataConstrainedObject dataConstrainedObject = null;
        if (!(this instanceof DataConstrainedObject)) {
            return null;
        }
        dataConstrainedObject = (DataConstrainedObject)((Object)this);
        int n2 = 0;
        while (n2 < dataConstrainedObject.getConstraintCount()) {
            if (dataConstrainedObject.getConstraint(n2).hasChildStatement()) {
                if (n <= 0) {
                    return dataConstrainedObject.getConstraint(n2).getChildStatement();
                }
                --n;
            }
            ++n2;
        }
        return null;
    }

    public static DataVector getChildrenInFlatVector(DataVector dataVector, DataStatement dataStatement) {
        if (dataVector == null) {
            dataVector = new DataVector();
        }
        dataVector.removeAllElements();
        if (dataStatement == null) {
            return dataVector;
        }
        dataVector.addElement(dataStatement);
        int n = 0;
        while (n < dataVector.count()) {
            DataStatement dataStatement2 = (DataStatement)dataVector.elementAt(n);
            int n2 = 0;
            while (n2 < dataStatement2.getChildStatementCount()) {
                if (dataVector.contains(dataStatement2.getChildStatement(n2))) {
                    System.err.println("[DataStatement:getChildrenInFlatVector]  Warning:  Found statement twice:  " + dataStatement2.getChildStatement(n2).toString());
                } else {
                    dataVector.insertElementAt(dataStatement2.getChildStatement(n2), n + 1 + n2);
                }
                ++n2;
            }
            ++n;
        }
        return dataVector;
    }
}

