/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class DataSourceString
extends DataSource {
    protected String ourString;

    public DataSourceString(String string) {
        this.ourString = string;
    }

    public String getString() {
        return this.ourString;
    }

    public int getStringLength() {
        return this.getString().length();
    }

    public void setString(String string) {
        this.ourString = string;
        super.reset();
    }

    public char read(int n) throws IOException {
        if (n >= 0 && n < this.getStringLength()) {
            return this.getString().charAt(n);
        }
        if (n >= this.getStringLength()) {
            throw new IOException("END-OF-FILE (" + this.getStringLength() + ", " + n + ")");
        }
        throw new IOException("Invalid Index (" + n + ")");
    }

    public String readSubString(int n, int n2) {
        if (n < 0) {
            System.err.println("[DataSourceString:readSubString]  Warning:  theStartPosition(" + n + ") < 0");
            n = 0;
        }
        if (n >= this.getStringLength()) {
            System.err.println("[DataSourceString:readSubString]  Warning:  theStartPosition(" + n + ") >= getStringLength(" + this.getStringLength() + ")");
            n = this.getStringLength() - 1;
        }
        if (n2 < 0) {
            System.err.println("[DataSourceString:readSubString]  Warning:  theEndPosition(" + n2 + ") < 0");
            n2 = 0;
        }
        if (n2 > this.getStringLength()) {
            System.err.println("[DataSourceString:readSubString]  Warning:  theEndPosition(" + n2 + ") > getStringLength(" + this.getStringLength() + ")");
            n2 = this.getStringLength();
        }
        if (n >= n2) {
            System.err.println("[DataSourceString:readSubString]  Warning:  theStartPosition(" + n + ") >= theEndPosition(" + n2 + ")");
            return "";
        }
        return this.getString().substring(n, n2);
    }
}

