/*
 * Decompiled with CFR 0.152.
 */
public class DataConstraint
extends DataComponent
implements DataValidateCode,
DataConstraintTagTaskIndexes {
    public static final String BEGIN_TAG_TASK_INDEX = "[";
    public static final String DEFAULT_TAG_TASK_INDEX = ".";
    public static final String END_TAG_TASK_INDEX = "]";
    public static final String TIME_SEPARATOR = ":";
    public static final String FRACTIONAL_TIME_SEPARATOR = ".";
    public static final String TAG_TASK = "TagTask";
    public static final String KEYWORD = "K";
    public static final String CONSTRAINT_OPTION = "ConstraintOption";
    public static final String EVENT_CONSTRAINT_OPTION = "EventConstraintOption";
    public static final String STATE_BOUNDARY = "StateBoundary";
    public static final String PRE_TIME_HOURS = "PreTimeHours";
    public static final String POST_TIME_HOURS = "PostTimeHours";
    public static final String PRE_TIME_MINUTES = "PreTimeMinutes";
    public static final String POST_TIME_MINUTES = "PostTimeMinutes";
    public static final String PRE_TIME_SECONDS = "PreTimeSeconds";
    public static final String POST_TIME_SECONDS = "PostTimeSeconds";
    public static final String PRE_TIME_FRACTIONS_OF_A_SECOND = "PreTimeFractionsOfASecond";
    public static final String CHILD = "CHILD";
    public static final String THIS = "THIS";
    public static final String PREVIOUS = "PREVIOUS";
    public static final int INVALID = -1;
    public static final int EXPAND_FIRST = 0;
    public static final int DELAY_EXPANSION = 1;
    public static final int SEQUENTIAL_HANDLING = 2;
    public static final int SEQUENTIAL_EXPANSION = 3;
    public static final int SEQUENTIAL_EXECUTION = 4;
    public static final int SERIAL = 5;
    public static final int PARALLEL = 6;
    public static final int WAIT = 7;
    public static final int DISABLE_UNTIL_EVENT = 8;
    public static final int DISABLE_UNTIL_TIME = 9;
    public static final int DISABLE_FOR_TIME = 10;
    public static final int TERMINATE_AT_EVENT = 11;
    public static final int TERMINATE_AT_TIME = 12;
    public static final int TERMINATE_IN_TIME = 13;
    public static final int TERMINATE = 14;
    public static final int ACTIVATE_AT_EVENT = 15;
    public static final int ACTIVATE_AT_TIME = 16;
    public static final int ACTIVATE_IN_TIME = 17;
    public static final int ACTIVATE = 18;
    public static final int MAXIMUM_ACTIVATE = 19;
    public static final int MAXIMUM_TRIGGER = 20;
    public static final int MONITOR_PERIOD = 21;
    public static final int EXCEPTION_HANDLER = 22;
    public static final int ON_TERMINATE = 23;
    public static final int DISTRIBUTED_FORMAT = 24;
    public static final int ON_AGENT = 25;
    public static final int TCM_TASK_TREE_PARENT = 26;
    public static final int TDL_REF_IN = 27;
    public static final int TCM_TASK_TREE_NAME = 28;
    public static final int MAX_CONSTRAINT_INDEX = 28;
    public static final boolean[] IS_POST_INSERT_CONSTRAINT = new boolean[]{false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false};
    public static final boolean[] IS_OVERRIDING_CONSTRAINT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, true, true, true, true, true};
    public static final boolean[] IS_NON_CXX_GENERATING_CONSTRAINT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true};
    public static final boolean[] APPLYABLE_AFTER_TASK_SPAWNED = new boolean[]{false, false, false, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false};
    public static final String[] CONSTRAINT_NAMES = new String[]{"EXPAND_FIRST", "DELAY_EXPANSION", "SEQUENTIAL_HANDLING", "SEQUENTIAL_EXPANSION", "SEQUENTIAL_EXECUTION", "SERIAL", "PARALLEL", "WAIT", "DISABLE_UNTIL_EVENT", "DISABLE_UNTIL_TIME", "DISABLE_FOR_TIME", "TERMINATE_AT_EVENT", "TERMINATE_AT_TIME", "TERMINATE_IN_TIME", "TERMINATE", "ACTIVATE_AT_EVENT", "ACTIVATE_AT_TIME", "ACTIVATE_IN_TIME", "ACTIVATE", "MAXIMUM_ACTIVATE", "MAXIMUM_TRIGGER", "MONITOR_PERIOD", "EXCEPTION_HANDLER", "ON_TERMINATE", "FORMAT", "ON_AGENT", "TCM_TASK_TREE_PARENT", "TDL_REF_IN", "TCM_TASK_TREE_NAME"};
    public static final String[][] CONSTRAINT_STRINGS = new String[][]{{"EXPAND", "FIRST"}, {"DELAY", "EXPANSION"}, {"SEQUENTIAL", "HANDLING"}, {"SEQUENTIAL", "EXPANSION"}, {"SEQUENTIAL", "EXECUTION"}, {"SERIAL"}, {"PARALLEL"}, {"WAIT"}, {"DISABLE", "UNTIL"}, {"DISABLE", "UNTIL"}, {"DISABLE", "FOR", "AFTER"}, {"TERMINATE", "AT"}, {"TERMINATE", "AT"}, {"TERMINATE", "IN", "AFTER"}, {"TERMINATE"}, {"ACTIVATE", "AT"}, {"ACTIVATE", "AT"}, {"ACTIVATE", "IN", "AFTER"}, {"ACTIVATE"}, {"MAXIMUM", "ACTIVATE"}, {"MAXIMUM", "TRIGGER"}, {"PERIOD"}, {"EXCEPTION", "HANDLER"}, {"ON", "TERMINATE", "SPAWN"}, {"FORMAT"}, {"ON"}, {"PARENT"}, {"TDL_REF", "IN"}, {"NAME"}};
    public static final int HANDLING = 0;
    public static final int EXPANSION = 1;
    public static final int PLANNING = 1;
    public static final int EXECUTION = 2;
    public static final int ACHIEVEMENT = 2;
    public static final int MAX_CONSTRAINT_OPTION_INDEX = 2;
    public static final String[] CONSTRAINT_OPTION_STRINGS = new String[]{"HANDLING", "EXPANSION", "EXECUTION"};
    public static final String[] OLD_CONSTRAINT_OPTION_STRINGS = new String[]{"HANDLING", "PLANNING", "ACHIEVEMENT"};
    public static final int ENABLED = 0;
    public static final int ACTIVE = 1;
    public static final int COMPLETED = 2;
    public static final int MAX_STATE_BOUNDARY_INDEX = 2;
    public static final String[] STATE_BOUNDARY_STRINGS = new String[]{"ENABLED", "ACTIVE", "COMPLETED"};
    public static final int HOURS = 0;
    public static final int MINUTES = 1;
    public static final int SECONDS = 2;
    public static final int FRACTIONS_OF_A_SECOND = 3;
    public static final int TOTAL_NUMBER_OF_TIME_INDEXES = 4;
    protected int constraintType;
    protected String eventTagTask;
    protected Object[] eventTagTaskIndexes;
    protected int constraintOption;
    protected int eventConstraintOption;
    protected int stateBoundary;
    protected String[] time;
    protected DataExpression timeExpression;
    protected DataExpression numericExpression;
    protected DataSpawnTask exceptionHandlerTask;
    protected DataSpawnTask onTerminateTask;
    protected boolean hasOnTerminateSpawnKeyword;
    protected DataExpression distributedFormatStringExpression;
    protected DataExpression distributedOnAgentExpression;
    protected DataExpression tcmTaskTreeParentExpression;
    protected DataExpression tdlRefInExpression;
    protected DataExpression tcmTaskTreeNameExpression;
    protected String cxxExternalSubtaskName;

    public static int getLastIndexOfConstraintOfType(int n, DataConstrainedObject dataConstrainedObject) {
        int n2 = dataConstrainedObject.getConstraintCount() - 1;
        while (n2 >= 0) {
            if (dataConstrainedObject.getConstraint(n2).getConstraintType() == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static boolean getShouldConstraintBeCxxGenerated(DataConstraint dataConstraint, DataVector dataVector, boolean bl, boolean bl2) {
        if (DataConstraint.getIsPostInsertConstraint(dataConstraint) != bl) {
            return false;
        }
        if (DataConstraint.getIsConstraintOverriden(dataConstraint, dataVector)) {
            return false;
        }
        return !DataConstraint.getIsNonCxxGeneratingConstraint(dataConstraint);
    }

    public static boolean getIsPostInsertConstraint(DataConstraint dataConstraint) {
        return DataConstraint.getIsPostInsertConstraint(dataConstraint.getConstraintType());
    }

    public static boolean getIsPostInsertConstraint(int n) {
        if (n < 0 || n > 28) {
            System.err.println("[DataConstraint:getIsPostInsertConstraint]  Warning:  theConstraintType (" + n + ") is out of range...");
            return false;
        }
        return IS_POST_INSERT_CONSTRAINT[n];
    }

    public static boolean getIsOverridingConstraint(DataConstraint dataConstraint) {
        return DataConstraint.getIsOverridingConstraint(dataConstraint.getConstraintType());
    }

    public static boolean getIsOverridingConstraint(int n) {
        if (n < 0 || n > 28) {
            System.err.println("[DataConstraint:getIsOverridingConstraint]  Warning:  theConstraintType (" + n + ") is out of range...");
            return false;
        }
        return IS_OVERRIDING_CONSTRAINT[n];
    }

    public static boolean getIsConstraintOverriden(DataConstraint dataConstraint, DataVector dataVector) {
        if (!DataConstraint.getIsOverridingConstraint(dataConstraint)) {
            return false;
        }
        int n = dataVector.count() - 1;
        while (n >= 0) {
            DataConstraint dataConstraint2 = (DataConstraint)dataVector.elementAt(n);
            if (dataConstraint2 == dataConstraint) {
                return false;
            }
            if (dataConstraint2.getConstraintType() == dataConstraint.getConstraintType()) {
                return true;
            }
            --n;
        }
        return false;
    }

    public static boolean getIsNonCxxGeneratingConstraint(DataConstraint dataConstraint) {
        return DataConstraint.getIsNonCxxGeneratingConstraint(dataConstraint.getConstraintType());
    }

    public static boolean getIsNonCxxGeneratingConstraint(int n) {
        if (n < 0 || n > 28) {
            System.err.println("[DataConstraint:getIsNonCxxGeneratingConstraint]  Warning:  theConstraintType (" + n + ") is out of range...");
            return false;
        }
        return IS_NON_CXX_GENERATING_CONSTRAINT[n];
    }

    public static boolean getIsApplyableAfterTaskSpawned(DataConstraint dataConstraint) {
        return DataConstraint.getIsApplyableAfterTaskSpawned(dataConstraint.getConstraintType());
    }

    public static boolean getIsApplyableAfterTaskSpawned(int n) {
        if (n < 0 || n > 28) {
            System.err.println("[DataConstraint:getIsApplyableAfterTaskSpawned]  Warning:  theConstraintType (" + n + ") is out of range...");
            return false;
        }
        return APPLYABLE_AFTER_TASK_SPAWNED[n];
    }

    public static int getConstraintIndexOfString(String string) {
        int n = 0;
        while (n < CONSTRAINT_NAMES.length) {
            if (CONSTRAINT_NAMES[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        System.err.println("[DataConstraint:getConstraintIndexOfString]  Warning:  Unknown Constraint \"" + string + "\".");
        return -1;
    }

    public static String getConstraintNameString(int n) {
        if (n >= 0 && n < CONSTRAINT_NAMES.length) {
            return CONSTRAINT_NAMES[n];
        }
        return "**UNKNOWN**";
    }

    public static String[] getConstraintTokens(int n) {
        if (n < 0 || n > 28) {
            System.err.println("[DataConstraint:getConstraintStrings]  Warning:  theConstraintIndex (" + n + ") is out of range...");
            return null;
        }
        return CONSTRAINT_STRINGS[n];
    }

    public static String getConstraintOptionString(int n) {
        if (n < 0 || n > 2) {
            System.err.println("[DataConstraint:getConstraintOptionString]  Warning:  theIndex (" + n + ") is out of range...");
            return null;
        }
        return CONSTRAINT_OPTION_STRINGS[n];
    }

    public static int getConstraintOptionIndexOfString(String string) {
        int n = 0;
        while (n < CONSTRAINT_OPTION_STRINGS.length) {
            if (CONSTRAINT_OPTION_STRINGS[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < OLD_CONSTRAINT_OPTION_STRINGS.length) {
            if (OLD_CONSTRAINT_OPTION_STRINGS[n2].equalsIgnoreCase(string)) {
                return n2;
            }
            ++n2;
        }
        System.err.println("[DataConstraint:getConstraintOptionIndexOfString]  Warning:  Unknown Constraint-Option \"" + string + "\".");
        return -1;
    }

    public static String getStateBoundaryString(int n) {
        if (n < 0 || n > 2) {
            System.err.println("[DataConstraint:getStateBoundaryString]  Warning:  theIndex (" + n + ") is out of range...");
            return null;
        }
        return STATE_BOUNDARY_STRINGS[n];
    }

    public static int getStateBoundaryIndexOfString(String string) {
        int n = 0;
        while (n < STATE_BOUNDARY_STRINGS.length) {
            if (STATE_BOUNDARY_STRINGS[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        System.err.println("[DataConstraint:getStateBoundaryIndexOfString]  Warning:  Unknown State-Boundary \"" + string + "\".");
        return -1;
    }

    public static String stripLeadingZeros(String string) {
        int n = 0;
        while (n < string.length() && string.charAt(n) == '0') {
            ++n;
        }
        if (n <= 0 || n >= string.length()) {
            return string;
        }
        return string.substring(n);
    }

    public DataConstraint() {
        this.clearConstraint();
    }

    public DataConstraint(int n) {
        this();
        this.setConstraintType(n);
    }

    public void clearConstraint() {
        this.constraintType = -1;
        this.eventTagTask = "";
        this.eventTagTaskIndexes = null;
        this.constraintOption = -1;
        this.eventConstraintOption = -1;
        this.stateBoundary = -1;
        this.time = null;
        this.timeExpression = null;
        this.numericExpression = null;
        this.exceptionHandlerTask = null;
        this.onTerminateTask = null;
        this.hasOnTerminateSpawnKeyword = true;
        this.distributedFormatStringExpression = null;
        this.distributedOnAgentExpression = null;
        this.tcmTaskTreeParentExpression = null;
        this.tdlRefInExpression = null;
        this.tcmTaskTreeNameExpression = null;
        this.cxxExternalSubtaskName = null;
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(int n) {
        this.constraintType = n;
    }

    public String getConstraintName() {
        return DataConstraint.getConstraintNameString(this.getConstraintType());
    }

    public String[] getConstraintTypeTokens() {
        return DataConstraint.getConstraintTokens(this.getConstraintType());
    }

    public String getTCMXorString() {
        switch (this.getConstraintType()) {
            case 0: {
                return "PLAN_FIRST";
            }
            case 1: {
                return "DELAY_PLANNING";
            }
            case 3: {
                return "SEQ_PLANNING";
            }
            case 4: {
                return "SEQ_ACH";
            }
            case 5: {
                return "DELAY_PLANNING | SEQ_ACH";
            }
        }
        return "0";
    }

    public boolean getHasTCMXorString() {
        return this.getTCMXorString() != "0";
    }

    public boolean getNeedsTasksArguments() {
        switch (this.getConstraintType()) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public void setConstraintTypeStringWithoutParsing(String string) {
        int n = DataConstraint.getConstraintIndexOfString(string);
        if (n != -1) {
            this.setConstraintType(n);
        } else {
            System.err.println("[DataConstraint:setConstraintTypeStringWithoutParsing]  Warning:  Unknown Constraint \"" + string + "\".");
        }
    }

    public boolean getHasEventTagTask() {
        return !DataComponent.isEmptyString(this.eventTagTask);
    }

    public boolean getHasNonStandardEventTagTask() {
        return this.getHasEventTagTask() && !this.getHasEventTagTaskOfThis() && !this.getHasEventTagTaskOfChild() && !this.getHasEventTagTaskOfPrevious();
    }

    public boolean getHasEventTagTaskOfThis() {
        return this.getHasEventTagTask() && THIS.equals(this.getEventTagTask());
    }

    public boolean getHasEventTagTaskOfChild() {
        return this.getHasEventTagTask() && CHILD.equals(this.getEventTagTask());
    }

    public boolean getHasEventTagTaskOfPrevious() {
        return this.getHasEventTagTask() && PREVIOUS.equals(this.getEventTagTask());
    }

    public String getEventTagTask() {
        if (this.eventTagTask != null) {
            return this.eventTagTask;
        }
        return "";
    }

    public void setEventTagTask(String string) {
        this.eventTagTask = string != null ? string : "";
    }

    public boolean getHasEventTagTaskIndexes() {
        return this.getEventTagTaskIndexes() != null && this.getEventTagTaskIndexes().length > 0;
    }

    public Object[] getEventTagTaskIndexes() {
        return this.eventTagTaskIndexes;
    }

    public void setEventTagTaskIndexesWithoutParsing(Object[] objectArray) {
        this.eventTagTaskIndexes = objectArray;
    }

    public boolean getHasTagTask() {
        return this.getHasEventTagTask();
    }

    public String getTagTask() {
        return this.getEventTagTask();
    }

    public void setTagTask(String string) {
        this.setEventTagTask(string);
    }

    public boolean getHasTagTaskIndexes() {
        return this.getHasEventTagTaskIndexes();
    }

    public Object[] getTagTaskIndexes() {
        return this.getEventTagTaskIndexes();
    }

    public void setTagTaskIndexesWithoutParsing(Object[] objectArray) {
        this.setEventTagTaskIndexesWithoutParsing(objectArray);
    }

    public boolean getHasConstraintOption() {
        return this.getConstraintOption() >= 0 && this.getConstraintOption() <= 2;
    }

    public int getConstraintOption() {
        return this.constraintOption;
    }

    public void setConstraintOption(int n) {
        this.constraintOption = n;
    }

    public String getConstraintOptionString() {
        return DataConstraint.getConstraintOptionString(this.getConstraintOption());
    }

    public void setConstraintOptionStringWithoutParsing(String string) {
        int n = DataConstraint.getConstraintOptionIndexOfString(string);
        if (n != -1) {
            this.setConstraintOption(n);
        } else {
            System.err.println("[DataConstraint:setConstraintOptionStringWithoutParsing]  Warning:  Unknown Constraint \"" + string + "\".");
        }
    }

    public boolean getHasEventConstraintOption() {
        return this.getEventConstraintOption() >= 0 && this.getEventConstraintOption() <= 2;
    }

    public int getEventConstraintOption() {
        return this.eventConstraintOption;
    }

    public void setEventConstraintOption(int n) {
        this.eventConstraintOption = n;
    }

    public String getEventConstraintOptionString() {
        return DataConstraint.getConstraintOptionString(this.getEventConstraintOption());
    }

    public void setEventConstraintOptionStringWithoutParsing(String string) {
        int n = DataConstraint.getConstraintOptionIndexOfString(string);
        if (n != -1) {
            this.setEventConstraintOption(n);
        } else {
            System.err.println("[DataConstraint:setEventConstraintOptionStringWithoutParsing]  Warning:  Unknown Constraint \"" + string + "\".");
        }
    }

    public boolean getHasStateBoundary() {
        return this.getStateBoundary() >= 0 && this.getStateBoundary() <= 2;
    }

    public int getStateBoundary() {
        return this.stateBoundary;
    }

    public void setStateBoundary(int n) {
        this.stateBoundary = n;
    }

    public String getStateBoundaryString() {
        return DataConstraint.getStateBoundaryString(this.getStateBoundary());
    }

    public void setStateBoundaryStringWithoutParsing(String string) {
        int n = DataConstraint.getStateBoundaryIndexOfString(string);
        if (n != -1) {
            this.setStateBoundary(n);
        } else {
            System.err.println("[DataConstraint:setStateBoundaryStringWithoutParsing]  Warning:  Unknown State-Boundary \"" + string + "\".");
        }
    }

    protected String[] getTime() {
        return this.time;
    }

    protected boolean getHasTime() {
        return this.getTime() != null;
    }

    protected void setHasTime(boolean bl) {
        if (bl == this.getHasTime()) {
            return;
        }
        if (bl) {
            this.time = new String[4];
            int n = 0;
            while (n < 4) {
                this.time[n] = null;
                ++n;
            }
        } else {
            this.time = null;
        }
    }

    public boolean getHasHours() {
        return this.getHasTime() && !DataComponent.isEmptyString(this.getTime()[0]);
    }

    public String getHours() {
        if (this.getHasHours()) {
            return this.getTime()[0];
        }
        return "";
    }

    public void setHoursWithoutParsing(String string) {
        this.setHasTime(true);
        this.getTime()[0] = string;
    }

    public boolean getHasMinutes() {
        return this.getHasTime() && !DataComponent.isEmptyString(this.getTime()[1]);
    }

    public String getMinutes() {
        if (this.getHasMinutes()) {
            return this.getTime()[1];
        }
        return "";
    }

    public void setMinutesWithoutParsing(String string) {
        this.setHasTime(true);
        this.getTime()[1] = string;
    }

    public boolean getHasSeconds() {
        return this.getHasTime() && !DataComponent.isEmptyString(this.getTime()[2]);
    }

    public String getSeconds() {
        if (this.getHasSeconds()) {
            return this.getTime()[2];
        }
        return "";
    }

    public void setSecondsWithoutParsing(String string) {
        this.setHasTime(true);
        this.getTime()[2] = string;
    }

    public boolean getHasFractionsOfASecond() {
        return this.getHasTime() && !DataComponent.isEmptyString(this.getTime()[3]);
    }

    public String getFractionsOfASecond() {
        if (this.getHasFractionsOfASecond()) {
            return this.getTime()[3];
        }
        return "";
    }

    public void setFractionsOfASecondWithoutParsing(String string) {
        this.setHasTime(true);
        this.getTime()[3] = string;
    }

    public DataExpression getTimeExpression() {
        return this.timeExpression;
    }

    public void setTimeExpression(DataExpression dataExpression) {
        this.timeExpression = dataExpression;
    }

    public DataExpression getNumericExpression() {
        return this.numericExpression;
    }

    public void setNumericExpression(DataExpression dataExpression) {
        this.numericExpression = dataExpression;
    }

    public DataSpawnTask getExceptionHandlerTask() {
        return this.exceptionHandlerTask;
    }

    public boolean setExceptionHandlerTask(DataSpawnTask dataSpawnTask) {
        if (dataSpawnTask != null && dataSpawnTask.getTaskName() != null && dataSpawnTask.getTaskName().length() > 0 && dataSpawnTask.getConstraintCount() == 0 || dataSpawnTask == null) {
            this.exceptionHandlerTask = dataSpawnTask;
            this.exceptionHandlerTask.setParent(this);
            return true;
        }
        System.err.println("[DataConstraint:setExceptionHandlerTask]  Error: Bad object for theExceptionHandlerTask:  " + dataSpawnTask.toString());
        return false;
    }

    public DataSpawnTask getOnTerminateTask() {
        return this.onTerminateTask;
    }

    public boolean setOnTerminateTask(DataSpawnTask dataSpawnTask) {
        if (dataSpawnTask != null && dataSpawnTask.getTaskName() != null && dataSpawnTask.getTaskName().length() > 0 && dataSpawnTask.getConstraintCount() == 0 || dataSpawnTask == null) {
            this.onTerminateTask = dataSpawnTask;
            this.onTerminateTask.setParent(this);
            if (!this.onTerminateTask.hasValidLineNumber()) {
                this.onTerminateTask.setLineNumber(this.getLineNumber());
            }
            return true;
        }
        System.err.println("[DataConstraint:setOnTerminateTask]  Error: Bad object for theOnTerminateTask:  " + dataSpawnTask.toString());
        return false;
    }

    public void setLineNumber(int n) {
        super.setLineNumber(n);
        if (this.getOnTerminateTask() != null) {
            this.getOnTerminateTask().setLineNumber(this.getLineNumber());
        }
    }

    public boolean getHasOnTerminateSpawnKeyword() {
        return this.hasOnTerminateSpawnKeyword;
    }

    public void setHasOnTerminateSpawnKeyword(boolean bl) {
        this.hasOnTerminateSpawnKeyword = bl;
    }

    public DataExpression getDistributedFormatStringExpression() {
        return this.distributedFormatStringExpression;
    }

    public void setDistributedFormatStringExpression(DataExpression dataExpression) {
        this.distributedFormatStringExpression = dataExpression;
    }

    public DataExpression getDistributedOnAgentExpression() {
        return this.distributedOnAgentExpression;
    }

    public void setDistributedOnAgentExpression(DataExpression dataExpression) {
        this.distributedOnAgentExpression = dataExpression;
    }

    public DataExpression getTcmTaskTreeParentExpression() {
        return this.tcmTaskTreeParentExpression;
    }

    public void setTcmTaskTreeParentExpression(DataExpression dataExpression) {
        this.tcmTaskTreeParentExpression = dataExpression;
    }

    public DataExpression getTdlRefInExpression() {
        return this.tdlRefInExpression;
    }

    public void setTdlRefInExpression(DataExpression dataExpression) {
        this.tdlRefInExpression = dataExpression;
    }

    public DataExpression getTcmTaskTreeNameExpression() {
        return this.tcmTaskTreeNameExpression;
    }

    public void setTcmTaskTreeNameExpression(DataExpression dataExpression) {
        this.tcmTaskTreeNameExpression = dataExpression;
    }

    public String getCxxExternalSubtaskName() {
        return this.cxxExternalSubtaskName;
    }

    public void setCxxExternalSubtaskName(String string) {
        this.cxxExternalSubtaskName = string;
    }

    public boolean hasChildStatement() {
        return this.getChildStatement() != null;
    }

    public DataStatement getChildStatement() {
        switch (this.getConstraintType()) {
            case 23: {
                return this.getOnTerminateTask();
            }
        }
        return null;
    }

    public boolean hasSubcomponentFraction(String string) {
        if (this.getHasEventTagTaskIndexes()) {
            int n = 0;
            while (n < this.getEventTagTaskIndexes().length) {
                if (this.getEventTagTaskIndexes()[n] instanceof DataComponent && ((DataComponent)this.getEventTagTaskIndexes()[n]).hasSubcomponentFraction(string) || !(this.getEventTagTaskIndexes()[n] instanceof DataComponent) && this.getEventTagTaskIndexes()[n].toString().indexOf(string) != -1) {
                    return true;
                }
                ++n;
            }
        }
        return super.hasSubcomponentFraction(string) || this.getTimeExpression() != null && this.getTimeExpression().hasSubcomponentFraction(string) || this.getNumericExpression() != null && this.getNumericExpression().hasSubcomponentFraction(string);
    }

    public void runOnSubcomponentFraction(String string, RunOnSubcomponentInterface runOnSubcomponentInterface, Object object) {
        super.runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        if (this.getHasEventTagTaskIndexes()) {
            int n = 0;
            while (n < this.getEventTagTaskIndexes().length) {
                if (this.getEventTagTaskIndexes()[n] instanceof DataComponent) {
                    ((DataComponent)this.getEventTagTaskIndexes()[n]).runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
                } else {
                    DataComponent.staticRunOnStringFraction(this.getEventTagTaskIndexes()[n].toString(), string, runOnSubcomponentInterface, object);
                }
                ++n;
            }
        }
        if (this.getTimeExpression() != null) {
            this.getTimeExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getNumericExpression() != null) {
            this.getNumericExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getExceptionHandlerTask() != null) {
            this.getExceptionHandlerTask().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getDistributedFormatStringExpression() != null) {
            this.getDistributedFormatStringExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getDistributedOnAgentExpression() != null) {
            this.getDistributedOnAgentExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getTcmTaskTreeParentExpression() != null) {
            this.getTcmTaskTreeParentExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getTdlRefInExpression() != null) {
            this.getTdlRefInExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
        if (this.getTcmTaskTreeNameExpression() != null) {
            this.getTcmTaskTreeNameExpression().runOnSubcomponentFraction(string, runOnSubcomponentInterface, object);
        }
    }

    public void validateExternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        if (this.getHasEventTagTaskOfThis()) {
            dataValidateCodeReturnValue.addWarning(this).write("Using ").write(DataComponent.CXX_TCM_ROOT_NODE).write(" for \"THIS\"\n");
            if (this.getConstraintType() == 2 || this.getEventConstraintOption() == 0 || this.getHasEventTagTask() && !this.getHasEventConstraintOption()) {
                dataValidateCodeReturnValue.addWarning(this).write(DataComponent.CXX_TCM_ROOT_NODE).write(" [\"THIS\"] Handling never runs.\n");
            }
        }
        if (this.getHasEventTagTaskOfPrevious()) {
            dataValidateCodeReturnValue.addWarning(this).write("Using ").write(DataComponent.CXX_TCM_PREVIOUS_EXTERNAL_TASK_REF).write(" for \"PREVIOUS\"\n");
        }
        if (this.getConstraintType() == 25) {
            dataValidateCodeReturnValue.addError(this).write("ON-AGENT constraint may ONLY be used inside a Task-body.").write("  It may NOT not be used inside a function or method!\n");
        }
        this.validateInternalCode(n, dataValidateCodeReturnValue, false);
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue) throws CompilationException {
        this.validateInternalCode(n, dataValidateCodeReturnValue, true);
    }

    public void validateInternalCode(int n, DataValidateCodeReturnValue dataValidateCodeReturnValue, boolean bl) throws CompilationException {
        if (this.getHasNonStandardEventTagTask()) {
            DataComponent dataComponent = this;
            while (dataComponent != null) {
                if (dataComponent instanceof DataTaskDefinition) break;
                dataComponent = dataComponent.getParent();
            }
            if (dataComponent == null) {
                throw new CompilationException(this.getMessageFilenameLead() + this.getLineNumberString() + ": Programmer Error:  Unable to find DataTaskDefinition ancestor.");
            }
            DataTaskDefinition dataTaskDefinition = (DataTaskDefinition)dataComponent;
            DataComponent dataComponent2 = dataTaskDefinition.getDataComponentWithName(this.getEventTagTask());
            if (dataComponent2 != null) {
                int n2 = dataTaskDefinition.getIterationParentCount(dataComponent2);
                if (dataComponent2 instanceof DataBindTaskStatement) {
                    if (this.getHasEventTagTaskIndexes()) {
                        dataValidateCodeReturnValue.addError(this).write("Too many Iteration-Indexes for TDL_BIND ").write("Constraint Reference.  (There is (are) ").write("" + this.getEventTagTaskIndexes().length).write(" array index(es) specified.  ").write("There should be zero.)\n");
                    }
                } else {
                    if (this.getHasEventTagTaskIndexes() && this.getEventTagTaskIndexes().length > n2) {
                        dataValidateCodeReturnValue.addError(this).write("Too many Iteration-Indexes for Constraint").write(" Reference.  (Reference is enclosed in ").write("" + n2).write(" iteration loop(s) and there is (are) ").write("" + this.getEventTagTaskIndexes().length).write(" array index(es) specified.)\n");
                    }
                    if (n2 > 0 && (this.getEventTagTaskIndexes() == null || this.getEventTagTaskIndexes().length < n2)) {
                        dataValidateCodeReturnValue.addWarning(this).write("Using an Iteration-Set of References for ").write("Constraint Reference.  (Reference is enclosed in ").write("" + n2).write(" iteration loop(s) and there is (are) ").write(this.getEventTagTaskIndexes() == null ? "0" : "" + this.getEventTagTaskIndexes().length).write(" array index(es) specified.)\n");
                    }
                }
            }
        }
        int n3 = 0;
        while (this.getHasEventTagTaskIndexes() && n3 < this.getEventTagTaskIndexes().length) {
            if (this.getEventTagTaskIndexes()[n3].toString().trim().charAt(0) == '0' && this.getEventTagTaskIndexes()[n3].toString().trim().length() > 1) {
                dataValidateCodeReturnValue.addWarning(this).write("Task Index is specified in octal.\n");
                break;
            }
            ++n3;
        }
        if (!(this.getConstraintType() != 2 && this.getConstraintType() != 3 && this.getConstraintType() != 4 || !this.getHasEventTagTaskOfChild() && !this.getHasEventTagTaskOfThis() || this.getConstraintType() == 2 && this.getHasEventTagTaskOfThis())) {
            dataValidateCodeReturnValue.addError(this).write("Circular dependency detected.  Sequential on ");
            if (this.getHasEventTagTaskOfChild()) {
                dataValidateCodeReturnValue.getDataDestination().write("CHILD.\n");
            } else {
                dataValidateCodeReturnValue.getDataDestination().write("THIS.\n");
            }
        }
        if (this.getConstraintType() == 5 && (this.getHasEventTagTaskOfChild() || this.getHasEventTagTaskOfThis())) {
            dataValidateCodeReturnValue.addError(this).write("Circular dependency detected.  Serial on ");
            if (this.getHasEventTagTaskOfChild()) {
                dataValidateCodeReturnValue.getDataDestination().write("CHILD.\n");
            } else {
                dataValidateCodeReturnValue.getDataDestination().write("THIS.\n");
            }
        }
        if (this.getConstraintType() == 8 || this.getConstraintType() == 10 && this.getHasEventTagTask()) {
            if (this.getHasEventTagTaskOfChild() && (!this.getHasConstraintOption() || this.getConstraintOption() == 0 || this.getConstraintOption() == 1 && (this.getEventConstraintOption() != 2 || this.getStateBoundary() != 0) || this.getConstraintOption() == 2 && (this.getEventConstraintOption() == 2 || !this.getHasEventConstraintOption() && this.getStateBoundary() == 2))) {
                dataValidateCodeReturnValue.addError(this).write("Circular dependency detected.  Disable on CHILD.\n");
            }
            if (this.getHasEventTagTaskOfThis() && (this.getEventConstraintOption() == 1 || this.getEventConstraintOption() == 2) && this.getStateBoundary() == 2) {
                dataValidateCodeReturnValue.addError(this).write("Circular dependency detected.  Disable on THIS.\n");
            }
        }
        if (this.getConstraintType() == 11 && this.getHasEventTagTaskOfChild()) {
            dataValidateCodeReturnValue.addWarning(this).write("Are you certain you want to Terminate on CHILD?\n");
        }
        if ((this.getConstraintType() == 11 || this.getConstraintType() == 13) && this.getHasEventTagTaskOfThis()) {
            dataValidateCodeReturnValue.addWarning(this).write("Are you certain you want to Terminate on THIS?\n");
        }
        if (this.getConstraintType() == 15 && this.getHasEventTagTaskOfChild()) {
            dataValidateCodeReturnValue.addWarning(this).write("Are you certain you want to Activate on CHILD?\n");
        }
        if ((this.getConstraintType() == 15 || this.getConstraintType() == 17) && this.getHasEventTagTaskOfThis()) {
            dataValidateCodeReturnValue.addWarning(this).write("Are you certain you want to Activate on THIS?\n");
        }
        if (this.getConstraintType() == 19 && this.getNumericExpression() == null) {
            dataValidateCodeReturnValue.addError(this).write("MAXIMUM ACTIVATE specification incomplete.\n");
        }
        if (this.getConstraintType() == 20 && this.getNumericExpression() == null) {
            dataValidateCodeReturnValue.addError(this).write("MAXIMUM ACTIVATE specification incomplete.\n");
        }
        if (this.getConstraintType() == 22 && (this.getExceptionHandlerTask() == null || this.getExceptionHandlerTask().getTaskName() == null || this.getExceptionHandlerTask().getTaskName().length() <= 0)) {
            dataValidateCodeReturnValue.addError(this).write("EXCEPTION HANDLER specification incomplete.\n");
        }
        if (this.getConstraintType() == 23 && (this.getOnTerminateTask() == null || this.getOnTerminateTask().getTaskName() == null || this.getOnTerminateTask().getTaskName().length() <= 0)) {
            dataValidateCodeReturnValue.addError(this).write("ON TERMINATE task specification incomplete.\n");
        }
        if (bl && this.getConstraintType() == 27) {
            dataValidateCodeReturnValue.addError(this).write("The \"TDL_REF IN\" constraint may not be used inside a ").write("Task.  It may only be employed outside of any Task, ").write("on SPAWNs located inside C++ functions or methods.\n");
        }
    }

    public boolean isValid(int n) {
        if (this.getConstraintType() < 0 || this.getConstraintType() > 28) {
            return false;
        }
        switch (this.getConstraintType()) {
            case 8: 
            case 11: 
            case 15: {
                if (this.getStateBoundary() < 0 || this.getStateBoundary() > 2) {
                    return false;
                }
                if (this.getEventTagTask() != null) break;
                return false;
            }
            case 9: 
            case 12: 
            case 16: {
                if (this.getHasHours() && this.getHasMinutes() || this.getTimeExpression() != null) break;
                return false;
            }
            case 10: 
            case 13: 
            case 17: {
                if (this.getHasSeconds() || this.getTimeExpression() != null) break;
                return false;
            }
            case 19: 
            case 20: {
                if (this.getNumericExpression() != null) break;
                return false;
            }
            case 22: {
                if (this.getExceptionHandlerTask() != null && this.getExceptionHandlerTask().getTaskName() != null && this.getExceptionHandlerTask().getTaskName().length() > 0) break;
                return false;
            }
            case 23: {
                if (this.getOnTerminateTask() != null && this.getOnTerminateTask().getTaskName() != null && this.getOnTerminateTask().getTaskName().length() > 0) break;
                return false;
            }
            case 24: {
                if (this.getDistributedFormatStringExpression() == null) {
                    return false;
                }
                if (this.getDistributedFormatStringExpression().getSubcomponentsCount() > 0) break;
                return false;
            }
            case 25: {
                if (this.getDistributedOnAgentExpression() == null) {
                    return false;
                }
                if (this.getDistributedOnAgentExpression().getSubcomponentsCount() > 0) break;
                return false;
            }
            case 26: {
                if (this.getTcmTaskTreeParentExpression() == null) {
                    return false;
                }
                if (this.getTcmTaskTreeParentExpression().getSubcomponentsCount() > 0) break;
                return false;
            }
            case 27: {
                if (this.getTdlRefInExpression() == null) {
                    return false;
                }
                if (this.getTdlRefInExpression().getSubcomponentsCount() > 0) break;
                return false;
            }
            case 28: {
                if (this.getTcmTaskTreeNameExpression() == null) {
                    return false;
                }
                if (this.getTcmTaskTreeNameExpression().getSubcomponentsCount() > 0) break;
                return false;
            }
        }
        return true;
    }

    public void generate(DataDestination dataDestination, int n) {
        this.warnIfInvalidObjectSubset(n, "generate");
        if (this.isCxxSubset(n)) {
            this.generateCxxTaskInternal(dataDestination);
        }
        boolean bl = false;
        int n2 = 0;
        String[] stringArray = this.getConstraintTypeTokens();
        if (stringArray == null || stringArray.length <= 0) {
            System.err.println("[DataConstraint:generate]  Error:  No keywordStrings!!! ( " + stringArray + ")");
            return;
        }
        this.initializeGenerateSubcomponentIndex();
        this.generateSubcomponents("DataComponentFirstTokenIndex", dataDestination, n, false);
        this.generateSubcomponents(KEYWORD + n2, dataDestination, n, this.getIndex("DataComponentFirstTokenIndex") == 0);
        dataDestination.write(stringArray[n2]);
        switch (this.getConstraintType()) {
            case 6: 
            case 7: 
            case 14: 
            case 18: {
                break;
            }
            case 0: 
            case 1: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                dataDestination.write(stringArray[n2]);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                dataDestination.write(stringArray[n2]);
            }
            case 5: {
                if (!this.getHasEventTagTask()) break;
                this.generateEventTagTask(dataDestination, n);
                break;
            }
            case 8: {
                this.generateSubcomponents(CONSTRAINT_OPTION, dataDestination, n, false);
                if (this.getHasConstraintOption()) {
                    dataDestination.write(this.getConstraintOptionString());
                }
            }
            case 11: 
            case 15: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                dataDestination.write(stringArray[n2]);
                this.generateEvent(dataDestination, n);
                break;
            }
            case 9: 
            case 10: {
                this.generateSubcomponents(CONSTRAINT_OPTION, dataDestination, n, false);
                if (this.getHasConstraintOption()) {
                    dataDestination.write(this.getConstraintOptionString());
                }
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                dataDestination.write(stringArray[n2]);
            }
            case 21: {
                this.generateTime(dataDestination, n);
                if (this.getConstraintType() != 10 && this.getConstraintType() != 13 && this.getConstraintType() != 17) break;
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                if (!this.getHasEventTagTask()) break;
                dataDestination.write(stringArray[n2]);
                this.generateEvent(dataDestination, n);
                break;
            }
            case 19: 
            case 20: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, true);
                dataDestination.write(stringArray[n2]);
                if (!this.getNumericExpression().hasLeadingWhitespaceSubcomponent()) {
                    dataDestination.write(" ");
                }
                this.getNumericExpression().generate(dataDestination, 0);
                break;
            }
            case 22: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, true);
                dataDestination.write(stringArray[n2]);
                this.getExceptionHandlerTask().generate(dataDestination, 3);
                break;
            }
            case 23: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, true);
                dataDestination.write(stringArray[n2]);
                this.getOnTerminateTask().generateLabels(dataDestination, 0, null, true);
                if (this.getHasOnTerminateSpawnKeyword()) {
                    this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, false);
                    dataDestination.write(stringArray[n2]);
                }
                this.getOnTerminateTask().generate(dataDestination, 3);
                break;
            }
            case 24: {
                if (this.getDistributedFormatStringExpression() == null) break;
                this.getDistributedFormatStringExpression().generate(dataDestination, n);
                break;
            }
            case 25: {
                if (this.getDistributedOnAgentExpression() == null) break;
                this.getDistributedOnAgentExpression().generate(dataDestination, n);
                break;
            }
            case 26: {
                if (this.getTcmTaskTreeParentExpression() == null) break;
                this.getTcmTaskTreeParentExpression().generate(dataDestination, n);
                break;
            }
            case 27: {
                this.generateSubcomponents(KEYWORD + ++n2, dataDestination, n, true);
                dataDestination.write(stringArray[n2]);
                if (this.getTdlRefInExpression() == null) break;
                this.getTdlRefInExpression().generate(dataDestination, n);
                break;
            }
            case 28: {
                if (this.getTcmTaskTreeNameExpression() == null) break;
                this.getTcmTaskTreeNameExpression().generate(dataDestination, n);
            }
        }
        this.generateAllRemainingSubcomponents(dataDestination, n, false);
    }

    protected void generateEventTagTask(DataDestination dataDestination, int n) {
        Object[] objectArray = this.getEventTagTaskIndexes();
        if (!this.getHasEventTagTask()) {
            System.err.println("[DataConstraint:generateEventTagTask]  Error:  No Event-Tag-Task available to generate...");
            return;
        }
        this.generateSubcomponents(TAG_TASK, dataDestination, n, true);
        dataDestination.write(this.getEventTagTask());
        if (this.getHasEventTagTaskIndexes()) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.generateSubcomponents(BEGIN_TAG_TASK_INDEX + n2, dataDestination, n, false);
                dataDestination.write(BEGIN_TAG_TASK_INDEX);
                this.generateSubcomponents("" + n2, dataDestination, n, false);
                if (objectArray[n2] != null) {
                    if (objectArray[n2] instanceof DataComponent) {
                        ((DataComponent)objectArray[n2]).generate(dataDestination, 0);
                    } else {
                        dataDestination.write(objectArray[n2].toString());
                    }
                }
                this.generateSubcomponents(END_TAG_TASK_INDEX + n2, dataDestination, n, false);
                dataDestination.write(END_TAG_TASK_INDEX);
                ++n2;
            }
        }
    }

    protected void generateEvent(DataDestination dataDestination, int n) {
        this.generateEventTagTask(dataDestination, n);
        this.generateSubcomponents(EVENT_CONSTRAINT_OPTION, dataDestination, n, false);
        if (this.getHasEventConstraintOption()) {
            dataDestination.write(this.getEventConstraintOptionString());
        }
        this.generateSubcomponents(STATE_BOUNDARY, dataDestination, n, false);
        dataDestination.write(this.getStateBoundaryString());
    }

    protected void generateTime(DataDestination dataDestination, int n) {
        if (this.getTimeExpression() != null) {
            int n2 = dataDestination.indentToCurrentColumn();
            if (n2 >= dataDestination.getNewlineText().length()) {
                dataDestination.removeIndent(dataDestination.getNewlineText().length());
                n2 -= dataDestination.getNewlineText().length();
            }
            this.getTimeExpression().generate(dataDestination, 0);
            dataDestination.removeIndent(n2);
        } else {
            this.generateSubcomponents(PRE_TIME_HOURS, dataDestination, n, false);
            if (this.getHasHours()) {
                dataDestination.write(this.getHours());
            }
            this.generateSubcomponents(POST_TIME_HOURS, dataDestination, n, false);
            if (this.getHasHours()) {
                dataDestination.write(TIME_SEPARATOR);
            }
            this.generateSubcomponents(PRE_TIME_MINUTES, dataDestination, n, false);
            if (this.getHasMinutes()) {
                dataDestination.write(this.getMinutes());
            } else if (this.getHasHours()) {
                dataDestination.write("0");
            }
            this.generateSubcomponents(POST_TIME_MINUTES, dataDestination, n, false);
            if (this.getHasMinutes() || this.getHasHours()) {
                dataDestination.write(TIME_SEPARATOR);
            }
            this.generateSubcomponents(PRE_TIME_SECONDS, dataDestination, n, false);
            if (this.getHasSeconds()) {
                dataDestination.write(this.getSeconds());
            } else if (this.getHasHours() || this.getHasMinutes()) {
                dataDestination.write("0");
            }
            this.generateSubcomponents(POST_TIME_SECONDS, dataDestination, n, false);
            if (this.getHasFractionsOfASecond()) {
                dataDestination.write(".");
            }
            this.generateSubcomponents(PRE_TIME_FRACTIONS_OF_A_SECOND, dataDestination, n, false);
            if (this.getHasFractionsOfASecond()) {
                dataDestination.write(this.getFractionsOfASecond());
            }
        }
    }

    public void generateCxxTaskInternal(DataDestination dataDestination) {
        int n = dataDestination.indentToCurrentColumn();
        switch (this.getConstraintType()) {
            case 0: {
                dataDestination.write("_TDL_ExpandFirst");
                break;
            }
            case 1: {
                dataDestination.write("_TDL_DelayExpansion");
                break;
            }
            case 6: {
                dataDestination.write("_TDL_Parallel");
                break;
            }
            case 7: {
                dataDestination.write("_TDL_Wait");
                break;
            }
            case 2: {
                dataDestination.write("_TDL_SequentialHandling");
                break;
            }
            case 3: {
                dataDestination.write("_TDL_SequentialExpansion");
                break;
            }
            case 4: {
                dataDestination.write("_TDL_SequentialExecution");
                break;
            }
            case 5: {
                dataDestination.write("_TDL_Serial");
                break;
            }
            case 8: {
                dataDestination.write("_TDL_DisableUntilEvent");
                break;
            }
            case 9: {
                dataDestination.write("_TDL_DisableUntilTime");
                break;
            }
            case 10: {
                dataDestination.write("_TDL_DisableForTime");
                break;
            }
            case 11: {
                dataDestination.write("_TDL_TerminateAtEvent");
                break;
            }
            case 12: {
                dataDestination.write("_TDL_TerminateAtTime");
                break;
            }
            case 13: {
                dataDestination.write("_TDL_TerminateInTime");
                break;
            }
            case 14: {
                dataDestination.write("_TDL_TerminateImmediate");
                break;
            }
            case 15: {
                dataDestination.write("_TDL_ActivateAtEvent");
                break;
            }
            case 16: {
                dataDestination.write("_TDL_ActivateAtTime");
                break;
            }
            case 17: {
                dataDestination.write("_TDL_ActivateInTime");
                break;
            }
            case 18: {
                dataDestination.write("_TDL_ActivateImmediate");
                break;
            }
            case 19: {
                dataDestination.write("_TDL_SetMonitorMaximumActivations");
                break;
            }
            case 20: {
                dataDestination.write("_TDL_SetMonitorMaximumTriggers");
                break;
            }
            case 21: {
                dataDestination.write("_TDL_SetMonitorPeriod");
                break;
            }
            case 22: {
                dataDestination.write("_TDL_AddExceptionHandler");
                break;
            }
            case 23: {
                dataDestination.write("_TDL_OnTermination");
                break;
            }
            case 25: {
                dataDestination.write("_TDL_OnAgent");
                break;
            }
            default: {
                String string = null;
                switch (this.getConstraintType()) {
                    case 24: {
                        string = "Distributed FORMAT";
                        break;
                    }
                    case 26: {
                        string = "PARENT";
                        break;
                    }
                    case 27: {
                        string = "TDL_REF IN";
                        break;
                    }
                    case 28: {
                        string = "NAME";
                    }
                }
                if (string != null) {
                    System.err.println("[DataConstraint:generateCxxTaskInternal]  Error:  Attempting to generate a " + string + " constraint.  This should not be " + "happening.  Aborting this constraint...");
                } else {
                    System.err.println("[DataConstraint:generateCxxTaskInternal]  Error:  Unknown Constraint-Type (" + this.getConstraintType() + ")  Aborting this constraint...");
                }
                dataDestination.removeIndent(n);
                return;
            }
        }
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        n += DataComponent.STANDARD_INDENT;
        dataDestination.write(" (\n");
        this.privateGenerateCxxArguments(dataDestination, null, true, false);
        dataDestination.write(" )");
        dataDestination.removeIndent(n);
    }

    public void generateCxxExternalSubtaskDeclarations(DataDestination dataDestination, boolean bl) {
        String string = null;
        String string2 = null;
        if (this.getCxxExternalSubtaskName() != null) {
            System.err.println("[DataConstraint:generateCxxExternalSubtaskDeclarations]  Internal consistency check failure:  generateCxxExternalSubtaskDeclarations() has previously been invoked without an intervening generateCxxTaskExternal() call.");
        }
        switch (this.getConstraintType()) {
            case 23: {
                if (this.getOnTerminateTask() == null || this.getOnTerminateTask().getTaskName() == null) {
                    throw new CompilationException("Internal Error:  DataConstraint object of type \"ON TERMINATE\" is lacking a task to spawn.");
                }
                string = this.getOnTerminateTask().getTaskName();
                string2 = "onTerminate";
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            this.setCxxExternalSubtaskName("_TDL_arbitrarySubTask_" + DataSpawnTask.getArbitrarySubTaskIndex());
            if (bl) {
                dataDestination.write("\n");
            }
            dataDestination.write("TCM_Task_Tree_Ref");
            dataDestination.write("  ");
            dataDestination.write(this.getCxxExternalSubtaskName());
            dataDestination.write(" = ");
            dataDestination.write("_TDL_Allocate_");
            dataDestination.write(string);
            dataDestination.write(" ( \"");
            dataDestination.write(string);
            dataDestination.write("-");
            dataDestination.write(string2);
            dataDestination.write("\" );\n");
        } else {
            this.setCxxExternalSubtaskName(null);
        }
    }

    public DataLabelStatement getCxxExternalSubtaskDeclarationLabel() {
        switch (this.getConstraintType()) {
            case 23: {
                if (this.getOnTerminateTask() == null) break;
                return this.getOnTerminateTask().getLabel();
            }
        }
        return null;
    }

    public void generateCxxTaskExternal(DataDestination dataDestination, String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        switch (this.getConstraintType()) {
            case 0: {
                if (!bl2) {
                    string4 = "_TDL_DO_TCM_EXPAND_FIRST";
                    break;
                }
                string4 = "_TDL_DO_TCM_EXPAND_FIRST_MONITOR_TASK_LEVEL";
                break;
            }
            case 1: {
                if (!bl2) {
                    string4 = "_TDL_DO_TCM_DELAY_EXPANSION";
                    break;
                }
                string4 = "_TDL_DO_TCM_DELAY_EXPANSION_MONITOR_TASK_LEVEL";
                break;
            }
            case 6: {
                string4 = "_TDL_DO_TCM_PARALLEL";
                break;
            }
            case 7: {
                string4 = "_TDL_DO_TCM_WAIT";
                break;
            }
            case 2: {
                string4 = "_TDL_DO_TCM_SEQUENTIAL_HANDLING";
                break;
            }
            case 3: {
                if (!bl2) {
                    string4 = "_TDL_DO_TCM_SEQUENTIAL_EXPANSION";
                    break;
                }
                string4 = "_TDL_DO_TCM_SEQUENTIAL_EXPANSION_MONITOR_TASK_LEVEL";
                break;
            }
            case 4: {
                if (!bl2) {
                    string4 = "_TDL_DO_TCM_SEQUENTIAL_EXECUTION";
                    break;
                }
                string4 = "_TDL_DO_TCM_SEQUENTIAL_EXECUTION_MONITOR_TASK_LEVEL";
                break;
            }
            case 5: {
                if (!bl2) {
                    string4 = "_TDL_DO_TCM_SERIAL";
                    break;
                }
                string4 = "_TDL_DO_TCM_SERIAL_MONITOR_TASK_LEVEL";
                break;
            }
            case 8: {
                string4 = "_TDL_DO_TCM_DISABLE_UNTIL_EVENT";
                break;
            }
            case 9: {
                string4 = "_TDL_DO_TCM_DISABLE_UNTIL";
                break;
            }
            case 10: {
                string4 = "_TDL_DO_TCM_DISABLE_FOR";
                break;
            }
            case 11: {
                string4 = "_TDL_DO_TCM_TERMINATE_AT_EVENT";
                break;
            }
            case 12: {
                string4 = "_TDL_DO_TCM_TERMINATE_AT";
                break;
            }
            case 13: {
                string4 = "_TDL_DO_TCM_TERMINATE_IN";
                break;
            }
            case 14: {
                string4 = "_TDL_DO_TCM_TERMINATE_IMMEDIATE";
                break;
            }
            case 15: {
                string4 = "_TDL_DO_TCM_ACTIVATE_AT_EVENT";
                break;
            }
            case 16: {
                string4 = "_TDL_DO_TCM_ACTIVATE_AT";
                break;
            }
            case 17: {
                string4 = "_TDL_DO_TCM_ACTIVATE_IN";
                break;
            }
            case 18: {
                string4 = "_TDL_DO_TCM_ACTIVATE_IMMEDIATE";
                break;
            }
            case 19: {
                string4 = "_TDL_DO_SET_MONITOR_MAXIMUM_ACTIVATIONS";
                break;
            }
            case 20: {
                string4 = "_TDL_DO_SET_MONITOR_MAXIMUM_TRIGGERS";
                break;
            }
            case 21: {
                string4 = "_TDL_DO_SET_MONITOR_PERIOD";
                break;
            }
            case 22: {
                string4 = "_TDL_DO_ADD_EXCEPTION_HANDLER";
                break;
            }
            case 23: {
                string4 = "_TDL_DO_TCM_ON_TERMINATION";
                break;
            }
            default: {
                String string5 = null;
                switch (this.getConstraintType()) {
                    case 24: {
                        string5 = "Distributed FORMAT";
                        break;
                    }
                    case 25: {
                        string5 = "Distributed ON-AGENT";
                        break;
                    }
                    case 26: {
                        string5 = "PARENT";
                        break;
                    }
                    case 27: {
                        string5 = "TDL_REF IN";
                        break;
                    }
                    case 28: {
                        string5 = "NAME";
                    }
                }
                if (string5 != null) {
                    System.err.println("[DataConstraint:generateCxxTaskExternal]  Error:  Attempting to generate a " + string5 + " constraint.  This should not be " + "happening.  Aborting this constraint...");
                } else {
                    System.err.println("[DataConstraint:generateCxxTaskExternal]  Error:  Unknown Constraint-Type (" + this.getConstraintType() + ")  Aborting this constraint...");
                }
                return;
            }
        }
        int n = dataDestination.indentToCurrentColumn();
        dataDestination.setNewlineText("       // ");
        dataDestination.write("\n");
        dataDestination.setStripLeadingWhitespace();
        this.generate(dataDestination, 0);
        dataDestination.clearNewlineText();
        dataDestination.removeIndent(n);
        dataDestination.write("\n");
        if (bl) {
            dataDestination.write("&& ");
        }
        dataDestination.write("TDL::verifyConstraint");
        dataDestination.write(" ( ");
        int n2 = dataDestination.indentToCurrentColumn();
        dataDestination.write(string);
        dataDestination.write(",\n");
        dataDestination.write("\"");
        dataDestination.write(string4);
        dataDestination.write("\",\n");
        dataDestination.write(string3);
        dataDestination.write(string4);
        dataDestination.addIndent(DataComponent.STANDARD_INDENT);
        dataDestination.write(" (\n");
        this.privateGenerateCxxArguments(dataDestination, string2, false, bl2);
        dataDestination.removeIndent(n2 += DataComponent.STANDARD_INDENT);
        dataDestination.write(" ) )");
        if (!bl) {
            dataDestination.write(";");
        }
        dataDestination.write("\n");
    }

    protected void privateGenerateCxxArguments(DataDestination dataDestination, String string, boolean bl, boolean bl2) {
        int n = dataDestination.indentToCurrentColumn();
        switch (this.getConstraintType()) {
            case 0: 
            case 1: 
            case 7: {
                if (string == null) break;
                dataDestination.write(string);
                break;
            }
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (bl2) {
                    if (string == null) break;
                    dataDestination.write(string);
                    break;
                }
            }
            case 2: {
                this.generateEventTagTaskCxxReference(dataDestination, string, bl);
                if (string == null) break;
                dataDestination.write(",\n");
                dataDestination.write(string);
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                this.privateGenerateCxxEventArguments(dataDestination, string, bl);
                if (string != null) {
                    dataDestination.write(",\n");
                    dataDestination.write(string);
                }
                if (this.getConstraintType() != 8) break;
                dataDestination.write(",\n");
                dataDestination.write(this.getCxxInterval(this.getConstraintOption()));
                break;
            }
            case 10: 
            case 13: 
            case 17: {
                if (this.getHasEventTagTask()) {
                    this.privateGenerateCxxEventArguments(dataDestination, string, bl);
                    dataDestination.write(",\n");
                }
            }
            case 9: 
            case 12: 
            case 16: {
                if (string != null) {
                    dataDestination.write(string);
                    dataDestination.write(",\n");
                }
                if (this.getConstraintType() == 9 || this.getConstraintType() == 10) {
                    dataDestination.write(this.getCxxInterval(this.getConstraintOption()));
                    dataDestination.write(",\n");
                }
                this.generateCxxTimeArguments(dataDestination);
                break;
            }
            case 14: 
            case 18: {
                if (string == null) break;
                dataDestination.write(string);
                break;
            }
            case 19: 
            case 20: {
                if (string != null) {
                    dataDestination.write(string);
                    dataDestination.write(",");
                }
                if (dataDestination.getEnableLineMacros()) {
                    dataDestination.setUsingTdlFileName(true);
                    dataDestination.makeNextLineNumber(this.getNumericExpression().getLineNumber());
                    dataDestination.write("\n");
                } else if (string != null) {
                    dataDestination.write("\n");
                }
                dataDestination.setStripLeadingWhitespace();
                dataDestination.setPersistentlyStripLeadingSpaces(true);
                this.getNumericExpression().generate(dataDestination, 0);
                dataDestination.setPersistentlyStripLeadingSpaces(false);
                if (!dataDestination.getEnableLineMacros()) break;
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n");
                break;
            }
            case 21: {
                if (string != null) {
                    dataDestination.write(string);
                    dataDestination.write(",\n");
                }
                this.generateCxxTimeArguments(dataDestination);
                break;
            }
            case 22: {
                DataTaskDefinition dataTaskDefinition;
                dataDestination.removeIndent(n);
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                if (string != null) {
                    dataDestination.write(string);
                    dataDestination.write(",\n");
                }
                if (this.getExceptionHandlerTask() == null || this.getExceptionHandlerTask().getTaskName() == null || this.getExceptionHandlerTask().getTaskName().length() <= 0) {
                    throw new CompilationException("Internal Error:  DataConstraint object of type \"EXCEPTION HANDLER\" does not handle an exception.");
                }
                dataDestination.write("_TDL_CreateExceptionHandler_");
                dataDestination.setStripLeadingWhitespace();
                this.getExceptionHandlerTask().generateTask(dataDestination, 0, false, false, true, true, true);
                dataDestination.write(",\n");
                int n2 = this.getParent() instanceof DataConstraintStatement && ((DataConstraintStatement)this.getParent()).getHasTaskTagOfThis() ? -1 : ((dataTaskDefinition = this.getParentTaskDefinition()) != null && dataTaskDefinition != this.getParent() ? dataTaskDefinition.getIdentifierForConstraint(this, true) : -1);
                dataDestination.write(Integer.toString(n2));
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.addIndent(n);
                break;
            }
            case 23: {
                dataDestination.removeIndent(n);
                dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                dataDestination.write("\n");
                if (this.getOnTerminateTask() == null || this.getOnTerminateTask().getTaskName() == null) {
                    throw new CompilationException("Internal Error:  DataConstraint object of type \"ON TERMINATE\" is lacking a task to spawn.");
                }
                if (!bl) {
                    if (string == null) {
                        throw new CompilationException("Internal Error:  External DataConstraint object of type \"ON TERMINATE\" is lacking an object being spawned.");
                    }
                    dataDestination.write(string);
                    dataDestination.write(",\n");
                    if (this.getCxxExternalSubtaskName() == null) {
                        throw new CompilationException("Internal Error:  generateCxxExternalSubtaskDeclarations() was NOT invoked before generateCxxTaskExternal().  NO allocation was made for this \"ON TERMINATE\" constraint's subtask.");
                    }
                    dataDestination.write("TDL::doSetOnTerminateTaskAction");
                    dataDestination.write(" ( ");
                    dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                    dataDestination.write("\n");
                    dataDestination.write("\"[:'");
                    dataDestination.write(this.getOnTerminateTask().getTaskName());
                    dataDestination.write("' - ");
                    dataDestination.write(this.getCxxExternalSubtaskName());
                    dataDestination.write("]\",\n");
                    dataDestination.write(this.getCxxExternalSubtaskName());
                    dataDestination.write(",\n");
                    this.getOnTerminateTask().addArgument(this.getCxxExternalSubtaskName(), 0);
                    this.setCxxExternalSubtaskName(null);
                } else {
                    DataTaskDefinition dataTaskDefinition = this.getParentTaskDefinition();
                    if (dataTaskDefinition == null) {
                        throw new CompilationException("Internal Error in [DataConstraint:privateGenerateCxxArguments]:  On-Terminate Constraint is not contained in a task.  Unable to satisfy constraint \"" + this.toString() + "\".");
                    }
                    String string2 = dataTaskDefinition.getIdentifierForSubtask(this.getOnTerminateTask());
                    dataDestination.write("_TDL_SpawnedTasks");
                    dataDestination.write(" . ");
                    dataDestination.write("doSetOnTerminateTaskAction");
                    dataDestination.write(" (");
                    dataDestination.addIndent(DataComponent.STANDARD_INDENT);
                    dataDestination.write("\n");
                    dataDestination.write("\"");
                    dataDestination.write(string2);
                    dataDestination.write("\",\n");
                    this.getOnTerminateTask().addArgument("_TDL_SpawnedTasks . getTaskTreeRef ( \"" + string2 + "\" )", 0);
                }
                dataDestination.write("_TDL_CreateAction_");
                dataDestination.setStripLeadingWhitespace();
                this.getOnTerminateTask().generateTask(dataDestination, 0, false, false, true, true, true);
                dataDestination.write(" )");
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                this.getOnTerminateTask().removeArgument(0);
                dataDestination.removeIndent(DataComponent.STANDARD_INDENT);
                dataDestination.addIndent(n);
                break;
            }
            case 25: {
                if (this.getDistributedOnAgentExpression() != null) {
                    this.getDistributedOnAgentExpression().generate(dataDestination, 0);
                    break;
                }
                throw new CompilationException("Internal Error:  DataConstraint object of type \"ON AGENT\" has a null on-agent expression.");
            }
            default: {
                System.err.println("[DataConstraint:privateGenerateCxxArguments]  ERROR:  Unknown Constraint-Type (" + this.getConstraintType() + ")");
            }
        }
        dataDestination.removeIndent(n);
    }

    public String getCxxHours() {
        return this.getHasHours() ? DataConstraint.stripLeadingZeros(this.getHours().trim()) : "0";
    }

    public String getCxxMinutes() {
        return this.getHasMinutes() ? DataConstraint.stripLeadingZeros(this.getMinutes().trim()) : "0";
    }

    public String getCxxSeconds() {
        return this.getHasSeconds() ? DataConstraint.stripLeadingZeros(this.getSeconds().trim()) : "0";
    }

    public String getCxxFractionsOfASecond() {
        return this.getHasFractionsOfASecond() ? "0." + this.getFractionsOfASecond().trim() : "double(0)";
    }

    public void generateCxxTimeArguments(DataDestination dataDestination) {
        this.generateCxxTimeArguments(dataDestination, "", "", "", "", ", ", true);
    }

    public void generateCxxTimeArguments(DataDestination dataDestination, String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.getTimeExpression() != null) {
            dataDestination.write(string);
            dataDestination.write("_TDL_SecondsToMSecs");
            dataDestination.write(" ( ");
            int n = dataDestination.indentToCurrentColumn();
            if (dataDestination.getEnableLineMacros()) {
                dataDestination.setUsingTdlFileName(true);
                dataDestination.makeNextLineNumber(this.getTimeExpression().getLineNumber());
                dataDestination.write("\n");
            }
            int n2 = this.getTimeExpression().getLeadingWhitespaceIndent();
            if (dataDestination.getIndent() > n2) {
                dataDestination.removeIndent(n2);
                n -= n2;
            }
            if (bl) {
                while (n2 > 0) {
                    dataDestination.write(" ");
                    --n2;
                }
            }
            dataDestination.setStripLeadingWhitespace();
            this.getTimeExpression().generate(dataDestination, 0);
            if (dataDestination.getEnableLineMacros()) {
                dataDestination.setUsingTdlFileName(false);
                dataDestination.write("\n");
            }
            dataDestination.write(" )");
            dataDestination.write(string2);
            dataDestination.removeIndent(n);
        } else {
            dataDestination.write(string3);
            int n = dataDestination.indentToCurrentColumn();
            dataDestination.write(this.getCxxHours());
            dataDestination.write(string5);
            dataDestination.write(this.getCxxMinutes());
            dataDestination.write(string5);
            dataDestination.write(this.getCxxSeconds());
            dataDestination.write(string5);
            dataDestination.write(this.getCxxFractionsOfASecond());
            dataDestination.removeIndent(n);
            dataDestination.write(string4);
        }
    }

    public String getCxxStateBoundary(int n) {
        switch (n) {
            case 0: {
                return "Start_Point";
            }
            case 1: {
                return "Start_Point";
            }
            case 2: {
                return "End_Point";
            }
        }
        return "Unknown_Point";
    }

    public String getCxxInterval(int n) {
        switch (n) {
            case 0: {
                return "Handling_Interval";
            }
            case 1: {
                return "Planning_Interval";
            }
            case 2: {
                return "Achieving_Interval";
            }
        }
        return "Unknown_Interval";
    }

    public void generateEventTagTaskCxxReference(DataDestination dataDestination, String string, boolean bl) {
        if (this.getHasEventTagTaskOfThis()) {
            if (bl) {
                dataDestination.write("_TDL_SpawnedTasks . getEnclosingTaskTreeNode()");
            } else {
                dataDestination.write(DataComponent.CXX_TCM_ROOT_NODE);
            }
        } else if (this.getHasEventTagTaskOfChild()) {
            if (bl) {
                dataDestination.write("_TDL_Constraint::SELF");
            } else {
                dataDestination.write(string);
            }
        } else if (this.getHasEventTagTaskOfPrevious()) {
            if (bl) {
                dataDestination.write("_TDL_Constraint::PREVIOUS");
            } else {
                dataDestination.write(DataComponent.CXX_TCM_PREVIOUS_EXTERNAL_TASK_REF);
            }
        } else {
            DataStatement.generateTagTaskCxxReference(dataDestination, this.getEventTagTask(), this.getEventTagTaskIndexes(), this);
        }
    }

    protected void privateGenerateCxxEventArguments(DataDestination dataDestination, String string, boolean bl) {
        this.generateEventTagTaskCxxReference(dataDestination, string, bl);
        dataDestination.write(",\n");
        dataDestination.write(this.getCxxInterval(this.getEventConstraintOption()));
        dataDestination.write(",\n");
        dataDestination.write(this.getCxxStateBoundary(this.getStateBoundary()));
    }
}

