/*
 * Decompiled with CFR 0.152.
 */
public class DataComponentPlaceholder
extends DataComponent {
    public static final int ARGUMENTS_DECLARATION = 0;
    public static final int HANDLEMANAGER_DECLARATION = 1;
    protected boolean markDeclarationsUsed;
    protected DataTaskDefinition ourDataTaskDefinition;
    protected int ourGenerationType;
    protected DataVector ourNonUniqueNames;
    protected DataVector ourStatements;
    protected DataHashtable ourOnAgentHashtable;
    protected String stringToGenerate;
    protected boolean isPartOfTdlFile;
    protected int currentLineNumber;

    public DataComponentPlaceholder(DataTaskDefinition dataTaskDefinition, boolean bl) {
        this.clear();
        this.ourDataTaskDefinition = dataTaskDefinition;
        this.markDeclarationsUsed = bl;
        this.ourGenerationType = 0;
    }

    public DataComponentPlaceholder(DataTaskDefinition dataTaskDefinition, DataVector dataVector, DataVector dataVector2, DataHashtable dataHashtable) {
        this.clear();
        this.ourDataTaskDefinition = dataTaskDefinition;
        this.ourGenerationType = 1;
        this.ourNonUniqueNames = dataVector;
        this.ourStatements = dataVector2;
        this.ourOnAgentHashtable = dataHashtable;
    }

    public DataComponentPlaceholder(String string) {
        if (string == null) {
            System.err.println("[DataComponentPlaceholder] Warning:  Null string.");
            string = "";
        }
        this.clear();
        this.stringToGenerate = string;
        this.isPartOfTdlFile = false;
        if (string.equals("\n")) {
            System.err.println("DataComponentPlaceholder initialized with newline string:");
            Thread.dumpStack();
        }
        if (DataComponent.isEmptyString(string)) {
            System.err.println("DataComponentPlaceholder initialized with empty string:");
            Thread.dumpStack();
        }
    }

    public DataComponentPlaceholder(String string, int n) {
        if (string == null) {
            System.err.println("[DataComponentPlaceholder] WARNING:  Null string.");
            string = "";
        }
        this.clear();
        this.stringToGenerate = string;
        this.currentLineNumber = n;
        this.isPartOfTdlFile = true;
    }

    protected void clear() {
        this.markDeclarationsUsed = false;
        this.ourGenerationType = -1;
        this.ourDataTaskDefinition = null;
        this.ourNonUniqueNames = null;
        this.ourStatements = null;
        this.ourOnAgentHashtable = null;
        this.stringToGenerate = null;
        this.isPartOfTdlFile = false;
        this.currentLineNumber = -1;
    }

    public void generate(DataDestination dataDestination, int n) {
        if (this.stringToGenerate != null) {
            if (!this.isPartOfTdlFile) {
                dataDestination.setUsingTdlFileName(false);
                if (this.stringToGenerate.charAt(0) != '\n') {
                    dataDestination.write("\n");
                }
            } else {
                dataDestination.setUsingTdlFileName(true);
                dataDestination.makeNextLineNumber(this.currentLineNumber);
                if (dataDestination.getEnableLineMacros()) {
                    dataDestination.write("\n");
                }
            }
            dataDestination.write(this.stringToGenerate);
            return;
        }
        if (this.ourDataTaskDefinition != null) {
            if (this.ourGenerationType == 1) {
                this.ourDataTaskDefinition.generateHandleManagerDeclaration(dataDestination, this.ourNonUniqueNames, this.ourStatements, this.ourOnAgentHashtable);
            } else {
                this.ourDataTaskDefinition.generateArgumentsDeclarationCode(this.markDeclarationsUsed, dataDestination);
            }
            return;
        }
        System.err.println("[DataComponentPlaceholder:generate]  Error:  Unknown generation encountered.");
    }
}

